//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azopenaiassistants

import (
	"time"
)

// Assistant - Represents an assistant that can call the model and use tools.
type Assistant struct {
	// REQUIRED; The Unix timestamp, in seconds, representing when this object was created.
	CreatedAt *time.Time

	// REQUIRED; The description of the assistant.
	Description *string

	// REQUIRED; A list of attached file IDs, ordered by creation date in ascending order.
	FileIDs []string

	// REQUIRED; The identifier, which can be referenced in API endpoints.
	ID *string

	// REQUIRED; The system instructions for the assistant to use.
	Instructions *string

	// REQUIRED; A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
	// about that object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string

	// REQUIRED; The ID of the model to use.
	DeploymentName *string

	// REQUIRED; The name of the assistant.
	Name *string

	// REQUIRED; The object type, which is always assistant.
	Object *string

	// REQUIRED; The collection of tools enabled for the assistant.
	Tools []ToolDefinitionClassification
}

// AssistantCreationBody - The request details to use when creating a new assistant.
type AssistantCreationBody struct {
	// REQUIRED; The ID of the model to use.
	DeploymentName *string

	// The description of the new assistant.
	Description *string

	// A list of previously uploaded file IDs to attach to the assistant.
	FileIDs []string

	// The system instructions for the new assistant to use.
	Instructions *string

	// A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information about that
	// object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string

	// The name of the new assistant.
	Name *string

	// The collection of tools to enable for the new assistant.
	Tools []ToolDefinitionClassification
}

// AssistantDeletionStatus - The status of an assistant deletion operation.
type AssistantDeletionStatus struct {
	// REQUIRED; A value indicating whether deletion was successful.
	Deleted *bool

	// REQUIRED; The ID of the resource specified for deletion.
	ID *string

	// REQUIRED; The object type, which is always 'assistant.deleted'.
	Object *string
}

// AssistantFile - Information about a file attached to an assistant, as used by tools that can read files.
type AssistantFile struct {
	// REQUIRED; The assistant ID that the file is attached to.
	AssistantID *string

	// REQUIRED; The Unix timestamp, in seconds, representing when this object was created.
	CreatedAt *time.Time

	// REQUIRED; The identifier, which can be referenced in API endpoints.
	ID *string

	// REQUIRED; The object type, which is always 'assistant.file'.
	Object *string
}

// AssistantFileDeletionStatus - The status of an assistant file deletion operation.
type AssistantFileDeletionStatus struct {
	// REQUIRED; A value indicating whether deletion was successful.
	Deleted *bool

	// REQUIRED; The ID of the resource specified for deletion.
	ID *string

	// REQUIRED; The object type, which is always 'assistant.file.deleted'.
	Object *string
}

// AssistantThread - Information about a single thread associated with an assistant.
type AssistantThread struct {
	// REQUIRED; The Unix timestamp, in seconds, representing when this object was created.
	CreatedAt *time.Time

	// REQUIRED; The identifier, which can be referenced in API endpoints.
	ID *string

	// REQUIRED; A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
	// about that object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string

	// REQUIRED; The object type, which is always 'thread'.
	Object *string
}

// AssistantThreadCreationOptions - The details used to create a new assistant thread.
type AssistantThreadCreationOptions struct {
	// The initial messages to associate with the new thread.
	Messages []ThreadInitializationMessage

	// A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information about that
	// object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string
}

// CodeInterpreterToolDefinition - The input definition information for a code interpreter tool as used to configure an assistant.
type CodeInterpreterToolDefinition struct {
	// REQUIRED; The object type.
	Type *string
}

// GetToolDefinition implements the ToolDefinitionClassification interface for type CodeInterpreterToolDefinition.
func (c *CodeInterpreterToolDefinition) GetToolDefinition() *ToolDefinition {
	return &ToolDefinition{
		Type: c.Type,
	}
}

// CreateAndRunThreadOptions - The details used when creating and immediately running a new assistant thread.
type CreateAndRunThreadOptions struct {
	// REQUIRED; The ID of the assistant for which the thread should be created.
	AssistantID *string

	// The overridden system instructions the assistant should use to run the thread.
	Instructions *string

	// A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information about that
	// object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string

	// The overridden model that the assistant should use to run the thread.
	DeploymentName *string

	// The details used to create the new thread.
	Thread *AssistantThreadCreationOptions

	// The overridden list of enabled tools the assistant should use to run the thread.
	Tools []ToolDefinitionClassification
}

// CreateRunBody - The details used when creating a new run of an assistant thread.
type CreateRunBody struct {
	// REQUIRED; The ID of the assistant that should run the thread.
	AssistantID *string

	// Additional instructions to append at the end of the instructions for the run. This is useful for modifying the behavior
	// on a per-run basis without overriding other instructions.
	AdditionalInstructions *string

	// The overridden system instructions that the assistant should use to run the thread.
	Instructions *string

	// A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information about that
	// object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string

	// The overridden model name that the assistant should use to run the thread.
	DeploymentName *string

	// The overridden list of enabled tools that the assistant should use to run the thread.
	Tools []ToolDefinitionClassification
}

// FileDeletionStatus - A status response from a file deletion operation.
type FileDeletionStatus struct {
	// REQUIRED; A value indicating whether deletion was successful.
	Deleted *bool

	// REQUIRED; The ID of the resource specified for deletion.
	ID *string

	// REQUIRED; The object type, which is always 'file'.
	Object *string
}

// FileListResponse - The response data from a file list operation.
type FileListResponse struct {
	// REQUIRED; The files returned for the request.
	Data []OpenAIFile

	// REQUIRED; The object type, which is always 'list'.
	Object *string
}

// FunctionDefinition - The input definition information for a function.
type FunctionDefinition struct {
	// REQUIRED; The name of the function to be called.
	Name *string

	// REQUIRED; The parameters the functions accepts, described as a JSON Schema object.
	Parameters any

	// A description of what the function does, used by the model to choose when and how to call the function.
	Description *string
}

// FunctionToolDefinition - The input definition information for a function tool as used to configure an assistant.
type FunctionToolDefinition struct {
	// REQUIRED; The definition of the concrete function that the function tool should call.
	Function *FunctionDefinition

	// REQUIRED; The object type.
	Type *string
}

// GetToolDefinition implements the ToolDefinitionClassification interface for type FunctionToolDefinition.
func (f *FunctionToolDefinition) GetToolDefinition() *ToolDefinition {
	return &ToolDefinition{
		Type: f.Type,
	}
}

// MessageContent - An abstract representation of a single item of thread message content.
type MessageContent struct {
	// REQUIRED; The object type.
	Type *string
}

// GetMessageContent implements the MessageContentClassification interface for type MessageContent.
func (m *MessageContent) GetMessageContent() *MessageContent { return m }

// MessageFile - Information about a file attached to an assistant thread message.
type MessageFile struct {
	// REQUIRED; The Unix timestamp, in seconds, representing when this object was created.
	CreatedAt *time.Time

	// REQUIRED; The identifier, which can be referenced in API endpoints.
	ID *string

	// REQUIRED; The ID of the message that this file is attached to.
	MessageID *string

	// REQUIRED; The object type, which is always 'thread.message.file'.
	Object *string
}

// MessageImageFileContent - A representation of image file content in a thread message.
type MessageImageFileContent struct {
	// REQUIRED; The image file for this thread message content item.
	ImageFile *MessageImageFileDetails

	// REQUIRED; The object type.
	Type *string
}

// GetMessageContent implements the MessageContentClassification interface for type MessageImageFileContent.
func (m *MessageImageFileContent) GetMessageContent() *MessageContent {
	return &MessageContent{
		Type: m.Type,
	}
}

// MessageImageFileDetails - An image reference, as represented in thread message content.
type MessageImageFileDetails struct {
	// REQUIRED; The ID for the file associated with this image.
	FileID *string
}

// MessageTextAnnotation - An abstract representation of an annotation to text thread message content.
type MessageTextAnnotation struct {
	// REQUIRED; The last text index associated with this text annotation.
	EndIndex *int32

	// REQUIRED; The first text index associated with this text annotation.
	StartIndex *int32

	// REQUIRED; The textual content associated with this text annotation item.
	Text *string

	// REQUIRED; The object type.
	Type *string
}

// GetMessageTextAnnotation implements the MessageTextAnnotationClassification interface for type MessageTextAnnotation.
func (m *MessageTextAnnotation) GetMessageTextAnnotation() *MessageTextAnnotation { return m }

// MessageTextContent - A representation of a textual item of thread message content.
type MessageTextContent struct {
	// REQUIRED; The text and associated annotations for this thread message content item.
	Text *MessageTextDetails

	// REQUIRED; The object type.
	Type *string
}

// GetMessageContent implements the MessageContentClassification interface for type MessageTextContent.
func (m *MessageTextContent) GetMessageContent() *MessageContent {
	return &MessageContent{
		Type: m.Type,
	}
}

// MessageTextDetails - The text and associated annotations for a single item of assistant thread message content.
type MessageTextDetails struct {
	// REQUIRED; A list of annotations associated with this text.
	Annotations []MessageTextAnnotationClassification

	// REQUIRED; The text data.
	Value *string
}

// MessageTextFileCitationAnnotation - A citation within the message that points to a specific quote from a specific File
// associated with the assistant or the message. Generated when the assistant uses the 'retrieval' tool to search files.
type MessageTextFileCitationAnnotation struct {
	// REQUIRED; The last text index associated with this text annotation.
	EndIndex *int32

	// REQUIRED; A citation within the message that points to a specific quote from a specific file. Generated when the assistant
	// uses the "retrieval" tool to search files.
	FileCitation *MessageTextFileCitationDetails

	// REQUIRED; The first text index associated with this text annotation.
	StartIndex *int32

	// REQUIRED; The textual content associated with this text annotation item.
	Text *string

	// REQUIRED; The object type.
	Type *string
}

// GetMessageTextAnnotation implements the MessageTextAnnotationClassification interface for type MessageTextFileCitationAnnotation.
func (m *MessageTextFileCitationAnnotation) GetMessageTextAnnotation() *MessageTextAnnotation {
	return &MessageTextAnnotation{
		EndIndex:   m.EndIndex,
		StartIndex: m.StartIndex,
		Text:       m.Text,
		Type:       m.Type,
	}
}

// MessageTextFileCitationDetails - A representation of a file-based text citation, as used in a file-based annotation of
// text thread message content.
type MessageTextFileCitationDetails struct {
	// REQUIRED; The ID of the file associated with this citation.
	FileID *string

	// REQUIRED; The specific quote cited in the associated file.
	Quote *string
}

// MessageTextFilePathAnnotation - A citation within the message that points to a file located at a specific path.
type MessageTextFilePathAnnotation struct {
	// REQUIRED; The last text index associated with this text annotation.
	EndIndex *int32

	// REQUIRED; A URL for the file that's generated when the assistant used the code_interpreter tool to generate a file.
	FilePath *MessageTextFilePathDetails

	// REQUIRED; The first text index associated with this text annotation.
	StartIndex *int32

	// REQUIRED; The textual content associated with this text annotation item.
	Text *string

	// REQUIRED; The object type.
	Type *string
}

// GetMessageTextAnnotation implements the MessageTextAnnotationClassification interface for type MessageTextFilePathAnnotation.
func (m *MessageTextFilePathAnnotation) GetMessageTextAnnotation() *MessageTextAnnotation {
	return &MessageTextAnnotation{
		EndIndex:   m.EndIndex,
		StartIndex: m.StartIndex,
		Text:       m.Text,
		Type:       m.Type,
	}
}

// MessageTextFilePathDetails - An encapsulation of an image file ID, as used by message image content.
type MessageTextFilePathDetails struct {
	// REQUIRED; The ID of the specific file that the citation is from.
	FileID *string
}

// OpenAIFile - Represents an assistant that can call the model and use tools.
type OpenAIFile struct {
	// REQUIRED; The size of the file, in bytes.
	Bytes *int32

	// REQUIRED; The Unix timestamp, in seconds, representing when this object was created.
	CreatedAt *time.Time

	// REQUIRED; The name of the file.
	Filename *string

	// REQUIRED; The identifier, which can be referenced in API endpoints.
	ID *string

	// REQUIRED; The object type, which is always 'file'.
	Object *string

	// REQUIRED; The intended purpose of a file.
	Purpose *FilePurpose
}

// UpdateMessageBody - The request details to use when updating a message.
type UpdateMessageBody struct {
	// A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information about that
	// object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string
}

// SubmitToolOutputsToRunBody - The request details to use when submitting tool outputs.
type SubmitToolOutputsToRunBody struct {
	// REQUIRED; The list of tool outputs requested by tool calls from the specified run.
	ToolOutputs []ToolOutput
}

// MessageFilesPage - The response data for a
// requested list of items.
type MessageFilesPage struct {
	// REQUIRED; The requested list of items.
	Data []MessageFile

	// REQUIRED; The first ID represented in this list.
	FirstID *string

	// REQUIRED; A value indicating whether there are additional values available not captured in this list.
	HasMore *bool

	// REQUIRED; The last ID represented in this list.
	LastID *string

	// REQUIRED; The object type, which is always list.
	Object *string
}

// AssistantsPage - The response data for a requested list of items.
type AssistantsPage struct {
	// REQUIRED; The requested list of items.
	Data []Assistant

	// REQUIRED; The first ID represented in this list.
	FirstID *string

	// REQUIRED; A value indicating whether there are additional values available not captured in this list.
	HasMore *bool

	// REQUIRED; The last ID represented in this list.
	LastID *string

	// REQUIRED; The object type, which is always list.
	Object *string
}

// CreateAssistantFileBody - The request details to use when creating an assistant file.
type CreateAssistantFileBody struct {
	// REQUIRED; The ID of the previously uploaded file to attach.
	FileID *string
}

// MessagesPage - The response data for a requested list
// of items.
type MessagesPage struct {
	// REQUIRED; The requested list of items.
	Data []ThreadMessage

	// REQUIRED; The first ID represented in this list.
	FirstID *string

	// REQUIRED; A value indicating whether there are additional values available not captured in this list.
	HasMore *bool

	// REQUIRED; The last ID represented in this list.
	LastID *string

	// REQUIRED; The object type, which is always list.
	Object *string
}

// UpdateRunBody - The request details to use when updating a run.
type UpdateRunBody struct {
	// A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information about that
	// object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string
}

// UpdateThreadBody - The request details to use when creating a thread.
type UpdateThreadBody struct {
	// A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information about that
	// object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string
}

// ThreadRunsPage - The response data for a requested list of items.
type ThreadRunsPage struct {
	// REQUIRED; The requested list of items.
	Data []ThreadRun

	// REQUIRED; The first ID represented in this list.
	FirstID *string

	// REQUIRED; A value indicating whether there are additional values available not captured in this list.
	HasMore *bool

	// REQUIRED; The last ID represented in this list.
	LastID *string

	// REQUIRED; The object type, which is always list.
	Object *string
}

// RunStepsPage - The response data for a requested
// list of items.
type RunStepsPage struct {
	// REQUIRED; The requested list of items.
	Data []RunStep

	// REQUIRED; The first ID represented in this list.
	FirstID *string

	// REQUIRED; A value indicating whether there are additional values available not captured in this list.
	HasMore *bool

	// REQUIRED; The last ID represented in this list.
	LastID *string

	// REQUIRED; The object type, which is always list.
	Object *string
}

// CreateMessageBody - The request details to use when creating a message.
type CreateMessageBody struct {
	// REQUIRED; The textual content for the new message.
	Content *string

	// REQUIRED; The role to associate with the new message.
	Role *MessageRole

	// A list of up to 10 file IDs to associate with the message, as used by tools like 'code_interpreter' or 'retrieval' that
	// can read files.
	FileIDs []string

	// A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information about that
	// object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string
}

// AssistantFilesPage - The response data for a requested list
// of items.
type AssistantFilesPage struct {
	// REQUIRED; The requested list of items.
	Data []AssistantFile

	// REQUIRED; The first ID represented in this list.
	FirstID *string

	// REQUIRED; A value indicating whether there are additional values available not captured in this list.
	HasMore *bool

	// REQUIRED; The last ID represented in this list.
	LastID *string

	// REQUIRED; The object type, which is always list.
	Object *string
}

// RequiredAction - An abstract representation of a required action for an assistant thread run to continue.
type RequiredAction struct {
	// REQUIRED; The object type.
	Type *string
}

// GetRequiredAction implements the RequiredActionClassification interface for type RequiredAction.
func (r *RequiredAction) GetRequiredAction() *RequiredAction { return r }

// RequiredFunctionToolCall - A representation of a requested call to a function tool, needed by the model to continue evaluation
// of a run.
type RequiredFunctionToolCall struct {
	// REQUIRED; Detailed information about the function to be executed by the tool that includes name and arguments.
	Function *RequiredFunctionToolCallDetails

	// REQUIRED; The ID of the tool call. This ID must be referenced when submitting tool outputs.
	ID *string

	// REQUIRED; The object type for the required tool call.
	Type *string
}

// GetRequiredToolCall implements the RequiredToolCallClassification interface for type RequiredFunctionToolCall.
func (r *RequiredFunctionToolCall) GetRequiredToolCall() *RequiredToolCall {
	return &RequiredToolCall{
		ID:   r.ID,
		Type: r.Type,
	}
}

// RequiredFunctionToolCallDetails - The detailed information for a function invocation, as provided by a required action
// invoking a function tool, that includes the name of and arguments to the function.
type RequiredFunctionToolCallDetails struct {
	// REQUIRED; The arguments to use when invoking the named function, as provided by the model. Arguments are presented as a
	// JSON document that should be validated and parsed for evaluation.
	Arguments *string

	// REQUIRED; The name of the function.
	Name *string
}

// RequiredToolCall - An abstract representation a a tool invocation needed by the model to continue a run.
type RequiredToolCall struct {
	// REQUIRED; The ID of the tool call. This ID must be referenced when submitting tool outputs.
	ID *string

	// REQUIRED; The object type for the required tool call.
	Type *string
}

// GetRequiredToolCall implements the RequiredToolCallClassification interface for type RequiredToolCall.
func (r *RequiredToolCall) GetRequiredToolCall() *RequiredToolCall { return r }

// RetrievalToolDefinition - The input definition information for a retrieval tool as used to configure an assistant.
type RetrievalToolDefinition struct {
	// REQUIRED; The object type.
	Type *string
}

// GetToolDefinition implements the ToolDefinitionClassification interface for type RetrievalToolDefinition.
func (r *RetrievalToolDefinition) GetToolDefinition() *ToolDefinition {
	return &ToolDefinition{
		Type: r.Type,
	}
}

// RunError - The details of an error as encountered by an assistant thread run.
type RunError struct {
	// REQUIRED; The status for the error.
	Code *string

	// REQUIRED; The human-readable text associated with the error.
	Message *string
}

// RunStep - Detailed information about a single step of an assistant thread run.
type RunStep struct {
	// REQUIRED; The ID of the assistant associated with the run step.
	AssistantID *string

	// REQUIRED; The Unix timestamp, in seconds, representing when this was cancelled.
	CancelledAt *time.Time

	// REQUIRED; The Unix timestamp, in seconds, representing when this completed.
	CompletedAt *time.Time

	// REQUIRED; The Unix timestamp, in seconds, representing when this object was created.
	CreatedAt *time.Time

	// REQUIRED; The Unix timestamp, in seconds, representing when this item expired.
	ExpiredAt *time.Time

	// REQUIRED; The Unix timestamp, in seconds, representing when this failed.
	FailedAt *time.Time

	// REQUIRED; The identifier, which can be referenced in API endpoints.
	ID *string

	// REQUIRED; If applicable, information about the last error encountered by this run step.
	LastError *RunStepLastError

	// REQUIRED; A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
	// about that object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string

	// REQUIRED; The object type, which is always 'thread.run.step'.
	Object *string

	// REQUIRED; The ID of the run that this run step is a part of.
	RunID *string

	// REQUIRED; The status of this run step.
	Status *RunStepStatus

	// REQUIRED; The details for this run step.
	StepDetails RunStepDetailsClassification

	// REQUIRED; The ID of the thread that was run.
	ThreadID *string

	// REQUIRED; The type of run step, which can be either messagecreation or toolcalls.
	Type *RunStepType
}

// RunStepCodeInterpreterImageOutput - A representation of an image output emitted by a code interpreter tool in response
// to a tool call by the model.
type RunStepCodeInterpreterImageOutput struct {
	// REQUIRED; Referential information for the image associated with this output.
	Image *RunStepCodeInterpreterImageReference

	// REQUIRED; The object type.
	Type *string
}

// GetRunStepCodeInterpreterToolCallOutput implements the RunStepCodeInterpreterToolCallOutputClassification interface for
// type RunStepCodeInterpreterImageOutput.
func (r *RunStepCodeInterpreterImageOutput) GetRunStepCodeInterpreterToolCallOutput() *RunStepCodeInterpreterToolCallOutput {
	return &RunStepCodeInterpreterToolCallOutput{
		Type: r.Type,
	}
}

// RunStepCodeInterpreterImageReference - An image reference emitted by a code interpreter tool in response to a tool call
// by the model.
type RunStepCodeInterpreterImageReference struct {
	// REQUIRED; The ID of the file associated with this image.
	FileID *string
}

// RunStepCodeInterpreterLogOutput - A representation of a log output emitted by a code interpreter tool in response to a
// tool call by the model.
type RunStepCodeInterpreterLogOutput struct {
	// REQUIRED; The serialized log output emitted by the code interpreter.
	Logs *string

	// REQUIRED; The object type.
	Type *string
}

// GetRunStepCodeInterpreterToolCallOutput implements the RunStepCodeInterpreterToolCallOutputClassification interface for
// type RunStepCodeInterpreterLogOutput.
func (r *RunStepCodeInterpreterLogOutput) GetRunStepCodeInterpreterToolCallOutput() *RunStepCodeInterpreterToolCallOutput {
	return &RunStepCodeInterpreterToolCallOutput{
		Type: r.Type,
	}
}

// RunStepCodeInterpreterToolCall - A record of a call to a code interpreter tool, issued by the model in evaluation of a
// defined tool, that represents inputs and outputs consumed and emitted by the code interpreter.
type RunStepCodeInterpreterToolCall struct {
	// REQUIRED; The details of the tool call to the code interpreter tool.
	CodeInterpreter *RunStepCodeInterpreterToolCallDetails

	// REQUIRED; The ID of the tool call. This ID must be referenced when you submit tool outputs.
	ID *string

	// REQUIRED; The object type.
	Type *string
}

// GetRunStepToolCall implements the RunStepToolCallClassification interface for type RunStepCodeInterpreterToolCall.
func (r *RunStepCodeInterpreterToolCall) GetRunStepToolCall() *RunStepToolCall {
	return &RunStepToolCall{
		ID:   r.ID,
		Type: r.Type,
	}
}

// RunStepCodeInterpreterToolCallDetails - The detailed information about a code interpreter invocation by the model.
type RunStepCodeInterpreterToolCallDetails struct {
	// REQUIRED; The input provided by the model to the code interpreter tool.
	Input *string

	// REQUIRED; The outputs produced by the code interpreter tool back to the model in response to the tool call.
	Outputs []RunStepCodeInterpreterToolCallOutputClassification
}

// RunStepCodeInterpreterToolCallOutput - An abstract representation of an emitted output from a code interpreter tool.
type RunStepCodeInterpreterToolCallOutput struct {
	// REQUIRED; The object type.
	Type *string
}

// GetRunStepCodeInterpreterToolCallOutput implements the RunStepCodeInterpreterToolCallOutputClassification interface for
// type RunStepCodeInterpreterToolCallOutput.
func (r *RunStepCodeInterpreterToolCallOutput) GetRunStepCodeInterpreterToolCallOutput() *RunStepCodeInterpreterToolCallOutput {
	return r
}

// RunStepDetails - An abstract representation of the details for a run step.
type RunStepDetails struct {
	// REQUIRED; The object type.
	Type *RunStepType
}

// GetRunStepDetails implements the RunStepDetailsClassification interface for type RunStepDetails.
func (r *RunStepDetails) GetRunStepDetails() *RunStepDetails { return r }

// RunStepError - The error information associated with a failed run step.
type RunStepError struct {
	// REQUIRED; The error code for this error.
	Code *RunStepErrorCode

	// REQUIRED; The human-readable text associated with this error.
	Message *string
}

// RunStepFunctionToolCall - A record of a call to a function tool, issued by the model in evaluation of a defined tool, that
// represents the inputs and output consumed and emitted by the specified function.
type RunStepFunctionToolCall struct {
	// REQUIRED; The detailed information about the function called by the model.
	Function *RunStepFunctionToolCallDetails

	// REQUIRED; The ID of the tool call. This ID must be referenced when you submit tool outputs.
	ID *string

	// REQUIRED; The object type.
	Type *string
}

// GetRunStepToolCall implements the RunStepToolCallClassification interface for type RunStepFunctionToolCall.
func (r *RunStepFunctionToolCall) GetRunStepToolCall() *RunStepToolCall {
	return &RunStepToolCall{
		ID:   r.ID,
		Type: r.Type,
	}
}

// RunStepFunctionToolCallDetails - The detailed information about the function called by the model.
type RunStepFunctionToolCallDetails struct {
	// REQUIRED; The arguments that the model requires are provided to the named function.
	Arguments *string

	// REQUIRED; The name of the function.
	Name *string

	// REQUIRED; The output of the function, only populated for function calls that have already have had their outputs submitted.
	Output *string
}

// RunStepLastError - If applicable, information about the last error encountered by this run step.
type RunStepLastError struct {
	// REQUIRED; The error code for this error.
	Code *RunStepErrorCode

	// REQUIRED; The human-readable text associated with this error.
	Message *string
}

// RunStepMessageCreationDetails - The detailed information associated with a message creation run step.
type RunStepMessageCreationDetails struct {
	// REQUIRED; Information about the message creation associated with this run step.
	MessageCreation *RunStepMessageCreationReference

	// REQUIRED; The object type.
	Type *RunStepType
}

// GetRunStepDetails implements the RunStepDetailsClassification interface for type RunStepMessageCreationDetails.
func (r *RunStepMessageCreationDetails) GetRunStepDetails() *RunStepDetails {
	return &RunStepDetails{
		Type: r.Type,
	}
}

// RunStepMessageCreationReference - The details of a message created as a part of a run step.
type RunStepMessageCreationReference struct {
	// REQUIRED; The ID of the message created by this run step.
	MessageID *string
}

// RunStepRetrievalToolCall - A record of a call to a retrieval tool, issued by the model in evaluation of a defined tool,
// that represents executed retrieval actions.
type RunStepRetrievalToolCall struct {
	// REQUIRED; The ID of the tool call. This ID must be referenced when you submit tool outputs.
	ID *string

	// REQUIRED; The key/value pairs produced by the retrieval tool.
	Retrieval map[string]*string

	// REQUIRED; The object type.
	Type *string
}

// GetRunStepToolCall implements the RunStepToolCallClassification interface for type RunStepRetrievalToolCall.
func (r *RunStepRetrievalToolCall) GetRunStepToolCall() *RunStepToolCall {
	return &RunStepToolCall{
		ID:   r.ID,
		Type: r.Type,
	}
}

// RunStepToolCall - An abstract representation of a detailed tool call as recorded within a run step for an existing run.
type RunStepToolCall struct {
	// REQUIRED; The ID of the tool call. This ID must be referenced when you submit tool outputs.
	ID *string

	// REQUIRED; The object type.
	Type *string
}

// GetRunStepToolCall implements the RunStepToolCallClassification interface for type RunStepToolCall.
func (r *RunStepToolCall) GetRunStepToolCall() *RunStepToolCall { return r }

// RunStepToolCallDetails - The detailed information associated with a run step calling tools.
type RunStepToolCallDetails struct {
	// REQUIRED; A list of tool call details for this run step.
	ToolCalls []RunStepToolCallClassification

	// REQUIRED; The object type.
	Type *RunStepType
}

// GetRunStepDetails implements the RunStepDetailsClassification interface for type RunStepToolCallDetails.
func (r *RunStepToolCallDetails) GetRunStepDetails() *RunStepDetails {
	return &RunStepDetails{
		Type: r.Type,
	}
}

// SubmitToolOutputsAction - The details for required tool calls that must be submitted for an assistant thread run to continue.
type SubmitToolOutputsAction struct {
	// REQUIRED; The details describing tools that should be called to submit tool outputs.
	SubmitToolOutputs *SubmitToolOutputsDetails

	// REQUIRED; The object type.
	Type *string
}

// GetRequiredAction implements the RequiredActionClassification interface for type SubmitToolOutputsAction.
func (s *SubmitToolOutputsAction) GetRequiredAction() *RequiredAction {
	return &RequiredAction{
		Type: s.Type,
	}
}

// SubmitToolOutputsDetails - The details describing tools that should be called to submit tool outputs.
type SubmitToolOutputsDetails struct {
	// REQUIRED; The list of tool calls that must be resolved for the assistant thread run to continue.
	ToolCalls []RequiredToolCallClassification
}

// ThreadDeletionStatus - The status of a thread deletion operation.
type ThreadDeletionStatus struct {
	// REQUIRED; A value indicating whether deletion was successful.
	Deleted *bool

	// REQUIRED; The ID of the resource specified for deletion.
	ID *string

	// REQUIRED; The object type, which is always 'thread.deleted'.
	Object *string
}

// ThreadInitializationMessage - A single message within an assistant thread, as provided during that thread's creation for
// its initial state.
type ThreadInitializationMessage struct {
	// REQUIRED; The textual content of the initial message. Currently, robust input including images and annotated text may only
	// be provided via a separate call to the create message API.
	Content *string

	// REQUIRED; The role associated with the assistant thread message. Currently, only 'user' is supported when providing initial
	// messages to a new thread.
	Role *MessageRole

	// A list of file IDs that the assistant should use. Useful for tools like retrieval and code_interpreter that can access
	// files.
	FileIDs []string

	// A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information about that
	// object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string
}

// ThreadMessage - A single, existing message within an assistant thread.
type ThreadMessage struct {
	// REQUIRED; The list of content items associated with the assistant thread message.
	Content []MessageContentClassification

	// REQUIRED; The Unix timestamp, in seconds, representing when this object was created.
	CreatedAt *time.Time

	// REQUIRED; A list of file IDs that the assistant should use. Useful for tools like retrieval and code_interpreter that can
	// access files.
	FileIDs []string

	// REQUIRED; The identifier, which can be referenced in API endpoints.
	ID *string

	// REQUIRED; A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
	// about that object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string

	// REQUIRED; The object type, which is always 'thread.message'.
	Object *string

	// REQUIRED; The role associated with the assistant thread message.
	Role *MessageRole

	// REQUIRED; The ID of the thread that this message belongs to.
	ThreadID *string

	// If applicable, the ID of the assistant that authored this message.
	AssistantID *string

	// If applicable, the ID of the run associated with the authoring of this message.
	RunID *string
}

// ThreadRun - Data representing a single evaluation run of an assistant thread.
type ThreadRun struct {
	// REQUIRED; The ID of the assistant associated with the thread this run was performed against.
	AssistantID *string

	// REQUIRED; The Unix timestamp, in seconds, representing when this was cancelled.
	CancelledAt *time.Time

	// REQUIRED; The Unix timestamp, in seconds, representing when this completed.
	CompletedAt *time.Time

	// REQUIRED; The Unix timestamp, in seconds, representing when this object was created.
	CreatedAt *time.Time

	// REQUIRED; The Unix timestamp, in seconds, representing when this item expires.
	ExpiresAt *time.Time

	// REQUIRED; The Unix timestamp, in seconds, representing when this failed.
	FailedAt *time.Time

	// REQUIRED; A list of attached file IDs, ordered by creation date in ascending order.
	FileIDs []string

	// REQUIRED; The identifier, which can be referenced in API endpoints.
	ID *string

	// REQUIRED; The overridden system instructions used for this assistant thread run.
	Instructions *string

	// REQUIRED; The last error, if any, encountered by this assistant thread run.
	LastError *ThreadRunLastError

	// REQUIRED; A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
	// about that object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string

	// REQUIRED; The ID of the model to use.
	DeploymentName *string

	// REQUIRED; The object type, which is always 'thread.run'.
	Object *string

	// REQUIRED; The Unix timestamp, in seconds, representing when this item was started.
	StartedAt *time.Time

	// REQUIRED; The status of the assistant thread run.
	Status *RunStatus

	// REQUIRED; The ID of the thread associated with this run.
	ThreadID *string

	// REQUIRED; The overridden enabled tools used for this assistant thread run.
	Tools []ToolDefinitionClassification

	// The details of the action required for the assistant thread run to continue.
	RequiredAction RequiredActionClassification
}

// ThreadRunLastError - The last error, if any, encountered by this assistant thread run.
type ThreadRunLastError struct {
	// REQUIRED; The status for the error.
	Code *string

	// REQUIRED; The human-readable text associated with the error.
	Message *string
}

// ToolDefinition - An abstract representation of an input tool definition that an assistant can use.
type ToolDefinition struct {
	// REQUIRED; The object type.
	Type *string
}

// GetToolDefinition implements the ToolDefinitionClassification interface for type ToolDefinition.
func (t *ToolDefinition) GetToolDefinition() *ToolDefinition { return t }

// ToolOutput - The data provided during a tool outputs submission to resolve pending tool calls and allow the model to continue.
type ToolOutput struct {
	// The output from the tool to be submitted.
	Output *string

	// The ID of the tool call being resolved, as provided in the tool calls of a required action from a run.
	ToolCallID *string
}

// UpdateAssistantBody - The request details to use when modifying an existing assistant.
type UpdateAssistantBody struct {
	// The modified description for the assistant to use.
	Description *string

	// The modified list of previously uploaded fileIDs to attach to the assistant.
	FileIDs []string

	// The modified system instructions for the new assistant to use.
	Instructions *string

	// A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information about that
	// object in a structured format. Keys may be up to 64 characters in length and
	// values may be up to 512 characters in length.
	Metadata map[string]*string

	// The ID of the model to use.
	DeploymentName *string

	// The modified name for the assistant to use.
	Name *string

	// The modified collection of tools to enable for the assistant.
	Tools []ToolDefinitionClassification
}
