//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azmetrics

// QueryResourcesOptions contains the optional parameters for the Client.QueryResources method.
type QueryResourcesOptions struct {
	// The list of aggregation types (comma separated) to retrieve.Examples: average, minimum, maximum
	Aggregation *string

	// The end time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'.
	EndTime *string

	// The filter is used to reduce the set of metric data returned.
	// Example:
	// Metric contains metadata A, B and C.
	// - Return all time series of C where A = a1 and B = b1 or b2
	// filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq ‘’
	// - Invalid variant:
	// filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘’ or B = ‘b2’
	// This is invalid because the logical or operator cannot separate two different metadata names.
	// - Return all time series where A = a1, B = b1 and C = c1:
	// filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘c1’
	// - Return all time series where A = a1
	// filter=A eq ‘a1’ and B eq ‘’ and C eq ‘’.
	Filter *string

	// The interval (i.e. timegrain) of the query in ISO 8601 duration format. Defaults to PT1M. Special case for 'FULL' value
	// that returns single datapoint for entire time span requested.Examples: PT15M,
	// PT1H, P1D, FULL
	Interval *string

	// The aggregation to use for sorting results and the direction of the sort. Only one order can be specified.Examples: sum
	// asc
	OrderBy *string

	// Dimension name(s) to rollup results by. For example if you only want to see metric values with a filter like 'City eq Seattle
	// or City eq Tacoma' but don't want to see separate values for each city,
	// you can specify 'RollUpBy=City' to see the results for Seattle and Tacoma rolled up into one timeseries.
	RollUpBy *string

	// The start time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'. If you have specified the endtime
	// parameter, then this parameter is required. If only starttime is specified, then
	// endtime defaults to the current time. If no time interval is specified, the default is 1 hour.
	StartTime *string

	// The maximum number of records to retrieve per resource ID in the request. Valid only if filter is specified. Defaults to
	// 10.
	Top *int32
}
