//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armanalysisservices_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/analysisservices/armanalysisservices"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/getServer.json
func ExampleServersClient_GetDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().GetDetails(ctx, "TestRG", "azsdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Server = armanalysisservices.Server{
	// 	Name: to.Ptr("azsdktest"),
	// 	ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.AnalysisServices/servers/azsdktest"),
	// 	Location: to.Ptr("West US"),
	// 	SKU: &armanalysisservices.ResourceSKU{
	// 		Name: to.Ptr("S1"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Tier: to.Ptr(armanalysisservices.SKUTierStandard),
	// 	},
	// 	Tags: map[string]*string{
	// 		"testKey": to.Ptr("testValue"),
	// 	},
	// 	Properties: &armanalysisservices.ServerProperties{
	// 		AsAdministrators: &armanalysisservices.ServerAdministrators{
	// 			Members: []*string{
	// 				to.Ptr("azsdktest@microsoft.com")},
	// 			},
	// 			ProvisioningState: to.Ptr(armanalysisservices.ProvisioningStateSucceeded),
	// 			ServerFullName: to.Ptr("asazure://nightly1.asazure-int.windows.net/azsdktest"),
	// 			State: to.Ptr(armanalysisservices.StateProvisioning),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/createServer.json
func ExampleServersClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServersClient().BeginCreate(ctx, "TestRG", "azsdktest", armanalysisservices.Server{
		Location: to.Ptr("West US"),
		SKU: &armanalysisservices.ResourceSKU{
			Name:     to.Ptr("S1"),
			Capacity: to.Ptr[int32](1),
			Tier:     to.Ptr(armanalysisservices.SKUTierStandard),
		},
		Tags: map[string]*string{
			"testKey": to.Ptr("testValue"),
		},
		Properties: &armanalysisservices.ServerProperties{
			AsAdministrators: &armanalysisservices.ServerAdministrators{
				Members: []*string{
					to.Ptr("azsdktest@microsoft.com"),
					to.Ptr("azsdktest2@microsoft.com")},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Server = armanalysisservices.Server{
	// 	Name: to.Ptr("azsdktest"),
	// 	ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.AnalysisServices/servers/azsdktest"),
	// 	Location: to.Ptr("West US"),
	// 	SKU: &armanalysisservices.ResourceSKU{
	// 		Name: to.Ptr("S1"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Tier: to.Ptr(armanalysisservices.SKUTierStandard),
	// 	},
	// 	Tags: map[string]*string{
	// 		"testKey": to.Ptr("testValue"),
	// 	},
	// 	Properties: &armanalysisservices.ServerProperties{
	// 		AsAdministrators: &armanalysisservices.ServerAdministrators{
	// 			Members: []*string{
	// 				to.Ptr("azsdktest@microsoft.com"),
	// 				to.Ptr("azsdktest2@microsoft.com")},
	// 			},
	// 			ProvisioningState: to.Ptr(armanalysisservices.ProvisioningStateSucceeded),
	// 			ServerFullName: to.Ptr("asazure://nightly1.asazure-int.windows.net/azsdktest"),
	// 			State: to.Ptr(armanalysisservices.StateProvisioning),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/deleteServer.json
func ExampleServersClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServersClient().BeginDelete(ctx, "TestRG", "azsdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/updateServer.json
func ExampleServersClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServersClient().BeginUpdate(ctx, "TestRG", "azsdktest", armanalysisservices.ServerUpdateParameters{
		Properties: &armanalysisservices.ServerMutableProperties{
			AsAdministrators: &armanalysisservices.ServerAdministrators{
				Members: []*string{
					to.Ptr("azsdktest@microsoft.com"),
					to.Ptr("azsdktest2@microsoft.com")},
			},
		},
		SKU: &armanalysisservices.ResourceSKU{
			Name:     to.Ptr("S1"),
			Capacity: to.Ptr[int32](1),
			Tier:     to.Ptr(armanalysisservices.SKUTierStandard),
		},
		Tags: map[string]*string{
			"testKey": to.Ptr("testValue"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Server = armanalysisservices.Server{
	// 	Name: to.Ptr("azsdktest"),
	// 	ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.AnalysisServices/servers/azsdktest"),
	// 	Location: to.Ptr("West US"),
	// 	SKU: &armanalysisservices.ResourceSKU{
	// 		Name: to.Ptr("S1"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Tier: to.Ptr(armanalysisservices.SKUTierStandard),
	// 	},
	// 	Tags: map[string]*string{
	// 		"testKey": to.Ptr("testValue"),
	// 	},
	// 	Properties: &armanalysisservices.ServerProperties{
	// 		AsAdministrators: &armanalysisservices.ServerAdministrators{
	// 			Members: []*string{
	// 				to.Ptr("azsdktest@microsoft.com"),
	// 				to.Ptr("azsdktest2@microsoft.com")},
	// 			},
	// 			ProvisioningState: to.Ptr(armanalysisservices.ProvisioningStateSucceeded),
	// 			ServerFullName: to.Ptr("asazure://nightly1.asazure-int.windows.net/azsdktest"),
	// 			State: to.Ptr(armanalysisservices.StateProvisioning),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/suspendServer.json
func ExampleServersClient_BeginSuspend() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServersClient().BeginSuspend(ctx, "TestRG", "azsdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/resumeServer.json
func ExampleServersClient_BeginResume() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServersClient().BeginResume(ctx, "TestRG", "azsdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/listServersInResourceGroup.json
func ExampleServersClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServersClient().NewListByResourceGroupPager("TestRG", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.Servers = armanalysisservices.Servers{
		// 	Value: []*armanalysisservices.Server{
		// 		{
		// 			Name: to.Ptr("azsdktest"),
		// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.AnalysisServices/servers/azsdktest"),
		// 			Location: to.Ptr("West US"),
		// 			SKU: &armanalysisservices.ResourceSKU{
		// 				Name: to.Ptr("S1"),
		// 				Capacity: to.Ptr[int32](1),
		// 				Tier: to.Ptr(armanalysisservices.SKUTierStandard),
		// 			},
		// 			Tags: map[string]*string{
		// 				"testKey": to.Ptr("testValue"),
		// 			},
		// 			Properties: &armanalysisservices.ServerProperties{
		// 				AsAdministrators: &armanalysisservices.ServerAdministrators{
		// 					Members: []*string{
		// 						to.Ptr("azsdktest@microsoft.com")},
		// 					},
		// 					ProvisioningState: to.Ptr(armanalysisservices.ProvisioningStateSucceeded),
		// 					ServerFullName: to.Ptr("asazure://nightly1.asazure-int.windows.net/azsdktest"),
		// 					State: to.Ptr(armanalysisservices.StateProvisioning),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("azsdktest2"),
		// 				ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.AnalysisServices/servers/azsdktest"),
		// 				Location: to.Ptr("West US"),
		// 				SKU: &armanalysisservices.ResourceSKU{
		// 					Name: to.Ptr("S0"),
		// 					Capacity: to.Ptr[int32](1),
		// 					Tier: to.Ptr(armanalysisservices.SKUTierStandard),
		// 				},
		// 				Tags: map[string]*string{
		// 					"testKey": to.Ptr("testValue"),
		// 				},
		// 				Properties: &armanalysisservices.ServerProperties{
		// 					AsAdministrators: &armanalysisservices.ServerAdministrators{
		// 						Members: []*string{
		// 							to.Ptr("azsdktest@microsoft.com")},
		// 						},
		// 						ProvisioningState: to.Ptr(armanalysisservices.ProvisioningStateSucceeded),
		// 						ServerFullName: to.Ptr("asazure://nightly1.asazure-int.windows.net/azsdktest"),
		// 						State: to.Ptr(armanalysisservices.StateProvisioning),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/listServers.json
func ExampleServersClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServersClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.Servers = armanalysisservices.Servers{
		// 	Value: []*armanalysisservices.Server{
		// 		{
		// 			Name: to.Ptr("azsdktest"),
		// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.AnalysisServices/servers/azsdktest"),
		// 			Location: to.Ptr("West US"),
		// 			SKU: &armanalysisservices.ResourceSKU{
		// 				Name: to.Ptr("S1"),
		// 				Capacity: to.Ptr[int32](1),
		// 				Tier: to.Ptr(armanalysisservices.SKUTierStandard),
		// 			},
		// 			Tags: map[string]*string{
		// 				"testKey": to.Ptr("testValue"),
		// 			},
		// 			Properties: &armanalysisservices.ServerProperties{
		// 				AsAdministrators: &armanalysisservices.ServerAdministrators{
		// 					Members: []*string{
		// 						to.Ptr("azsdktest@microsoft.com")},
		// 					},
		// 					ProvisioningState: to.Ptr(armanalysisservices.ProvisioningStateSucceeded),
		// 					ServerFullName: to.Ptr("asazure://nightly1.asazure-int.windows.net/azsdktest"),
		// 					State: to.Ptr(armanalysisservices.StateProvisioning),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("azsdktest2"),
		// 				ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG2/providers/Microsoft.AnalysisServices/servers/azsdktest"),
		// 				Location: to.Ptr("West US"),
		// 				SKU: &armanalysisservices.ResourceSKU{
		// 					Name: to.Ptr("S0"),
		// 					Capacity: to.Ptr[int32](1),
		// 					Tier: to.Ptr(armanalysisservices.SKUTierStandard),
		// 				},
		// 				Tags: map[string]*string{
		// 					"testKey": to.Ptr("testValue"),
		// 				},
		// 				Properties: &armanalysisservices.ServerProperties{
		// 					AsAdministrators: &armanalysisservices.ServerAdministrators{
		// 						Members: []*string{
		// 							to.Ptr("azsdktest@microsoft.com")},
		// 						},
		// 						ProvisioningState: to.Ptr(armanalysisservices.ProvisioningStateSucceeded),
		// 						ServerFullName: to.Ptr("asazure://nightly1.asazure-int.windows.net/azsdktest"),
		// 						State: to.Ptr(armanalysisservices.StateProvisioning),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/listSkusForNew.json
func ExampleServersClient_ListSKUsForNew() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().ListSKUsForNew(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SKUEnumerationForNewResourceResult = armanalysisservices.SKUEnumerationForNewResourceResult{
	// 	Value: []*armanalysisservices.ResourceSKU{
	// 		{
	// 			Name: to.Ptr("B1"),
	// 		},
	// 		{
	// 			Name: to.Ptr("B2"),
	// 		},
	// 		{
	// 			Name: to.Ptr("D1"),
	// 		},
	// 		{
	// 			Name: to.Ptr("S0"),
	// 		},
	// 		{
	// 			Name: to.Ptr("S1"),
	// 		},
	// 		{
	// 			Name: to.Ptr("S2"),
	// 		},
	// 		{
	// 			Name: to.Ptr("S3"),
	// 		},
	// 		{
	// 			Name: to.Ptr("S4"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/listSkusForExisting.json
func ExampleServersClient_ListSKUsForExisting() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().ListSKUsForExisting(ctx, "TestRG", "azsdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SKUEnumerationForExistingResourceResult = armanalysisservices.SKUEnumerationForExistingResourceResult{
	// 	Value: []*armanalysisservices.SKUDetailsForExistingResource{
	// 		{
	// 			SKU: &armanalysisservices.ResourceSKU{
	// 				Name: to.Ptr("B1"),
	// 				Tier: to.Ptr(armanalysisservices.SKUTierBasic),
	// 			},
	// 		},
	// 		{
	// 			SKU: &armanalysisservices.ResourceSKU{
	// 				Name: to.Ptr("B2"),
	// 				Tier: to.Ptr(armanalysisservices.SKUTierBasic),
	// 			},
	// 		},
	// 		{
	// 			SKU: &armanalysisservices.ResourceSKU{
	// 				Name: to.Ptr("S0"),
	// 				Tier: to.Ptr(armanalysisservices.SKUTierStandard),
	// 			},
	// 		},
	// 		{
	// 			SKU: &armanalysisservices.ResourceSKU{
	// 				Name: to.Ptr("S1"),
	// 				Tier: to.Ptr(armanalysisservices.SKUTierStandard),
	// 			},
	// 		},
	// 		{
	// 			SKU: &armanalysisservices.ResourceSKU{
	// 				Name: to.Ptr("S2"),
	// 				Tier: to.Ptr(armanalysisservices.SKUTierStandard),
	// 			},
	// 		},
	// 		{
	// 			SKU: &armanalysisservices.ResourceSKU{
	// 				Name: to.Ptr("S3"),
	// 				Tier: to.Ptr(armanalysisservices.SKUTierStandard),
	// 			},
	// 		},
	// 		{
	// 			SKU: &armanalysisservices.ResourceSKU{
	// 				Name: to.Ptr("S4"),
	// 				Tier: to.Ptr(armanalysisservices.SKUTierStandard),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/listGatewayStatus.json
func ExampleServersClient_ListGatewayStatus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().ListGatewayStatus(ctx, "TestRG", "azsdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GatewayListStatusLive = armanalysisservices.GatewayListStatusLive{
	// 	Status: to.Ptr[int32](0),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/dissociateGateway.json
func ExampleServersClient_DissociateGateway() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewServersClient().DissociateGateway(ctx, "TestRG", "azsdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/checkNameAvailability.json
func ExampleServersClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().CheckNameAvailability(ctx, "West US", armanalysisservices.CheckServerNameAvailabilityParameters{
		Name: to.Ptr("azsdktest"),
		Type: to.Ptr("Microsoft.AnalysisServices/servers"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckServerNameAvailabilityResult = armanalysisservices.CheckServerNameAvailabilityResult{
	// 	NameAvailable: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/operationResults.json
func ExampleServersClient_ListOperationResults() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewServersClient().ListOperationResults(ctx, "West US", "00000000000000000000000000000000", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/operationStatuses.json
func ExampleServersClient_ListOperationStatuses() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armanalysisservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().ListOperationStatuses(ctx, "West US", "testoperationid", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationStatus = armanalysisservices.OperationStatus{
	// 	Name: to.Ptr("testoperationid"),
	// 	EndTime: to.Ptr("2017-01-01T16:13:13.933Z"),
	// 	ID: to.Ptr("/subscriptions/id/locations/westus/operationstatuses/testoperationid"),
	// 	StartTime: to.Ptr("2017-01-01T13:13:13.933Z"),
	// 	Status: to.Ptr("Succeeded"),
	// }
}
