//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapimanagement

// APIClientCreateOrUpdateResponse contains the response from method APIClient.BeginCreateOrUpdate.
type APIClientCreateOrUpdateResponse struct {
	// API details.
	APIContract
}

// APIClientDeleteResponse contains the response from method APIClient.Delete.
type APIClientDeleteResponse struct {
	// placeholder for future response values
}

// APIClientGetEntityTagResponse contains the response from method APIClient.GetEntityTag.
type APIClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIClientGetResponse contains the response from method APIClient.Get.
type APIClientGetResponse struct {
	// API details.
	APIContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIClientListByServiceResponse contains the response from method APIClient.NewListByServicePager.
type APIClientListByServiceResponse struct {
	// Paged API list representation.
	APICollection
}

// APIClientListByTagsResponse contains the response from method APIClient.NewListByTagsPager.
type APIClientListByTagsResponse struct {
	// Paged Tag list representation.
	TagResourceCollection
}

// APIClientUpdateResponse contains the response from method APIClient.Update.
type APIClientUpdateResponse struct {
	// API details.
	APIContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIDiagnosticClientCreateOrUpdateResponse contains the response from method APIDiagnosticClient.CreateOrUpdate.
type APIDiagnosticClientCreateOrUpdateResponse struct {
	// Diagnostic details.
	DiagnosticContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIDiagnosticClientDeleteResponse contains the response from method APIDiagnosticClient.Delete.
type APIDiagnosticClientDeleteResponse struct {
	// placeholder for future response values
}

// APIDiagnosticClientGetEntityTagResponse contains the response from method APIDiagnosticClient.GetEntityTag.
type APIDiagnosticClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIDiagnosticClientGetResponse contains the response from method APIDiagnosticClient.Get.
type APIDiagnosticClientGetResponse struct {
	// Diagnostic details.
	DiagnosticContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIDiagnosticClientListByServiceResponse contains the response from method APIDiagnosticClient.NewListByServicePager.
type APIDiagnosticClientListByServiceResponse struct {
	// Paged Diagnostic list representation.
	DiagnosticCollection
}

// APIDiagnosticClientUpdateResponse contains the response from method APIDiagnosticClient.Update.
type APIDiagnosticClientUpdateResponse struct {
	// Diagnostic details.
	DiagnosticContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIExportClientGetResponse contains the response from method APIExportClient.Get.
type APIExportClientGetResponse struct {
	// API Export result.
	APIExportResult
}

// APIIssueAttachmentClientCreateOrUpdateResponse contains the response from method APIIssueAttachmentClient.CreateOrUpdate.
type APIIssueAttachmentClientCreateOrUpdateResponse struct {
	// Issue Attachment Contract details.
	IssueAttachmentContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueAttachmentClientDeleteResponse contains the response from method APIIssueAttachmentClient.Delete.
type APIIssueAttachmentClientDeleteResponse struct {
	// placeholder for future response values
}

// APIIssueAttachmentClientGetEntityTagResponse contains the response from method APIIssueAttachmentClient.GetEntityTag.
type APIIssueAttachmentClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIIssueAttachmentClientGetResponse contains the response from method APIIssueAttachmentClient.Get.
type APIIssueAttachmentClientGetResponse struct {
	// Issue Attachment Contract details.
	IssueAttachmentContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueAttachmentClientListByServiceResponse contains the response from method APIIssueAttachmentClient.NewListByServicePager.
type APIIssueAttachmentClientListByServiceResponse struct {
	// Paged Issue Attachment list representation.
	IssueAttachmentCollection
}

// APIIssueClientCreateOrUpdateResponse contains the response from method APIIssueClient.CreateOrUpdate.
type APIIssueClientCreateOrUpdateResponse struct {
	// Issue Contract details.
	IssueContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueClientDeleteResponse contains the response from method APIIssueClient.Delete.
type APIIssueClientDeleteResponse struct {
	// placeholder for future response values
}

// APIIssueClientGetEntityTagResponse contains the response from method APIIssueClient.GetEntityTag.
type APIIssueClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIIssueClientGetResponse contains the response from method APIIssueClient.Get.
type APIIssueClientGetResponse struct {
	// Issue Contract details.
	IssueContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueClientListByServiceResponse contains the response from method APIIssueClient.NewListByServicePager.
type APIIssueClientListByServiceResponse struct {
	// Paged Issue list representation.
	IssueCollection
}

// APIIssueClientUpdateResponse contains the response from method APIIssueClient.Update.
type APIIssueClientUpdateResponse struct {
	// Issue Contract details.
	IssueContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueCommentClientCreateOrUpdateResponse contains the response from method APIIssueCommentClient.CreateOrUpdate.
type APIIssueCommentClientCreateOrUpdateResponse struct {
	// Issue Comment Contract details.
	IssueCommentContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueCommentClientDeleteResponse contains the response from method APIIssueCommentClient.Delete.
type APIIssueCommentClientDeleteResponse struct {
	// placeholder for future response values
}

// APIIssueCommentClientGetEntityTagResponse contains the response from method APIIssueCommentClient.GetEntityTag.
type APIIssueCommentClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIIssueCommentClientGetResponse contains the response from method APIIssueCommentClient.Get.
type APIIssueCommentClientGetResponse struct {
	// Issue Comment Contract details.
	IssueCommentContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueCommentClientListByServiceResponse contains the response from method APIIssueCommentClient.NewListByServicePager.
type APIIssueCommentClientListByServiceResponse struct {
	// Paged Issue Comment list representation.
	IssueCommentCollection
}

// APIOperationClientCreateOrUpdateResponse contains the response from method APIOperationClient.CreateOrUpdate.
type APIOperationClientCreateOrUpdateResponse struct {
	// API Operation details.
	OperationContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIOperationClientDeleteResponse contains the response from method APIOperationClient.Delete.
type APIOperationClientDeleteResponse struct {
	// placeholder for future response values
}

// APIOperationClientGetEntityTagResponse contains the response from method APIOperationClient.GetEntityTag.
type APIOperationClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIOperationClientGetResponse contains the response from method APIOperationClient.Get.
type APIOperationClientGetResponse struct {
	// API Operation details.
	OperationContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIOperationClientListByAPIResponse contains the response from method APIOperationClient.NewListByAPIPager.
type APIOperationClientListByAPIResponse struct {
	// Paged Operation list representation.
	OperationCollection
}

// APIOperationClientUpdateResponse contains the response from method APIOperationClient.Update.
type APIOperationClientUpdateResponse struct {
	// API Operation details.
	OperationContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIOperationPolicyClientCreateOrUpdateResponse contains the response from method APIOperationPolicyClient.CreateOrUpdate.
type APIOperationPolicyClientCreateOrUpdateResponse struct {
	// Policy Contract details.
	PolicyContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIOperationPolicyClientDeleteResponse contains the response from method APIOperationPolicyClient.Delete.
type APIOperationPolicyClientDeleteResponse struct {
	// placeholder for future response values
}

// APIOperationPolicyClientGetEntityTagResponse contains the response from method APIOperationPolicyClient.GetEntityTag.
type APIOperationPolicyClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIOperationPolicyClientGetResponse contains the response from method APIOperationPolicyClient.Get.
type APIOperationPolicyClientGetResponse struct {
	// Policy Contract details.
	PolicyContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIOperationPolicyClientListByOperationResponse contains the response from method APIOperationPolicyClient.ListByOperation.
type APIOperationPolicyClientListByOperationResponse struct {
	// The response of the list policy operation.
	PolicyCollection
}

// APIPolicyClientCreateOrUpdateResponse contains the response from method APIPolicyClient.CreateOrUpdate.
type APIPolicyClientCreateOrUpdateResponse struct {
	// Policy Contract details.
	PolicyContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIPolicyClientDeleteResponse contains the response from method APIPolicyClient.Delete.
type APIPolicyClientDeleteResponse struct {
	// placeholder for future response values
}

// APIPolicyClientGetEntityTagResponse contains the response from method APIPolicyClient.GetEntityTag.
type APIPolicyClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIPolicyClientGetResponse contains the response from method APIPolicyClient.Get.
type APIPolicyClientGetResponse struct {
	// Policy Contract details.
	PolicyContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIPolicyClientListByAPIResponse contains the response from method APIPolicyClient.ListByAPI.
type APIPolicyClientListByAPIResponse struct {
	// The response of the list policy operation.
	PolicyCollection
}

// APIProductClientListByApisResponse contains the response from method APIProductClient.NewListByApisPager.
type APIProductClientListByApisResponse struct {
	// Paged Products list representation.
	ProductCollection
}

// APIReleaseClientCreateOrUpdateResponse contains the response from method APIReleaseClient.CreateOrUpdate.
type APIReleaseClientCreateOrUpdateResponse struct {
	// ApiRelease details.
	APIReleaseContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIReleaseClientDeleteResponse contains the response from method APIReleaseClient.Delete.
type APIReleaseClientDeleteResponse struct {
	// placeholder for future response values
}

// APIReleaseClientGetEntityTagResponse contains the response from method APIReleaseClient.GetEntityTag.
type APIReleaseClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIReleaseClientGetResponse contains the response from method APIReleaseClient.Get.
type APIReleaseClientGetResponse struct {
	// ApiRelease details.
	APIReleaseContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIReleaseClientListByServiceResponse contains the response from method APIReleaseClient.NewListByServicePager.
type APIReleaseClientListByServiceResponse struct {
	// Paged ApiRelease list representation.
	APIReleaseCollection
}

// APIReleaseClientUpdateResponse contains the response from method APIReleaseClient.Update.
type APIReleaseClientUpdateResponse struct {
	// ApiRelease details.
	APIReleaseContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIRevisionClientListByServiceResponse contains the response from method APIRevisionClient.NewListByServicePager.
type APIRevisionClientListByServiceResponse struct {
	// Paged API Revision list representation.
	APIRevisionCollection
}

// APISchemaClientCreateOrUpdateResponse contains the response from method APISchemaClient.BeginCreateOrUpdate.
type APISchemaClientCreateOrUpdateResponse struct {
	// API Schema Contract details.
	SchemaContract
}

// APISchemaClientDeleteResponse contains the response from method APISchemaClient.Delete.
type APISchemaClientDeleteResponse struct {
	// placeholder for future response values
}

// APISchemaClientGetEntityTagResponse contains the response from method APISchemaClient.GetEntityTag.
type APISchemaClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APISchemaClientGetResponse contains the response from method APISchemaClient.Get.
type APISchemaClientGetResponse struct {
	// API Schema Contract details.
	SchemaContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APISchemaClientListByAPIResponse contains the response from method APISchemaClient.NewListByAPIPager.
type APISchemaClientListByAPIResponse struct {
	// The response of the list schema operation.
	SchemaCollection
}

// APITagDescriptionClientCreateOrUpdateResponse contains the response from method APITagDescriptionClient.CreateOrUpdate.
type APITagDescriptionClientCreateOrUpdateResponse struct {
	// Contract details.
	TagDescriptionContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APITagDescriptionClientDeleteResponse contains the response from method APITagDescriptionClient.Delete.
type APITagDescriptionClientDeleteResponse struct {
	// placeholder for future response values
}

// APITagDescriptionClientGetEntityTagResponse contains the response from method APITagDescriptionClient.GetEntityTag.
type APITagDescriptionClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APITagDescriptionClientGetResponse contains the response from method APITagDescriptionClient.Get.
type APITagDescriptionClientGetResponse struct {
	// Contract details.
	TagDescriptionContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APITagDescriptionClientListByServiceResponse contains the response from method APITagDescriptionClient.NewListByServicePager.
type APITagDescriptionClientListByServiceResponse struct {
	// Paged TagDescription list representation.
	TagDescriptionCollection
}

// APIVersionSetClientCreateOrUpdateResponse contains the response from method APIVersionSetClient.CreateOrUpdate.
type APIVersionSetClientCreateOrUpdateResponse struct {
	// API Version Set Contract details.
	APIVersionSetContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIVersionSetClientDeleteResponse contains the response from method APIVersionSetClient.Delete.
type APIVersionSetClientDeleteResponse struct {
	// placeholder for future response values
}

// APIVersionSetClientGetEntityTagResponse contains the response from method APIVersionSetClient.GetEntityTag.
type APIVersionSetClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIVersionSetClientGetResponse contains the response from method APIVersionSetClient.Get.
type APIVersionSetClientGetResponse struct {
	// API Version Set Contract details.
	APIVersionSetContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIVersionSetClientListByServiceResponse contains the response from method APIVersionSetClient.NewListByServicePager.
type APIVersionSetClientListByServiceResponse struct {
	// Paged API Version Set list representation.
	APIVersionSetCollection
}

// APIVersionSetClientUpdateResponse contains the response from method APIVersionSetClient.Update.
type APIVersionSetClientUpdateResponse struct {
	// API Version Set Contract details.
	APIVersionSetContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIWikiClientCreateOrUpdateResponse contains the response from method APIWikiClient.CreateOrUpdate.
type APIWikiClientCreateOrUpdateResponse struct {
	// Wiki properties
	WikiContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIWikiClientDeleteResponse contains the response from method APIWikiClient.Delete.
type APIWikiClientDeleteResponse struct {
	// placeholder for future response values
}

// APIWikiClientGetEntityTagResponse contains the response from method APIWikiClient.GetEntityTag.
type APIWikiClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIWikiClientGetResponse contains the response from method APIWikiClient.Get.
type APIWikiClientGetResponse struct {
	// Wiki properties
	WikiContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIWikiClientUpdateResponse contains the response from method APIWikiClient.Update.
type APIWikiClientUpdateResponse struct {
	// Wiki properties
	WikiContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIWikisClientListResponse contains the response from method APIWikisClient.NewListPager.
type APIWikisClientListResponse struct {
	// Paged Wiki list representation.
	WikiCollection
}

// AuthorizationAccessPolicyClientCreateOrUpdateResponse contains the response from method AuthorizationAccessPolicyClient.CreateOrUpdate.
type AuthorizationAccessPolicyClientCreateOrUpdateResponse struct {
	// Authorization access policy contract.
	AuthorizationAccessPolicyContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationAccessPolicyClientDeleteResponse contains the response from method AuthorizationAccessPolicyClient.Delete.
type AuthorizationAccessPolicyClientDeleteResponse struct {
	// placeholder for future response values
}

// AuthorizationAccessPolicyClientGetResponse contains the response from method AuthorizationAccessPolicyClient.Get.
type AuthorizationAccessPolicyClientGetResponse struct {
	// Authorization access policy contract.
	AuthorizationAccessPolicyContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationAccessPolicyClientListByAuthorizationResponse contains the response from method AuthorizationAccessPolicyClient.NewListByAuthorizationPager.
type AuthorizationAccessPolicyClientListByAuthorizationResponse struct {
	// Paged Authorization Access Policy list representation.
	AuthorizationAccessPolicyCollection
}

// AuthorizationClientConfirmConsentCodeResponse contains the response from method AuthorizationClient.ConfirmConsentCode.
type AuthorizationClientConfirmConsentCodeResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationClientCreateOrUpdateResponse contains the response from method AuthorizationClient.CreateOrUpdate.
type AuthorizationClientCreateOrUpdateResponse struct {
	// Authorization contract.
	AuthorizationContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationClientDeleteResponse contains the response from method AuthorizationClient.Delete.
type AuthorizationClientDeleteResponse struct {
	// placeholder for future response values
}

// AuthorizationClientGetResponse contains the response from method AuthorizationClient.Get.
type AuthorizationClientGetResponse struct {
	// Authorization contract.
	AuthorizationContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationClientListByAuthorizationProviderResponse contains the response from method AuthorizationClient.NewListByAuthorizationProviderPager.
type AuthorizationClientListByAuthorizationProviderResponse struct {
	// Paged Authorization list representation.
	AuthorizationCollection
}

// AuthorizationLoginLinksClientPostResponse contains the response from method AuthorizationLoginLinksClient.Post.
type AuthorizationLoginLinksClientPostResponse struct {
	// Authorization login response contract.
	AuthorizationLoginResponseContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationProviderClientCreateOrUpdateResponse contains the response from method AuthorizationProviderClient.CreateOrUpdate.
type AuthorizationProviderClientCreateOrUpdateResponse struct {
	// Authorization Provider contract.
	AuthorizationProviderContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationProviderClientDeleteResponse contains the response from method AuthorizationProviderClient.Delete.
type AuthorizationProviderClientDeleteResponse struct {
	// placeholder for future response values
}

// AuthorizationProviderClientGetResponse contains the response from method AuthorizationProviderClient.Get.
type AuthorizationProviderClientGetResponse struct {
	// Authorization Provider contract.
	AuthorizationProviderContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationProviderClientListByServiceResponse contains the response from method AuthorizationProviderClient.NewListByServicePager.
type AuthorizationProviderClientListByServiceResponse struct {
	// Paged Authorization Provider list representation.
	AuthorizationProviderCollection
}

// AuthorizationServerClientCreateOrUpdateResponse contains the response from method AuthorizationServerClient.CreateOrUpdate.
type AuthorizationServerClientCreateOrUpdateResponse struct {
	// External OAuth authorization server settings.
	AuthorizationServerContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationServerClientDeleteResponse contains the response from method AuthorizationServerClient.Delete.
type AuthorizationServerClientDeleteResponse struct {
	// placeholder for future response values
}

// AuthorizationServerClientGetEntityTagResponse contains the response from method AuthorizationServerClient.GetEntityTag.
type AuthorizationServerClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// AuthorizationServerClientGetResponse contains the response from method AuthorizationServerClient.Get.
type AuthorizationServerClientGetResponse struct {
	// External OAuth authorization server settings.
	AuthorizationServerContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationServerClientListByServiceResponse contains the response from method AuthorizationServerClient.NewListByServicePager.
type AuthorizationServerClientListByServiceResponse struct {
	// Paged OAuth2 Authorization Servers list representation.
	AuthorizationServerCollection
}

// AuthorizationServerClientListSecretsResponse contains the response from method AuthorizationServerClient.ListSecrets.
type AuthorizationServerClientListSecretsResponse struct {
	// OAuth Server Secrets Contract.
	AuthorizationServerSecretsContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationServerClientUpdateResponse contains the response from method AuthorizationServerClient.Update.
type AuthorizationServerClientUpdateResponse struct {
	// External OAuth authorization server settings.
	AuthorizationServerContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// BackendClientCreateOrUpdateResponse contains the response from method BackendClient.CreateOrUpdate.
type BackendClientCreateOrUpdateResponse struct {
	// Backend details.
	BackendContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// BackendClientDeleteResponse contains the response from method BackendClient.Delete.
type BackendClientDeleteResponse struct {
	// placeholder for future response values
}

// BackendClientGetEntityTagResponse contains the response from method BackendClient.GetEntityTag.
type BackendClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// BackendClientGetResponse contains the response from method BackendClient.Get.
type BackendClientGetResponse struct {
	// Backend details.
	BackendContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// BackendClientListByServiceResponse contains the response from method BackendClient.NewListByServicePager.
type BackendClientListByServiceResponse struct {
	// Paged Backend list representation.
	BackendCollection
}

// BackendClientReconnectResponse contains the response from method BackendClient.Reconnect.
type BackendClientReconnectResponse struct {
	// placeholder for future response values
}

// BackendClientUpdateResponse contains the response from method BackendClient.Update.
type BackendClientUpdateResponse struct {
	// Backend details.
	BackendContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// CacheClientCreateOrUpdateResponse contains the response from method CacheClient.CreateOrUpdate.
type CacheClientCreateOrUpdateResponse struct {
	// Cache details.
	CacheContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// CacheClientDeleteResponse contains the response from method CacheClient.Delete.
type CacheClientDeleteResponse struct {
	// placeholder for future response values
}

// CacheClientGetEntityTagResponse contains the response from method CacheClient.GetEntityTag.
type CacheClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// CacheClientGetResponse contains the response from method CacheClient.Get.
type CacheClientGetResponse struct {
	// Cache details.
	CacheContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// CacheClientListByServiceResponse contains the response from method CacheClient.NewListByServicePager.
type CacheClientListByServiceResponse struct {
	// Paged Caches list representation.
	CacheCollection
}

// CacheClientUpdateResponse contains the response from method CacheClient.Update.
type CacheClientUpdateResponse struct {
	// Cache details.
	CacheContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// CertificateClientCreateOrUpdateResponse contains the response from method CertificateClient.CreateOrUpdate.
type CertificateClientCreateOrUpdateResponse struct {
	// Certificate details.
	CertificateContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// CertificateClientDeleteResponse contains the response from method CertificateClient.Delete.
type CertificateClientDeleteResponse struct {
	// placeholder for future response values
}

// CertificateClientGetEntityTagResponse contains the response from method CertificateClient.GetEntityTag.
type CertificateClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// CertificateClientGetResponse contains the response from method CertificateClient.Get.
type CertificateClientGetResponse struct {
	// Certificate details.
	CertificateContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// CertificateClientListByServiceResponse contains the response from method CertificateClient.NewListByServicePager.
type CertificateClientListByServiceResponse struct {
	// Paged Certificates list representation.
	CertificateCollection
}

// CertificateClientRefreshSecretResponse contains the response from method CertificateClient.RefreshSecret.
type CertificateClientRefreshSecretResponse struct {
	// Certificate details.
	CertificateContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ClientPerformConnectivityCheckAsyncResponse contains the response from method Client.BeginPerformConnectivityCheckAsync.
type ClientPerformConnectivityCheckAsyncResponse struct {
	// Information on the connectivity status.
	ConnectivityCheckResponse
}

// ContentItemClientCreateOrUpdateResponse contains the response from method ContentItemClient.CreateOrUpdate.
type ContentItemClientCreateOrUpdateResponse struct {
	// Content type contract details.
	ContentItemContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ContentItemClientDeleteResponse contains the response from method ContentItemClient.Delete.
type ContentItemClientDeleteResponse struct {
	// placeholder for future response values
}

// ContentItemClientGetEntityTagResponse contains the response from method ContentItemClient.GetEntityTag.
type ContentItemClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// ContentItemClientGetResponse contains the response from method ContentItemClient.Get.
type ContentItemClientGetResponse struct {
	// Content type contract details.
	ContentItemContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ContentItemClientListByServiceResponse contains the response from method ContentItemClient.NewListByServicePager.
type ContentItemClientListByServiceResponse struct {
	// Paged list of content items.
	ContentItemCollection
}

// ContentTypeClientCreateOrUpdateResponse contains the response from method ContentTypeClient.CreateOrUpdate.
type ContentTypeClientCreateOrUpdateResponse struct {
	// Content type contract details.
	ContentTypeContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ContentTypeClientDeleteResponse contains the response from method ContentTypeClient.Delete.
type ContentTypeClientDeleteResponse struct {
	// placeholder for future response values
}

// ContentTypeClientGetResponse contains the response from method ContentTypeClient.Get.
type ContentTypeClientGetResponse struct {
	// Content type contract details.
	ContentTypeContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ContentTypeClientListByServiceResponse contains the response from method ContentTypeClient.NewListByServicePager.
type ContentTypeClientListByServiceResponse struct {
	// Paged list of content types.
	ContentTypeCollection
}

// DelegationSettingsClientCreateOrUpdateResponse contains the response from method DelegationSettingsClient.CreateOrUpdate.
type DelegationSettingsClientCreateOrUpdateResponse struct {
	// Delegation settings for a developer portal.
	PortalDelegationSettings
}

// DelegationSettingsClientGetEntityTagResponse contains the response from method DelegationSettingsClient.GetEntityTag.
type DelegationSettingsClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// DelegationSettingsClientGetResponse contains the response from method DelegationSettingsClient.Get.
type DelegationSettingsClientGetResponse struct {
	// Delegation settings for a developer portal.
	PortalDelegationSettings

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// DelegationSettingsClientListSecretsResponse contains the response from method DelegationSettingsClient.ListSecrets.
type DelegationSettingsClientListSecretsResponse struct {
	// Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
	PortalSettingValidationKeyContract
}

// DelegationSettingsClientUpdateResponse contains the response from method DelegationSettingsClient.Update.
type DelegationSettingsClientUpdateResponse struct {
	// placeholder for future response values
}

// DeletedServicesClientGetByNameResponse contains the response from method DeletedServicesClient.GetByName.
type DeletedServicesClientGetByNameResponse struct {
	// Deleted API Management Service information.
	DeletedServiceContract
}

// DeletedServicesClientListBySubscriptionResponse contains the response from method DeletedServicesClient.NewListBySubscriptionPager.
type DeletedServicesClientListBySubscriptionResponse struct {
	// Paged deleted API Management Services List Representation.
	DeletedServicesCollection
}

// DeletedServicesClientPurgeResponse contains the response from method DeletedServicesClient.BeginPurge.
type DeletedServicesClientPurgeResponse struct {
	// Deleted API Management Service information.
	DeletedServiceContract
}

// DiagnosticClientCreateOrUpdateResponse contains the response from method DiagnosticClient.CreateOrUpdate.
type DiagnosticClientCreateOrUpdateResponse struct {
	// Diagnostic details.
	DiagnosticContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// DiagnosticClientDeleteResponse contains the response from method DiagnosticClient.Delete.
type DiagnosticClientDeleteResponse struct {
	// placeholder for future response values
}

// DiagnosticClientGetEntityTagResponse contains the response from method DiagnosticClient.GetEntityTag.
type DiagnosticClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// DiagnosticClientGetResponse contains the response from method DiagnosticClient.Get.
type DiagnosticClientGetResponse struct {
	// Diagnostic details.
	DiagnosticContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// DiagnosticClientListByServiceResponse contains the response from method DiagnosticClient.NewListByServicePager.
type DiagnosticClientListByServiceResponse struct {
	// Paged Diagnostic list representation.
	DiagnosticCollection
}

// DiagnosticClientUpdateResponse contains the response from method DiagnosticClient.Update.
type DiagnosticClientUpdateResponse struct {
	// Diagnostic details.
	DiagnosticContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// DocumentationClientCreateOrUpdateResponse contains the response from method DocumentationClient.CreateOrUpdate.
type DocumentationClientCreateOrUpdateResponse struct {
	// Markdown documentation details.
	DocumentationContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// DocumentationClientDeleteResponse contains the response from method DocumentationClient.Delete.
type DocumentationClientDeleteResponse struct {
	// placeholder for future response values
}

// DocumentationClientGetEntityTagResponse contains the response from method DocumentationClient.GetEntityTag.
type DocumentationClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// DocumentationClientGetResponse contains the response from method DocumentationClient.Get.
type DocumentationClientGetResponse struct {
	// Markdown documentation details.
	DocumentationContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// DocumentationClientListByServiceResponse contains the response from method DocumentationClient.NewListByServicePager.
type DocumentationClientListByServiceResponse struct {
	// Paged Documentation list representation.
	DocumentationCollection
}

// DocumentationClientUpdateResponse contains the response from method DocumentationClient.Update.
type DocumentationClientUpdateResponse struct {
	// Markdown documentation details.
	DocumentationContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// EmailTemplateClientCreateOrUpdateResponse contains the response from method EmailTemplateClient.CreateOrUpdate.
type EmailTemplateClientCreateOrUpdateResponse struct {
	// Email Template details.
	EmailTemplateContract
}

// EmailTemplateClientDeleteResponse contains the response from method EmailTemplateClient.Delete.
type EmailTemplateClientDeleteResponse struct {
	// placeholder for future response values
}

// EmailTemplateClientGetEntityTagResponse contains the response from method EmailTemplateClient.GetEntityTag.
type EmailTemplateClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// EmailTemplateClientGetResponse contains the response from method EmailTemplateClient.Get.
type EmailTemplateClientGetResponse struct {
	// Email Template details.
	EmailTemplateContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// EmailTemplateClientListByServiceResponse contains the response from method EmailTemplateClient.NewListByServicePager.
type EmailTemplateClientListByServiceResponse struct {
	// Paged email template list representation.
	EmailTemplateCollection
}

// EmailTemplateClientUpdateResponse contains the response from method EmailTemplateClient.Update.
type EmailTemplateClientUpdateResponse struct {
	// Email Template details.
	EmailTemplateContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayAPIClientCreateOrUpdateResponse contains the response from method GatewayAPIClient.CreateOrUpdate.
type GatewayAPIClientCreateOrUpdateResponse struct {
	// API details.
	APIContract
}

// GatewayAPIClientDeleteResponse contains the response from method GatewayAPIClient.Delete.
type GatewayAPIClientDeleteResponse struct {
	// placeholder for future response values
}

// GatewayAPIClientGetEntityTagResponse contains the response from method GatewayAPIClient.GetEntityTag.
type GatewayAPIClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GatewayAPIClientListByServiceResponse contains the response from method GatewayAPIClient.NewListByServicePager.
type GatewayAPIClientListByServiceResponse struct {
	// Paged API list representation.
	APICollection
}

// GatewayCertificateAuthorityClientCreateOrUpdateResponse contains the response from method GatewayCertificateAuthorityClient.CreateOrUpdate.
type GatewayCertificateAuthorityClientCreateOrUpdateResponse struct {
	// Gateway certificate authority details.
	GatewayCertificateAuthorityContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayCertificateAuthorityClientDeleteResponse contains the response from method GatewayCertificateAuthorityClient.Delete.
type GatewayCertificateAuthorityClientDeleteResponse struct {
	// placeholder for future response values
}

// GatewayCertificateAuthorityClientGetEntityTagResponse contains the response from method GatewayCertificateAuthorityClient.GetEntityTag.
type GatewayCertificateAuthorityClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GatewayCertificateAuthorityClientGetResponse contains the response from method GatewayCertificateAuthorityClient.Get.
type GatewayCertificateAuthorityClientGetResponse struct {
	// Gateway certificate authority details.
	GatewayCertificateAuthorityContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayCertificateAuthorityClientListByServiceResponse contains the response from method GatewayCertificateAuthorityClient.NewListByServicePager.
type GatewayCertificateAuthorityClientListByServiceResponse struct {
	// Paged Gateway certificate authority list representation.
	GatewayCertificateAuthorityCollection
}

// GatewayClientCreateOrUpdateResponse contains the response from method GatewayClient.CreateOrUpdate.
type GatewayClientCreateOrUpdateResponse struct {
	// Gateway details.
	GatewayContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayClientDeleteResponse contains the response from method GatewayClient.Delete.
type GatewayClientDeleteResponse struct {
	// placeholder for future response values
}

// GatewayClientGenerateTokenResponse contains the response from method GatewayClient.GenerateToken.
type GatewayClientGenerateTokenResponse struct {
	// Gateway access token.
	GatewayTokenContract
}

// GatewayClientGetEntityTagResponse contains the response from method GatewayClient.GetEntityTag.
type GatewayClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GatewayClientGetResponse contains the response from method GatewayClient.Get.
type GatewayClientGetResponse struct {
	// Gateway details.
	GatewayContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayClientListByServiceResponse contains the response from method GatewayClient.NewListByServicePager.
type GatewayClientListByServiceResponse struct {
	// Paged Gateway list representation.
	GatewayCollection
}

// GatewayClientListKeysResponse contains the response from method GatewayClient.ListKeys.
type GatewayClientListKeysResponse struct {
	// Gateway authentication keys.
	GatewayKeysContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayClientRegenerateKeyResponse contains the response from method GatewayClient.RegenerateKey.
type GatewayClientRegenerateKeyResponse struct {
	// placeholder for future response values
}

// GatewayClientUpdateResponse contains the response from method GatewayClient.Update.
type GatewayClientUpdateResponse struct {
	// Gateway details.
	GatewayContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayHostnameConfigurationClientCreateOrUpdateResponse contains the response from method GatewayHostnameConfigurationClient.CreateOrUpdate.
type GatewayHostnameConfigurationClientCreateOrUpdateResponse struct {
	// Gateway hostname configuration details.
	GatewayHostnameConfigurationContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayHostnameConfigurationClientDeleteResponse contains the response from method GatewayHostnameConfigurationClient.Delete.
type GatewayHostnameConfigurationClientDeleteResponse struct {
	// placeholder for future response values
}

// GatewayHostnameConfigurationClientGetEntityTagResponse contains the response from method GatewayHostnameConfigurationClient.GetEntityTag.
type GatewayHostnameConfigurationClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GatewayHostnameConfigurationClientGetResponse contains the response from method GatewayHostnameConfigurationClient.Get.
type GatewayHostnameConfigurationClientGetResponse struct {
	// Gateway hostname configuration details.
	GatewayHostnameConfigurationContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayHostnameConfigurationClientListByServiceResponse contains the response from method GatewayHostnameConfigurationClient.NewListByServicePager.
type GatewayHostnameConfigurationClientListByServiceResponse struct {
	// Paged Gateway hostname configuration list representation.
	GatewayHostnameConfigurationCollection
}

// GlobalSchemaClientCreateOrUpdateResponse contains the response from method GlobalSchemaClient.BeginCreateOrUpdate.
type GlobalSchemaClientCreateOrUpdateResponse struct {
	// Global Schema Contract details.
	GlobalSchemaContract
}

// GlobalSchemaClientDeleteResponse contains the response from method GlobalSchemaClient.Delete.
type GlobalSchemaClientDeleteResponse struct {
	// placeholder for future response values
}

// GlobalSchemaClientGetEntityTagResponse contains the response from method GlobalSchemaClient.GetEntityTag.
type GlobalSchemaClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GlobalSchemaClientGetResponse contains the response from method GlobalSchemaClient.Get.
type GlobalSchemaClientGetResponse struct {
	// Global Schema Contract details.
	GlobalSchemaContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GlobalSchemaClientListByServiceResponse contains the response from method GlobalSchemaClient.NewListByServicePager.
type GlobalSchemaClientListByServiceResponse struct {
	// The response of the list schema operation.
	GlobalSchemaCollection
}

// GraphQLAPIResolverClientCreateOrUpdateResponse contains the response from method GraphQLAPIResolverClient.CreateOrUpdate.
type GraphQLAPIResolverClientCreateOrUpdateResponse struct {
	// GraphQL API Resolver details.
	ResolverContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GraphQLAPIResolverClientDeleteResponse contains the response from method GraphQLAPIResolverClient.Delete.
type GraphQLAPIResolverClientDeleteResponse struct {
	// placeholder for future response values
}

// GraphQLAPIResolverClientGetEntityTagResponse contains the response from method GraphQLAPIResolverClient.GetEntityTag.
type GraphQLAPIResolverClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GraphQLAPIResolverClientGetResponse contains the response from method GraphQLAPIResolverClient.Get.
type GraphQLAPIResolverClientGetResponse struct {
	// GraphQL API Resolver details.
	ResolverContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GraphQLAPIResolverClientListByAPIResponse contains the response from method GraphQLAPIResolverClient.NewListByAPIPager.
type GraphQLAPIResolverClientListByAPIResponse struct {
	// Paged Resolver list representation.
	ResolverCollection
}

// GraphQLAPIResolverClientUpdateResponse contains the response from method GraphQLAPIResolverClient.Update.
type GraphQLAPIResolverClientUpdateResponse struct {
	// GraphQL API Resolver details.
	ResolverContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GraphQLAPIResolverPolicyClientCreateOrUpdateResponse contains the response from method GraphQLAPIResolverPolicyClient.CreateOrUpdate.
type GraphQLAPIResolverPolicyClientCreateOrUpdateResponse struct {
	// Policy Contract details.
	PolicyContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GraphQLAPIResolverPolicyClientDeleteResponse contains the response from method GraphQLAPIResolverPolicyClient.Delete.
type GraphQLAPIResolverPolicyClientDeleteResponse struct {
	// placeholder for future response values
}

// GraphQLAPIResolverPolicyClientGetEntityTagResponse contains the response from method GraphQLAPIResolverPolicyClient.GetEntityTag.
type GraphQLAPIResolverPolicyClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GraphQLAPIResolverPolicyClientGetResponse contains the response from method GraphQLAPIResolverPolicyClient.Get.
type GraphQLAPIResolverPolicyClientGetResponse struct {
	// Policy Contract details.
	PolicyContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GraphQLAPIResolverPolicyClientListByResolverResponse contains the response from method GraphQLAPIResolverPolicyClient.NewListByResolverPager.
type GraphQLAPIResolverPolicyClientListByResolverResponse struct {
	// The response of the list policy operation.
	PolicyCollection
}

// GroupClientCreateOrUpdateResponse contains the response from method GroupClient.CreateOrUpdate.
type GroupClientCreateOrUpdateResponse struct {
	// Contract details.
	GroupContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GroupClientDeleteResponse contains the response from method GroupClient.Delete.
type GroupClientDeleteResponse struct {
	// placeholder for future response values
}

// GroupClientGetEntityTagResponse contains the response from method GroupClient.GetEntityTag.
type GroupClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GroupClientGetResponse contains the response from method GroupClient.Get.
type GroupClientGetResponse struct {
	// Contract details.
	GroupContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GroupClientListByServiceResponse contains the response from method GroupClient.NewListByServicePager.
type GroupClientListByServiceResponse struct {
	// Paged Group list representation.
	GroupCollection
}

// GroupClientUpdateResponse contains the response from method GroupClient.Update.
type GroupClientUpdateResponse struct {
	// Contract details.
	GroupContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GroupUserClientCheckEntityExistsResponse contains the response from method GroupUserClient.CheckEntityExists.
type GroupUserClientCheckEntityExistsResponse struct {
	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GroupUserClientCreateResponse contains the response from method GroupUserClient.Create.
type GroupUserClientCreateResponse struct {
	// User details.
	UserContract
}

// GroupUserClientDeleteResponse contains the response from method GroupUserClient.Delete.
type GroupUserClientDeleteResponse struct {
	// placeholder for future response values
}

// GroupUserClientListResponse contains the response from method GroupUserClient.NewListPager.
type GroupUserClientListResponse struct {
	// Paged Users list representation.
	UserCollection
}

// IdentityProviderClientCreateOrUpdateResponse contains the response from method IdentityProviderClient.CreateOrUpdate.
type IdentityProviderClientCreateOrUpdateResponse struct {
	// Identity Provider details.
	IdentityProviderContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// IdentityProviderClientDeleteResponse contains the response from method IdentityProviderClient.Delete.
type IdentityProviderClientDeleteResponse struct {
	// placeholder for future response values
}

// IdentityProviderClientGetEntityTagResponse contains the response from method IdentityProviderClient.GetEntityTag.
type IdentityProviderClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// IdentityProviderClientGetResponse contains the response from method IdentityProviderClient.Get.
type IdentityProviderClientGetResponse struct {
	// Identity Provider details.
	IdentityProviderContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// IdentityProviderClientListByServiceResponse contains the response from method IdentityProviderClient.NewListByServicePager.
type IdentityProviderClientListByServiceResponse struct {
	// List of all the Identity Providers configured on the service instance.
	IdentityProviderList
}

// IdentityProviderClientListSecretsResponse contains the response from method IdentityProviderClient.ListSecrets.
type IdentityProviderClientListSecretsResponse struct {
	// Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
	ClientSecretContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// IdentityProviderClientUpdateResponse contains the response from method IdentityProviderClient.Update.
type IdentityProviderClientUpdateResponse struct {
	// Identity Provider details.
	IdentityProviderContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// IssueClientGetResponse contains the response from method IssueClient.Get.
type IssueClientGetResponse struct {
	// Issue Contract details.
	IssueContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// IssueClientListByServiceResponse contains the response from method IssueClient.NewListByServicePager.
type IssueClientListByServiceResponse struct {
	// Paged Issue list representation.
	IssueCollection
}

// LoggerClientCreateOrUpdateResponse contains the response from method LoggerClient.CreateOrUpdate.
type LoggerClientCreateOrUpdateResponse struct {
	// Logger details.
	LoggerContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// LoggerClientDeleteResponse contains the response from method LoggerClient.Delete.
type LoggerClientDeleteResponse struct {
	// placeholder for future response values
}

// LoggerClientGetEntityTagResponse contains the response from method LoggerClient.GetEntityTag.
type LoggerClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// LoggerClientGetResponse contains the response from method LoggerClient.Get.
type LoggerClientGetResponse struct {
	// Logger details.
	LoggerContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// LoggerClientListByServiceResponse contains the response from method LoggerClient.NewListByServicePager.
type LoggerClientListByServiceResponse struct {
	// Paged Logger list representation.
	LoggerCollection
}

// LoggerClientUpdateResponse contains the response from method LoggerClient.Update.
type LoggerClientUpdateResponse struct {
	// Logger details.
	LoggerContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// NamedValueClientCreateOrUpdateResponse contains the response from method NamedValueClient.BeginCreateOrUpdate.
type NamedValueClientCreateOrUpdateResponse struct {
	// NamedValue details.
	NamedValueContract
}

// NamedValueClientDeleteResponse contains the response from method NamedValueClient.Delete.
type NamedValueClientDeleteResponse struct {
	// placeholder for future response values
}

// NamedValueClientGetEntityTagResponse contains the response from method NamedValueClient.GetEntityTag.
type NamedValueClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// NamedValueClientGetResponse contains the response from method NamedValueClient.Get.
type NamedValueClientGetResponse struct {
	// NamedValue details.
	NamedValueContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// NamedValueClientListByServiceResponse contains the response from method NamedValueClient.NewListByServicePager.
type NamedValueClientListByServiceResponse struct {
	// Paged NamedValue list representation.
	NamedValueCollection
}

// NamedValueClientListValueResponse contains the response from method NamedValueClient.ListValue.
type NamedValueClientListValueResponse struct {
	// Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
	NamedValueSecretContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// NamedValueClientRefreshSecretResponse contains the response from method NamedValueClient.BeginRefreshSecret.
type NamedValueClientRefreshSecretResponse struct {
	// NamedValue details.
	NamedValueContract
}

// NamedValueClientUpdateResponse contains the response from method NamedValueClient.BeginUpdate.
type NamedValueClientUpdateResponse struct {
	// NamedValue details.
	NamedValueContract
}

// NetworkStatusClientListByLocationResponse contains the response from method NetworkStatusClient.ListByLocation.
type NetworkStatusClientListByLocationResponse struct {
	// Network Status details.
	NetworkStatusContract
}

// NetworkStatusClientListByServiceResponse contains the response from method NetworkStatusClient.ListByService.
type NetworkStatusClientListByServiceResponse struct {
	// List of Network Status values.
	NetworkStatusContractByLocationArray []*NetworkStatusContractByLocation
}

// NotificationClientCreateOrUpdateResponse contains the response from method NotificationClient.CreateOrUpdate.
type NotificationClientCreateOrUpdateResponse struct {
	// Notification details.
	NotificationContract
}

// NotificationClientGetResponse contains the response from method NotificationClient.Get.
type NotificationClientGetResponse struct {
	// Notification details.
	NotificationContract
}

// NotificationClientListByServiceResponse contains the response from method NotificationClient.NewListByServicePager.
type NotificationClientListByServiceResponse struct {
	// Paged Notification list representation.
	NotificationCollection
}

// NotificationRecipientEmailClientCheckEntityExistsResponse contains the response from method NotificationRecipientEmailClient.CheckEntityExists.
type NotificationRecipientEmailClientCheckEntityExistsResponse struct {
	// Success indicates if the operation succeeded or failed.
	Success bool
}

// NotificationRecipientEmailClientCreateOrUpdateResponse contains the response from method NotificationRecipientEmailClient.CreateOrUpdate.
type NotificationRecipientEmailClientCreateOrUpdateResponse struct {
	// Recipient Email details.
	RecipientEmailContract
}

// NotificationRecipientEmailClientDeleteResponse contains the response from method NotificationRecipientEmailClient.Delete.
type NotificationRecipientEmailClientDeleteResponse struct {
	// placeholder for future response values
}

// NotificationRecipientEmailClientListByNotificationResponse contains the response from method NotificationRecipientEmailClient.ListByNotification.
type NotificationRecipientEmailClientListByNotificationResponse struct {
	// Paged Recipient User list representation.
	RecipientEmailCollection
}

// NotificationRecipientUserClientCheckEntityExistsResponse contains the response from method NotificationRecipientUserClient.CheckEntityExists.
type NotificationRecipientUserClientCheckEntityExistsResponse struct {
	// Success indicates if the operation succeeded or failed.
	Success bool
}

// NotificationRecipientUserClientCreateOrUpdateResponse contains the response from method NotificationRecipientUserClient.CreateOrUpdate.
type NotificationRecipientUserClientCreateOrUpdateResponse struct {
	// Recipient User details.
	RecipientUserContract
}

// NotificationRecipientUserClientDeleteResponse contains the response from method NotificationRecipientUserClient.Delete.
type NotificationRecipientUserClientDeleteResponse struct {
	// placeholder for future response values
}

// NotificationRecipientUserClientListByNotificationResponse contains the response from method NotificationRecipientUserClient.ListByNotification.
type NotificationRecipientUserClientListByNotificationResponse struct {
	// Paged Recipient User list representation.
	RecipientUserCollection
}

// OpenIDConnectProviderClientCreateOrUpdateResponse contains the response from method OpenIDConnectProviderClient.CreateOrUpdate.
type OpenIDConnectProviderClientCreateOrUpdateResponse struct {
	// OpenId Connect Provider details.
	OpenidConnectProviderContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// OpenIDConnectProviderClientDeleteResponse contains the response from method OpenIDConnectProviderClient.Delete.
type OpenIDConnectProviderClientDeleteResponse struct {
	// placeholder for future response values
}

// OpenIDConnectProviderClientGetEntityTagResponse contains the response from method OpenIDConnectProviderClient.GetEntityTag.
type OpenIDConnectProviderClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// OpenIDConnectProviderClientGetResponse contains the response from method OpenIDConnectProviderClient.Get.
type OpenIDConnectProviderClientGetResponse struct {
	// OpenId Connect Provider details.
	OpenidConnectProviderContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// OpenIDConnectProviderClientListByServiceResponse contains the response from method OpenIDConnectProviderClient.NewListByServicePager.
type OpenIDConnectProviderClientListByServiceResponse struct {
	// Paged OpenIdProviders list representation.
	OpenIDConnectProviderCollection
}

// OpenIDConnectProviderClientListSecretsResponse contains the response from method OpenIDConnectProviderClient.ListSecrets.
type OpenIDConnectProviderClientListSecretsResponse struct {
	// Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
	ClientSecretContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// OpenIDConnectProviderClientUpdateResponse contains the response from method OpenIDConnectProviderClient.Update.
type OpenIDConnectProviderClientUpdateResponse struct {
	// OpenId Connect Provider details.
	OpenidConnectProviderContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// OperationClientListByTagsResponse contains the response from method OperationClient.NewListByTagsPager.
type OperationClientListByTagsResponse struct {
	// Paged Tag list representation.
	TagResourceCollection
}

// OperationsClientListResponse contains the response from method OperationsClient.NewListPager.
type OperationsClientListResponse struct {
	// Result of the request to list REST API operations. It contains a list of operations and a URL nextLink to get the next
	// set of results.
	OperationListResult
}

// OutboundNetworkDependenciesEndpointsClientListByServiceResponse contains the response from method OutboundNetworkDependenciesEndpointsClient.ListByService.
type OutboundNetworkDependenciesEndpointsClientListByServiceResponse struct {
	// Collection of Outbound Environment Endpoints
	OutboundEnvironmentEndpointList
}

// PolicyClientCreateOrUpdateResponse contains the response from method PolicyClient.CreateOrUpdate.
type PolicyClientCreateOrUpdateResponse struct {
	// Policy Contract details.
	PolicyContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// PolicyClientDeleteResponse contains the response from method PolicyClient.Delete.
type PolicyClientDeleteResponse struct {
	// placeholder for future response values
}

// PolicyClientGetEntityTagResponse contains the response from method PolicyClient.GetEntityTag.
type PolicyClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// PolicyClientGetResponse contains the response from method PolicyClient.Get.
type PolicyClientGetResponse struct {
	// Policy Contract details.
	PolicyContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// PolicyClientListByServiceResponse contains the response from method PolicyClient.ListByService.
type PolicyClientListByServiceResponse struct {
	// The response of the list policy operation.
	PolicyCollection
}

// PolicyDescriptionClientListByServiceResponse contains the response from method PolicyDescriptionClient.ListByService.
type PolicyDescriptionClientListByServiceResponse struct {
	// Descriptions of API Management policies.
	PolicyDescriptionCollection
}

// PolicyFragmentClientCreateOrUpdateResponse contains the response from method PolicyFragmentClient.BeginCreateOrUpdate.
type PolicyFragmentClientCreateOrUpdateResponse struct {
	// Policy fragment contract details.
	PolicyFragmentContract
}

// PolicyFragmentClientDeleteResponse contains the response from method PolicyFragmentClient.Delete.
type PolicyFragmentClientDeleteResponse struct {
	// placeholder for future response values
}

// PolicyFragmentClientGetEntityTagResponse contains the response from method PolicyFragmentClient.GetEntityTag.
type PolicyFragmentClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// PolicyFragmentClientGetResponse contains the response from method PolicyFragmentClient.Get.
type PolicyFragmentClientGetResponse struct {
	// Policy fragment contract details.
	PolicyFragmentContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// PolicyFragmentClientListByServiceResponse contains the response from method PolicyFragmentClient.ListByService.
type PolicyFragmentClientListByServiceResponse struct {
	// The response of the get policy fragments operation.
	PolicyFragmentCollection
}

// PolicyFragmentClientListReferencesResponse contains the response from method PolicyFragmentClient.ListReferences.
type PolicyFragmentClientListReferencesResponse struct {
	// A collection of resources.
	ResourceCollection
}

// PortalConfigClientCreateOrUpdateResponse contains the response from method PortalConfigClient.CreateOrUpdate.
type PortalConfigClientCreateOrUpdateResponse struct {
	// The developer portal configuration contract.
	PortalConfigContract
}

// PortalConfigClientGetEntityTagResponse contains the response from method PortalConfigClient.GetEntityTag.
type PortalConfigClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// PortalConfigClientGetResponse contains the response from method PortalConfigClient.Get.
type PortalConfigClientGetResponse struct {
	// The developer portal configuration contract.
	PortalConfigContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// PortalConfigClientListByServiceResponse contains the response from method PortalConfigClient.ListByService.
type PortalConfigClientListByServiceResponse struct {
	// The collection of the developer portal configurations.
	PortalConfigCollection
}

// PortalConfigClientUpdateResponse contains the response from method PortalConfigClient.Update.
type PortalConfigClientUpdateResponse struct {
	// The developer portal configuration contract.
	PortalConfigContract
}

// PortalRevisionClientCreateOrUpdateResponse contains the response from method PortalRevisionClient.BeginCreateOrUpdate.
type PortalRevisionClientCreateOrUpdateResponse struct {
	// Portal Revision's contract details.
	PortalRevisionContract
}

// PortalRevisionClientGetEntityTagResponse contains the response from method PortalRevisionClient.GetEntityTag.
type PortalRevisionClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// PortalRevisionClientGetResponse contains the response from method PortalRevisionClient.Get.
type PortalRevisionClientGetResponse struct {
	// Portal Revision's contract details.
	PortalRevisionContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// PortalRevisionClientListByServiceResponse contains the response from method PortalRevisionClient.NewListByServicePager.
type PortalRevisionClientListByServiceResponse struct {
	// Paged list of portal revisions.
	PortalRevisionCollection
}

// PortalRevisionClientUpdateResponse contains the response from method PortalRevisionClient.BeginUpdate.
type PortalRevisionClientUpdateResponse struct {
	// Portal Revision's contract details.
	PortalRevisionContract
}

// PortalSettingsClientListByServiceResponse contains the response from method PortalSettingsClient.ListByService.
type PortalSettingsClientListByServiceResponse struct {
	// Descriptions of API Management policies.
	PortalSettingsCollection
}

// PrivateEndpointConnectionClientCreateOrUpdateResponse contains the response from method PrivateEndpointConnectionClient.BeginCreateOrUpdate.
type PrivateEndpointConnectionClientCreateOrUpdateResponse struct {
	// The Private Endpoint Connection resource.
	PrivateEndpointConnection
}

// PrivateEndpointConnectionClientDeleteResponse contains the response from method PrivateEndpointConnectionClient.BeginDelete.
type PrivateEndpointConnectionClientDeleteResponse struct {
	// placeholder for future response values
}

// PrivateEndpointConnectionClientGetByNameResponse contains the response from method PrivateEndpointConnectionClient.GetByName.
type PrivateEndpointConnectionClientGetByNameResponse struct {
	// The Private Endpoint Connection resource.
	PrivateEndpointConnection
}

// PrivateEndpointConnectionClientGetPrivateLinkResourceResponse contains the response from method PrivateEndpointConnectionClient.GetPrivateLinkResource.
type PrivateEndpointConnectionClientGetPrivateLinkResourceResponse struct {
	// A private link resource
	PrivateLinkResource
}

// PrivateEndpointConnectionClientListByServiceResponse contains the response from method PrivateEndpointConnectionClient.NewListByServicePager.
type PrivateEndpointConnectionClientListByServiceResponse struct {
	// List of private endpoint connection associated with the specified storage account
	PrivateEndpointConnectionListResult
}

// PrivateEndpointConnectionClientListPrivateLinkResourcesResponse contains the response from method PrivateEndpointConnectionClient.ListPrivateLinkResources.
type PrivateEndpointConnectionClientListPrivateLinkResourcesResponse struct {
	// A list of private link resources
	PrivateLinkResourceListResult
}

// ProductAPIClientCheckEntityExistsResponse contains the response from method ProductAPIClient.CheckEntityExists.
type ProductAPIClientCheckEntityExistsResponse struct {
	// Success indicates if the operation succeeded or failed.
	Success bool
}

// ProductAPIClientCreateOrUpdateResponse contains the response from method ProductAPIClient.CreateOrUpdate.
type ProductAPIClientCreateOrUpdateResponse struct {
	// API details.
	APIContract
}

// ProductAPIClientDeleteResponse contains the response from method ProductAPIClient.Delete.
type ProductAPIClientDeleteResponse struct {
	// placeholder for future response values
}

// ProductAPIClientListByProductResponse contains the response from method ProductAPIClient.NewListByProductPager.
type ProductAPIClientListByProductResponse struct {
	// Paged API list representation.
	APICollection
}

// ProductClientCreateOrUpdateResponse contains the response from method ProductClient.CreateOrUpdate.
type ProductClientCreateOrUpdateResponse struct {
	// Product details.
	ProductContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ProductClientDeleteResponse contains the response from method ProductClient.Delete.
type ProductClientDeleteResponse struct {
	// placeholder for future response values
}

// ProductClientGetEntityTagResponse contains the response from method ProductClient.GetEntityTag.
type ProductClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// ProductClientGetResponse contains the response from method ProductClient.Get.
type ProductClientGetResponse struct {
	// Product details.
	ProductContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ProductClientListByServiceResponse contains the response from method ProductClient.NewListByServicePager.
type ProductClientListByServiceResponse struct {
	// Paged Products list representation.
	ProductCollection
}

// ProductClientListByTagsResponse contains the response from method ProductClient.NewListByTagsPager.
type ProductClientListByTagsResponse struct {
	// Paged Tag list representation.
	TagResourceCollection
}

// ProductClientUpdateResponse contains the response from method ProductClient.Update.
type ProductClientUpdateResponse struct {
	// Product details.
	ProductContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ProductGroupClientCheckEntityExistsResponse contains the response from method ProductGroupClient.CheckEntityExists.
type ProductGroupClientCheckEntityExistsResponse struct {
	// Success indicates if the operation succeeded or failed.
	Success bool
}

// ProductGroupClientCreateOrUpdateResponse contains the response from method ProductGroupClient.CreateOrUpdate.
type ProductGroupClientCreateOrUpdateResponse struct {
	// Contract details.
	GroupContract
}

// ProductGroupClientDeleteResponse contains the response from method ProductGroupClient.Delete.
type ProductGroupClientDeleteResponse struct {
	// placeholder for future response values
}

// ProductGroupClientListByProductResponse contains the response from method ProductGroupClient.NewListByProductPager.
type ProductGroupClientListByProductResponse struct {
	// Paged Group list representation.
	GroupCollection
}

// ProductPolicyClientCreateOrUpdateResponse contains the response from method ProductPolicyClient.CreateOrUpdate.
type ProductPolicyClientCreateOrUpdateResponse struct {
	// Policy Contract details.
	PolicyContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ProductPolicyClientDeleteResponse contains the response from method ProductPolicyClient.Delete.
type ProductPolicyClientDeleteResponse struct {
	// placeholder for future response values
}

// ProductPolicyClientGetEntityTagResponse contains the response from method ProductPolicyClient.GetEntityTag.
type ProductPolicyClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// ProductPolicyClientGetResponse contains the response from method ProductPolicyClient.Get.
type ProductPolicyClientGetResponse struct {
	// Policy Contract details.
	PolicyContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ProductPolicyClientListByProductResponse contains the response from method ProductPolicyClient.ListByProduct.
type ProductPolicyClientListByProductResponse struct {
	// The response of the list policy operation.
	PolicyCollection
}

// ProductSubscriptionsClientListResponse contains the response from method ProductSubscriptionsClient.NewListPager.
type ProductSubscriptionsClientListResponse struct {
	// Paged Subscriptions list representation.
	SubscriptionCollection
}

// ProductWikiClientCreateOrUpdateResponse contains the response from method ProductWikiClient.CreateOrUpdate.
type ProductWikiClientCreateOrUpdateResponse struct {
	// Wiki properties
	WikiContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ProductWikiClientDeleteResponse contains the response from method ProductWikiClient.Delete.
type ProductWikiClientDeleteResponse struct {
	// placeholder for future response values
}

// ProductWikiClientGetEntityTagResponse contains the response from method ProductWikiClient.GetEntityTag.
type ProductWikiClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// ProductWikiClientGetResponse contains the response from method ProductWikiClient.Get.
type ProductWikiClientGetResponse struct {
	// Wiki properties
	WikiContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ProductWikiClientUpdateResponse contains the response from method ProductWikiClient.Update.
type ProductWikiClientUpdateResponse struct {
	// Wiki properties
	WikiContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ProductWikisClientListResponse contains the response from method ProductWikisClient.NewListPager.
type ProductWikisClientListResponse struct {
	// Paged Wiki list representation.
	WikiCollection

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// QuotaByCounterKeysClientListByServiceResponse contains the response from method QuotaByCounterKeysClient.ListByService.
type QuotaByCounterKeysClientListByServiceResponse struct {
	// Paged Quota Counter list representation.
	QuotaCounterCollection
}

// QuotaByCounterKeysClientUpdateResponse contains the response from method QuotaByCounterKeysClient.Update.
type QuotaByCounterKeysClientUpdateResponse struct {
	// Paged Quota Counter list representation.
	QuotaCounterCollection
}

// QuotaByPeriodKeysClientGetResponse contains the response from method QuotaByPeriodKeysClient.Get.
type QuotaByPeriodKeysClientGetResponse struct {
	// Quota counter details.
	QuotaCounterContract
}

// QuotaByPeriodKeysClientUpdateResponse contains the response from method QuotaByPeriodKeysClient.Update.
type QuotaByPeriodKeysClientUpdateResponse struct {
	// Quota counter details.
	QuotaCounterContract
}

// RegionClientListByServiceResponse contains the response from method RegionClient.NewListByServicePager.
type RegionClientListByServiceResponse struct {
	// Lists Regions operation response details.
	RegionListResult
}

// ReportsClientListByAPIResponse contains the response from method ReportsClient.NewListByAPIPager.
type ReportsClientListByAPIResponse struct {
	// Paged Report records list representation.
	ReportCollection
}

// ReportsClientListByGeoResponse contains the response from method ReportsClient.NewListByGeoPager.
type ReportsClientListByGeoResponse struct {
	// Paged Report records list representation.
	ReportCollection
}

// ReportsClientListByOperationResponse contains the response from method ReportsClient.NewListByOperationPager.
type ReportsClientListByOperationResponse struct {
	// Paged Report records list representation.
	ReportCollection
}

// ReportsClientListByProductResponse contains the response from method ReportsClient.NewListByProductPager.
type ReportsClientListByProductResponse struct {
	// Paged Report records list representation.
	ReportCollection
}

// ReportsClientListByRequestResponse contains the response from method ReportsClient.NewListByRequestPager.
type ReportsClientListByRequestResponse struct {
	// Paged Report records list representation.
	RequestReportCollection
}

// ReportsClientListBySubscriptionResponse contains the response from method ReportsClient.NewListBySubscriptionPager.
type ReportsClientListBySubscriptionResponse struct {
	// Paged Report records list representation.
	ReportCollection
}

// ReportsClientListByTimeResponse contains the response from method ReportsClient.NewListByTimePager.
type ReportsClientListByTimeResponse struct {
	// Paged Report records list representation.
	ReportCollection
}

// ReportsClientListByUserResponse contains the response from method ReportsClient.NewListByUserPager.
type ReportsClientListByUserResponse struct {
	// Paged Report records list representation.
	ReportCollection
}

// SKUsClientListResponse contains the response from method SKUsClient.NewListPager.
type SKUsClientListResponse struct {
	// The List Resource Skus operation response.
	SKUsResult
}

// ServiceClientApplyNetworkConfigurationUpdatesResponse contains the response from method ServiceClient.BeginApplyNetworkConfigurationUpdates.
type ServiceClientApplyNetworkConfigurationUpdatesResponse struct {
	// A single API Management service resource in List or Get response.
	ServiceResource
}

// ServiceClientBackupResponse contains the response from method ServiceClient.BeginBackup.
type ServiceClientBackupResponse struct {
	// A single API Management service resource in List or Get response.
	ServiceResource
}

// ServiceClientCheckNameAvailabilityResponse contains the response from method ServiceClient.CheckNameAvailability.
type ServiceClientCheckNameAvailabilityResponse struct {
	// Response of the CheckNameAvailability operation.
	ServiceNameAvailabilityResult
}

// ServiceClientCreateOrUpdateResponse contains the response from method ServiceClient.BeginCreateOrUpdate.
type ServiceClientCreateOrUpdateResponse struct {
	// A single API Management service resource in List or Get response.
	ServiceResource
}

// ServiceClientDeleteResponse contains the response from method ServiceClient.BeginDelete.
type ServiceClientDeleteResponse struct {
	// A single API Management service resource in List or Get response.
	ServiceResource
}

// ServiceClientGetDomainOwnershipIdentifierResponse contains the response from method ServiceClient.GetDomainOwnershipIdentifier.
type ServiceClientGetDomainOwnershipIdentifierResponse struct {
	// Response of the GetDomainOwnershipIdentifier operation.
	ServiceGetDomainOwnershipIdentifierResult
}

// ServiceClientGetResponse contains the response from method ServiceClient.Get.
type ServiceClientGetResponse struct {
	// A single API Management service resource in List or Get response.
	ServiceResource
}

// ServiceClientGetSsoTokenResponse contains the response from method ServiceClient.GetSsoToken.
type ServiceClientGetSsoTokenResponse struct {
	// The response of the GetSsoToken operation.
	ServiceGetSsoTokenResult
}

// ServiceClientListByResourceGroupResponse contains the response from method ServiceClient.NewListByResourceGroupPager.
type ServiceClientListByResourceGroupResponse struct {
	// The response of the List API Management services operation.
	ServiceListResult
}

// ServiceClientListResponse contains the response from method ServiceClient.NewListPager.
type ServiceClientListResponse struct {
	// The response of the List API Management services operation.
	ServiceListResult
}

// ServiceClientMigrateToStv2Response contains the response from method ServiceClient.BeginMigrateToStv2.
type ServiceClientMigrateToStv2Response struct {
	// A single API Management service resource in List or Get response.
	ServiceResource
}

// ServiceClientRestoreResponse contains the response from method ServiceClient.BeginRestore.
type ServiceClientRestoreResponse struct {
	// A single API Management service resource in List or Get response.
	ServiceResource
}

// ServiceClientUpdateResponse contains the response from method ServiceClient.BeginUpdate.
type ServiceClientUpdateResponse struct {
	// A single API Management service resource in List or Get response.
	ServiceResource
}

// ServiceSKUsClientListAvailableServiceSKUsResponse contains the response from method ServiceSKUsClient.NewListAvailableServiceSKUsPager.
type ServiceSKUsClientListAvailableServiceSKUsResponse struct {
	// The API Management service SKUs operation response.
	ResourceSKUResults
}

// SignInSettingsClientCreateOrUpdateResponse contains the response from method SignInSettingsClient.CreateOrUpdate.
type SignInSettingsClientCreateOrUpdateResponse struct {
	// Sign-In settings for the Developer Portal.
	PortalSigninSettings
}

// SignInSettingsClientGetEntityTagResponse contains the response from method SignInSettingsClient.GetEntityTag.
type SignInSettingsClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// SignInSettingsClientGetResponse contains the response from method SignInSettingsClient.Get.
type SignInSettingsClientGetResponse struct {
	// Sign-In settings for the Developer Portal.
	PortalSigninSettings

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// SignInSettingsClientUpdateResponse contains the response from method SignInSettingsClient.Update.
type SignInSettingsClientUpdateResponse struct {
	// placeholder for future response values
}

// SignUpSettingsClientCreateOrUpdateResponse contains the response from method SignUpSettingsClient.CreateOrUpdate.
type SignUpSettingsClientCreateOrUpdateResponse struct {
	// Sign-Up settings for a developer portal.
	PortalSignupSettings
}

// SignUpSettingsClientGetEntityTagResponse contains the response from method SignUpSettingsClient.GetEntityTag.
type SignUpSettingsClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// SignUpSettingsClientGetResponse contains the response from method SignUpSettingsClient.Get.
type SignUpSettingsClientGetResponse struct {
	// Sign-Up settings for a developer portal.
	PortalSignupSettings

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// SignUpSettingsClientUpdateResponse contains the response from method SignUpSettingsClient.Update.
type SignUpSettingsClientUpdateResponse struct {
	// placeholder for future response values
}

// SubscriptionClientCreateOrUpdateResponse contains the response from method SubscriptionClient.CreateOrUpdate.
type SubscriptionClientCreateOrUpdateResponse struct {
	// Subscription details.
	SubscriptionContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// SubscriptionClientDeleteResponse contains the response from method SubscriptionClient.Delete.
type SubscriptionClientDeleteResponse struct {
	// placeholder for future response values
}

// SubscriptionClientGetEntityTagResponse contains the response from method SubscriptionClient.GetEntityTag.
type SubscriptionClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// SubscriptionClientGetResponse contains the response from method SubscriptionClient.Get.
type SubscriptionClientGetResponse struct {
	// Subscription details.
	SubscriptionContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// SubscriptionClientListResponse contains the response from method SubscriptionClient.NewListPager.
type SubscriptionClientListResponse struct {
	// Paged Subscriptions list representation.
	SubscriptionCollection
}

// SubscriptionClientListSecretsResponse contains the response from method SubscriptionClient.ListSecrets.
type SubscriptionClientListSecretsResponse struct {
	// Subscription keys.
	SubscriptionKeysContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// SubscriptionClientRegeneratePrimaryKeyResponse contains the response from method SubscriptionClient.RegeneratePrimaryKey.
type SubscriptionClientRegeneratePrimaryKeyResponse struct {
	// placeholder for future response values
}

// SubscriptionClientRegenerateSecondaryKeyResponse contains the response from method SubscriptionClient.RegenerateSecondaryKey.
type SubscriptionClientRegenerateSecondaryKeyResponse struct {
	// placeholder for future response values
}

// SubscriptionClientUpdateResponse contains the response from method SubscriptionClient.Update.
type SubscriptionClientUpdateResponse struct {
	// Subscription details.
	SubscriptionContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientAssignToAPIResponse contains the response from method TagClient.AssignToAPI.
type TagClientAssignToAPIResponse struct {
	// Tag Contract details.
	TagContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientAssignToOperationResponse contains the response from method TagClient.AssignToOperation.
type TagClientAssignToOperationResponse struct {
	// Tag Contract details.
	TagContract
}

// TagClientAssignToProductResponse contains the response from method TagClient.AssignToProduct.
type TagClientAssignToProductResponse struct {
	// Tag Contract details.
	TagContract
}

// TagClientCreateOrUpdateResponse contains the response from method TagClient.CreateOrUpdate.
type TagClientCreateOrUpdateResponse struct {
	// Tag Contract details.
	TagContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientDeleteResponse contains the response from method TagClient.Delete.
type TagClientDeleteResponse struct {
	// placeholder for future response values
}

// TagClientDetachFromAPIResponse contains the response from method TagClient.DetachFromAPI.
type TagClientDetachFromAPIResponse struct {
	// placeholder for future response values
}

// TagClientDetachFromOperationResponse contains the response from method TagClient.DetachFromOperation.
type TagClientDetachFromOperationResponse struct {
	// placeholder for future response values
}

// TagClientDetachFromProductResponse contains the response from method TagClient.DetachFromProduct.
type TagClientDetachFromProductResponse struct {
	// placeholder for future response values
}

// TagClientGetByAPIResponse contains the response from method TagClient.GetByAPI.
type TagClientGetByAPIResponse struct {
	// Tag Contract details.
	TagContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientGetByOperationResponse contains the response from method TagClient.GetByOperation.
type TagClientGetByOperationResponse struct {
	// Tag Contract details.
	TagContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientGetByProductResponse contains the response from method TagClient.GetByProduct.
type TagClientGetByProductResponse struct {
	// Tag Contract details.
	TagContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientGetEntityStateByAPIResponse contains the response from method TagClient.GetEntityStateByAPI.
type TagClientGetEntityStateByAPIResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// TagClientGetEntityStateByOperationResponse contains the response from method TagClient.GetEntityStateByOperation.
type TagClientGetEntityStateByOperationResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// TagClientGetEntityStateByProductResponse contains the response from method TagClient.GetEntityStateByProduct.
type TagClientGetEntityStateByProductResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// TagClientGetEntityStateResponse contains the response from method TagClient.GetEntityState.
type TagClientGetEntityStateResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// TagClientGetResponse contains the response from method TagClient.Get.
type TagClientGetResponse struct {
	// Tag Contract details.
	TagContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientListByAPIResponse contains the response from method TagClient.NewListByAPIPager.
type TagClientListByAPIResponse struct {
	// Paged Tag list representation.
	TagCollection
}

// TagClientListByOperationResponse contains the response from method TagClient.NewListByOperationPager.
type TagClientListByOperationResponse struct {
	// Paged Tag list representation.
	TagCollection
}

// TagClientListByProductResponse contains the response from method TagClient.NewListByProductPager.
type TagClientListByProductResponse struct {
	// Paged Tag list representation.
	TagCollection
}

// TagClientListByServiceResponse contains the response from method TagClient.NewListByServicePager.
type TagClientListByServiceResponse struct {
	// Paged Tag list representation.
	TagCollection
}

// TagClientUpdateResponse contains the response from method TagClient.Update.
type TagClientUpdateResponse struct {
	// Tag Contract details.
	TagContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagResourceClientListByServiceResponse contains the response from method TagResourceClient.NewListByServicePager.
type TagResourceClientListByServiceResponse struct {
	// Paged Tag list representation.
	TagResourceCollection
}

// TenantAccessClientCreateResponse contains the response from method TenantAccessClient.Create.
type TenantAccessClientCreateResponse struct {
	// Tenant Settings.
	AccessInformationContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TenantAccessClientGetEntityTagResponse contains the response from method TenantAccessClient.GetEntityTag.
type TenantAccessClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// TenantAccessClientGetResponse contains the response from method TenantAccessClient.Get.
type TenantAccessClientGetResponse struct {
	// Tenant Settings.
	AccessInformationContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TenantAccessClientListByServiceResponse contains the response from method TenantAccessClient.NewListByServicePager.
type TenantAccessClientListByServiceResponse struct {
	// Paged AccessInformation list representation.
	AccessInformationCollection
}

// TenantAccessClientListSecretsResponse contains the response from method TenantAccessClient.ListSecrets.
type TenantAccessClientListSecretsResponse struct {
	// Tenant access information contract of the API Management service.
	AccessInformationSecretsContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TenantAccessClientRegeneratePrimaryKeyResponse contains the response from method TenantAccessClient.RegeneratePrimaryKey.
type TenantAccessClientRegeneratePrimaryKeyResponse struct {
	// placeholder for future response values
}

// TenantAccessClientRegenerateSecondaryKeyResponse contains the response from method TenantAccessClient.RegenerateSecondaryKey.
type TenantAccessClientRegenerateSecondaryKeyResponse struct {
	// placeholder for future response values
}

// TenantAccessClientUpdateResponse contains the response from method TenantAccessClient.Update.
type TenantAccessClientUpdateResponse struct {
	// Tenant Settings.
	AccessInformationContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TenantAccessGitClientRegeneratePrimaryKeyResponse contains the response from method TenantAccessGitClient.RegeneratePrimaryKey.
type TenantAccessGitClientRegeneratePrimaryKeyResponse struct {
	// placeholder for future response values
}

// TenantAccessGitClientRegenerateSecondaryKeyResponse contains the response from method TenantAccessGitClient.RegenerateSecondaryKey.
type TenantAccessGitClientRegenerateSecondaryKeyResponse struct {
	// placeholder for future response values
}

// TenantConfigurationClientDeployResponse contains the response from method TenantConfigurationClient.BeginDeploy.
type TenantConfigurationClientDeployResponse struct {
	// Long Running Git Operation Results.
	OperationResultContract
}

// TenantConfigurationClientGetSyncStateResponse contains the response from method TenantConfigurationClient.GetSyncState.
type TenantConfigurationClientGetSyncStateResponse struct {
	// Result of Tenant Configuration Sync State.
	TenantConfigurationSyncStateContract
}

// TenantConfigurationClientSaveResponse contains the response from method TenantConfigurationClient.BeginSave.
type TenantConfigurationClientSaveResponse struct {
	// Long Running Git Operation Results.
	OperationResultContract
}

// TenantConfigurationClientValidateResponse contains the response from method TenantConfigurationClient.BeginValidate.
type TenantConfigurationClientValidateResponse struct {
	// Long Running Git Operation Results.
	OperationResultContract
}

// TenantSettingsClientGetResponse contains the response from method TenantSettingsClient.Get.
type TenantSettingsClientGetResponse struct {
	// Tenant Settings.
	TenantSettingsContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TenantSettingsClientListByServiceResponse contains the response from method TenantSettingsClient.NewListByServicePager.
type TenantSettingsClientListByServiceResponse struct {
	// Paged AccessInformation list representation.
	TenantSettingsCollection
}

// UserClientCreateOrUpdateResponse contains the response from method UserClient.CreateOrUpdate.
type UserClientCreateOrUpdateResponse struct {
	// User details.
	UserContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// UserClientDeleteResponse contains the response from method UserClient.Delete.
type UserClientDeleteResponse struct {
	// placeholder for future response values
}

// UserClientGenerateSsoURLResponse contains the response from method UserClient.GenerateSsoURL.
type UserClientGenerateSsoURLResponse struct {
	// Generate SSO Url operations response details.
	GenerateSsoURLResult
}

// UserClientGetEntityTagResponse contains the response from method UserClient.GetEntityTag.
type UserClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// UserClientGetResponse contains the response from method UserClient.Get.
type UserClientGetResponse struct {
	// User details.
	UserContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// UserClientGetSharedAccessTokenResponse contains the response from method UserClient.GetSharedAccessToken.
type UserClientGetSharedAccessTokenResponse struct {
	// Get User Token response details.
	UserTokenResult
}

// UserClientListByServiceResponse contains the response from method UserClient.NewListByServicePager.
type UserClientListByServiceResponse struct {
	// Paged Users list representation.
	UserCollection
}

// UserClientUpdateResponse contains the response from method UserClient.Update.
type UserClientUpdateResponse struct {
	// User details.
	UserContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// UserConfirmationPasswordClientSendResponse contains the response from method UserConfirmationPasswordClient.Send.
type UserConfirmationPasswordClientSendResponse struct {
	// placeholder for future response values
}

// UserGroupClientListResponse contains the response from method UserGroupClient.NewListPager.
type UserGroupClientListResponse struct {
	// Paged Group list representation.
	GroupCollection
}

// UserIdentitiesClientListResponse contains the response from method UserIdentitiesClient.NewListPager.
type UserIdentitiesClientListResponse struct {
	// List of Users Identity list representation.
	UserIdentityCollection
}

// UserSubscriptionClientGetResponse contains the response from method UserSubscriptionClient.Get.
type UserSubscriptionClientGetResponse struct {
	// Subscription details.
	SubscriptionContract

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// UserSubscriptionClientListResponse contains the response from method UserSubscriptionClient.NewListPager.
type UserSubscriptionClientListResponse struct {
	// Paged Subscriptions list representation.
	SubscriptionCollection
}
