//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappcontainers_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appcontainers/armappcontainers/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/AppResiliency_CreateOrUpdate.json
func ExampleAppResiliencyClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAppResiliencyClient().CreateOrUpdate(ctx, "rg", "testcontainerApp0", "resiliency-policy-1", armappcontainers.AppResiliency{
		Properties: &armappcontainers.AppResiliencyProperties{
			CircuitBreakerPolicy: &armappcontainers.CircuitBreakerPolicy{
				ConsecutiveErrors:  to.Ptr[int32](5),
				IntervalInSeconds:  to.Ptr[int32](10),
				MaxEjectionPercent: to.Ptr[int32](50),
			},
			HTTPConnectionPool: &armappcontainers.HTTPConnectionPool{
				HTTP1MaxPendingRequests: to.Ptr[int32](1024),
				HTTP2MaxRequests:        to.Ptr[int32](1024),
			},
			HTTPRetryPolicy: &armappcontainers.HTTPRetryPolicy{
				Matches: &armappcontainers.HTTPRetryPolicyMatches{
					Errors: []*string{
						to.Ptr("5xx"),
						to.Ptr("connect-failure"),
						to.Ptr("reset"),
						to.Ptr("retriable-headers"),
						to.Ptr("retriable-status-codes")},
					Headers: []*armappcontainers.HeaderMatch{
						{
							Header: to.Ptr("X-Content-Type"),
							Match: &armappcontainers.HeaderMatchMatch{
								PrefixMatch: to.Ptr("GOATS"),
							},
						}},
					HTTPStatusCodes: []*int32{
						to.Ptr[int32](502),
						to.Ptr[int32](503)},
				},
				MaxRetries: to.Ptr[int32](5),
				RetryBackOff: &armappcontainers.HTTPRetryPolicyRetryBackOff{
					InitialDelayInMilliseconds: to.Ptr[int64](1000),
					MaxIntervalInMilliseconds:  to.Ptr[int64](10000),
				},
			},
			TCPConnectionPool: &armappcontainers.TCPConnectionPool{
				MaxConnections: to.Ptr[int32](100),
			},
			TCPRetryPolicy: &armappcontainers.TCPRetryPolicy{
				MaxConnectAttempts: to.Ptr[int32](3),
			},
			TimeoutPolicy: &armappcontainers.TimeoutPolicy{
				ConnectionTimeoutInSeconds: to.Ptr[int32](5),
				ResponseTimeoutInSeconds:   to.Ptr[int32](15),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AppResiliency = armappcontainers.AppResiliency{
	// 	Name: to.Ptr("resiliency-policy-1"),
	// 	Type: to.Ptr("Microsoft.App/containerApps/resiliencyPolicies"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/containerApps/testcontainerApp0/resiliencyPolicies/resiliency-policy-1"),
	// 	Properties: &armappcontainers.AppResiliencyProperties{
	// 		CircuitBreakerPolicy: &armappcontainers.CircuitBreakerPolicy{
	// 			ConsecutiveErrors: to.Ptr[int32](5),
	// 			IntervalInSeconds: to.Ptr[int32](10),
	// 			MaxEjectionPercent: to.Ptr[int32](50),
	// 		},
	// 		HTTPConnectionPool: &armappcontainers.HTTPConnectionPool{
	// 			HTTP1MaxPendingRequests: to.Ptr[int32](1024),
	// 			HTTP2MaxRequests: to.Ptr[int32](1024),
	// 		},
	// 		HTTPRetryPolicy: &armappcontainers.HTTPRetryPolicy{
	// 			Matches: &armappcontainers.HTTPRetryPolicyMatches{
	// 				Errors: []*string{
	// 					to.Ptr("5xx"),
	// 					to.Ptr("connect-failure"),
	// 					to.Ptr("reset"),
	// 					to.Ptr("retriable-headers"),
	// 					to.Ptr("retriable-status-codes")},
	// 					Headers: []*armappcontainers.HeaderMatch{
	// 						{
	// 							Header: to.Ptr("X-Content-Type"),
	// 							Match: &armappcontainers.HeaderMatchMatch{
	// 								PrefixMatch: to.Ptr("GOATS"),
	// 							},
	// 					}},
	// 					HTTPStatusCodes: []*int32{
	// 						to.Ptr[int32](502),
	// 						to.Ptr[int32](503)},
	// 					},
	// 					MaxRetries: to.Ptr[int32](5),
	// 					RetryBackOff: &armappcontainers.HTTPRetryPolicyRetryBackOff{
	// 						InitialDelayInMilliseconds: to.Ptr[int64](1000),
	// 						MaxIntervalInMilliseconds: to.Ptr[int64](10000),
	// 					},
	// 				},
	// 				TCPConnectionPool: &armappcontainers.TCPConnectionPool{
	// 					MaxConnections: to.Ptr[int32](100),
	// 				},
	// 				TCPRetryPolicy: &armappcontainers.TCPRetryPolicy{
	// 					MaxConnectAttempts: to.Ptr[int32](3),
	// 				},
	// 				TimeoutPolicy: &armappcontainers.TimeoutPolicy{
	// 					ConnectionTimeoutInSeconds: to.Ptr[int32](5),
	// 					ResponseTimeoutInSeconds: to.Ptr[int32](15),
	// 				},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/AppResiliency_Patch.json
func ExampleAppResiliencyClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAppResiliencyClient().Update(ctx, "rg", "testcontainerApp0", "resiliency-policy-1", armappcontainers.AppResiliency{
		Properties: &armappcontainers.AppResiliencyProperties{
			TimeoutPolicy: &armappcontainers.TimeoutPolicy{
				ConnectionTimeoutInSeconds: to.Ptr[int32](40),
				ResponseTimeoutInSeconds:   to.Ptr[int32](30),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AppResiliency = armappcontainers.AppResiliency{
	// 	Name: to.Ptr("resiliency-policy-1"),
	// 	Type: to.Ptr("Microsoft.App/containerApps/resiliencyPolicies"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/containerApps/testcontainerApp0/resiliencyPolicies/resiliency-policy-1"),
	// 	Properties: &armappcontainers.AppResiliencyProperties{
	// 		CircuitBreakerPolicy: &armappcontainers.CircuitBreakerPolicy{
	// 			ConsecutiveErrors: to.Ptr[int32](5),
	// 			IntervalInSeconds: to.Ptr[int32](10),
	// 			MaxEjectionPercent: to.Ptr[int32](50),
	// 		},
	// 		HTTPConnectionPool: &armappcontainers.HTTPConnectionPool{
	// 			HTTP1MaxPendingRequests: to.Ptr[int32](1024),
	// 			HTTP2MaxRequests: to.Ptr[int32](1024),
	// 		},
	// 		HTTPRetryPolicy: &armappcontainers.HTTPRetryPolicy{
	// 			Matches: &armappcontainers.HTTPRetryPolicyMatches{
	// 				Errors: []*string{
	// 					to.Ptr("5xx"),
	// 					to.Ptr("connect-failure"),
	// 					to.Ptr("reset"),
	// 					to.Ptr("retriable-headers"),
	// 					to.Ptr("retriable-status-codes")},
	// 					Headers: []*armappcontainers.HeaderMatch{
	// 						{
	// 							Header: to.Ptr("X-Content-Type"),
	// 							Match: &armappcontainers.HeaderMatchMatch{
	// 								PrefixMatch: to.Ptr("GOATS"),
	// 							},
	// 					}},
	// 					HTTPStatusCodes: []*int32{
	// 						to.Ptr[int32](502),
	// 						to.Ptr[int32](503)},
	// 					},
	// 					MaxRetries: to.Ptr[int32](5),
	// 					RetryBackOff: &armappcontainers.HTTPRetryPolicyRetryBackOff{
	// 						InitialDelayInMilliseconds: to.Ptr[int64](1000),
	// 						MaxIntervalInMilliseconds: to.Ptr[int64](10000),
	// 					},
	// 				},
	// 				TCPConnectionPool: &armappcontainers.TCPConnectionPool{
	// 					MaxConnections: to.Ptr[int32](100),
	// 				},
	// 				TCPRetryPolicy: &armappcontainers.TCPRetryPolicy{
	// 					MaxConnectAttempts: to.Ptr[int32](3),
	// 				},
	// 				TimeoutPolicy: &armappcontainers.TimeoutPolicy{
	// 					ConnectionTimeoutInSeconds: to.Ptr[int32](40),
	// 					ResponseTimeoutInSeconds: to.Ptr[int32](30),
	// 				},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/AppResiliency_Delete.json
func ExampleAppResiliencyClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAppResiliencyClient().Delete(ctx, "rg", "testcontainerApp0", "resiliency-policy-1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/AppResiliency_Get.json
func ExampleAppResiliencyClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAppResiliencyClient().Get(ctx, "rg", "testcontainerApp0", "resiliency-policy-1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AppResiliency = armappcontainers.AppResiliency{
	// 	Name: to.Ptr("resiliency-policy-1"),
	// 	Type: to.Ptr("Microsoft.App/containerApps/resiliencyPolicies"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/containerApps/testcontainerApp0/resiliencyPolicies/resiliency-policy-1"),
	// 	Properties: &armappcontainers.AppResiliencyProperties{
	// 		CircuitBreakerPolicy: &armappcontainers.CircuitBreakerPolicy{
	// 			ConsecutiveErrors: to.Ptr[int32](5),
	// 			IntervalInSeconds: to.Ptr[int32](10),
	// 			MaxEjectionPercent: to.Ptr[int32](50),
	// 		},
	// 		HTTPConnectionPool: &armappcontainers.HTTPConnectionPool{
	// 			HTTP1MaxPendingRequests: to.Ptr[int32](1024),
	// 			HTTP2MaxRequests: to.Ptr[int32](1024),
	// 		},
	// 		HTTPRetryPolicy: &armappcontainers.HTTPRetryPolicy{
	// 			Matches: &armappcontainers.HTTPRetryPolicyMatches{
	// 				Errors: []*string{
	// 					to.Ptr("5xx"),
	// 					to.Ptr("connect-failure"),
	// 					to.Ptr("reset"),
	// 					to.Ptr("retriable-headers"),
	// 					to.Ptr("retriable-status-codes")},
	// 					Headers: []*armappcontainers.HeaderMatch{
	// 						{
	// 							Header: to.Ptr("X-Content-Type"),
	// 							Match: &armappcontainers.HeaderMatchMatch{
	// 								PrefixMatch: to.Ptr("GOATS"),
	// 							},
	// 					}},
	// 					HTTPStatusCodes: []*int32{
	// 						to.Ptr[int32](502),
	// 						to.Ptr[int32](503)},
	// 					},
	// 					MaxRetries: to.Ptr[int32](5),
	// 					RetryBackOff: &armappcontainers.HTTPRetryPolicyRetryBackOff{
	// 						InitialDelayInMilliseconds: to.Ptr[int64](1000),
	// 						MaxIntervalInMilliseconds: to.Ptr[int64](10000),
	// 					},
	// 				},
	// 				TCPConnectionPool: &armappcontainers.TCPConnectionPool{
	// 					MaxConnections: to.Ptr[int32](100),
	// 				},
	// 				TCPRetryPolicy: &armappcontainers.TCPRetryPolicy{
	// 					MaxConnectAttempts: to.Ptr[int32](3),
	// 				},
	// 				TimeoutPolicy: &armappcontainers.TimeoutPolicy{
	// 					ConnectionTimeoutInSeconds: to.Ptr[int32](5),
	// 					ResponseTimeoutInSeconds: to.Ptr[int32](15),
	// 				},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/AppResiliency_List.json
func ExampleAppResiliencyClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAppResiliencyClient().NewListPager("rg", "testcontainerApp0", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AppResiliencyCollection = armappcontainers.AppResiliencyCollection{
		// 	Value: []*armappcontainers.AppResiliency{
		// 		{
		// 			Name: to.Ptr("resiliency-policy-1"),
		// 			Type: to.Ptr("Microsoft.App/containerApps/resiliencyPolicies"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/containerApps/testcontainerApp0/resiliencyPolicies/resiliency-policy-1"),
		// 			Properties: &armappcontainers.AppResiliencyProperties{
		// 				CircuitBreakerPolicy: &armappcontainers.CircuitBreakerPolicy{
		// 					ConsecutiveErrors: to.Ptr[int32](5),
		// 					IntervalInSeconds: to.Ptr[int32](10),
		// 					MaxEjectionPercent: to.Ptr[int32](50),
		// 				},
		// 				HTTPConnectionPool: &armappcontainers.HTTPConnectionPool{
		// 					HTTP1MaxPendingRequests: to.Ptr[int32](1024),
		// 					HTTP2MaxRequests: to.Ptr[int32](1024),
		// 				},
		// 				HTTPRetryPolicy: &armappcontainers.HTTPRetryPolicy{
		// 					Matches: &armappcontainers.HTTPRetryPolicyMatches{
		// 						Errors: []*string{
		// 							to.Ptr("5xx"),
		// 							to.Ptr("connect-failure"),
		// 							to.Ptr("reset"),
		// 							to.Ptr("retriable-headers"),
		// 							to.Ptr("retriable-status-codes")},
		// 							Headers: []*armappcontainers.HeaderMatch{
		// 								{
		// 									Header: to.Ptr("X-Content-Type"),
		// 									Match: &armappcontainers.HeaderMatchMatch{
		// 										PrefixMatch: to.Ptr("GOATS"),
		// 									},
		// 							}},
		// 							HTTPStatusCodes: []*int32{
		// 								to.Ptr[int32](502),
		// 								to.Ptr[int32](503)},
		// 							},
		// 							MaxRetries: to.Ptr[int32](5),
		// 							RetryBackOff: &armappcontainers.HTTPRetryPolicyRetryBackOff{
		// 								InitialDelayInMilliseconds: to.Ptr[int64](1000),
		// 								MaxIntervalInMilliseconds: to.Ptr[int64](10000),
		// 							},
		// 						},
		// 						TCPConnectionPool: &armappcontainers.TCPConnectionPool{
		// 							MaxConnections: to.Ptr[int32](100),
		// 						},
		// 						TCPRetryPolicy: &armappcontainers.TCPRetryPolicy{
		// 							MaxConnectAttempts: to.Ptr[int32](3),
		// 						},
		// 						TimeoutPolicy: &armappcontainers.TimeoutPolicy{
		// 							ConnectionTimeoutInSeconds: to.Ptr[int32](5),
		// 							ResponseTimeoutInSeconds: to.Ptr[int32](15),
		// 						},
		// 					},
		// 			}},
		// 		}
	}
}
