//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
	"net/http"
	"net/url"
	"regexp"
)

// DeletedWebAppsServer is a fake server for instances of the armappservice.DeletedWebAppsClient type.
type DeletedWebAppsServer struct {
	// GetDeletedWebAppByLocation is the fake for method DeletedWebAppsClient.GetDeletedWebAppByLocation
	// HTTP status codes to indicate success: http.StatusOK
	GetDeletedWebAppByLocation func(ctx context.Context, location string, deletedSiteID string, options *armappservice.DeletedWebAppsClientGetDeletedWebAppByLocationOptions) (resp azfake.Responder[armappservice.DeletedWebAppsClientGetDeletedWebAppByLocationResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method DeletedWebAppsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armappservice.DeletedWebAppsClientListOptions) (resp azfake.PagerResponder[armappservice.DeletedWebAppsClientListResponse])

	// NewListByLocationPager is the fake for method DeletedWebAppsClient.NewListByLocationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByLocationPager func(location string, options *armappservice.DeletedWebAppsClientListByLocationOptions) (resp azfake.PagerResponder[armappservice.DeletedWebAppsClientListByLocationResponse])
}

// NewDeletedWebAppsServerTransport creates a new instance of DeletedWebAppsServerTransport with the provided implementation.
// The returned DeletedWebAppsServerTransport instance is connected to an instance of armappservice.DeletedWebAppsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDeletedWebAppsServerTransport(srv *DeletedWebAppsServer) *DeletedWebAppsServerTransport {
	return &DeletedWebAppsServerTransport{
		srv:                    srv,
		newListPager:           newTracker[azfake.PagerResponder[armappservice.DeletedWebAppsClientListResponse]](),
		newListByLocationPager: newTracker[azfake.PagerResponder[armappservice.DeletedWebAppsClientListByLocationResponse]](),
	}
}

// DeletedWebAppsServerTransport connects instances of armappservice.DeletedWebAppsClient to instances of DeletedWebAppsServer.
// Don't use this type directly, use NewDeletedWebAppsServerTransport instead.
type DeletedWebAppsServerTransport struct {
	srv                    *DeletedWebAppsServer
	newListPager           *tracker[azfake.PagerResponder[armappservice.DeletedWebAppsClientListResponse]]
	newListByLocationPager *tracker[azfake.PagerResponder[armappservice.DeletedWebAppsClientListByLocationResponse]]
}

// Do implements the policy.Transporter interface for DeletedWebAppsServerTransport.
func (d *DeletedWebAppsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DeletedWebAppsClient.GetDeletedWebAppByLocation":
		resp, err = d.dispatchGetDeletedWebAppByLocation(req)
	case "DeletedWebAppsClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	case "DeletedWebAppsClient.NewListByLocationPager":
		resp, err = d.dispatchNewListByLocationPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DeletedWebAppsServerTransport) dispatchGetDeletedWebAppByLocation(req *http.Request) (*http.Response, error) {
	if d.srv.GetDeletedWebAppByLocation == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDeletedWebAppByLocation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deletedSites/(?P<deletedSiteId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	deletedSiteIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("deletedSiteId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetDeletedWebAppByLocation(req.Context(), locationParam, deletedSiteIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeletedSite, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeletedWebAppsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/deletedSites`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := d.srv.NewListPager(nil)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappservice.DeletedWebAppsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}

func (d *DeletedWebAppsServerTransport) dispatchNewListByLocationPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByLocationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByLocationPager not implemented")}
	}
	newListByLocationPager := d.newListByLocationPager.get(req)
	if newListByLocationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deletedSites`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByLocationPager(locationParam, nil)
		newListByLocationPager = &resp
		d.newListByLocationPager.add(req, newListByLocationPager)
		server.PagerResponderInjectNextLinks(newListByLocationPager, req, func(page *armappservice.DeletedWebAppsClientListByLocationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByLocationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByLocationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByLocationPager) {
		d.newListByLocationPager.remove(req)
	}
	return resp, nil
}
