//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
	"net/http"
	"net/url"
	"regexp"
	"time"
)

// DiagnosticsServer is a fake server for instances of the armappservice.DiagnosticsClient type.
type DiagnosticsServer struct {
	// ExecuteSiteAnalysis is the fake for method DiagnosticsClient.ExecuteSiteAnalysis
	// HTTP status codes to indicate success: http.StatusOK
	ExecuteSiteAnalysis func(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, options *armappservice.DiagnosticsClientExecuteSiteAnalysisOptions) (resp azfake.Responder[armappservice.DiagnosticsClientExecuteSiteAnalysisResponse], errResp azfake.ErrorResponder)

	// ExecuteSiteAnalysisSlot is the fake for method DiagnosticsClient.ExecuteSiteAnalysisSlot
	// HTTP status codes to indicate success: http.StatusOK
	ExecuteSiteAnalysisSlot func(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string, options *armappservice.DiagnosticsClientExecuteSiteAnalysisSlotOptions) (resp azfake.Responder[armappservice.DiagnosticsClientExecuteSiteAnalysisSlotResponse], errResp azfake.ErrorResponder)

	// ExecuteSiteDetector is the fake for method DiagnosticsClient.ExecuteSiteDetector
	// HTTP status codes to indicate success: http.StatusOK
	ExecuteSiteDetector func(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, options *armappservice.DiagnosticsClientExecuteSiteDetectorOptions) (resp azfake.Responder[armappservice.DiagnosticsClientExecuteSiteDetectorResponse], errResp azfake.ErrorResponder)

	// ExecuteSiteDetectorSlot is the fake for method DiagnosticsClient.ExecuteSiteDetectorSlot
	// HTTP status codes to indicate success: http.StatusOK
	ExecuteSiteDetectorSlot func(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, slot string, options *armappservice.DiagnosticsClientExecuteSiteDetectorSlotOptions) (resp azfake.Responder[armappservice.DiagnosticsClientExecuteSiteDetectorSlotResponse], errResp azfake.ErrorResponder)

	// GetHostingEnvironmentDetectorResponse is the fake for method DiagnosticsClient.GetHostingEnvironmentDetectorResponse
	// HTTP status codes to indicate success: http.StatusOK
	GetHostingEnvironmentDetectorResponse func(ctx context.Context, resourceGroupName string, name string, detectorName string, options *armappservice.DiagnosticsClientGetHostingEnvironmentDetectorResponseOptions) (resp azfake.Responder[armappservice.DiagnosticsClientGetHostingEnvironmentDetectorResponseResponse], errResp azfake.ErrorResponder)

	// GetSiteAnalysis is the fake for method DiagnosticsClient.GetSiteAnalysis
	// HTTP status codes to indicate success: http.StatusOK
	GetSiteAnalysis func(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, options *armappservice.DiagnosticsClientGetSiteAnalysisOptions) (resp azfake.Responder[armappservice.DiagnosticsClientGetSiteAnalysisResponse], errResp azfake.ErrorResponder)

	// GetSiteAnalysisSlot is the fake for method DiagnosticsClient.GetSiteAnalysisSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetSiteAnalysisSlot func(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string, options *armappservice.DiagnosticsClientGetSiteAnalysisSlotOptions) (resp azfake.Responder[armappservice.DiagnosticsClientGetSiteAnalysisSlotResponse], errResp azfake.ErrorResponder)

	// GetSiteDetector is the fake for method DiagnosticsClient.GetSiteDetector
	// HTTP status codes to indicate success: http.StatusOK
	GetSiteDetector func(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, options *armappservice.DiagnosticsClientGetSiteDetectorOptions) (resp azfake.Responder[armappservice.DiagnosticsClientGetSiteDetectorResponse], errResp azfake.ErrorResponder)

	// GetSiteDetectorResponse is the fake for method DiagnosticsClient.GetSiteDetectorResponse
	// HTTP status codes to indicate success: http.StatusOK
	GetSiteDetectorResponse func(ctx context.Context, resourceGroupName string, siteName string, detectorName string, options *armappservice.DiagnosticsClientGetSiteDetectorResponseOptions) (resp azfake.Responder[armappservice.DiagnosticsClientGetSiteDetectorResponseResponse], errResp azfake.ErrorResponder)

	// GetSiteDetectorResponseSlot is the fake for method DiagnosticsClient.GetSiteDetectorResponseSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetSiteDetectorResponseSlot func(ctx context.Context, resourceGroupName string, siteName string, detectorName string, slot string, options *armappservice.DiagnosticsClientGetSiteDetectorResponseSlotOptions) (resp azfake.Responder[armappservice.DiagnosticsClientGetSiteDetectorResponseSlotResponse], errResp azfake.ErrorResponder)

	// GetSiteDetectorSlot is the fake for method DiagnosticsClient.GetSiteDetectorSlot
	// HTTP status codes to indicate success: http.StatusOK
	GetSiteDetectorSlot func(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, slot string, options *armappservice.DiagnosticsClientGetSiteDetectorSlotOptions) (resp azfake.Responder[armappservice.DiagnosticsClientGetSiteDetectorSlotResponse], errResp azfake.ErrorResponder)

	// GetSiteDiagnosticCategory is the fake for method DiagnosticsClient.GetSiteDiagnosticCategory
	// HTTP status codes to indicate success: http.StatusOK
	GetSiteDiagnosticCategory func(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, options *armappservice.DiagnosticsClientGetSiteDiagnosticCategoryOptions) (resp azfake.Responder[armappservice.DiagnosticsClientGetSiteDiagnosticCategoryResponse], errResp azfake.ErrorResponder)

	// GetSiteDiagnosticCategorySlot is the fake for method DiagnosticsClient.GetSiteDiagnosticCategorySlot
	// HTTP status codes to indicate success: http.StatusOK
	GetSiteDiagnosticCategorySlot func(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string, options *armappservice.DiagnosticsClientGetSiteDiagnosticCategorySlotOptions) (resp azfake.Responder[armappservice.DiagnosticsClientGetSiteDiagnosticCategorySlotResponse], errResp azfake.ErrorResponder)

	// NewListHostingEnvironmentDetectorResponsesPager is the fake for method DiagnosticsClient.NewListHostingEnvironmentDetectorResponsesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListHostingEnvironmentDetectorResponsesPager func(resourceGroupName string, name string, options *armappservice.DiagnosticsClientListHostingEnvironmentDetectorResponsesOptions) (resp azfake.PagerResponder[armappservice.DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse])

	// NewListSiteAnalysesPager is the fake for method DiagnosticsClient.NewListSiteAnalysesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSiteAnalysesPager func(resourceGroupName string, siteName string, diagnosticCategory string, options *armappservice.DiagnosticsClientListSiteAnalysesOptions) (resp azfake.PagerResponder[armappservice.DiagnosticsClientListSiteAnalysesResponse])

	// NewListSiteAnalysesSlotPager is the fake for method DiagnosticsClient.NewListSiteAnalysesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSiteAnalysesSlotPager func(resourceGroupName string, siteName string, diagnosticCategory string, slot string, options *armappservice.DiagnosticsClientListSiteAnalysesSlotOptions) (resp azfake.PagerResponder[armappservice.DiagnosticsClientListSiteAnalysesSlotResponse])

	// NewListSiteDetectorResponsesPager is the fake for method DiagnosticsClient.NewListSiteDetectorResponsesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSiteDetectorResponsesPager func(resourceGroupName string, siteName string, options *armappservice.DiagnosticsClientListSiteDetectorResponsesOptions) (resp azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDetectorResponsesResponse])

	// NewListSiteDetectorResponsesSlotPager is the fake for method DiagnosticsClient.NewListSiteDetectorResponsesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSiteDetectorResponsesSlotPager func(resourceGroupName string, siteName string, slot string, options *armappservice.DiagnosticsClientListSiteDetectorResponsesSlotOptions) (resp azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDetectorResponsesSlotResponse])

	// NewListSiteDetectorsPager is the fake for method DiagnosticsClient.NewListSiteDetectorsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSiteDetectorsPager func(resourceGroupName string, siteName string, diagnosticCategory string, options *armappservice.DiagnosticsClientListSiteDetectorsOptions) (resp azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDetectorsResponse])

	// NewListSiteDetectorsSlotPager is the fake for method DiagnosticsClient.NewListSiteDetectorsSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSiteDetectorsSlotPager func(resourceGroupName string, siteName string, diagnosticCategory string, slot string, options *armappservice.DiagnosticsClientListSiteDetectorsSlotOptions) (resp azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDetectorsSlotResponse])

	// NewListSiteDiagnosticCategoriesPager is the fake for method DiagnosticsClient.NewListSiteDiagnosticCategoriesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSiteDiagnosticCategoriesPager func(resourceGroupName string, siteName string, options *armappservice.DiagnosticsClientListSiteDiagnosticCategoriesOptions) (resp azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDiagnosticCategoriesResponse])

	// NewListSiteDiagnosticCategoriesSlotPager is the fake for method DiagnosticsClient.NewListSiteDiagnosticCategoriesSlotPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSiteDiagnosticCategoriesSlotPager func(resourceGroupName string, siteName string, slot string, options *armappservice.DiagnosticsClientListSiteDiagnosticCategoriesSlotOptions) (resp azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse])
}

// NewDiagnosticsServerTransport creates a new instance of DiagnosticsServerTransport with the provided implementation.
// The returned DiagnosticsServerTransport instance is connected to an instance of armappservice.DiagnosticsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDiagnosticsServerTransport(srv *DiagnosticsServer) *DiagnosticsServerTransport {
	return &DiagnosticsServerTransport{
		srv: srv,
		newListHostingEnvironmentDetectorResponsesPager: newTracker[azfake.PagerResponder[armappservice.DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse]](),
		newListSiteAnalysesPager:                        newTracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteAnalysesResponse]](),
		newListSiteAnalysesSlotPager:                    newTracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteAnalysesSlotResponse]](),
		newListSiteDetectorResponsesPager:               newTracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDetectorResponsesResponse]](),
		newListSiteDetectorResponsesSlotPager:           newTracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDetectorResponsesSlotResponse]](),
		newListSiteDetectorsPager:                       newTracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDetectorsResponse]](),
		newListSiteDetectorsSlotPager:                   newTracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDetectorsSlotResponse]](),
		newListSiteDiagnosticCategoriesPager:            newTracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDiagnosticCategoriesResponse]](),
		newListSiteDiagnosticCategoriesSlotPager:        newTracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse]](),
	}
}

// DiagnosticsServerTransport connects instances of armappservice.DiagnosticsClient to instances of DiagnosticsServer.
// Don't use this type directly, use NewDiagnosticsServerTransport instead.
type DiagnosticsServerTransport struct {
	srv                                             *DiagnosticsServer
	newListHostingEnvironmentDetectorResponsesPager *tracker[azfake.PagerResponder[armappservice.DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse]]
	newListSiteAnalysesPager                        *tracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteAnalysesResponse]]
	newListSiteAnalysesSlotPager                    *tracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteAnalysesSlotResponse]]
	newListSiteDetectorResponsesPager               *tracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDetectorResponsesResponse]]
	newListSiteDetectorResponsesSlotPager           *tracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDetectorResponsesSlotResponse]]
	newListSiteDetectorsPager                       *tracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDetectorsResponse]]
	newListSiteDetectorsSlotPager                   *tracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDetectorsSlotResponse]]
	newListSiteDiagnosticCategoriesPager            *tracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDiagnosticCategoriesResponse]]
	newListSiteDiagnosticCategoriesSlotPager        *tracker[azfake.PagerResponder[armappservice.DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse]]
}

// Do implements the policy.Transporter interface for DiagnosticsServerTransport.
func (d *DiagnosticsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DiagnosticsClient.ExecuteSiteAnalysis":
		resp, err = d.dispatchExecuteSiteAnalysis(req)
	case "DiagnosticsClient.ExecuteSiteAnalysisSlot":
		resp, err = d.dispatchExecuteSiteAnalysisSlot(req)
	case "DiagnosticsClient.ExecuteSiteDetector":
		resp, err = d.dispatchExecuteSiteDetector(req)
	case "DiagnosticsClient.ExecuteSiteDetectorSlot":
		resp, err = d.dispatchExecuteSiteDetectorSlot(req)
	case "DiagnosticsClient.GetHostingEnvironmentDetectorResponse":
		resp, err = d.dispatchGetHostingEnvironmentDetectorResponse(req)
	case "DiagnosticsClient.GetSiteAnalysis":
		resp, err = d.dispatchGetSiteAnalysis(req)
	case "DiagnosticsClient.GetSiteAnalysisSlot":
		resp, err = d.dispatchGetSiteAnalysisSlot(req)
	case "DiagnosticsClient.GetSiteDetector":
		resp, err = d.dispatchGetSiteDetector(req)
	case "DiagnosticsClient.GetSiteDetectorResponse":
		resp, err = d.dispatchGetSiteDetectorResponse(req)
	case "DiagnosticsClient.GetSiteDetectorResponseSlot":
		resp, err = d.dispatchGetSiteDetectorResponseSlot(req)
	case "DiagnosticsClient.GetSiteDetectorSlot":
		resp, err = d.dispatchGetSiteDetectorSlot(req)
	case "DiagnosticsClient.GetSiteDiagnosticCategory":
		resp, err = d.dispatchGetSiteDiagnosticCategory(req)
	case "DiagnosticsClient.GetSiteDiagnosticCategorySlot":
		resp, err = d.dispatchGetSiteDiagnosticCategorySlot(req)
	case "DiagnosticsClient.NewListHostingEnvironmentDetectorResponsesPager":
		resp, err = d.dispatchNewListHostingEnvironmentDetectorResponsesPager(req)
	case "DiagnosticsClient.NewListSiteAnalysesPager":
		resp, err = d.dispatchNewListSiteAnalysesPager(req)
	case "DiagnosticsClient.NewListSiteAnalysesSlotPager":
		resp, err = d.dispatchNewListSiteAnalysesSlotPager(req)
	case "DiagnosticsClient.NewListSiteDetectorResponsesPager":
		resp, err = d.dispatchNewListSiteDetectorResponsesPager(req)
	case "DiagnosticsClient.NewListSiteDetectorResponsesSlotPager":
		resp, err = d.dispatchNewListSiteDetectorResponsesSlotPager(req)
	case "DiagnosticsClient.NewListSiteDetectorsPager":
		resp, err = d.dispatchNewListSiteDetectorsPager(req)
	case "DiagnosticsClient.NewListSiteDetectorsSlotPager":
		resp, err = d.dispatchNewListSiteDetectorsSlotPager(req)
	case "DiagnosticsClient.NewListSiteDiagnosticCategoriesPager":
		resp, err = d.dispatchNewListSiteDiagnosticCategoriesPager(req)
	case "DiagnosticsClient.NewListSiteDiagnosticCategoriesSlotPager":
		resp, err = d.dispatchNewListSiteDiagnosticCategoriesSlotPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchExecuteSiteAnalysis(req *http.Request) (*http.Response, error) {
	if d.srv.ExecuteSiteAnalysis == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExecuteSiteAnalysis not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/analyses/(?P<analysisName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/execute`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
	if err != nil {
		return nil, err
	}
	analysisNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("analysisName")])
	if err != nil {
		return nil, err
	}
	startTimeUnescaped, err := url.QueryUnescape(qp.Get("startTime"))
	if err != nil {
		return nil, err
	}
	startTimeParam, err := parseOptional(startTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	endTimeUnescaped, err := url.QueryUnescape(qp.Get("endTime"))
	if err != nil {
		return nil, err
	}
	endTimeParam, err := parseOptional(endTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	timeGrainUnescaped, err := url.QueryUnescape(qp.Get("timeGrain"))
	if err != nil {
		return nil, err
	}
	timeGrainParam := getOptional(timeGrainUnescaped)
	var options *armappservice.DiagnosticsClientExecuteSiteAnalysisOptions
	if startTimeParam != nil || endTimeParam != nil || timeGrainParam != nil {
		options = &armappservice.DiagnosticsClientExecuteSiteAnalysisOptions{
			StartTime: startTimeParam,
			EndTime:   endTimeParam,
			TimeGrain: timeGrainParam,
		}
	}
	respr, errRespr := d.srv.ExecuteSiteAnalysis(req.Context(), resourceGroupNameParam, siteNameParam, diagnosticCategoryParam, analysisNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DiagnosticAnalysis, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchExecuteSiteAnalysisSlot(req *http.Request) (*http.Response, error) {
	if d.srv.ExecuteSiteAnalysisSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExecuteSiteAnalysisSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/analyses/(?P<analysisName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/execute`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
	if err != nil {
		return nil, err
	}
	analysisNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("analysisName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	startTimeUnescaped, err := url.QueryUnescape(qp.Get("startTime"))
	if err != nil {
		return nil, err
	}
	startTimeParam, err := parseOptional(startTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	endTimeUnescaped, err := url.QueryUnescape(qp.Get("endTime"))
	if err != nil {
		return nil, err
	}
	endTimeParam, err := parseOptional(endTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	timeGrainUnescaped, err := url.QueryUnescape(qp.Get("timeGrain"))
	if err != nil {
		return nil, err
	}
	timeGrainParam := getOptional(timeGrainUnescaped)
	var options *armappservice.DiagnosticsClientExecuteSiteAnalysisSlotOptions
	if startTimeParam != nil || endTimeParam != nil || timeGrainParam != nil {
		options = &armappservice.DiagnosticsClientExecuteSiteAnalysisSlotOptions{
			StartTime: startTimeParam,
			EndTime:   endTimeParam,
			TimeGrain: timeGrainParam,
		}
	}
	respr, errRespr := d.srv.ExecuteSiteAnalysisSlot(req.Context(), resourceGroupNameParam, siteNameParam, diagnosticCategoryParam, analysisNameParam, slotParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DiagnosticAnalysis, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchExecuteSiteDetector(req *http.Request) (*http.Response, error) {
	if d.srv.ExecuteSiteDetector == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExecuteSiteDetector not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detectors/(?P<detectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/execute`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	detectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("detectorName")])
	if err != nil {
		return nil, err
	}
	diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
	if err != nil {
		return nil, err
	}
	startTimeUnescaped, err := url.QueryUnescape(qp.Get("startTime"))
	if err != nil {
		return nil, err
	}
	startTimeParam, err := parseOptional(startTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	endTimeUnescaped, err := url.QueryUnescape(qp.Get("endTime"))
	if err != nil {
		return nil, err
	}
	endTimeParam, err := parseOptional(endTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	timeGrainUnescaped, err := url.QueryUnescape(qp.Get("timeGrain"))
	if err != nil {
		return nil, err
	}
	timeGrainParam := getOptional(timeGrainUnescaped)
	var options *armappservice.DiagnosticsClientExecuteSiteDetectorOptions
	if startTimeParam != nil || endTimeParam != nil || timeGrainParam != nil {
		options = &armappservice.DiagnosticsClientExecuteSiteDetectorOptions{
			StartTime: startTimeParam,
			EndTime:   endTimeParam,
			TimeGrain: timeGrainParam,
		}
	}
	respr, errRespr := d.srv.ExecuteSiteDetector(req.Context(), resourceGroupNameParam, siteNameParam, detectorNameParam, diagnosticCategoryParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DiagnosticDetectorResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchExecuteSiteDetectorSlot(req *http.Request) (*http.Response, error) {
	if d.srv.ExecuteSiteDetectorSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExecuteSiteDetectorSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detectors/(?P<detectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/execute`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	detectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("detectorName")])
	if err != nil {
		return nil, err
	}
	diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	startTimeUnescaped, err := url.QueryUnescape(qp.Get("startTime"))
	if err != nil {
		return nil, err
	}
	startTimeParam, err := parseOptional(startTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	endTimeUnescaped, err := url.QueryUnescape(qp.Get("endTime"))
	if err != nil {
		return nil, err
	}
	endTimeParam, err := parseOptional(endTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	timeGrainUnescaped, err := url.QueryUnescape(qp.Get("timeGrain"))
	if err != nil {
		return nil, err
	}
	timeGrainParam := getOptional(timeGrainUnescaped)
	var options *armappservice.DiagnosticsClientExecuteSiteDetectorSlotOptions
	if startTimeParam != nil || endTimeParam != nil || timeGrainParam != nil {
		options = &armappservice.DiagnosticsClientExecuteSiteDetectorSlotOptions{
			StartTime: startTimeParam,
			EndTime:   endTimeParam,
			TimeGrain: timeGrainParam,
		}
	}
	respr, errRespr := d.srv.ExecuteSiteDetectorSlot(req.Context(), resourceGroupNameParam, siteNameParam, detectorNameParam, diagnosticCategoryParam, slotParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DiagnosticDetectorResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchGetHostingEnvironmentDetectorResponse(req *http.Request) (*http.Response, error) {
	if d.srv.GetHostingEnvironmentDetectorResponse == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetHostingEnvironmentDetectorResponse not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detectors/(?P<detectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	detectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("detectorName")])
	if err != nil {
		return nil, err
	}
	startTimeUnescaped, err := url.QueryUnescape(qp.Get("startTime"))
	if err != nil {
		return nil, err
	}
	startTimeParam, err := parseOptional(startTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	endTimeUnescaped, err := url.QueryUnescape(qp.Get("endTime"))
	if err != nil {
		return nil, err
	}
	endTimeParam, err := parseOptional(endTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	timeGrainUnescaped, err := url.QueryUnescape(qp.Get("timeGrain"))
	if err != nil {
		return nil, err
	}
	timeGrainParam := getOptional(timeGrainUnescaped)
	var options *armappservice.DiagnosticsClientGetHostingEnvironmentDetectorResponseOptions
	if startTimeParam != nil || endTimeParam != nil || timeGrainParam != nil {
		options = &armappservice.DiagnosticsClientGetHostingEnvironmentDetectorResponseOptions{
			StartTime: startTimeParam,
			EndTime:   endTimeParam,
			TimeGrain: timeGrainParam,
		}
	}
	respr, errRespr := d.srv.GetHostingEnvironmentDetectorResponse(req.Context(), resourceGroupNameParam, nameParam, detectorNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DetectorResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchGetSiteAnalysis(req *http.Request) (*http.Response, error) {
	if d.srv.GetSiteAnalysis == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSiteAnalysis not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/analyses/(?P<analysisName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
	if err != nil {
		return nil, err
	}
	analysisNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("analysisName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetSiteAnalysis(req.Context(), resourceGroupNameParam, siteNameParam, diagnosticCategoryParam, analysisNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AnalysisDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchGetSiteAnalysisSlot(req *http.Request) (*http.Response, error) {
	if d.srv.GetSiteAnalysisSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSiteAnalysisSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/analyses/(?P<analysisName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
	if err != nil {
		return nil, err
	}
	analysisNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("analysisName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetSiteAnalysisSlot(req.Context(), resourceGroupNameParam, siteNameParam, diagnosticCategoryParam, analysisNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AnalysisDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchGetSiteDetector(req *http.Request) (*http.Response, error) {
	if d.srv.GetSiteDetector == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSiteDetector not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detectors/(?P<detectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
	if err != nil {
		return nil, err
	}
	detectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("detectorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetSiteDetector(req.Context(), resourceGroupNameParam, siteNameParam, diagnosticCategoryParam, detectorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DetectorDefinitionResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchGetSiteDetectorResponse(req *http.Request) (*http.Response, error) {
	if d.srv.GetSiteDetectorResponse == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSiteDetectorResponse not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detectors/(?P<detectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	detectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("detectorName")])
	if err != nil {
		return nil, err
	}
	startTimeUnescaped, err := url.QueryUnescape(qp.Get("startTime"))
	if err != nil {
		return nil, err
	}
	startTimeParam, err := parseOptional(startTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	endTimeUnescaped, err := url.QueryUnescape(qp.Get("endTime"))
	if err != nil {
		return nil, err
	}
	endTimeParam, err := parseOptional(endTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	timeGrainUnescaped, err := url.QueryUnescape(qp.Get("timeGrain"))
	if err != nil {
		return nil, err
	}
	timeGrainParam := getOptional(timeGrainUnescaped)
	var options *armappservice.DiagnosticsClientGetSiteDetectorResponseOptions
	if startTimeParam != nil || endTimeParam != nil || timeGrainParam != nil {
		options = &armappservice.DiagnosticsClientGetSiteDetectorResponseOptions{
			StartTime: startTimeParam,
			EndTime:   endTimeParam,
			TimeGrain: timeGrainParam,
		}
	}
	respr, errRespr := d.srv.GetSiteDetectorResponse(req.Context(), resourceGroupNameParam, siteNameParam, detectorNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DetectorResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchGetSiteDetectorResponseSlot(req *http.Request) (*http.Response, error) {
	if d.srv.GetSiteDetectorResponseSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSiteDetectorResponseSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detectors/(?P<detectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	detectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("detectorName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	startTimeUnescaped, err := url.QueryUnescape(qp.Get("startTime"))
	if err != nil {
		return nil, err
	}
	startTimeParam, err := parseOptional(startTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	endTimeUnescaped, err := url.QueryUnescape(qp.Get("endTime"))
	if err != nil {
		return nil, err
	}
	endTimeParam, err := parseOptional(endTimeUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	timeGrainUnescaped, err := url.QueryUnescape(qp.Get("timeGrain"))
	if err != nil {
		return nil, err
	}
	timeGrainParam := getOptional(timeGrainUnescaped)
	var options *armappservice.DiagnosticsClientGetSiteDetectorResponseSlotOptions
	if startTimeParam != nil || endTimeParam != nil || timeGrainParam != nil {
		options = &armappservice.DiagnosticsClientGetSiteDetectorResponseSlotOptions{
			StartTime: startTimeParam,
			EndTime:   endTimeParam,
			TimeGrain: timeGrainParam,
		}
	}
	respr, errRespr := d.srv.GetSiteDetectorResponseSlot(req.Context(), resourceGroupNameParam, siteNameParam, detectorNameParam, slotParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DetectorResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchGetSiteDetectorSlot(req *http.Request) (*http.Response, error) {
	if d.srv.GetSiteDetectorSlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSiteDetectorSlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detectors/(?P<detectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
	if err != nil {
		return nil, err
	}
	detectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("detectorName")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetSiteDetectorSlot(req.Context(), resourceGroupNameParam, siteNameParam, diagnosticCategoryParam, detectorNameParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DetectorDefinitionResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchGetSiteDiagnosticCategory(req *http.Request) (*http.Response, error) {
	if d.srv.GetSiteDiagnosticCategory == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSiteDiagnosticCategory not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetSiteDiagnosticCategory(req.Context(), resourceGroupNameParam, siteNameParam, diagnosticCategoryParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DiagnosticCategory, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchGetSiteDiagnosticCategorySlot(req *http.Request) (*http.Response, error) {
	if d.srv.GetSiteDiagnosticCategorySlot == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSiteDiagnosticCategorySlot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
	if err != nil {
		return nil, err
	}
	slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetSiteDiagnosticCategorySlot(req.Context(), resourceGroupNameParam, siteNameParam, diagnosticCategoryParam, slotParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DiagnosticCategory, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchNewListHostingEnvironmentDetectorResponsesPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListHostingEnvironmentDetectorResponsesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListHostingEnvironmentDetectorResponsesPager not implemented")}
	}
	newListHostingEnvironmentDetectorResponsesPager := d.newListHostingEnvironmentDetectorResponsesPager.get(req)
	if newListHostingEnvironmentDetectorResponsesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detectors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListHostingEnvironmentDetectorResponsesPager(resourceGroupNameParam, nameParam, nil)
		newListHostingEnvironmentDetectorResponsesPager = &resp
		d.newListHostingEnvironmentDetectorResponsesPager.add(req, newListHostingEnvironmentDetectorResponsesPager)
		server.PagerResponderInjectNextLinks(newListHostingEnvironmentDetectorResponsesPager, req, func(page *armappservice.DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListHostingEnvironmentDetectorResponsesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListHostingEnvironmentDetectorResponsesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListHostingEnvironmentDetectorResponsesPager) {
		d.newListHostingEnvironmentDetectorResponsesPager.remove(req)
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchNewListSiteAnalysesPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListSiteAnalysesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSiteAnalysesPager not implemented")}
	}
	newListSiteAnalysesPager := d.newListSiteAnalysesPager.get(req)
	if newListSiteAnalysesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/analyses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
		if err != nil {
			return nil, err
		}
		diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListSiteAnalysesPager(resourceGroupNameParam, siteNameParam, diagnosticCategoryParam, nil)
		newListSiteAnalysesPager = &resp
		d.newListSiteAnalysesPager.add(req, newListSiteAnalysesPager)
		server.PagerResponderInjectNextLinks(newListSiteAnalysesPager, req, func(page *armappservice.DiagnosticsClientListSiteAnalysesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSiteAnalysesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListSiteAnalysesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSiteAnalysesPager) {
		d.newListSiteAnalysesPager.remove(req)
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchNewListSiteAnalysesSlotPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListSiteAnalysesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSiteAnalysesSlotPager not implemented")}
	}
	newListSiteAnalysesSlotPager := d.newListSiteAnalysesSlotPager.get(req)
	if newListSiteAnalysesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/analyses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
		if err != nil {
			return nil, err
		}
		diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListSiteAnalysesSlotPager(resourceGroupNameParam, siteNameParam, diagnosticCategoryParam, slotParam, nil)
		newListSiteAnalysesSlotPager = &resp
		d.newListSiteAnalysesSlotPager.add(req, newListSiteAnalysesSlotPager)
		server.PagerResponderInjectNextLinks(newListSiteAnalysesSlotPager, req, func(page *armappservice.DiagnosticsClientListSiteAnalysesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSiteAnalysesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListSiteAnalysesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSiteAnalysesSlotPager) {
		d.newListSiteAnalysesSlotPager.remove(req)
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchNewListSiteDetectorResponsesPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListSiteDetectorResponsesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSiteDetectorResponsesPager not implemented")}
	}
	newListSiteDetectorResponsesPager := d.newListSiteDetectorResponsesPager.get(req)
	if newListSiteDetectorResponsesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detectors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListSiteDetectorResponsesPager(resourceGroupNameParam, siteNameParam, nil)
		newListSiteDetectorResponsesPager = &resp
		d.newListSiteDetectorResponsesPager.add(req, newListSiteDetectorResponsesPager)
		server.PagerResponderInjectNextLinks(newListSiteDetectorResponsesPager, req, func(page *armappservice.DiagnosticsClientListSiteDetectorResponsesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSiteDetectorResponsesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListSiteDetectorResponsesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSiteDetectorResponsesPager) {
		d.newListSiteDetectorResponsesPager.remove(req)
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchNewListSiteDetectorResponsesSlotPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListSiteDetectorResponsesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSiteDetectorResponsesSlotPager not implemented")}
	}
	newListSiteDetectorResponsesSlotPager := d.newListSiteDetectorResponsesSlotPager.get(req)
	if newListSiteDetectorResponsesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detectors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListSiteDetectorResponsesSlotPager(resourceGroupNameParam, siteNameParam, slotParam, nil)
		newListSiteDetectorResponsesSlotPager = &resp
		d.newListSiteDetectorResponsesSlotPager.add(req, newListSiteDetectorResponsesSlotPager)
		server.PagerResponderInjectNextLinks(newListSiteDetectorResponsesSlotPager, req, func(page *armappservice.DiagnosticsClientListSiteDetectorResponsesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSiteDetectorResponsesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListSiteDetectorResponsesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSiteDetectorResponsesSlotPager) {
		d.newListSiteDetectorResponsesSlotPager.remove(req)
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchNewListSiteDetectorsPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListSiteDetectorsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSiteDetectorsPager not implemented")}
	}
	newListSiteDetectorsPager := d.newListSiteDetectorsPager.get(req)
	if newListSiteDetectorsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detectors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
		if err != nil {
			return nil, err
		}
		diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListSiteDetectorsPager(resourceGroupNameParam, siteNameParam, diagnosticCategoryParam, nil)
		newListSiteDetectorsPager = &resp
		d.newListSiteDetectorsPager.add(req, newListSiteDetectorsPager)
		server.PagerResponderInjectNextLinks(newListSiteDetectorsPager, req, func(page *armappservice.DiagnosticsClientListSiteDetectorsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSiteDetectorsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListSiteDetectorsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSiteDetectorsPager) {
		d.newListSiteDetectorsPager.remove(req)
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchNewListSiteDetectorsSlotPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListSiteDetectorsSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSiteDetectorsSlotPager not implemented")}
	}
	newListSiteDetectorsSlotPager := d.newListSiteDetectorsSlotPager.get(req)
	if newListSiteDetectorsSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticCategory>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detectors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
		if err != nil {
			return nil, err
		}
		diagnosticCategoryParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticCategory")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListSiteDetectorsSlotPager(resourceGroupNameParam, siteNameParam, diagnosticCategoryParam, slotParam, nil)
		newListSiteDetectorsSlotPager = &resp
		d.newListSiteDetectorsSlotPager.add(req, newListSiteDetectorsSlotPager)
		server.PagerResponderInjectNextLinks(newListSiteDetectorsSlotPager, req, func(page *armappservice.DiagnosticsClientListSiteDetectorsSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSiteDetectorsSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListSiteDetectorsSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSiteDetectorsSlotPager) {
		d.newListSiteDetectorsSlotPager.remove(req)
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchNewListSiteDiagnosticCategoriesPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListSiteDiagnosticCategoriesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSiteDiagnosticCategoriesPager not implemented")}
	}
	newListSiteDiagnosticCategoriesPager := d.newListSiteDiagnosticCategoriesPager.get(req)
	if newListSiteDiagnosticCategoriesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListSiteDiagnosticCategoriesPager(resourceGroupNameParam, siteNameParam, nil)
		newListSiteDiagnosticCategoriesPager = &resp
		d.newListSiteDiagnosticCategoriesPager.add(req, newListSiteDiagnosticCategoriesPager)
		server.PagerResponderInjectNextLinks(newListSiteDiagnosticCategoriesPager, req, func(page *armappservice.DiagnosticsClientListSiteDiagnosticCategoriesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSiteDiagnosticCategoriesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListSiteDiagnosticCategoriesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSiteDiagnosticCategoriesPager) {
		d.newListSiteDiagnosticCategoriesPager.remove(req)
	}
	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchNewListSiteDiagnosticCategoriesSlotPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListSiteDiagnosticCategoriesSlotPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSiteDiagnosticCategoriesSlotPager not implemented")}
	}
	newListSiteDiagnosticCategoriesSlotPager := d.newListSiteDiagnosticCategoriesSlotPager.get(req)
	if newListSiteDiagnosticCategoriesSlotPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/slots/(?P<slot>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
		if err != nil {
			return nil, err
		}
		slotParam, err := url.PathUnescape(matches[regex.SubexpIndex("slot")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListSiteDiagnosticCategoriesSlotPager(resourceGroupNameParam, siteNameParam, slotParam, nil)
		newListSiteDiagnosticCategoriesSlotPager = &resp
		d.newListSiteDiagnosticCategoriesSlotPager.add(req, newListSiteDiagnosticCategoriesSlotPager)
		server.PagerResponderInjectNextLinks(newListSiteDiagnosticCategoriesSlotPager, req, func(page *armappservice.DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSiteDiagnosticCategoriesSlotPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListSiteDiagnosticCategoriesSlotPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSiteDiagnosticCategoriesSlotPager) {
		d.newListSiteDiagnosticCategoriesSlotPager.remove(req)
	}
	return resp, nil
}
