//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// RoleManagementPoliciesServer is a fake server for instances of the armauthorization.RoleManagementPoliciesClient type.
type RoleManagementPoliciesServer struct {
	// Delete is the fake for method RoleManagementPoliciesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, scope string, roleManagementPolicyName string, options *armauthorization.RoleManagementPoliciesClientDeleteOptions) (resp azfake.Responder[armauthorization.RoleManagementPoliciesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method RoleManagementPoliciesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, roleManagementPolicyName string, options *armauthorization.RoleManagementPoliciesClientGetOptions) (resp azfake.Responder[armauthorization.RoleManagementPoliciesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListForScopePager is the fake for method RoleManagementPoliciesClient.NewListForScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForScopePager func(scope string, options *armauthorization.RoleManagementPoliciesClientListForScopeOptions) (resp azfake.PagerResponder[armauthorization.RoleManagementPoliciesClientListForScopeResponse])

	// Update is the fake for method RoleManagementPoliciesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, scope string, roleManagementPolicyName string, parameters armauthorization.RoleManagementPolicy, options *armauthorization.RoleManagementPoliciesClientUpdateOptions) (resp azfake.Responder[armauthorization.RoleManagementPoliciesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewRoleManagementPoliciesServerTransport creates a new instance of RoleManagementPoliciesServerTransport with the provided implementation.
// The returned RoleManagementPoliciesServerTransport instance is connected to an instance of armauthorization.RoleManagementPoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRoleManagementPoliciesServerTransport(srv *RoleManagementPoliciesServer) *RoleManagementPoliciesServerTransport {
	return &RoleManagementPoliciesServerTransport{
		srv:                  srv,
		newListForScopePager: newTracker[azfake.PagerResponder[armauthorization.RoleManagementPoliciesClientListForScopeResponse]](),
	}
}

// RoleManagementPoliciesServerTransport connects instances of armauthorization.RoleManagementPoliciesClient to instances of RoleManagementPoliciesServer.
// Don't use this type directly, use NewRoleManagementPoliciesServerTransport instead.
type RoleManagementPoliciesServerTransport struct {
	srv                  *RoleManagementPoliciesServer
	newListForScopePager *tracker[azfake.PagerResponder[armauthorization.RoleManagementPoliciesClientListForScopeResponse]]
}

// Do implements the policy.Transporter interface for RoleManagementPoliciesServerTransport.
func (r *RoleManagementPoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RoleManagementPoliciesClient.Delete":
		resp, err = r.dispatchDelete(req)
	case "RoleManagementPoliciesClient.Get":
		resp, err = r.dispatchGet(req)
	case "RoleManagementPoliciesClient.NewListForScopePager":
		resp, err = r.dispatchNewListForScopePager(req)
	case "RoleManagementPoliciesClient.Update":
		resp, err = r.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RoleManagementPoliciesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if r.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementPolicies/(?P<roleManagementPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	roleManagementPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleManagementPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Delete(req.Context(), scopeParam, roleManagementPolicyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RoleManagementPoliciesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementPolicies/(?P<roleManagementPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	roleManagementPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleManagementPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), scopeParam, roleManagementPolicyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RoleManagementPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RoleManagementPoliciesServerTransport) dispatchNewListForScopePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListForScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForScopePager not implemented")}
	}
	newListForScopePager := r.newListForScopePager.get(req)
	if newListForScopePager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListForScopePager(scopeParam, nil)
		newListForScopePager = &resp
		r.newListForScopePager.add(req, newListForScopePager)
		server.PagerResponderInjectNextLinks(newListForScopePager, req, func(page *armauthorization.RoleManagementPoliciesClientListForScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListForScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForScopePager) {
		r.newListForScopePager.remove(req)
	}
	return resp, nil
}

func (r *RoleManagementPoliciesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementPolicies/(?P<roleManagementPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armauthorization.RoleManagementPolicy](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	roleManagementPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleManagementPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Update(req.Context(), scopeParam, roleManagementPolicyNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RoleManagementPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
