//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armazuredata

import "time"

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *string

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// ODataError - Information about an error.
type ODataError struct {
	// A language-independent error name.
	Code *string

	// The error details.
	Details []*ODataError

	// The error message.
	Message *string

	// The target of the error (for example, the name of the property in error).
	Target *string
}

// Operation - SQL REST API operation definition.
type Operation struct {
	// READ-ONLY; The localized display information for this particular operation / action.
	Display *OperationDisplay

	// READ-ONLY; The name of the operation being performed on this particular object.
	Name *string

	// READ-ONLY; The intended executor of the operation.
	Origin *OperationOrigin

	// READ-ONLY; Additional descriptions for the operation.
	Properties map[string]any
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// READ-ONLY; The localized friendly description for the operation.
	Description *string

	// READ-ONLY; The localized friendly name for the operation.
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name.
	Provider *string

	// READ-ONLY; The localized friendly form of the resource type related to this action/operation.
	Resource *string
}

// OperationListResult - Result of the request to list SQL operations.
type OperationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*Operation
}

// Plan for the resource.
type Plan struct {
	// REQUIRED; A user defined name of the 3rd Party Artifact that is being procured.
	Name *string

	// REQUIRED; The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact
	// at the time of Data Market onboarding.
	Product *string

	// REQUIRED; The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string

	// A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string

	// The version of the desired product/artifact.
	Version *string
}

// ProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required location
// and tags
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

type Resource struct {
	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// ResourceModelWithAllowedPropertySet - The resource model definition containing the full set of allowed properties for a
// resource. Except properties bag, there cannot be a top level property outside of this set.
type ResourceModelWithAllowedPropertySet struct {
	Identity *ResourceModelWithAllowedPropertySetIdentity

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string

	// The geo-location where the resource lives
	Location *string

	// The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another
	// azure resource. If this is present, complete mode deployment will not
	// delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string
	Plan      *ResourceModelWithAllowedPropertySetPlan
	SKU       *ResourceModelWithAllowedPropertySetSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; The etag field is not required. If it is provided in the response body, it must also be provided as a header
	// per the normal etag convention. Entity tags are used for comparing two or more entities
	// from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match
	// (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string

	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts..
	Type *string
}

type ResourceModelWithAllowedPropertySetIdentity struct {
	// The identity type.
	Type *string

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

type ResourceModelWithAllowedPropertySetPlan struct {
	// REQUIRED; A user defined name of the 3rd Party Artifact that is being procured.
	Name *string

	// REQUIRED; The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact
	// at the time of Data Market onboarding.
	Product *string

	// REQUIRED; The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string

	// A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string

	// The version of the desired product/artifact.
	Version *string
}

type ResourceModelWithAllowedPropertySetSKU struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier
}

type ResourceSKU struct {
	Capacity *int32
	Family   *string
	Name     *string
	Size     *string
	Tier     *string
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier
}

// SQLServer - A SQL server.
type SQLServer struct {
	// Resource properties.
	Properties *SQLServerProperties

	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// SQLServerListResult - A list of SQL servers.
type SQLServerListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*SQLServer
}

// SQLServerProperties - The SQL server properties.
type SQLServerProperties struct {
	// Cores of the Sql Server.
	Cores *int32

	// Sql Server Edition.
	Edition *string

	// Sql Server Json Property Bag.
	PropertyBag *string

	// ID for Parent Sql Server Registration.
	RegistrationID *string

	// Version of the Sql Server.
	Version *string
}

// SQLServerRegistration - A SQL server registration.
type SQLServerRegistration struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource properties.
	Properties *SQLServerRegistrationProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// SQLServerRegistrationListResult - Server
type SQLServerRegistrationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*SQLServerRegistration
}

// SQLServerRegistrationProperties - The SQL server Registration properties.
type SQLServerRegistrationProperties struct {
	// Optional Properties as JSON string
	PropertyBag *string

	// Resource Group Name
	ResourceGroup *string

	// Subscription Id
	SubscriptionID *string
}

// SQLServerRegistrationUpdate - An update to a SQL Server Registration.
type SQLServerRegistrationUpdate struct {
	// Resource tags.
	Tags map[string]*string
}

// SystemData - Read only system data
type SystemData struct {
	// The timestamp of resource creation (UTC)
	CreatedAt *time.Time

	// An identifier for the identity that created the resource
	CreatedBy *string

	// The type of identity that created the resource
	CreatedByType *IdentityType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// An identifier for the identity that last modified the resource
	LastModifiedBy *string

	// The type of identity that last modified the resource
	LastModifiedByType *IdentityType
}

// TrackedResource - The resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}
