//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armbotservice_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/botservice/armbotservice"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/PutAlexaChannel.json
func ExampleChannelsClient_Create_createAlexaChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().Create(ctx, "OneResourceGroupName", "samplebotname", armbotservice.ChannelNameAlexaChannel, armbotservice.BotChannel{
		Location: to.Ptr("global"),
		Properties: &armbotservice.AlexaChannel{
			ChannelName: to.Ptr("AlexaChannel"),
			Properties: &armbotservice.AlexaChannelProperties{
				AlexaSkillID: to.Ptr("XAlexaSkillIdX"),
				IsEnabled:    to.Ptr(true),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BotChannel = armbotservice.BotChannel{
	// 	ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.AlexaChannel{
	// 		ChannelName: to.Ptr("AlexaChannel"),
	// 		Properties: &armbotservice.AlexaChannelProperties{
	// 			AlexaSkillID: to.Ptr("alexa skill id"),
	// 			IsEnabled: to.Ptr(true),
	// 			ServiceEndpointURI: to.Ptr("https://domain/XUrlFragmentX/botId"),
	// 			URLFragment: to.Ptr("XUrlFragmentX"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/PutChannel.json
func ExampleChannelsClient_Create_createChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().Create(ctx, "OneResourceGroupName", "samplebotname", armbotservice.ChannelNameEmailChannel, armbotservice.BotChannel{
		Location: to.Ptr("global"),
		Properties: &armbotservice.EmailChannel{
			ChannelName: to.Ptr("EmailChannel"),
			Properties: &armbotservice.EmailChannelProperties{
				EmailAddress: to.Ptr("a@b.com"),
				IsEnabled:    to.Ptr(true),
				Password:     to.Ptr("pwd"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BotChannel = armbotservice.BotChannel{
	// 	ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.EmailChannel{
	// 		ChannelName: to.Ptr("EmailChannel"),
	// 		Properties: &armbotservice.EmailChannelProperties{
	// 			EmailAddress: to.Ptr("a@b.com"),
	// 			IsEnabled: to.Ptr(true),
	// 			Password: to.Ptr("pwd"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/PutDirectLineSpeechChannel.json
func ExampleChannelsClient_Create_createDirectLineSpeechChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().Create(ctx, "OneResourceGroupName", "samplebotname", armbotservice.ChannelNameDirectLineSpeechChannel, armbotservice.BotChannel{
		Location: to.Ptr("global"),
		Properties: &armbotservice.DirectLineSpeechChannel{
			ChannelName: to.Ptr("DirectLineSpeechChannel"),
			Properties: &armbotservice.DirectLineSpeechChannelProperties{
				CognitiveServiceRegion:          to.Ptr("XcognitiveServiceRegionX"),
				CognitiveServiceSubscriptionKey: to.Ptr("XcognitiveServiceSubscriptionKeyX"),
				IsEnabled:                       to.Ptr(true),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BotChannel = armbotservice.BotChannel{
	// 	ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.DirectLineSpeechChannel{
	// 		ChannelName: to.Ptr("DirectLineSpeechChannel"),
	// 		Properties: &armbotservice.DirectLineSpeechChannelProperties{
	// 			CognitiveServiceRegion: to.Ptr("XcognitiveServiceRegionX"),
	// 			IsEnabled: to.Ptr(true),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/PutEmailChannel.json
func ExampleChannelsClient_Create_createEmailChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().Create(ctx, "OneResourceGroupName", "samplebotname", armbotservice.ChannelNameEmailChannel, armbotservice.BotChannel{
		Location: to.Ptr("global"),
		Properties: &armbotservice.EmailChannel{
			ChannelName: to.Ptr("EmailChannel"),
			Properties: &armbotservice.EmailChannelProperties{
				AuthMethod:   to.Ptr(armbotservice.EmailChannelAuthMethodGraph),
				EmailAddress: to.Ptr("a@b.com"),
				IsEnabled:    to.Ptr(true),
				MagicCode:    to.Ptr("000000"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BotChannel = armbotservice.BotChannel{
	// 	ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.EmailChannel{
	// 		ChannelName: to.Ptr("EmailChannel"),
	// 		Properties: &armbotservice.EmailChannelProperties{
	// 			AuthMethod: to.Ptr(armbotservice.EmailChannelAuthMethodGraph),
	// 			EmailAddress: to.Ptr("a@b.com"),
	// 			IsEnabled: to.Ptr(true),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/PutLineChannel.json
func ExampleChannelsClient_Create_createLineChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().Create(ctx, "OneResourceGroupName", "samplebotname", armbotservice.ChannelNameLineChannel, armbotservice.BotChannel{
		Location: to.Ptr("global"),
		Properties: &armbotservice.LineChannel{
			ChannelName: to.Ptr("LineChannel"),
			Properties: &armbotservice.LineChannelProperties{
				LineRegistrations: []*armbotservice.LineRegistration{
					{
						ChannelAccessToken: to.Ptr("channelAccessToken"),
						ChannelSecret:      to.Ptr("channelSecret"),
					}},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BotChannel = armbotservice.BotChannel{
	// 	ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.LineChannel{
	// 		ChannelName: to.Ptr("LineChannel"),
	// 		Properties: &armbotservice.LineChannelProperties{
	// 			CallbackURL: to.Ptr("http://callbackUrl"),
	// 			IsValidated: to.Ptr(true),
	// 			LineRegistrations: []*armbotservice.LineRegistration{
	// 				{
	// 					GeneratedID: to.Ptr("id"),
	// 			}},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/UpdateAlexaChannel.json
func ExampleChannelsClient_Update_updateAlexaChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().Update(ctx, "OneResourceGroupName", "samplebotname", armbotservice.ChannelNameAlexaChannel, armbotservice.BotChannel{
		Location: to.Ptr("global"),
		Properties: &armbotservice.AlexaChannel{
			ChannelName: to.Ptr("AlexaChannel"),
			Properties: &armbotservice.AlexaChannelProperties{
				AlexaSkillID: to.Ptr("XAlexaSkillIdX"),
				IsEnabled:    to.Ptr(true),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BotChannel = armbotservice.BotChannel{
	// 	ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.AlexaChannel{
	// 		ChannelName: to.Ptr("AlexaChannel"),
	// 		Properties: &armbotservice.AlexaChannelProperties{
	// 			AlexaSkillID: to.Ptr("XAlexaSkillIdX"),
	// 			IsEnabled: to.Ptr(true),
	// 			ServiceEndpointURI: to.Ptr("https://domain/XUrlFragmentX/botId"),
	// 			URLFragment: to.Ptr("XUrlFragmentX"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/UpdateChannel.json
func ExampleChannelsClient_Update_updateChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().Update(ctx, "OneResourceGroupName", "samplebotname", armbotservice.ChannelNameEmailChannel, armbotservice.BotChannel{
		Location: to.Ptr("global"),
		Properties: &armbotservice.EmailChannel{
			ChannelName: to.Ptr("EmailChannel"),
			Properties: &armbotservice.EmailChannelProperties{
				EmailAddress: to.Ptr("a@b.com"),
				IsEnabled:    to.Ptr(true),
				Password:     to.Ptr("pwd"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BotChannel = armbotservice.BotChannel{
	// 	ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.EmailChannel{
	// 		ChannelName: to.Ptr("EmailChannel"),
	// 		Properties: &armbotservice.EmailChannelProperties{
	// 			EmailAddress: to.Ptr("a@b.com"),
	// 			IsEnabled: to.Ptr(true),
	// 			Password: to.Ptr("pwd"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/UpdateDirectLineSpeechChannel.json
func ExampleChannelsClient_Update_updateDirectLineSpeechChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().Update(ctx, "OneResourceGroupName", "samplebotname", armbotservice.ChannelNameDirectLineSpeechChannel, armbotservice.BotChannel{
		Location: to.Ptr("global"),
		Properties: &armbotservice.DirectLineSpeechChannel{
			ChannelName: to.Ptr("DirectLineSpeechChannel"),
			Properties: &armbotservice.DirectLineSpeechChannelProperties{
				CognitiveServiceRegion:          to.Ptr("XcognitiveServiceRegionX"),
				CognitiveServiceSubscriptionKey: to.Ptr("XcognitiveServiceSubscriptionKeyX"),
				IsEnabled:                       to.Ptr(true),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BotChannel = armbotservice.BotChannel{
	// 	ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.DirectLineSpeechChannel{
	// 		ChannelName: to.Ptr("DirectLineSpeechChannel"),
	// 		Properties: &armbotservice.DirectLineSpeechChannelProperties{
	// 			CognitiveServiceRegion: to.Ptr("XcognitiveServiceRegionX"),
	// 			IsEnabled: to.Ptr(true),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/UpdateLineChannel.json
func ExampleChannelsClient_Update_updateLineChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().Update(ctx, "OneResourceGroupName", "samplebotname", armbotservice.ChannelNameLineChannel, armbotservice.BotChannel{
		Location: to.Ptr("global"),
		Properties: &armbotservice.LineChannel{
			ChannelName: to.Ptr("LineChannel"),
			Properties: &armbotservice.LineChannelProperties{
				LineRegistrations: []*armbotservice.LineRegistration{
					{
						ChannelAccessToken: to.Ptr("channelAccessToken"),
						ChannelSecret:      to.Ptr("channelSecret"),
					}},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BotChannel = armbotservice.BotChannel{
	// 	ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.LineChannel{
	// 		ChannelName: to.Ptr("LineChannel"),
	// 		Properties: &armbotservice.LineChannelProperties{
	// 			CallbackURL: to.Ptr("http://callbackUrl"),
	// 			IsValidated: to.Ptr(true),
	// 			LineRegistrations: []*armbotservice.LineRegistration{
	// 				{
	// 					GeneratedID: to.Ptr("id"),
	// 			}},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/DeleteChannel.json
func ExampleChannelsClient_Delete_deleteChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewChannelsClient().Delete(ctx, "OneResourceGroupName", "samplebotname", "EmailChannel", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/DeleteDirectLineSpeechChannel.json
func ExampleChannelsClient_Delete_deleteDirectLineSpeechChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewChannelsClient().Delete(ctx, "OneResourceGroupName", "samplebotname", "DirectLineSpeechChannel", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetAlexaChannel.json
func ExampleChannelsClient_Get_getAlexaChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().Get(ctx, "OneResourceGroupName", "samplebotname", "AlexaChannel", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BotChannel = armbotservice.BotChannel{
	// 	ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.AlexaChannel{
	// 		ChannelName: to.Ptr("AlexaChannel"),
	// 		Properties: &armbotservice.AlexaChannelProperties{
	// 			AlexaSkillID: to.Ptr("alexa skill id"),
	// 			IsEnabled: to.Ptr(true),
	// 			ServiceEndpointURI: to.Ptr("https://domain/XUrlFragmentX/botId"),
	// 			URLFragment: to.Ptr("XUrlFragmentX"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetChannel.json
func ExampleChannelsClient_Get_getChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().Get(ctx, "OneResourceGroupName", "samplebotname", "EmailChannel", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BotChannel = armbotservice.BotChannel{
	// 	ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.EmailChannel{
	// 		ChannelName: to.Ptr("EmailChannel"),
	// 		Properties: &armbotservice.EmailChannelProperties{
	// 			EmailAddress: to.Ptr("a@b.com"),
	// 			IsEnabled: to.Ptr(true),
	// 			Password: to.Ptr("pwd"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetDirectLineSpeechChannel.json
func ExampleChannelsClient_Get_getDirectLineSpeechChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().Get(ctx, "OneResourceGroupName", "samplebotname", "DirectLineSpeechChannel", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BotChannel = armbotservice.BotChannel{
	// 	ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.DirectLineSpeechChannel{
	// 		ChannelName: to.Ptr("DirectLineSpeechChannel"),
	// 		Properties: &armbotservice.DirectLineSpeechChannelProperties{
	// 			CognitiveServiceRegion: to.Ptr("Cognitive service region"),
	// 			CustomSpeechModelID: to.Ptr("Custom speech model ID"),
	// 			CustomVoiceDeploymentID: to.Ptr("Custom voice deployment ID"),
	// 			IsDefaultBotForCogSvcAccount: to.Ptr(true),
	// 			IsEnabled: to.Ptr(true),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetLineChannel.json
func ExampleChannelsClient_Get_getLineChannel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().Get(ctx, "OneResourceGroupName", "samplebotname", "LineChannel", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BotChannel = armbotservice.BotChannel{
	// 	ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.LineChannel{
	// 		ChannelName: to.Ptr("LineChannel"),
	// 		Properties: &armbotservice.LineChannelProperties{
	// 			CallbackURL: to.Ptr("http://callbackUrl"),
	// 			IsValidated: to.Ptr(true),
	// 			LineRegistrations: []*armbotservice.LineRegistration{
	// 				{
	// 					GeneratedID: to.Ptr("id"),
	// 			}},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/ListChannel.json
func ExampleChannelsClient_ListWithKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChannelsClient().ListWithKeys(ctx, "OneResourceGroupName", "samplebotname", armbotservice.ChannelNameEmailChannel, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ListChannelWithKeysResponse = armbotservice.ListChannelWithKeysResponse{
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.EmailChannel{
	// 		ChannelName: to.Ptr("EmailChannel"),
	// 		Properties: &armbotservice.EmailChannelProperties{
	// 			EmailAddress: to.Ptr("a@b.com"),
	// 			IsEnabled: to.Ptr(true),
	// 			Password: to.Ptr("pwd"),
	// 		},
	// 	},
	// 	Resource: &armbotservice.DirectLineChannel{
	// 		ChannelName: to.Ptr("DirectLineChannel"),
	// 		Etag: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 		Location: to.Ptr("aaaaaa"),
	// 		Properties: &armbotservice.DirectLineChannelProperties{
	// 			Sites: []*armbotservice.DirectLineSite{
	// 				{
	// 					IsBlockUserUploadEnabled: to.Ptr(false),
	// 					IsEnabled: to.Ptr(true),
	// 					IsSecureSiteEnabled: to.Ptr(false),
	// 					IsV1Enabled: to.Ptr(true),
	// 					IsV3Enabled: to.Ptr(true),
	// 					Key: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 					Key2: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 					SiteID: to.Ptr("aaaaaaaaaaa"),
	// 					SiteName: to.Ptr("aaaaaaaaaaaa"),
	// 					TrustedOrigins: []*string{
	// 						to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa")},
	// 				}},
	// 			},
	// 		},
	// 		Setting: &armbotservice.ChannelSettings{
	// 			BotIconURL: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 			BotID: to.Ptr("aaaaaaaaaaaaaaaaaaaa"),
	// 			ChannelDisplayName: to.Ptr("aaaaaaaaaaa"),
	// 			ChannelID: to.Ptr("aaaaaaaaaa"),
	// 			DisableLocalAuth: to.Ptr(false),
	// 			ExtensionKey1: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 			ExtensionKey2: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 			IsEnabled: to.Ptr(true),
	// 			Sites: []*armbotservice.Site{
	// 				{
	// 					ETag: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 					IsBlockUserUploadEnabled: to.Ptr(false),
	// 					IsEnabled: to.Ptr(true),
	// 					IsSecureSiteEnabled: to.Ptr(false),
	// 					IsTokenEnabled: to.Ptr(false),
	// 					IsV1Enabled: to.Ptr(true),
	// 					IsV3Enabled: to.Ptr(true),
	// 					IsWebchatPreviewEnabled: to.Ptr(false),
	// 					Key: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 					Key2: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 					SiteID: to.Ptr("aaaaaaaaaaa"),
	// 					SiteName: to.Ptr("aaaaaaaaaaaa"),
	// 					TrustedOrigins: []*string{
	// 						to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa")},
	// 				}},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/ListChannelsByBotService.json
func ExampleChannelsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewChannelsClient().NewListByResourceGroupPager("OneResourceGroupName", "samplebotname", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ChannelResponseList = armbotservice.ChannelResponseList{
		// 	Value: []*armbotservice.BotChannel{
		// 		{
		// 			ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
		// 			Location: to.Ptr("global"),
		// 			Properties: &armbotservice.EmailChannel{
		// 				ChannelName: to.Ptr("EmailChannel"),
		// 				Properties: &armbotservice.EmailChannelProperties{
		// 					EmailAddress: to.Ptr("a@b.com"),
		// 					IsEnabled: to.Ptr(true),
		// 					Password: to.Ptr("pwd"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
		// 			Location: to.Ptr("global"),
		// 			Properties: &armbotservice.FacebookChannel{
		// 				ChannelName: to.Ptr("FacebookChannel"),
		// 				Properties: &armbotservice.FacebookChannelProperties{
		// 					AppID: to.Ptr("id"),
		// 					CallbackURL: to.Ptr("appid"),
		// 					IsEnabled: to.Ptr(true),
		// 					Pages: []*armbotservice.FacebookPage{
		// 						{
		// 							ID: to.Ptr("id"),
		// 					}},
		// 				},
		// 			},
		// 	}},
		// }
	}
}
