//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cdn/armcdn/v2"
	"net/http"
	"net/url"
	"regexp"
)

// AFDCustomDomainsServer is a fake server for instances of the armcdn.AFDCustomDomainsClient type.
type AFDCustomDomainsServer struct {
	// BeginCreate is the fake for method AFDCustomDomainsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceGroupName string, profileName string, customDomainName string, customDomain armcdn.AFDDomain, options *armcdn.AFDCustomDomainsClientBeginCreateOptions) (resp azfake.PollerResponder[armcdn.AFDCustomDomainsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method AFDCustomDomainsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, profileName string, customDomainName string, options *armcdn.AFDCustomDomainsClientBeginDeleteOptions) (resp azfake.PollerResponder[armcdn.AFDCustomDomainsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AFDCustomDomainsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, profileName string, customDomainName string, options *armcdn.AFDCustomDomainsClientGetOptions) (resp azfake.Responder[armcdn.AFDCustomDomainsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByProfilePager is the fake for method AFDCustomDomainsClient.NewListByProfilePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByProfilePager func(resourceGroupName string, profileName string, options *armcdn.AFDCustomDomainsClientListByProfileOptions) (resp azfake.PagerResponder[armcdn.AFDCustomDomainsClientListByProfileResponse])

	// BeginRefreshValidationToken is the fake for method AFDCustomDomainsClient.BeginRefreshValidationToken
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRefreshValidationToken func(ctx context.Context, resourceGroupName string, profileName string, customDomainName string, options *armcdn.AFDCustomDomainsClientBeginRefreshValidationTokenOptions) (resp azfake.PollerResponder[armcdn.AFDCustomDomainsClientRefreshValidationTokenResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method AFDCustomDomainsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, profileName string, customDomainName string, customDomainUpdateProperties armcdn.AFDDomainUpdateParameters, options *armcdn.AFDCustomDomainsClientBeginUpdateOptions) (resp azfake.PollerResponder[armcdn.AFDCustomDomainsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewAFDCustomDomainsServerTransport creates a new instance of AFDCustomDomainsServerTransport with the provided implementation.
// The returned AFDCustomDomainsServerTransport instance is connected to an instance of armcdn.AFDCustomDomainsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAFDCustomDomainsServerTransport(srv *AFDCustomDomainsServer) *AFDCustomDomainsServerTransport {
	return &AFDCustomDomainsServerTransport{
		srv:                         srv,
		beginCreate:                 newTracker[azfake.PollerResponder[armcdn.AFDCustomDomainsClientCreateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armcdn.AFDCustomDomainsClientDeleteResponse]](),
		newListByProfilePager:       newTracker[azfake.PagerResponder[armcdn.AFDCustomDomainsClientListByProfileResponse]](),
		beginRefreshValidationToken: newTracker[azfake.PollerResponder[armcdn.AFDCustomDomainsClientRefreshValidationTokenResponse]](),
		beginUpdate:                 newTracker[azfake.PollerResponder[armcdn.AFDCustomDomainsClientUpdateResponse]](),
	}
}

// AFDCustomDomainsServerTransport connects instances of armcdn.AFDCustomDomainsClient to instances of AFDCustomDomainsServer.
// Don't use this type directly, use NewAFDCustomDomainsServerTransport instead.
type AFDCustomDomainsServerTransport struct {
	srv                         *AFDCustomDomainsServer
	beginCreate                 *tracker[azfake.PollerResponder[armcdn.AFDCustomDomainsClientCreateResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armcdn.AFDCustomDomainsClientDeleteResponse]]
	newListByProfilePager       *tracker[azfake.PagerResponder[armcdn.AFDCustomDomainsClientListByProfileResponse]]
	beginRefreshValidationToken *tracker[azfake.PollerResponder[armcdn.AFDCustomDomainsClientRefreshValidationTokenResponse]]
	beginUpdate                 *tracker[azfake.PollerResponder[armcdn.AFDCustomDomainsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for AFDCustomDomainsServerTransport.
func (a *AFDCustomDomainsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AFDCustomDomainsClient.BeginCreate":
		resp, err = a.dispatchBeginCreate(req)
	case "AFDCustomDomainsClient.BeginDelete":
		resp, err = a.dispatchBeginDelete(req)
	case "AFDCustomDomainsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AFDCustomDomainsClient.NewListByProfilePager":
		resp, err = a.dispatchNewListByProfilePager(req)
	case "AFDCustomDomainsClient.BeginRefreshValidationToken":
		resp, err = a.dispatchBeginRefreshValidationToken(req)
	case "AFDCustomDomainsClient.BeginUpdate":
		resp, err = a.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AFDCustomDomainsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := a.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<customDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcdn.AFDDomain](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		customDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customDomainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreate(req.Context(), resourceGroupNameParam, profileNameParam, customDomainNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		a.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		a.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		a.beginCreate.remove(req)
	}

	return resp, nil
}

func (a *AFDCustomDomainsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if a.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := a.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<customDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		customDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customDomainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginDelete(req.Context(), resourceGroupNameParam, profileNameParam, customDomainNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		a.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		a.beginDelete.remove(req)
	}

	return resp, nil
}

func (a *AFDCustomDomainsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<customDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
	if err != nil {
		return nil, err
	}
	customDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customDomainName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, profileNameParam, customDomainNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AFDDomain, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AFDCustomDomainsServerTransport) dispatchNewListByProfilePager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByProfilePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByProfilePager not implemented")}
	}
	newListByProfilePager := a.newListByProfilePager.get(req)
	if newListByProfilePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByProfilePager(resourceGroupNameParam, profileNameParam, nil)
		newListByProfilePager = &resp
		a.newListByProfilePager.add(req, newListByProfilePager)
		server.PagerResponderInjectNextLinks(newListByProfilePager, req, func(page *armcdn.AFDCustomDomainsClientListByProfileResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByProfilePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByProfilePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByProfilePager) {
		a.newListByProfilePager.remove(req)
	}
	return resp, nil
}

func (a *AFDCustomDomainsServerTransport) dispatchBeginRefreshValidationToken(req *http.Request) (*http.Response, error) {
	if a.srv.BeginRefreshValidationToken == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRefreshValidationToken not implemented")}
	}
	beginRefreshValidationToken := a.beginRefreshValidationToken.get(req)
	if beginRefreshValidationToken == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<customDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/refreshValidationToken`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		customDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customDomainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginRefreshValidationToken(req.Context(), resourceGroupNameParam, profileNameParam, customDomainNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRefreshValidationToken = &respr
		a.beginRefreshValidationToken.add(req, beginRefreshValidationToken)
	}

	resp, err := server.PollerResponderNext(beginRefreshValidationToken, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		a.beginRefreshValidationToken.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRefreshValidationToken) {
		a.beginRefreshValidationToken.remove(req)
	}

	return resp, nil
}

func (a *AFDCustomDomainsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := a.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<customDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcdn.AFDDomainUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		customDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customDomainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginUpdate(req.Context(), resourceGroupNameParam, profileNameParam, customDomainNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		a.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		a.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		a.beginUpdate.remove(req)
	}

	return resp, nil
}
