//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armcognitiveservices.ClientFactory type.
type ServerFactory struct {
	AccountsServer                   AccountsServer
	CommitmentPlansServer            CommitmentPlansServer
	CommitmentTiersServer            CommitmentTiersServer
	DeletedAccountsServer            DeletedAccountsServer
	DeploymentsServer                DeploymentsServer
	ManagementServer                 ManagementServer
	ModelsServer                     ModelsServer
	OperationsServer                 OperationsServer
	PrivateEndpointConnectionsServer PrivateEndpointConnectionsServer
	PrivateLinkResourcesServer       PrivateLinkResourcesServer
	ResourceSKUsServer               ResourceSKUsServer
	UsagesServer                     UsagesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armcognitiveservices.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armcognitiveservices.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                *ServerFactory
	trMu                               sync.Mutex
	trAccountsServer                   *AccountsServerTransport
	trCommitmentPlansServer            *CommitmentPlansServerTransport
	trCommitmentTiersServer            *CommitmentTiersServerTransport
	trDeletedAccountsServer            *DeletedAccountsServerTransport
	trDeploymentsServer                *DeploymentsServerTransport
	trManagementServer                 *ManagementServerTransport
	trModelsServer                     *ModelsServerTransport
	trOperationsServer                 *OperationsServerTransport
	trPrivateEndpointConnectionsServer *PrivateEndpointConnectionsServerTransport
	trPrivateLinkResourcesServer       *PrivateLinkResourcesServerTransport
	trResourceSKUsServer               *ResourceSKUsServerTransport
	trUsagesServer                     *UsagesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AccountsClient":
		initServer(s, &s.trAccountsServer, func() *AccountsServerTransport { return NewAccountsServerTransport(&s.srv.AccountsServer) })
		resp, err = s.trAccountsServer.Do(req)
	case "CommitmentPlansClient":
		initServer(s, &s.trCommitmentPlansServer, func() *CommitmentPlansServerTransport {
			return NewCommitmentPlansServerTransport(&s.srv.CommitmentPlansServer)
		})
		resp, err = s.trCommitmentPlansServer.Do(req)
	case "CommitmentTiersClient":
		initServer(s, &s.trCommitmentTiersServer, func() *CommitmentTiersServerTransport {
			return NewCommitmentTiersServerTransport(&s.srv.CommitmentTiersServer)
		})
		resp, err = s.trCommitmentTiersServer.Do(req)
	case "DeletedAccountsClient":
		initServer(s, &s.trDeletedAccountsServer, func() *DeletedAccountsServerTransport {
			return NewDeletedAccountsServerTransport(&s.srv.DeletedAccountsServer)
		})
		resp, err = s.trDeletedAccountsServer.Do(req)
	case "DeploymentsClient":
		initServer(s, &s.trDeploymentsServer, func() *DeploymentsServerTransport { return NewDeploymentsServerTransport(&s.srv.DeploymentsServer) })
		resp, err = s.trDeploymentsServer.Do(req)
	case "ManagementClient":
		initServer(s, &s.trManagementServer, func() *ManagementServerTransport { return NewManagementServerTransport(&s.srv.ManagementServer) })
		resp, err = s.trManagementServer.Do(req)
	case "ModelsClient":
		initServer(s, &s.trModelsServer, func() *ModelsServerTransport { return NewModelsServerTransport(&s.srv.ModelsServer) })
		resp, err = s.trModelsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PrivateEndpointConnectionsClient":
		initServer(s, &s.trPrivateEndpointConnectionsServer, func() *PrivateEndpointConnectionsServerTransport {
			return NewPrivateEndpointConnectionsServerTransport(&s.srv.PrivateEndpointConnectionsServer)
		})
		resp, err = s.trPrivateEndpointConnectionsServer.Do(req)
	case "PrivateLinkResourcesClient":
		initServer(s, &s.trPrivateLinkResourcesServer, func() *PrivateLinkResourcesServerTransport {
			return NewPrivateLinkResourcesServerTransport(&s.srv.PrivateLinkResourcesServer)
		})
		resp, err = s.trPrivateLinkResourcesServer.Do(req)
	case "ResourceSKUsClient":
		initServer(s, &s.trResourceSKUsServer, func() *ResourceSKUsServerTransport { return NewResourceSKUsServerTransport(&s.srv.ResourceSKUsServer) })
		resp, err = s.trResourceSKUsServer.Do(req)
	case "UsagesClient":
		initServer(s, &s.trUsagesServer, func() *UsagesServerTransport { return NewUsagesServerTransport(&s.srv.UsagesServer) })
		resp, err = s.trUsagesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
