//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/frontdoor/armfrontdoor"
	"net/http"
	"net/url"
	"regexp"
	"time"
)

// ReportsServer is a fake server for instances of the armfrontdoor.ReportsClient type.
type ReportsServer struct {
	// GetLatencyScorecards is the fake for method ReportsClient.GetLatencyScorecards
	// HTTP status codes to indicate success: http.StatusOK
	GetLatencyScorecards func(ctx context.Context, resourceGroupName string, profileName string, experimentName string, aggregationInterval armfrontdoor.LatencyScorecardAggregationInterval, options *armfrontdoor.ReportsClientGetLatencyScorecardsOptions) (resp azfake.Responder[armfrontdoor.ReportsClientGetLatencyScorecardsResponse], errResp azfake.ErrorResponder)

	// GetTimeseries is the fake for method ReportsClient.GetTimeseries
	// HTTP status codes to indicate success: http.StatusOK
	GetTimeseries func(ctx context.Context, resourceGroupName string, profileName string, experimentName string, startDateTimeUTC time.Time, endDateTimeUTC time.Time, aggregationInterval armfrontdoor.TimeseriesAggregationInterval, timeseriesType armfrontdoor.TimeseriesType, options *armfrontdoor.ReportsClientGetTimeseriesOptions) (resp azfake.Responder[armfrontdoor.ReportsClientGetTimeseriesResponse], errResp azfake.ErrorResponder)
}

// NewReportsServerTransport creates a new instance of ReportsServerTransport with the provided implementation.
// The returned ReportsServerTransport instance is connected to an instance of armfrontdoor.ReportsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReportsServerTransport(srv *ReportsServer) *ReportsServerTransport {
	return &ReportsServerTransport{srv: srv}
}

// ReportsServerTransport connects instances of armfrontdoor.ReportsClient to instances of ReportsServer.
// Don't use this type directly, use NewReportsServerTransport instead.
type ReportsServerTransport struct {
	srv *ReportsServer
}

// Do implements the policy.Transporter interface for ReportsServerTransport.
func (r *ReportsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReportsClient.GetLatencyScorecards":
		resp, err = r.dispatchGetLatencyScorecards(req)
	case "ReportsClient.GetTimeseries":
		resp, err = r.dispatchGetTimeseries(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReportsServerTransport) dispatchGetLatencyScorecards(req *http.Request) (*http.Response, error) {
	if r.srv.GetLatencyScorecards == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetLatencyScorecards not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/NetworkExperimentProfiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/Experiments/(?P<experimentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/LatencyScorecard`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
	if err != nil {
		return nil, err
	}
	experimentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("experimentName")])
	if err != nil {
		return nil, err
	}
	endDateTimeUTCUnescaped, err := url.QueryUnescape(qp.Get("endDateTimeUTC"))
	if err != nil {
		return nil, err
	}
	endDateTimeUTCParam := getOptional(endDateTimeUTCUnescaped)
	countryUnescaped, err := url.QueryUnescape(qp.Get("country"))
	if err != nil {
		return nil, err
	}
	countryParam := getOptional(countryUnescaped)
	aggregationIntervalParam, err := parseWithCast(qp.Get("aggregationInterval"), func(v string) (armfrontdoor.LatencyScorecardAggregationInterval, error) {
		p, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armfrontdoor.LatencyScorecardAggregationInterval(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armfrontdoor.ReportsClientGetLatencyScorecardsOptions
	if endDateTimeUTCParam != nil || countryParam != nil {
		options = &armfrontdoor.ReportsClientGetLatencyScorecardsOptions{
			EndDateTimeUTC: endDateTimeUTCParam,
			Country:        countryParam,
		}
	}
	respr, errRespr := r.srv.GetLatencyScorecards(req.Context(), resourceGroupNameParam, profileNameParam, experimentNameParam, aggregationIntervalParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LatencyScorecard, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ReportsServerTransport) dispatchGetTimeseries(req *http.Request) (*http.Response, error) {
	if r.srv.GetTimeseries == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetTimeseries not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/NetworkExperimentProfiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/Experiments/(?P<experimentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/Timeseries`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
	if err != nil {
		return nil, err
	}
	experimentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("experimentName")])
	if err != nil {
		return nil, err
	}
	startDateTimeUTCUnescaped, err := url.QueryUnescape(qp.Get("startDateTimeUTC"))
	if err != nil {
		return nil, err
	}
	startDateTimeUTCParam, err := time.Parse(time.RFC3339Nano, startDateTimeUTCUnescaped)
	if err != nil {
		return nil, err
	}
	endDateTimeUTCUnescaped, err := url.QueryUnescape(qp.Get("endDateTimeUTC"))
	if err != nil {
		return nil, err
	}
	endDateTimeUTCParam, err := time.Parse(time.RFC3339Nano, endDateTimeUTCUnescaped)
	if err != nil {
		return nil, err
	}
	aggregationIntervalParam, err := parseWithCast(qp.Get("aggregationInterval"), func(v string) (armfrontdoor.TimeseriesAggregationInterval, error) {
		p, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armfrontdoor.TimeseriesAggregationInterval(p), nil
	})
	if err != nil {
		return nil, err
	}
	timeseriesTypeParam, err := parseWithCast(qp.Get("timeseriesType"), func(v string) (armfrontdoor.TimeseriesType, error) {
		p, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armfrontdoor.TimeseriesType(p), nil
	})
	if err != nil {
		return nil, err
	}
	endpointUnescaped, err := url.QueryUnescape(qp.Get("endpoint"))
	if err != nil {
		return nil, err
	}
	endpointParam := getOptional(endpointUnescaped)
	countryUnescaped, err := url.QueryUnescape(qp.Get("country"))
	if err != nil {
		return nil, err
	}
	countryParam := getOptional(countryUnescaped)
	var options *armfrontdoor.ReportsClientGetTimeseriesOptions
	if endpointParam != nil || countryParam != nil {
		options = &armfrontdoor.ReportsClientGetTimeseriesOptions{
			Endpoint: endpointParam,
			Country:  countryParam,
		}
	}
	respr, errRespr := r.srv.GetTimeseries(req.Context(), resourceGroupNameParam, profileNameParam, experimentNameParam, startDateTimeUTCParam, endDateTimeUTCParam, aggregationIntervalParam, timeseriesTypeParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Timeseries, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
