//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mysql/armmysqlflexibleservers/v2"
	"net/http"
	"net/url"
	"regexp"
)

// AdvancedThreatProtectionSettingsServer is a fake server for instances of the armmysqlflexibleservers.AdvancedThreatProtectionSettingsClient type.
type AdvancedThreatProtectionSettingsServer struct {
	// Get is the fake for method AdvancedThreatProtectionSettingsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, advancedThreatProtectionName armmysqlflexibleservers.AdvancedThreatProtectionName, options *armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientGetOptions) (resp azfake.Responder[armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method AdvancedThreatProtectionSettingsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, serverName string, options *armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientListOptions) (resp azfake.PagerResponder[armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientListResponse])

	// BeginUpdate is the fake for method AdvancedThreatProtectionSettingsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, serverName string, advancedThreatProtectionName armmysqlflexibleservers.AdvancedThreatProtectionName, parameters armmysqlflexibleservers.AdvancedThreatProtectionForUpdate, options *armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientBeginUpdateOptions) (resp azfake.PollerResponder[armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpdatePut is the fake for method AdvancedThreatProtectionSettingsClient.BeginUpdatePut
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginUpdatePut func(ctx context.Context, resourceGroupName string, serverName string, advancedThreatProtectionName armmysqlflexibleservers.AdvancedThreatProtectionName, parameters armmysqlflexibleservers.AdvancedThreatProtection, options *armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientBeginUpdatePutOptions) (resp azfake.PollerResponder[armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientUpdatePutResponse], errResp azfake.ErrorResponder)
}

// NewAdvancedThreatProtectionSettingsServerTransport creates a new instance of AdvancedThreatProtectionSettingsServerTransport with the provided implementation.
// The returned AdvancedThreatProtectionSettingsServerTransport instance is connected to an instance of armmysqlflexibleservers.AdvancedThreatProtectionSettingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAdvancedThreatProtectionSettingsServerTransport(srv *AdvancedThreatProtectionSettingsServer) *AdvancedThreatProtectionSettingsServerTransport {
	return &AdvancedThreatProtectionSettingsServerTransport{
		srv:            srv,
		newListPager:   newTracker[azfake.PagerResponder[armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientListResponse]](),
		beginUpdate:    newTracker[azfake.PollerResponder[armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientUpdateResponse]](),
		beginUpdatePut: newTracker[azfake.PollerResponder[armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientUpdatePutResponse]](),
	}
}

// AdvancedThreatProtectionSettingsServerTransport connects instances of armmysqlflexibleservers.AdvancedThreatProtectionSettingsClient to instances of AdvancedThreatProtectionSettingsServer.
// Don't use this type directly, use NewAdvancedThreatProtectionSettingsServerTransport instead.
type AdvancedThreatProtectionSettingsServerTransport struct {
	srv            *AdvancedThreatProtectionSettingsServer
	newListPager   *tracker[azfake.PagerResponder[armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientListResponse]]
	beginUpdate    *tracker[azfake.PollerResponder[armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientUpdateResponse]]
	beginUpdatePut *tracker[azfake.PollerResponder[armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientUpdatePutResponse]]
}

// Do implements the policy.Transporter interface for AdvancedThreatProtectionSettingsServerTransport.
func (a *AdvancedThreatProtectionSettingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AdvancedThreatProtectionSettingsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AdvancedThreatProtectionSettingsClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	case "AdvancedThreatProtectionSettingsClient.BeginUpdate":
		resp, err = a.dispatchBeginUpdate(req)
	case "AdvancedThreatProtectionSettingsClient.BeginUpdatePut":
		resp, err = a.dispatchBeginUpdatePut(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AdvancedThreatProtectionSettingsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/flexibleServers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/advancedThreatProtectionSettings/(?P<advancedThreatProtectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	advancedThreatProtectionNameParam, err := parseWithCast(matches[regex.SubexpIndex("advancedThreatProtectionName")], func(v string) (armmysqlflexibleservers.AdvancedThreatProtectionName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armmysqlflexibleservers.AdvancedThreatProtectionName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, advancedThreatProtectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AdvancedThreatProtection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AdvancedThreatProtectionSettingsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/flexibleServers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/advancedThreatProtectionSettings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListPager(resourceGroupNameParam, serverNameParam, nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmysqlflexibleservers.AdvancedThreatProtectionSettingsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}

func (a *AdvancedThreatProtectionSettingsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := a.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/flexibleServers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/advancedThreatProtectionSettings/(?P<advancedThreatProtectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmysqlflexibleservers.AdvancedThreatProtectionForUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		advancedThreatProtectionNameParam, err := parseWithCast(matches[regex.SubexpIndex("advancedThreatProtectionName")], func(v string) (armmysqlflexibleservers.AdvancedThreatProtectionName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armmysqlflexibleservers.AdvancedThreatProtectionName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginUpdate(req.Context(), resourceGroupNameParam, serverNameParam, advancedThreatProtectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		a.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		a.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		a.beginUpdate.remove(req)
	}

	return resp, nil
}

func (a *AdvancedThreatProtectionSettingsServerTransport) dispatchBeginUpdatePut(req *http.Request) (*http.Response, error) {
	if a.srv.BeginUpdatePut == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdatePut not implemented")}
	}
	beginUpdatePut := a.beginUpdatePut.get(req)
	if beginUpdatePut == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/flexibleServers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/advancedThreatProtectionSettings/(?P<advancedThreatProtectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmysqlflexibleservers.AdvancedThreatProtection](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		advancedThreatProtectionNameParam, err := parseWithCast(matches[regex.SubexpIndex("advancedThreatProtectionName")], func(v string) (armmysqlflexibleservers.AdvancedThreatProtectionName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armmysqlflexibleservers.AdvancedThreatProtectionName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginUpdatePut(req.Context(), resourceGroupNameParam, serverNameParam, advancedThreatProtectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdatePut = &respr
		a.beginUpdatePut.add(req, beginUpdatePut)
	}

	resp, err := server.PollerResponderNext(beginUpdatePut, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		a.beginUpdatePut.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdatePut) {
		a.beginUpdatePut.remove(req)
	}

	return resp, nil
}
