//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpostgresql

import "time"

// Configuration - Represents a Configuration.
type Configuration struct {
	// The properties of a configuration.
	Properties *ConfigurationProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ConfigurationListResult - A list of server configurations.
type ConfigurationListResult struct {
	// The list of server configurations.
	Value []*Configuration
}

// ConfigurationProperties - The properties of a configuration.
type ConfigurationProperties struct {
	// Source of the configuration.
	Source *string

	// Value of the configuration.
	Value *string

	// READ-ONLY; Allowed values of the configuration.
	AllowedValues *string

	// READ-ONLY; Data type of the configuration.
	DataType *string

	// READ-ONLY; Default value of the configuration.
	DefaultValue *string

	// READ-ONLY; Description of the configuration.
	Description *string
}

// Database - Represents a Database.
type Database struct {
	// The properties of a database.
	Properties *DatabaseProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DatabaseListResult - A List of databases.
type DatabaseListResult struct {
	// The list of databases housed in a server
	Value []*Database
}

// DatabaseProperties - The properties of a database.
type DatabaseProperties struct {
	// The charset of the database.
	Charset *string

	// The collation of the database.
	Collation *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.)
type ErrorResponse struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorResponse

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// FirewallRule - Represents a server firewall rule.
type FirewallRule struct {
	// REQUIRED; The properties of a firewall rule.
	Properties *FirewallRuleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FirewallRuleListResult - A list of firewall rules.
type FirewallRuleListResult struct {
	// The list of firewall rules in a server.
	Value []*FirewallRule
}

// FirewallRuleProperties - The properties of a server firewall rule.
type FirewallRuleProperties struct {
	// REQUIRED; The end IP address of the server firewall rule. Must be IPv4 format.
	EndIPAddress *string

	// REQUIRED; The start IP address of the server firewall rule. Must be IPv4 format.
	StartIPAddress *string
}

// LogFile - Represents a log file.
type LogFile struct {
	// The properties of the log file.
	Properties *LogFileProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LogFileListResult - A list of log files.
type LogFileListResult struct {
	// The list of log files.
	Value []*LogFile
}

// LogFileProperties - The properties of a log file.
type LogFileProperties struct {
	// Size of the log file.
	SizeInKB *int64

	// Type of the log file.
	Type *string

	// The url to download the log file from.
	URL *string

	// READ-ONLY; Creation timestamp of the log file.
	CreatedTime *time.Time

	// READ-ONLY; Last modified timestamp of the log file.
	LastModifiedTime *time.Time
}

// NameAvailability - Represents a resource name availability.
type NameAvailability struct {
	// Error Message.
	Message *string

	// Indicates whether the resource name is available.
	NameAvailable *bool

	// Reason for name being unavailable.
	Reason *string
}

// NameAvailabilityRequest - Request from client to check resource name availability.
type NameAvailabilityRequest struct {
	// REQUIRED; Resource name to verify.
	Name *string

	// Resource type used for verification.
	Type *string
}

// Operation - REST API operation definition.
type Operation struct {
	// READ-ONLY; The localized display information for this particular operation or action.
	Display *OperationDisplay

	// READ-ONLY; The name of the operation being performed on this particular object.
	Name *string

	// READ-ONLY; The intended executor of the operation.
	Origin *OperationOrigin

	// READ-ONLY; Additional descriptions for the operation.
	Properties map[string]any
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// READ-ONLY; Operation description.
	Description *string

	// READ-ONLY; Localized friendly name for the operation.
	Operation *string

	// READ-ONLY; Operation resource provider name.
	Provider *string

	// READ-ONLY; Resource on which the operation is performed.
	Resource *string
}

// OperationListResult - A list of resource provider operations.
type OperationListResult struct {
	// The list of resource provider operations.
	Value []*Operation
}

// PerformanceTierListResult - A list of performance tiers.
type PerformanceTierListResult struct {
	// The list of performance tiers
	Value []*PerformanceTierProperties
}

// PerformanceTierProperties - Performance tier properties
type PerformanceTierProperties struct {
	// ID of the performance tier.
	ID *string

	// Maximum Backup retention in days for the performance tier edition
	MaxBackupRetentionDays *int32

	// Max storage allowed for a server.
	MaxLargeStorageMB *int32

	// Max storage allowed for a server.
	MaxStorageMB *int32

	// Minimum Backup retention in days for the performance tier edition
	MinBackupRetentionDays *int32

	// Max storage allowed for a server.
	MinLargeStorageMB *int32

	// Max storage allowed for a server.
	MinStorageMB *int32

	// Service level objectives associated with the performance tier
	ServiceLevelObjectives []*PerformanceTierServiceLevelObjectives
}

// PerformanceTierServiceLevelObjectives - Service level objectives for performance tier.
type PerformanceTierServiceLevelObjectives struct {
	// Edition of the performance tier.
	Edition *string

	// Hardware generation associated with the service level objective
	HardwareGeneration *string

	// ID for the service level objective.
	ID *string

	// Maximum Backup retention in days for the performance tier edition
	MaxBackupRetentionDays *int32

	// Max storage allowed for a server.
	MaxStorageMB *int32

	// Minimum Backup retention in days for the performance tier edition
	MinBackupRetentionDays *int32

	// Max storage allowed for a server.
	MinStorageMB *int32

	// vCore associated with the service level objective
	VCore *int32
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty

	// Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty

	// READ-ONLY; State of the private endpoint connection.
	ProvisioningState *string
}

type PrivateEndpointProperty struct {
	// Resource id of the private endpoint.
	ID *string
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The private link resource group id.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

type PrivateLinkServiceConnectionStateProperty struct {
	// REQUIRED; The private link service connection description.
	Description *string

	// REQUIRED; The private link service connection status.
	Status *string

	// READ-ONLY; The actions required for private link service connection.
	ActionsRequired *string
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RecoverableServerProperties - The recoverable server's properties.
type RecoverableServerProperties struct {
	// READ-ONLY; Edition of the performance tier.
	Edition *string

	// READ-ONLY; Hardware generation associated with the service level objective
	HardwareGeneration *string

	// READ-ONLY; The last available backup date time.
	LastAvailableBackupDateTime *string

	// READ-ONLY; The service level objective
	ServiceLevelObjective *string

	// READ-ONLY; vCore associated with the service level objective
	VCore *int32

	// READ-ONLY; The PostgreSQL version
	Version *string
}

// RecoverableServerResource - A recoverable server resource.
type RecoverableServerResource struct {
	// Resource properties.
	Properties *RecoverableServerProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceIdentity - Azure Active Directory identity configuration for a resource.
type ResourceIdentity struct {
	// The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal
	// for the resource.
	Type *IdentityType

	// READ-ONLY; The Azure Active Directory principal id.
	PrincipalID *string

	// READ-ONLY; The Azure Active Directory tenant id.
	TenantID *string
}

// SKU - Billing information related properties of a server.
type SKU struct {
	// REQUIRED; The name of the sku, typically, tier + family + cores, e.g. BGen41, GPGen58.
	Name *string

	// The scale up/out capacity, representing server's compute units.
	Capacity *int32

	// The family of hardware.
	Family *string

	// The size code, to be interpreted by resource as appropriate.
	Size *string

	// The tier of the particular SKU, e.g. Basic.
	Tier *SKUTier
}

// SecurityAlertPolicyProperties - Properties of a security alert policy.
type SecurityAlertPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy, whether it is enabled or disabled.
	State *ServerSecurityAlertPolicyState

	// Specifies an array of alerts that are disabled. Allowed values are: SqlInjection, SqlInjectionVulnerability, AccessAnomaly
	DisabledAlerts []*string

	// Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool

	// Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses []*string

	// Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32

	// Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat
	// Detection audit logs.
	StorageEndpoint *string
}

// Server - Represents a server.
type Server struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The Azure Active Directory identity of the server.
	Identity *ResourceIdentity

	// Properties of the server.
	Properties *ServerProperties

	// The SKU (pricing tier) of the server.
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerAdministratorProperties - The properties of an server Administrator.
type ServerAdministratorProperties struct {
	// CONSTANT; The type of administrator.
	// Field has constant value "ActiveDirectory", any specified value is ignored.
	AdministratorType *string

	// REQUIRED; The server administrator login account name.
	Login *string

	// REQUIRED; The server administrator Sid (Secure ID).
	Sid *string

	// REQUIRED; The server Active Directory Administrator tenant id.
	TenantID *string
}

// ServerAdministratorResource - Represents a and external administrator to be created.
type ServerAdministratorResource struct {
	// Properties of the server AAD administrator.
	Properties *ServerAdministratorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerAdministratorResourceListResult - The response to a list Active Directory Administrators request.
type ServerAdministratorResourceListResult struct {
	// The list of server Active Directory Administrators for the server.
	Value []*ServerAdministratorResource
}

// ServerForCreate - Represents a server to be created.
type ServerForCreate struct {
	// REQUIRED; The location the resource resides in.
	Location *string

	// REQUIRED; Properties of the server.
	Properties ServerPropertiesForCreateClassification

	// The Azure Active Directory identity of the server.
	Identity *ResourceIdentity

	// The SKU (pricing tier) of the server.
	SKU *SKU

	// Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string
}

// ServerKey - A PostgreSQL Server key.
type ServerKey struct {
	// Properties of the ServerKey Resource.
	Properties *ServerKeyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; Kind of encryption protector used to protect the key.
	Kind *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerKeyListResult - A list of PostgreSQL Server keys.
type ServerKeyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; A list of PostgreSQL Server keys.
	Value []*ServerKey
}

// ServerKeyProperties - Properties for a key execution.
type ServerKeyProperties struct {
	// REQUIRED; The key type like 'AzureKeyVault'.
	ServerKeyType *ServerKeyType

	// The URI of the key.
	URI *string

	// READ-ONLY; The key creation date.
	CreationDate *time.Time
}

// ServerListResult - A list of servers.
type ServerListResult struct {
	// The list of servers
	Value []*Server
}

// ServerPrivateEndpointConnection - A private endpoint connection under a server
type ServerPrivateEndpointConnection struct {
	// READ-ONLY; Resource ID of the Private Endpoint Connection.
	ID *string

	// READ-ONLY; Private endpoint connection properties
	Properties *ServerPrivateEndpointConnectionProperties
}

// ServerPrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type ServerPrivateEndpointConnectionProperties struct {
	// Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty

	// Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *ServerPrivateLinkServiceConnectionStateProperty

	// READ-ONLY; State of the private endpoint connection.
	ProvisioningState *PrivateEndpointProvisioningState
}

type ServerPrivateLinkServiceConnectionStateProperty struct {
	// REQUIRED; The private link service connection description.
	Description *string

	// REQUIRED; The private link service connection status.
	Status *PrivateLinkServiceConnectionStateStatus

	// READ-ONLY; The actions required for private link service connection.
	ActionsRequired *PrivateLinkServiceConnectionStateActionsRequire
}

// ServerProperties - The properties of a server.
type ServerProperties struct {
	// The administrator's login name of a server. Can only be specified when the server is being created (and is required for
	// creation).
	AdministratorLogin *string

	// Earliest restore point creation time (ISO8601 format)
	EarliestRestoreDate *time.Time

	// The fully qualified domain name of a server.
	FullyQualifiedDomainName *string

	// Status showing whether the server enabled infrastructure encryption.
	InfrastructureEncryption *InfrastructureEncryption

	// The master server id of a replica server.
	MasterServerID *string

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum

	// The maximum number of replicas that a master server can have.
	ReplicaCapacity *int32

	// The replication role of the server.
	ReplicationRole *string

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum

	// Storage profile of a server.
	StorageProfile *StorageProfile

	// A state of a server that is visible to user.
	UserVisibleState *ServerState

	// Server version.
	Version *ServerVersion

	// READ-ONLY; Status showing whether the server data encryption is enabled with customer-managed keys.
	ByokEnforcement *string

	// READ-ONLY; List of private endpoint connections on a server
	PrivateEndpointConnections []*ServerPrivateEndpointConnection
}

// ServerPropertiesForCreate - The properties used to create a new server.
type ServerPropertiesForCreate struct {
	// REQUIRED; The mode to create a new server.
	CreateMode *CreateMode

	// Status showing whether the server enabled infrastructure encryption.
	InfrastructureEncryption *InfrastructureEncryption

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum

	// Storage profile of a server.
	StorageProfile *StorageProfile

	// Server version.
	Version *ServerVersion
}

// GetServerPropertiesForCreate implements the ServerPropertiesForCreateClassification interface for type ServerPropertiesForCreate.
func (s *ServerPropertiesForCreate) GetServerPropertiesForCreate() *ServerPropertiesForCreate {
	return s
}

// ServerPropertiesForDefaultCreate - The properties used to create a new server.
type ServerPropertiesForDefaultCreate struct {
	// REQUIRED; The administrator's login name of a server. Can only be specified when the server is being created (and is required
	// for creation).
	AdministratorLogin *string

	// REQUIRED; The password of the administrator login.
	AdministratorLoginPassword *string

	// REQUIRED; The mode to create a new server.
	CreateMode *CreateMode

	// Status showing whether the server enabled infrastructure encryption.
	InfrastructureEncryption *InfrastructureEncryption

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum

	// Storage profile of a server.
	StorageProfile *StorageProfile

	// Server version.
	Version *ServerVersion
}

// GetServerPropertiesForCreate implements the ServerPropertiesForCreateClassification interface for type ServerPropertiesForDefaultCreate.
func (s *ServerPropertiesForDefaultCreate) GetServerPropertiesForCreate() *ServerPropertiesForCreate {
	return &ServerPropertiesForCreate{
		CreateMode:               s.CreateMode,
		InfrastructureEncryption: s.InfrastructureEncryption,
		MinimalTLSVersion:        s.MinimalTLSVersion,
		PublicNetworkAccess:      s.PublicNetworkAccess,
		SSLEnforcement:           s.SSLEnforcement,
		StorageProfile:           s.StorageProfile,
		Version:                  s.Version,
	}
}

// ServerPropertiesForGeoRestore - The properties used to create a new server by restoring to a different region from a geo
// replicated backup.
type ServerPropertiesForGeoRestore struct {
	// REQUIRED; The mode to create a new server.
	CreateMode *CreateMode

	// REQUIRED; The source server id to restore from.
	SourceServerID *string

	// Status showing whether the server enabled infrastructure encryption.
	InfrastructureEncryption *InfrastructureEncryption

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum

	// Storage profile of a server.
	StorageProfile *StorageProfile

	// Server version.
	Version *ServerVersion
}

// GetServerPropertiesForCreate implements the ServerPropertiesForCreateClassification interface for type ServerPropertiesForGeoRestore.
func (s *ServerPropertiesForGeoRestore) GetServerPropertiesForCreate() *ServerPropertiesForCreate {
	return &ServerPropertiesForCreate{
		CreateMode:               s.CreateMode,
		InfrastructureEncryption: s.InfrastructureEncryption,
		MinimalTLSVersion:        s.MinimalTLSVersion,
		PublicNetworkAccess:      s.PublicNetworkAccess,
		SSLEnforcement:           s.SSLEnforcement,
		StorageProfile:           s.StorageProfile,
		Version:                  s.Version,
	}
}

// ServerPropertiesForReplica - The properties to create a new replica.
type ServerPropertiesForReplica struct {
	// REQUIRED; The mode to create a new server.
	CreateMode *CreateMode

	// REQUIRED; The master server id to create replica from.
	SourceServerID *string

	// Status showing whether the server enabled infrastructure encryption.
	InfrastructureEncryption *InfrastructureEncryption

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum

	// Storage profile of a server.
	StorageProfile *StorageProfile

	// Server version.
	Version *ServerVersion
}

// GetServerPropertiesForCreate implements the ServerPropertiesForCreateClassification interface for type ServerPropertiesForReplica.
func (s *ServerPropertiesForReplica) GetServerPropertiesForCreate() *ServerPropertiesForCreate {
	return &ServerPropertiesForCreate{
		CreateMode:               s.CreateMode,
		InfrastructureEncryption: s.InfrastructureEncryption,
		MinimalTLSVersion:        s.MinimalTLSVersion,
		PublicNetworkAccess:      s.PublicNetworkAccess,
		SSLEnforcement:           s.SSLEnforcement,
		StorageProfile:           s.StorageProfile,
		Version:                  s.Version,
	}
}

// ServerPropertiesForRestore - The properties used to create a new server by restoring from a backup.
type ServerPropertiesForRestore struct {
	// REQUIRED; The mode to create a new server.
	CreateMode *CreateMode

	// REQUIRED; Restore point creation time (ISO8601 format), specifying the time to restore from.
	RestorePointInTime *time.Time

	// REQUIRED; The source server id to restore from.
	SourceServerID *string

	// Status showing whether the server enabled infrastructure encryption.
	InfrastructureEncryption *InfrastructureEncryption

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum

	// Storage profile of a server.
	StorageProfile *StorageProfile

	// Server version.
	Version *ServerVersion
}

// GetServerPropertiesForCreate implements the ServerPropertiesForCreateClassification interface for type ServerPropertiesForRestore.
func (s *ServerPropertiesForRestore) GetServerPropertiesForCreate() *ServerPropertiesForCreate {
	return &ServerPropertiesForCreate{
		CreateMode:               s.CreateMode,
		InfrastructureEncryption: s.InfrastructureEncryption,
		MinimalTLSVersion:        s.MinimalTLSVersion,
		PublicNetworkAccess:      s.PublicNetworkAccess,
		SSLEnforcement:           s.SSLEnforcement,
		StorageProfile:           s.StorageProfile,
		Version:                  s.Version,
	}
}

// ServerSecurityAlertPolicy - A server security alert policy.
type ServerSecurityAlertPolicy struct {
	// Resource properties.
	Properties *SecurityAlertPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerSecurityAlertPolicyListResult - A list of the server's security alert policies.
type ServerSecurityAlertPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*ServerSecurityAlertPolicy
}

// ServerUpdateParameters - Parameters allowed to update for a server.
type ServerUpdateParameters struct {
	// The Azure Active Directory identity of the server.
	Identity *ResourceIdentity

	// The properties that can be updated for a server.
	Properties *ServerUpdateParametersProperties

	// The SKU (pricing tier) of the server.
	SKU *SKU

	// Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string
}

// ServerUpdateParametersProperties - The properties that can be updated for a server.
type ServerUpdateParametersProperties struct {
	// The password of the administrator login.
	AdministratorLoginPassword *string

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum

	// The replication role of the server.
	ReplicationRole *string

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum

	// Storage profile of a server.
	StorageProfile *StorageProfile

	// The version of a server.
	Version *ServerVersion
}

// StorageProfile - Storage Profile properties of a server
type StorageProfile struct {
	// Backup retention days for the server.
	BackupRetentionDays *int32

	// Enable Geo-redundant or not for server backup.
	GeoRedundantBackup *GeoRedundantBackup

	// Enable Storage Auto Grow.
	StorageAutogrow *StorageAutogrow

	// Max storage allowed for a server.
	StorageMB *int32
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// VirtualNetworkRule - A virtual network rule.
type VirtualNetworkRule struct {
	// Resource properties.
	Properties *VirtualNetworkRuleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// VirtualNetworkRuleListResult - A list of virtual network rules.
type VirtualNetworkRuleListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*VirtualNetworkRule
}

// VirtualNetworkRuleProperties - Properties of a virtual network rule.
type VirtualNetworkRuleProperties struct {
	// REQUIRED; The ARM resource id of the virtual network subnet.
	VirtualNetworkSubnetID *string

	// Create firewall rule before the virtual network has vnet service endpoint enabled.
	IgnoreMissingVnetServiceEndpoint *bool

	// READ-ONLY; Virtual Network Rule State
	State *VirtualNetworkRuleState
}
