//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup/v4"
	"net/http"
	"net/url"
	"regexp"
)

// ResourceGuardProxiesServer is a fake server for instances of the armrecoveryservicesbackup.ResourceGuardProxiesClient type.
type ResourceGuardProxiesServer struct {
	// NewGetPager is the fake for method ResourceGuardProxiesClient.NewGetPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetPager func(vaultName string, resourceGroupName string, options *armrecoveryservicesbackup.ResourceGuardProxiesClientGetOptions) (resp azfake.PagerResponder[armrecoveryservicesbackup.ResourceGuardProxiesClientGetResponse])
}

// NewResourceGuardProxiesServerTransport creates a new instance of ResourceGuardProxiesServerTransport with the provided implementation.
// The returned ResourceGuardProxiesServerTransport instance is connected to an instance of armrecoveryservicesbackup.ResourceGuardProxiesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewResourceGuardProxiesServerTransport(srv *ResourceGuardProxiesServer) *ResourceGuardProxiesServerTransport {
	return &ResourceGuardProxiesServerTransport{
		srv:         srv,
		newGetPager: newTracker[azfake.PagerResponder[armrecoveryservicesbackup.ResourceGuardProxiesClientGetResponse]](),
	}
}

// ResourceGuardProxiesServerTransport connects instances of armrecoveryservicesbackup.ResourceGuardProxiesClient to instances of ResourceGuardProxiesServer.
// Don't use this type directly, use NewResourceGuardProxiesServerTransport instead.
type ResourceGuardProxiesServerTransport struct {
	srv         *ResourceGuardProxiesServer
	newGetPager *tracker[azfake.PagerResponder[armrecoveryservicesbackup.ResourceGuardProxiesClientGetResponse]]
}

// Do implements the policy.Transporter interface for ResourceGuardProxiesServerTransport.
func (r *ResourceGuardProxiesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ResourceGuardProxiesClient.NewGetPager":
		resp, err = r.dispatchNewGetPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ResourceGuardProxiesServerTransport) dispatchNewGetPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewGetPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetPager not implemented")}
	}
	newGetPager := r.newGetPager.get(req)
	if newGetPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupResourceGuardProxies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewGetPager(vaultNameParam, resourceGroupNameParam, nil)
		newGetPager = &resp
		r.newGetPager.add(req, newGetPager)
		server.PagerResponderInjectNextLinks(newGetPager, req, func(page *armrecoveryservicesbackup.ResourceGuardProxiesClientGetResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newGetPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetPager) {
		r.newGetPager.remove(req)
	}
	return resp, nil
}
