//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armchanges

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armchanges"
	moduleVersion = "v1.2.0"
)

// ChangeCategory - The entity that made the change
type ChangeCategory string

const (
	// ChangeCategorySystem - System initiated change
	ChangeCategorySystem ChangeCategory = "System"
	// ChangeCategoryUser - User initiated change
	ChangeCategoryUser ChangeCategory = "User"
)

// PossibleChangeCategoryValues returns the possible values for the ChangeCategory const type.
func PossibleChangeCategoryValues() []ChangeCategory {
	return []ChangeCategory{
		ChangeCategorySystem,
		ChangeCategoryUser,
	}
}

// ChangeType - The type of change that was captured in the resource
type ChangeType string

const (
	// ChangeTypeCreate - A newly created resource
	ChangeTypeCreate ChangeType = "Create"
	// ChangeTypeDelete - An existing resource was deleted
	ChangeTypeDelete ChangeType = "Delete"
	// ChangeTypeUpdate - An existing resource underwent a change
	ChangeTypeUpdate ChangeType = "Update"
)

// PossibleChangeTypeValues returns the possible values for the ChangeType const type.
func PossibleChangeTypeValues() []ChangeType {
	return []ChangeType{
		ChangeTypeCreate,
		ChangeTypeDelete,
		ChangeTypeUpdate,
	}
}

// PropertyChangeType - The type of change that occurred
type PropertyChangeType string

const (
	// PropertyChangeTypeInsert - A property was newly created
	PropertyChangeTypeInsert PropertyChangeType = "Insert"
	// PropertyChangeTypeRemove - An existing property was deleted
	PropertyChangeTypeRemove PropertyChangeType = "Remove"
	// PropertyChangeTypeUpdate - An existing property underwent a change
	PropertyChangeTypeUpdate PropertyChangeType = "Update"
)

// PossiblePropertyChangeTypeValues returns the possible values for the PropertyChangeType const type.
func PossiblePropertyChangeTypeValues() []PropertyChangeType {
	return []PropertyChangeType{
		PropertyChangeTypeInsert,
		PropertyChangeTypeRemove,
		PropertyChangeTypeUpdate,
	}
}
