//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ServerVulnerabilityAssessmentsSettingsClient contains the methods for the ServerVulnerabilityAssessmentsSettings group.
// Don't use this type directly, use NewServerVulnerabilityAssessmentsSettingsClient() instead.
type ServerVulnerabilityAssessmentsSettingsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewServerVulnerabilityAssessmentsSettingsClient creates a new instance of ServerVulnerabilityAssessmentsSettingsClient with the specified values.
//   - subscriptionID - Azure subscription ID
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewServerVulnerabilityAssessmentsSettingsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ServerVulnerabilityAssessmentsSettingsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ServerVulnerabilityAssessmentsSettingsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Create or update a server vulnerability assessments setting of the requested kind on the subscription
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-05-01
//   - settingKind - The kind of the server vulnerability assessments setting
//   - serverVulnerabilityAssessmentsSetting - A server vulnerability assessments setting over a predefined scope
//   - options - ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateOptions contains the optional parameters for the ServerVulnerabilityAssessmentsSettingsClient.CreateOrUpdate
//     method.
func (client *ServerVulnerabilityAssessmentsSettingsClient) CreateOrUpdate(ctx context.Context, settingKind ServerVulnerabilityAssessmentsSettingKindName, serverVulnerabilityAssessmentsSetting ServerVulnerabilityAssessmentsSettingClassification, options *ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateOptions) (ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "ServerVulnerabilityAssessmentsSettingsClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, settingKind, serverVulnerabilityAssessmentsSetting, options)
	if err != nil {
		return ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ServerVulnerabilityAssessmentsSettingsClient) createOrUpdateCreateRequest(ctx context.Context, settingKind ServerVulnerabilityAssessmentsSettingKindName, serverVulnerabilityAssessmentsSetting ServerVulnerabilityAssessmentsSettingClassification, options *ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if settingKind == "" {
		return nil, errors.New("parameter settingKind cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{settingKind}", url.PathEscape(string(settingKind)))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, serverVulnerabilityAssessmentsSetting); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ServerVulnerabilityAssessmentsSettingsClient) createOrUpdateHandleResponse(resp *http.Response) (ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse, error) {
	result := ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result); err != nil {
		return ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Delete the server vulnerability assessments setting of the requested kind from the subscription
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-05-01
//   - settingKind - The kind of the server vulnerability assessments setting
//   - options - ServerVulnerabilityAssessmentsSettingsClientDeleteOptions contains the optional parameters for the ServerVulnerabilityAssessmentsSettingsClient.Delete
//     method.
func (client *ServerVulnerabilityAssessmentsSettingsClient) Delete(ctx context.Context, settingKind ServerVulnerabilityAssessmentsSettingKindName, options *ServerVulnerabilityAssessmentsSettingsClientDeleteOptions) (ServerVulnerabilityAssessmentsSettingsClientDeleteResponse, error) {
	var err error
	const operationName = "ServerVulnerabilityAssessmentsSettingsClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, settingKind, options)
	if err != nil {
		return ServerVulnerabilityAssessmentsSettingsClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ServerVulnerabilityAssessmentsSettingsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ServerVulnerabilityAssessmentsSettingsClientDeleteResponse{}, err
	}
	return ServerVulnerabilityAssessmentsSettingsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ServerVulnerabilityAssessmentsSettingsClient) deleteCreateRequest(ctx context.Context, settingKind ServerVulnerabilityAssessmentsSettingKindName, options *ServerVulnerabilityAssessmentsSettingsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if settingKind == "" {
		return nil, errors.New("parameter settingKind cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{settingKind}", url.PathEscape(string(settingKind)))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a server vulnerability assessments setting of the requested kind, that is set on the subscription
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-05-01
//   - settingKind - The kind of the server vulnerability assessments setting
//   - options - ServerVulnerabilityAssessmentsSettingsClientGetOptions contains the optional parameters for the ServerVulnerabilityAssessmentsSettingsClient.Get
//     method.
func (client *ServerVulnerabilityAssessmentsSettingsClient) Get(ctx context.Context, settingKind ServerVulnerabilityAssessmentsSettingKindName, options *ServerVulnerabilityAssessmentsSettingsClientGetOptions) (ServerVulnerabilityAssessmentsSettingsClientGetResponse, error) {
	var err error
	const operationName = "ServerVulnerabilityAssessmentsSettingsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, settingKind, options)
	if err != nil {
		return ServerVulnerabilityAssessmentsSettingsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ServerVulnerabilityAssessmentsSettingsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ServerVulnerabilityAssessmentsSettingsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ServerVulnerabilityAssessmentsSettingsClient) getCreateRequest(ctx context.Context, settingKind ServerVulnerabilityAssessmentsSettingKindName, options *ServerVulnerabilityAssessmentsSettingsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if settingKind == "" {
		return nil, errors.New("parameter settingKind cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{settingKind}", url.PathEscape(string(settingKind)))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ServerVulnerabilityAssessmentsSettingsClient) getHandleResponse(resp *http.Response) (ServerVulnerabilityAssessmentsSettingsClientGetResponse, error) {
	result := ServerVulnerabilityAssessmentsSettingsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result); err != nil {
		return ServerVulnerabilityAssessmentsSettingsClientGetResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Get a list of all the server vulnerability assessments settings over a subscription level
// scope
//
// Generated from API version 2023-05-01
//   - options - ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionOptions contains the optional parameters for the
//     ServerVulnerabilityAssessmentsSettingsClient.NewListBySubscriptionPager method.
func (client *ServerVulnerabilityAssessmentsSettingsClient) NewListBySubscriptionPager(options *ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionOptions) *runtime.Pager[ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse]{
		More: func(page ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse) (ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ServerVulnerabilityAssessmentsSettingsClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *ServerVulnerabilityAssessmentsSettingsClient) listBySubscriptionCreateRequest(ctx context.Context, options *ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *ServerVulnerabilityAssessmentsSettingsClient) listBySubscriptionHandleResponse(resp *http.Response) (ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse, error) {
	result := ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerVulnerabilityAssessmentsSettingsList); err != nil {
		return ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse{}, err
	}
	return result, nil
}
