//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armservicelinker_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/servicelinker/armservicelinker/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c16ce913afbdaa073e8ca5e480f3b465db2de542/specification/servicelinker/resource-manager/Microsoft.ServiceLinker/preview/2023-04-01-preview/examples/ConfigurationNamesList.json
func ExampleConfigurationNamesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armservicelinker.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewConfigurationNamesClient().NewListPager(&armservicelinker.ConfigurationNamesClientListOptions{Filter: nil,
		SkipToken: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ConfigurationNameResult = armservicelinker.ConfigurationNameResult{
		// 	Value: []*armservicelinker.ConfigurationNameItem{
		// 		{
		// 			Properties: &armservicelinker.ConfigurationNames{
		// 				AuthType: to.Ptr(armservicelinker.AuthTypeSystemAssignedIdentity),
		// 				ClientType: to.Ptr(armservicelinker.ClientTypeNone),
		// 				Names: []*armservicelinker.ConfigurationName{
		// 					{
		// 						Description: to.Ptr("App configuration endpoint"),
		// 						Value: to.Ptr("AZURE_APPCONFIGURATION_ENDPOINT"),
		// 					},
		// 					{
		// 						Description: to.Ptr("The scopes required for the token."),
		// 						Value: to.Ptr("AZURE_APPCONFIGURATION_SCOPE"),
		// 				}},
		// 				TargetService: to.Ptr("MICROSOFT.APPCONFIGURATION/CONFIGURATIONSTORES"),
		// 			},
		// 		},
		// 		{
		// 			Properties: &armservicelinker.ConfigurationNames{
		// 				AuthType: to.Ptr(armservicelinker.AuthTypeUserAssignedIdentity),
		// 				ClientType: to.Ptr(armservicelinker.ClientTypeNone),
		// 				Names: []*armservicelinker.ConfigurationName{
		// 					{
		// 						Description: to.Ptr("App configuration endpoint"),
		// 						Value: to.Ptr("AZURE_APPCONFIGURATION_ENDPOINT"),
		// 					},
		// 					{
		// 						Description: to.Ptr("The client(application) ID of the user identity."),
		// 						Value: to.Ptr("AZURE_APPCONFIGURATION_CLIENTID"),
		// 					},
		// 					{
		// 						Description: to.Ptr("The scopes required for getting token."),
		// 						Value: to.Ptr("AZURE_APPCONFIGURATION_SCOPE"),
		// 				}},
		// 				TargetService: to.Ptr("MICROSOFT.APPCONFIGURATION/CONFIGURATIONSTORES"),
		// 			},
		// 	}},
		// }
	}
}
