//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The subscription ID that identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAgentClient creates a new instance of AgentClient.
func (c *ClientFactory) NewAgentClient() *AgentClient {
	subClient, _ := NewAgentClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBackupShortTermRetentionPoliciesClient creates a new instance of BackupShortTermRetentionPoliciesClient.
func (c *ClientFactory) NewBackupShortTermRetentionPoliciesClient() *BackupShortTermRetentionPoliciesClient {
	subClient, _ := NewBackupShortTermRetentionPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCapabilitiesClient creates a new instance of CapabilitiesClient.
func (c *ClientFactory) NewCapabilitiesClient() *CapabilitiesClient {
	subClient, _ := NewCapabilitiesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataMaskingPoliciesClient creates a new instance of DataMaskingPoliciesClient.
func (c *ClientFactory) NewDataMaskingPoliciesClient() *DataMaskingPoliciesClient {
	subClient, _ := NewDataMaskingPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataMaskingRulesClient creates a new instance of DataMaskingRulesClient.
func (c *ClientFactory) NewDataMaskingRulesClient() *DataMaskingRulesClient {
	subClient, _ := NewDataMaskingRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataWarehouseUserActivitiesClient creates a new instance of DataWarehouseUserActivitiesClient.
func (c *ClientFactory) NewDataWarehouseUserActivitiesClient() *DataWarehouseUserActivitiesClient {
	subClient, _ := NewDataWarehouseUserActivitiesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseAdvancedThreatProtectionSettingsClient creates a new instance of DatabaseAdvancedThreatProtectionSettingsClient.
func (c *ClientFactory) NewDatabaseAdvancedThreatProtectionSettingsClient() *DatabaseAdvancedThreatProtectionSettingsClient {
	subClient, _ := NewDatabaseAdvancedThreatProtectionSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseAdvisorsClient creates a new instance of DatabaseAdvisorsClient.
func (c *ClientFactory) NewDatabaseAdvisorsClient() *DatabaseAdvisorsClient {
	subClient, _ := NewDatabaseAdvisorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseAutomaticTuningClient creates a new instance of DatabaseAutomaticTuningClient.
func (c *ClientFactory) NewDatabaseAutomaticTuningClient() *DatabaseAutomaticTuningClient {
	subClient, _ := NewDatabaseAutomaticTuningClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseBlobAuditingPoliciesClient creates a new instance of DatabaseBlobAuditingPoliciesClient.
func (c *ClientFactory) NewDatabaseBlobAuditingPoliciesClient() *DatabaseBlobAuditingPoliciesClient {
	subClient, _ := NewDatabaseBlobAuditingPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseColumnsClient creates a new instance of DatabaseColumnsClient.
func (c *ClientFactory) NewDatabaseColumnsClient() *DatabaseColumnsClient {
	subClient, _ := NewDatabaseColumnsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseEncryptionProtectorsClient creates a new instance of DatabaseEncryptionProtectorsClient.
func (c *ClientFactory) NewDatabaseEncryptionProtectorsClient() *DatabaseEncryptionProtectorsClient {
	subClient, _ := NewDatabaseEncryptionProtectorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseExtensionsClient creates a new instance of DatabaseExtensionsClient.
func (c *ClientFactory) NewDatabaseExtensionsClient() *DatabaseExtensionsClient {
	subClient, _ := NewDatabaseExtensionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseOperationsClient creates a new instance of DatabaseOperationsClient.
func (c *ClientFactory) NewDatabaseOperationsClient() *DatabaseOperationsClient {
	subClient, _ := NewDatabaseOperationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseRecommendedActionsClient creates a new instance of DatabaseRecommendedActionsClient.
func (c *ClientFactory) NewDatabaseRecommendedActionsClient() *DatabaseRecommendedActionsClient {
	subClient, _ := NewDatabaseRecommendedActionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseSQLVulnerabilityAssessmentBaselinesClient creates a new instance of DatabaseSQLVulnerabilityAssessmentBaselinesClient.
func (c *ClientFactory) NewDatabaseSQLVulnerabilityAssessmentBaselinesClient() *DatabaseSQLVulnerabilityAssessmentBaselinesClient {
	subClient, _ := NewDatabaseSQLVulnerabilityAssessmentBaselinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseSQLVulnerabilityAssessmentExecuteScanClient creates a new instance of DatabaseSQLVulnerabilityAssessmentExecuteScanClient.
func (c *ClientFactory) NewDatabaseSQLVulnerabilityAssessmentExecuteScanClient() *DatabaseSQLVulnerabilityAssessmentExecuteScanClient {
	subClient, _ := NewDatabaseSQLVulnerabilityAssessmentExecuteScanClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient creates a new instance of DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.
func (c *ClientFactory) NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient() *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient {
	subClient, _ := NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseSQLVulnerabilityAssessmentScanResultClient creates a new instance of DatabaseSQLVulnerabilityAssessmentScanResultClient.
func (c *ClientFactory) NewDatabaseSQLVulnerabilityAssessmentScanResultClient() *DatabaseSQLVulnerabilityAssessmentScanResultClient {
	subClient, _ := NewDatabaseSQLVulnerabilityAssessmentScanResultClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseSQLVulnerabilityAssessmentScansClient creates a new instance of DatabaseSQLVulnerabilityAssessmentScansClient.
func (c *ClientFactory) NewDatabaseSQLVulnerabilityAssessmentScansClient() *DatabaseSQLVulnerabilityAssessmentScansClient {
	subClient, _ := NewDatabaseSQLVulnerabilityAssessmentScansClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseSQLVulnerabilityAssessmentsSettingsClient creates a new instance of DatabaseSQLVulnerabilityAssessmentsSettingsClient.
func (c *ClientFactory) NewDatabaseSQLVulnerabilityAssessmentsSettingsClient() *DatabaseSQLVulnerabilityAssessmentsSettingsClient {
	subClient, _ := NewDatabaseSQLVulnerabilityAssessmentsSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseSchemasClient creates a new instance of DatabaseSchemasClient.
func (c *ClientFactory) NewDatabaseSchemasClient() *DatabaseSchemasClient {
	subClient, _ := NewDatabaseSchemasClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseSecurityAlertPoliciesClient creates a new instance of DatabaseSecurityAlertPoliciesClient.
func (c *ClientFactory) NewDatabaseSecurityAlertPoliciesClient() *DatabaseSecurityAlertPoliciesClient {
	subClient, _ := NewDatabaseSecurityAlertPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseTablesClient creates a new instance of DatabaseTablesClient.
func (c *ClientFactory) NewDatabaseTablesClient() *DatabaseTablesClient {
	subClient, _ := NewDatabaseTablesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseUsagesClient creates a new instance of DatabaseUsagesClient.
func (c *ClientFactory) NewDatabaseUsagesClient() *DatabaseUsagesClient {
	subClient, _ := NewDatabaseUsagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseVulnerabilityAssessmentRuleBaselinesClient creates a new instance of DatabaseVulnerabilityAssessmentRuleBaselinesClient.
func (c *ClientFactory) NewDatabaseVulnerabilityAssessmentRuleBaselinesClient() *DatabaseVulnerabilityAssessmentRuleBaselinesClient {
	subClient, _ := NewDatabaseVulnerabilityAssessmentRuleBaselinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseVulnerabilityAssessmentScansClient creates a new instance of DatabaseVulnerabilityAssessmentScansClient.
func (c *ClientFactory) NewDatabaseVulnerabilityAssessmentScansClient() *DatabaseVulnerabilityAssessmentScansClient {
	subClient, _ := NewDatabaseVulnerabilityAssessmentScansClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseVulnerabilityAssessmentsClient creates a new instance of DatabaseVulnerabilityAssessmentsClient.
func (c *ClientFactory) NewDatabaseVulnerabilityAssessmentsClient() *DatabaseVulnerabilityAssessmentsClient {
	subClient, _ := NewDatabaseVulnerabilityAssessmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabasesClient creates a new instance of DatabasesClient.
func (c *ClientFactory) NewDatabasesClient() *DatabasesClient {
	subClient, _ := NewDatabasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDeletedServersClient creates a new instance of DeletedServersClient.
func (c *ClientFactory) NewDeletedServersClient() *DeletedServersClient {
	subClient, _ := NewDeletedServersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDistributedAvailabilityGroupsClient creates a new instance of DistributedAvailabilityGroupsClient.
func (c *ClientFactory) NewDistributedAvailabilityGroupsClient() *DistributedAvailabilityGroupsClient {
	subClient, _ := NewDistributedAvailabilityGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewElasticPoolActivitiesClient creates a new instance of ElasticPoolActivitiesClient.
func (c *ClientFactory) NewElasticPoolActivitiesClient() *ElasticPoolActivitiesClient {
	subClient, _ := NewElasticPoolActivitiesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewElasticPoolDatabaseActivitiesClient creates a new instance of ElasticPoolDatabaseActivitiesClient.
func (c *ClientFactory) NewElasticPoolDatabaseActivitiesClient() *ElasticPoolDatabaseActivitiesClient {
	subClient, _ := NewElasticPoolDatabaseActivitiesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewElasticPoolOperationsClient creates a new instance of ElasticPoolOperationsClient.
func (c *ClientFactory) NewElasticPoolOperationsClient() *ElasticPoolOperationsClient {
	subClient, _ := NewElasticPoolOperationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewElasticPoolsClient creates a new instance of ElasticPoolsClient.
func (c *ClientFactory) NewElasticPoolsClient() *ElasticPoolsClient {
	subClient, _ := NewElasticPoolsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewEncryptionProtectorsClient creates a new instance of EncryptionProtectorsClient.
func (c *ClientFactory) NewEncryptionProtectorsClient() *EncryptionProtectorsClient {
	subClient, _ := NewEncryptionProtectorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewEndpointCertificatesClient creates a new instance of EndpointCertificatesClient.
func (c *ClientFactory) NewEndpointCertificatesClient() *EndpointCertificatesClient {
	subClient, _ := NewEndpointCertificatesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewExtendedDatabaseBlobAuditingPoliciesClient creates a new instance of ExtendedDatabaseBlobAuditingPoliciesClient.
func (c *ClientFactory) NewExtendedDatabaseBlobAuditingPoliciesClient() *ExtendedDatabaseBlobAuditingPoliciesClient {
	subClient, _ := NewExtendedDatabaseBlobAuditingPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewExtendedServerBlobAuditingPoliciesClient creates a new instance of ExtendedServerBlobAuditingPoliciesClient.
func (c *ClientFactory) NewExtendedServerBlobAuditingPoliciesClient() *ExtendedServerBlobAuditingPoliciesClient {
	subClient, _ := NewExtendedServerBlobAuditingPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFailoverGroupsClient creates a new instance of FailoverGroupsClient.
func (c *ClientFactory) NewFailoverGroupsClient() *FailoverGroupsClient {
	subClient, _ := NewFailoverGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFirewallRulesClient creates a new instance of FirewallRulesClient.
func (c *ClientFactory) NewFirewallRulesClient() *FirewallRulesClient {
	subClient, _ := NewFirewallRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGeoBackupPoliciesClient creates a new instance of GeoBackupPoliciesClient.
func (c *ClientFactory) NewGeoBackupPoliciesClient() *GeoBackupPoliciesClient {
	subClient, _ := NewGeoBackupPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIPv6FirewallRulesClient creates a new instance of IPv6FirewallRulesClient.
func (c *ClientFactory) NewIPv6FirewallRulesClient() *IPv6FirewallRulesClient {
	subClient, _ := NewIPv6FirewallRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewInstanceFailoverGroupsClient creates a new instance of InstanceFailoverGroupsClient.
func (c *ClientFactory) NewInstanceFailoverGroupsClient() *InstanceFailoverGroupsClient {
	subClient, _ := NewInstanceFailoverGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewInstancePoolsClient creates a new instance of InstancePoolsClient.
func (c *ClientFactory) NewInstancePoolsClient() *InstancePoolsClient {
	subClient, _ := NewInstancePoolsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobAgentsClient creates a new instance of JobAgentsClient.
func (c *ClientFactory) NewJobAgentsClient() *JobAgentsClient {
	subClient, _ := NewJobAgentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobCredentialsClient creates a new instance of JobCredentialsClient.
func (c *ClientFactory) NewJobCredentialsClient() *JobCredentialsClient {
	subClient, _ := NewJobCredentialsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobExecutionsClient creates a new instance of JobExecutionsClient.
func (c *ClientFactory) NewJobExecutionsClient() *JobExecutionsClient {
	subClient, _ := NewJobExecutionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobPrivateEndpointsClient creates a new instance of JobPrivateEndpointsClient.
func (c *ClientFactory) NewJobPrivateEndpointsClient() *JobPrivateEndpointsClient {
	subClient, _ := NewJobPrivateEndpointsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobStepExecutionsClient creates a new instance of JobStepExecutionsClient.
func (c *ClientFactory) NewJobStepExecutionsClient() *JobStepExecutionsClient {
	subClient, _ := NewJobStepExecutionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobStepsClient creates a new instance of JobStepsClient.
func (c *ClientFactory) NewJobStepsClient() *JobStepsClient {
	subClient, _ := NewJobStepsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobTargetExecutionsClient creates a new instance of JobTargetExecutionsClient.
func (c *ClientFactory) NewJobTargetExecutionsClient() *JobTargetExecutionsClient {
	subClient, _ := NewJobTargetExecutionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobTargetGroupsClient creates a new instance of JobTargetGroupsClient.
func (c *ClientFactory) NewJobTargetGroupsClient() *JobTargetGroupsClient {
	subClient, _ := NewJobTargetGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobVersionsClient creates a new instance of JobVersionsClient.
func (c *ClientFactory) NewJobVersionsClient() *JobVersionsClient {
	subClient, _ := NewJobVersionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobsClient creates a new instance of JobsClient.
func (c *ClientFactory) NewJobsClient() *JobsClient {
	subClient, _ := NewJobsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLedgerDigestUploadsClient creates a new instance of LedgerDigestUploadsClient.
func (c *ClientFactory) NewLedgerDigestUploadsClient() *LedgerDigestUploadsClient {
	subClient, _ := NewLedgerDigestUploadsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLongTermRetentionBackupsClient creates a new instance of LongTermRetentionBackupsClient.
func (c *ClientFactory) NewLongTermRetentionBackupsClient() *LongTermRetentionBackupsClient {
	subClient, _ := NewLongTermRetentionBackupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLongTermRetentionManagedInstanceBackupsClient creates a new instance of LongTermRetentionManagedInstanceBackupsClient.
func (c *ClientFactory) NewLongTermRetentionManagedInstanceBackupsClient() *LongTermRetentionManagedInstanceBackupsClient {
	subClient, _ := NewLongTermRetentionManagedInstanceBackupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLongTermRetentionPoliciesClient creates a new instance of LongTermRetentionPoliciesClient.
func (c *ClientFactory) NewLongTermRetentionPoliciesClient() *LongTermRetentionPoliciesClient {
	subClient, _ := NewLongTermRetentionPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMaintenanceWindowOptionsClient creates a new instance of MaintenanceWindowOptionsClient.
func (c *ClientFactory) NewMaintenanceWindowOptionsClient() *MaintenanceWindowOptionsClient {
	subClient, _ := NewMaintenanceWindowOptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMaintenanceWindowsClient creates a new instance of MaintenanceWindowsClient.
func (c *ClientFactory) NewMaintenanceWindowsClient() *MaintenanceWindowsClient {
	subClient, _ := NewMaintenanceWindowsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedBackupShortTermRetentionPoliciesClient creates a new instance of ManagedBackupShortTermRetentionPoliciesClient.
func (c *ClientFactory) NewManagedBackupShortTermRetentionPoliciesClient() *ManagedBackupShortTermRetentionPoliciesClient {
	subClient, _ := NewManagedBackupShortTermRetentionPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseAdvancedThreatProtectionSettingsClient creates a new instance of ManagedDatabaseAdvancedThreatProtectionSettingsClient.
func (c *ClientFactory) NewManagedDatabaseAdvancedThreatProtectionSettingsClient() *ManagedDatabaseAdvancedThreatProtectionSettingsClient {
	subClient, _ := NewManagedDatabaseAdvancedThreatProtectionSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseColumnsClient creates a new instance of ManagedDatabaseColumnsClient.
func (c *ClientFactory) NewManagedDatabaseColumnsClient() *ManagedDatabaseColumnsClient {
	subClient, _ := NewManagedDatabaseColumnsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseMoveOperationsClient creates a new instance of ManagedDatabaseMoveOperationsClient.
func (c *ClientFactory) NewManagedDatabaseMoveOperationsClient() *ManagedDatabaseMoveOperationsClient {
	subClient, _ := NewManagedDatabaseMoveOperationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseQueriesClient creates a new instance of ManagedDatabaseQueriesClient.
func (c *ClientFactory) NewManagedDatabaseQueriesClient() *ManagedDatabaseQueriesClient {
	subClient, _ := NewManagedDatabaseQueriesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseRecommendedSensitivityLabelsClient creates a new instance of ManagedDatabaseRecommendedSensitivityLabelsClient.
func (c *ClientFactory) NewManagedDatabaseRecommendedSensitivityLabelsClient() *ManagedDatabaseRecommendedSensitivityLabelsClient {
	subClient, _ := NewManagedDatabaseRecommendedSensitivityLabelsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseRestoreDetailsClient creates a new instance of ManagedDatabaseRestoreDetailsClient.
func (c *ClientFactory) NewManagedDatabaseRestoreDetailsClient() *ManagedDatabaseRestoreDetailsClient {
	subClient, _ := NewManagedDatabaseRestoreDetailsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseSchemasClient creates a new instance of ManagedDatabaseSchemasClient.
func (c *ClientFactory) NewManagedDatabaseSchemasClient() *ManagedDatabaseSchemasClient {
	subClient, _ := NewManagedDatabaseSchemasClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseSecurityAlertPoliciesClient creates a new instance of ManagedDatabaseSecurityAlertPoliciesClient.
func (c *ClientFactory) NewManagedDatabaseSecurityAlertPoliciesClient() *ManagedDatabaseSecurityAlertPoliciesClient {
	subClient, _ := NewManagedDatabaseSecurityAlertPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseSecurityEventsClient creates a new instance of ManagedDatabaseSecurityEventsClient.
func (c *ClientFactory) NewManagedDatabaseSecurityEventsClient() *ManagedDatabaseSecurityEventsClient {
	subClient, _ := NewManagedDatabaseSecurityEventsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseSensitivityLabelsClient creates a new instance of ManagedDatabaseSensitivityLabelsClient.
func (c *ClientFactory) NewManagedDatabaseSensitivityLabelsClient() *ManagedDatabaseSensitivityLabelsClient {
	subClient, _ := NewManagedDatabaseSensitivityLabelsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseTablesClient creates a new instance of ManagedDatabaseTablesClient.
func (c *ClientFactory) NewManagedDatabaseTablesClient() *ManagedDatabaseTablesClient {
	subClient, _ := NewManagedDatabaseTablesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseTransparentDataEncryptionClient creates a new instance of ManagedDatabaseTransparentDataEncryptionClient.
func (c *ClientFactory) NewManagedDatabaseTransparentDataEncryptionClient() *ManagedDatabaseTransparentDataEncryptionClient {
	subClient, _ := NewManagedDatabaseTransparentDataEncryptionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient creates a new instance of ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.
func (c *ClientFactory) NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient() *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient {
	subClient, _ := NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseVulnerabilityAssessmentScansClient creates a new instance of ManagedDatabaseVulnerabilityAssessmentScansClient.
func (c *ClientFactory) NewManagedDatabaseVulnerabilityAssessmentScansClient() *ManagedDatabaseVulnerabilityAssessmentScansClient {
	subClient, _ := NewManagedDatabaseVulnerabilityAssessmentScansClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabaseVulnerabilityAssessmentsClient creates a new instance of ManagedDatabaseVulnerabilityAssessmentsClient.
func (c *ClientFactory) NewManagedDatabaseVulnerabilityAssessmentsClient() *ManagedDatabaseVulnerabilityAssessmentsClient {
	subClient, _ := NewManagedDatabaseVulnerabilityAssessmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedDatabasesClient creates a new instance of ManagedDatabasesClient.
func (c *ClientFactory) NewManagedDatabasesClient() *ManagedDatabasesClient {
	subClient, _ := NewManagedDatabasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedInstanceAdministratorsClient creates a new instance of ManagedInstanceAdministratorsClient.
func (c *ClientFactory) NewManagedInstanceAdministratorsClient() *ManagedInstanceAdministratorsClient {
	subClient, _ := NewManagedInstanceAdministratorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedInstanceAdvancedThreatProtectionSettingsClient creates a new instance of ManagedInstanceAdvancedThreatProtectionSettingsClient.
func (c *ClientFactory) NewManagedInstanceAdvancedThreatProtectionSettingsClient() *ManagedInstanceAdvancedThreatProtectionSettingsClient {
	subClient, _ := NewManagedInstanceAdvancedThreatProtectionSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedInstanceAzureADOnlyAuthenticationsClient creates a new instance of ManagedInstanceAzureADOnlyAuthenticationsClient.
func (c *ClientFactory) NewManagedInstanceAzureADOnlyAuthenticationsClient() *ManagedInstanceAzureADOnlyAuthenticationsClient {
	subClient, _ := NewManagedInstanceAzureADOnlyAuthenticationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedInstanceDtcsClient creates a new instance of ManagedInstanceDtcsClient.
func (c *ClientFactory) NewManagedInstanceDtcsClient() *ManagedInstanceDtcsClient {
	subClient, _ := NewManagedInstanceDtcsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedInstanceEncryptionProtectorsClient creates a new instance of ManagedInstanceEncryptionProtectorsClient.
func (c *ClientFactory) NewManagedInstanceEncryptionProtectorsClient() *ManagedInstanceEncryptionProtectorsClient {
	subClient, _ := NewManagedInstanceEncryptionProtectorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedInstanceKeysClient creates a new instance of ManagedInstanceKeysClient.
func (c *ClientFactory) NewManagedInstanceKeysClient() *ManagedInstanceKeysClient {
	subClient, _ := NewManagedInstanceKeysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedInstanceLongTermRetentionPoliciesClient creates a new instance of ManagedInstanceLongTermRetentionPoliciesClient.
func (c *ClientFactory) NewManagedInstanceLongTermRetentionPoliciesClient() *ManagedInstanceLongTermRetentionPoliciesClient {
	subClient, _ := NewManagedInstanceLongTermRetentionPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedInstanceOperationsClient creates a new instance of ManagedInstanceOperationsClient.
func (c *ClientFactory) NewManagedInstanceOperationsClient() *ManagedInstanceOperationsClient {
	subClient, _ := NewManagedInstanceOperationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedInstancePrivateEndpointConnectionsClient creates a new instance of ManagedInstancePrivateEndpointConnectionsClient.
func (c *ClientFactory) NewManagedInstancePrivateEndpointConnectionsClient() *ManagedInstancePrivateEndpointConnectionsClient {
	subClient, _ := NewManagedInstancePrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedInstancePrivateLinkResourcesClient creates a new instance of ManagedInstancePrivateLinkResourcesClient.
func (c *ClientFactory) NewManagedInstancePrivateLinkResourcesClient() *ManagedInstancePrivateLinkResourcesClient {
	subClient, _ := NewManagedInstancePrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedInstanceTdeCertificatesClient creates a new instance of ManagedInstanceTdeCertificatesClient.
func (c *ClientFactory) NewManagedInstanceTdeCertificatesClient() *ManagedInstanceTdeCertificatesClient {
	subClient, _ := NewManagedInstanceTdeCertificatesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedInstanceVulnerabilityAssessmentsClient creates a new instance of ManagedInstanceVulnerabilityAssessmentsClient.
func (c *ClientFactory) NewManagedInstanceVulnerabilityAssessmentsClient() *ManagedInstanceVulnerabilityAssessmentsClient {
	subClient, _ := NewManagedInstanceVulnerabilityAssessmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedInstancesClient creates a new instance of ManagedInstancesClient.
func (c *ClientFactory) NewManagedInstancesClient() *ManagedInstancesClient {
	subClient, _ := NewManagedInstancesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedLedgerDigestUploadsClient creates a new instance of ManagedLedgerDigestUploadsClient.
func (c *ClientFactory) NewManagedLedgerDigestUploadsClient() *ManagedLedgerDigestUploadsClient {
	subClient, _ := NewManagedLedgerDigestUploadsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient creates a new instance of ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.
func (c *ClientFactory) NewManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient() *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient {
	subClient, _ := NewManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedServerDNSAliasesClient creates a new instance of ManagedServerDNSAliasesClient.
func (c *ClientFactory) NewManagedServerDNSAliasesClient() *ManagedServerDNSAliasesClient {
	subClient, _ := NewManagedServerDNSAliasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedServerSecurityAlertPoliciesClient creates a new instance of ManagedServerSecurityAlertPoliciesClient.
func (c *ClientFactory) NewManagedServerSecurityAlertPoliciesClient() *ManagedServerSecurityAlertPoliciesClient {
	subClient, _ := NewManagedServerSecurityAlertPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewOutboundFirewallRulesClient creates a new instance of OutboundFirewallRulesClient.
func (c *ClientFactory) NewOutboundFirewallRulesClient() *OutboundFirewallRulesClient {
	subClient, _ := NewOutboundFirewallRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRecommendedSensitivityLabelsClient creates a new instance of RecommendedSensitivityLabelsClient.
func (c *ClientFactory) NewRecommendedSensitivityLabelsClient() *RecommendedSensitivityLabelsClient {
	subClient, _ := NewRecommendedSensitivityLabelsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRecoverableDatabasesClient creates a new instance of RecoverableDatabasesClient.
func (c *ClientFactory) NewRecoverableDatabasesClient() *RecoverableDatabasesClient {
	subClient, _ := NewRecoverableDatabasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRecoverableManagedDatabasesClient creates a new instance of RecoverableManagedDatabasesClient.
func (c *ClientFactory) NewRecoverableManagedDatabasesClient() *RecoverableManagedDatabasesClient {
	subClient, _ := NewRecoverableManagedDatabasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewReplicationLinksClient creates a new instance of ReplicationLinksClient.
func (c *ClientFactory) NewReplicationLinksClient() *ReplicationLinksClient {
	subClient, _ := NewReplicationLinksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableDroppedDatabasesClient creates a new instance of RestorableDroppedDatabasesClient.
func (c *ClientFactory) NewRestorableDroppedDatabasesClient() *RestorableDroppedDatabasesClient {
	subClient, _ := NewRestorableDroppedDatabasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableDroppedManagedDatabasesClient creates a new instance of RestorableDroppedManagedDatabasesClient.
func (c *ClientFactory) NewRestorableDroppedManagedDatabasesClient() *RestorableDroppedManagedDatabasesClient {
	subClient, _ := NewRestorableDroppedManagedDatabasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorePointsClient creates a new instance of RestorePointsClient.
func (c *ClientFactory) NewRestorePointsClient() *RestorePointsClient {
	subClient, _ := NewRestorePointsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSensitivityLabelsClient creates a new instance of SensitivityLabelsClient.
func (c *ClientFactory) NewSensitivityLabelsClient() *SensitivityLabelsClient {
	subClient, _ := NewSensitivityLabelsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerAdvancedThreatProtectionSettingsClient creates a new instance of ServerAdvancedThreatProtectionSettingsClient.
func (c *ClientFactory) NewServerAdvancedThreatProtectionSettingsClient() *ServerAdvancedThreatProtectionSettingsClient {
	subClient, _ := NewServerAdvancedThreatProtectionSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerAdvisorsClient creates a new instance of ServerAdvisorsClient.
func (c *ClientFactory) NewServerAdvisorsClient() *ServerAdvisorsClient {
	subClient, _ := NewServerAdvisorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerAutomaticTuningClient creates a new instance of ServerAutomaticTuningClient.
func (c *ClientFactory) NewServerAutomaticTuningClient() *ServerAutomaticTuningClient {
	subClient, _ := NewServerAutomaticTuningClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerAzureADAdministratorsClient creates a new instance of ServerAzureADAdministratorsClient.
func (c *ClientFactory) NewServerAzureADAdministratorsClient() *ServerAzureADAdministratorsClient {
	subClient, _ := NewServerAzureADAdministratorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerAzureADOnlyAuthenticationsClient creates a new instance of ServerAzureADOnlyAuthenticationsClient.
func (c *ClientFactory) NewServerAzureADOnlyAuthenticationsClient() *ServerAzureADOnlyAuthenticationsClient {
	subClient, _ := NewServerAzureADOnlyAuthenticationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerBlobAuditingPoliciesClient creates a new instance of ServerBlobAuditingPoliciesClient.
func (c *ClientFactory) NewServerBlobAuditingPoliciesClient() *ServerBlobAuditingPoliciesClient {
	subClient, _ := NewServerBlobAuditingPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerCommunicationLinksClient creates a new instance of ServerCommunicationLinksClient.
func (c *ClientFactory) NewServerCommunicationLinksClient() *ServerCommunicationLinksClient {
	subClient, _ := NewServerCommunicationLinksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerConfigurationOptionsClient creates a new instance of ServerConfigurationOptionsClient.
func (c *ClientFactory) NewServerConfigurationOptionsClient() *ServerConfigurationOptionsClient {
	subClient, _ := NewServerConfigurationOptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerConnectionPoliciesClient creates a new instance of ServerConnectionPoliciesClient.
func (c *ClientFactory) NewServerConnectionPoliciesClient() *ServerConnectionPoliciesClient {
	subClient, _ := NewServerConnectionPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerDNSAliasesClient creates a new instance of ServerDNSAliasesClient.
func (c *ClientFactory) NewServerDNSAliasesClient() *ServerDNSAliasesClient {
	subClient, _ := NewServerDNSAliasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerDevOpsAuditSettingsClient creates a new instance of ServerDevOpsAuditSettingsClient.
func (c *ClientFactory) NewServerDevOpsAuditSettingsClient() *ServerDevOpsAuditSettingsClient {
	subClient, _ := NewServerDevOpsAuditSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerKeysClient creates a new instance of ServerKeysClient.
func (c *ClientFactory) NewServerKeysClient() *ServerKeysClient {
	subClient, _ := NewServerKeysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerOperationsClient creates a new instance of ServerOperationsClient.
func (c *ClientFactory) NewServerOperationsClient() *ServerOperationsClient {
	subClient, _ := NewServerOperationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerSecurityAlertPoliciesClient creates a new instance of ServerSecurityAlertPoliciesClient.
func (c *ClientFactory) NewServerSecurityAlertPoliciesClient() *ServerSecurityAlertPoliciesClient {
	subClient, _ := NewServerSecurityAlertPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerTrustCertificatesClient creates a new instance of ServerTrustCertificatesClient.
func (c *ClientFactory) NewServerTrustCertificatesClient() *ServerTrustCertificatesClient {
	subClient, _ := NewServerTrustCertificatesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerTrustGroupsClient creates a new instance of ServerTrustGroupsClient.
func (c *ClientFactory) NewServerTrustGroupsClient() *ServerTrustGroupsClient {
	subClient, _ := NewServerTrustGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerUsagesClient creates a new instance of ServerUsagesClient.
func (c *ClientFactory) NewServerUsagesClient() *ServerUsagesClient {
	subClient, _ := NewServerUsagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerVulnerabilityAssessmentsClient creates a new instance of ServerVulnerabilityAssessmentsClient.
func (c *ClientFactory) NewServerVulnerabilityAssessmentsClient() *ServerVulnerabilityAssessmentsClient {
	subClient, _ := NewServerVulnerabilityAssessmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServersClient creates a new instance of ServersClient.
func (c *ClientFactory) NewServersClient() *ServersClient {
	subClient, _ := NewServersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServiceObjectivesClient creates a new instance of ServiceObjectivesClient.
func (c *ClientFactory) NewServiceObjectivesClient() *ServiceObjectivesClient {
	subClient, _ := NewServiceObjectivesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewStartStopManagedInstanceSchedulesClient creates a new instance of StartStopManagedInstanceSchedulesClient.
func (c *ClientFactory) NewStartStopManagedInstanceSchedulesClient() *StartStopManagedInstanceSchedulesClient {
	subClient, _ := NewStartStopManagedInstanceSchedulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSubscriptionUsagesClient creates a new instance of SubscriptionUsagesClient.
func (c *ClientFactory) NewSubscriptionUsagesClient() *SubscriptionUsagesClient {
	subClient, _ := NewSubscriptionUsagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSynapseLinkWorkspacesClient creates a new instance of SynapseLinkWorkspacesClient.
func (c *ClientFactory) NewSynapseLinkWorkspacesClient() *SynapseLinkWorkspacesClient {
	subClient, _ := NewSynapseLinkWorkspacesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSyncAgentsClient creates a new instance of SyncAgentsClient.
func (c *ClientFactory) NewSyncAgentsClient() *SyncAgentsClient {
	subClient, _ := NewSyncAgentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSyncGroupsClient creates a new instance of SyncGroupsClient.
func (c *ClientFactory) NewSyncGroupsClient() *SyncGroupsClient {
	subClient, _ := NewSyncGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSyncMembersClient creates a new instance of SyncMembersClient.
func (c *ClientFactory) NewSyncMembersClient() *SyncMembersClient {
	subClient, _ := NewSyncMembersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTdeCertificatesClient creates a new instance of TdeCertificatesClient.
func (c *ClientFactory) NewTdeCertificatesClient() *TdeCertificatesClient {
	subClient, _ := NewTdeCertificatesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTimeZonesClient creates a new instance of TimeZonesClient.
func (c *ClientFactory) NewTimeZonesClient() *TimeZonesClient {
	subClient, _ := NewTimeZonesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTransparentDataEncryptionsClient creates a new instance of TransparentDataEncryptionsClient.
func (c *ClientFactory) NewTransparentDataEncryptionsClient() *TransparentDataEncryptionsClient {
	subClient, _ := NewTransparentDataEncryptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewUsagesClient creates a new instance of UsagesClient.
func (c *ClientFactory) NewUsagesClient() *UsagesClient {
	subClient, _ := NewUsagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualClustersClient creates a new instance of VirtualClustersClient.
func (c *ClientFactory) NewVirtualClustersClient() *VirtualClustersClient {
	subClient, _ := NewVirtualClustersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualNetworkRulesClient creates a new instance of VirtualNetworkRulesClient.
func (c *ClientFactory) NewVirtualNetworkRulesClient() *VirtualNetworkRulesClient {
	subClient, _ := NewVirtualNetworkRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVulnerabilityAssessmentBaselineClient creates a new instance of VulnerabilityAssessmentBaselineClient.
func (c *ClientFactory) NewVulnerabilityAssessmentBaselineClient() *VulnerabilityAssessmentBaselineClient {
	subClient, _ := NewVulnerabilityAssessmentBaselineClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVulnerabilityAssessmentBaselinesClient creates a new instance of VulnerabilityAssessmentBaselinesClient.
func (c *ClientFactory) NewVulnerabilityAssessmentBaselinesClient() *VulnerabilityAssessmentBaselinesClient {
	subClient, _ := NewVulnerabilityAssessmentBaselinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVulnerabilityAssessmentExecuteScanClient creates a new instance of VulnerabilityAssessmentExecuteScanClient.
func (c *ClientFactory) NewVulnerabilityAssessmentExecuteScanClient() *VulnerabilityAssessmentExecuteScanClient {
	subClient, _ := NewVulnerabilityAssessmentExecuteScanClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVulnerabilityAssessmentRuleBaselineClient creates a new instance of VulnerabilityAssessmentRuleBaselineClient.
func (c *ClientFactory) NewVulnerabilityAssessmentRuleBaselineClient() *VulnerabilityAssessmentRuleBaselineClient {
	subClient, _ := NewVulnerabilityAssessmentRuleBaselineClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVulnerabilityAssessmentRuleBaselinesClient creates a new instance of VulnerabilityAssessmentRuleBaselinesClient.
func (c *ClientFactory) NewVulnerabilityAssessmentRuleBaselinesClient() *VulnerabilityAssessmentRuleBaselinesClient {
	subClient, _ := NewVulnerabilityAssessmentRuleBaselinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVulnerabilityAssessmentScanResultClient creates a new instance of VulnerabilityAssessmentScanResultClient.
func (c *ClientFactory) NewVulnerabilityAssessmentScanResultClient() *VulnerabilityAssessmentScanResultClient {
	subClient, _ := NewVulnerabilityAssessmentScanResultClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVulnerabilityAssessmentScansClient creates a new instance of VulnerabilityAssessmentScansClient.
func (c *ClientFactory) NewVulnerabilityAssessmentScansClient() *VulnerabilityAssessmentScansClient {
	subClient, _ := NewVulnerabilityAssessmentScansClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVulnerabilityAssessmentsClient creates a new instance of VulnerabilityAssessmentsClient.
func (c *ClientFactory) NewVulnerabilityAssessmentsClient() *VulnerabilityAssessmentsClient {
	subClient, _ := NewVulnerabilityAssessmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVulnerabilityAssessmentsSettingsClient creates a new instance of VulnerabilityAssessmentsSettingsClient.
func (c *ClientFactory) NewVulnerabilityAssessmentsSettingsClient() *VulnerabilityAssessmentsSettingsClient {
	subClient, _ := NewVulnerabilityAssessmentsSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkloadClassifiersClient creates a new instance of WorkloadClassifiersClient.
func (c *ClientFactory) NewWorkloadClassifiersClient() *WorkloadClassifiersClient {
	subClient, _ := NewWorkloadClassifiersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkloadGroupsClient creates a new instance of WorkloadGroupsClient.
func (c *ClientFactory) NewWorkloadGroupsClient() *WorkloadGroupsClient {
	subClient, _ := NewWorkloadGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
