//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// RecoverableManagedDatabasesServer is a fake server for instances of the armsql.RecoverableManagedDatabasesClient type.
type RecoverableManagedDatabasesServer struct {
	// Get is the fake for method RecoverableManagedDatabasesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, managedInstanceName string, recoverableDatabaseName string, options *armsql.RecoverableManagedDatabasesClientGetOptions) (resp azfake.Responder[armsql.RecoverableManagedDatabasesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByInstancePager is the fake for method RecoverableManagedDatabasesClient.NewListByInstancePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByInstancePager func(resourceGroupName string, managedInstanceName string, options *armsql.RecoverableManagedDatabasesClientListByInstanceOptions) (resp azfake.PagerResponder[armsql.RecoverableManagedDatabasesClientListByInstanceResponse])
}

// NewRecoverableManagedDatabasesServerTransport creates a new instance of RecoverableManagedDatabasesServerTransport with the provided implementation.
// The returned RecoverableManagedDatabasesServerTransport instance is connected to an instance of armsql.RecoverableManagedDatabasesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRecoverableManagedDatabasesServerTransport(srv *RecoverableManagedDatabasesServer) *RecoverableManagedDatabasesServerTransport {
	return &RecoverableManagedDatabasesServerTransport{
		srv:                    srv,
		newListByInstancePager: newTracker[azfake.PagerResponder[armsql.RecoverableManagedDatabasesClientListByInstanceResponse]](),
	}
}

// RecoverableManagedDatabasesServerTransport connects instances of armsql.RecoverableManagedDatabasesClient to instances of RecoverableManagedDatabasesServer.
// Don't use this type directly, use NewRecoverableManagedDatabasesServerTransport instead.
type RecoverableManagedDatabasesServerTransport struct {
	srv                    *RecoverableManagedDatabasesServer
	newListByInstancePager *tracker[azfake.PagerResponder[armsql.RecoverableManagedDatabasesClientListByInstanceResponse]]
}

// Do implements the policy.Transporter interface for RecoverableManagedDatabasesServerTransport.
func (r *RecoverableManagedDatabasesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RecoverableManagedDatabasesClient.Get":
		resp, err = r.dispatchGet(req)
	case "RecoverableManagedDatabasesClient.NewListByInstancePager":
		resp, err = r.dispatchNewListByInstancePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RecoverableManagedDatabasesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recoverableDatabases/(?P<recoverableDatabaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	recoverableDatabaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("recoverableDatabaseName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, managedInstanceNameParam, recoverableDatabaseNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RecoverableManagedDatabase, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecoverableManagedDatabasesServerTransport) dispatchNewListByInstancePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByInstancePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByInstancePager not implemented")}
	}
	newListByInstancePager := r.newListByInstancePager.get(req)
	if newListByInstancePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recoverableDatabases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByInstancePager(resourceGroupNameParam, managedInstanceNameParam, nil)
		newListByInstancePager = &resp
		r.newListByInstancePager.add(req, newListByInstancePager)
		server.PagerResponderInjectNextLinks(newListByInstancePager, req, func(page *armsql.RecoverableManagedDatabasesClientListByInstanceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByInstancePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByInstancePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByInstancePager) {
		r.newListByInstancePager.remove(req)
	}
	return resp, nil
}
