//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstoragecache_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storagecache/armstoragecache/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/storagecache/resource-manager/Microsoft.StorageCache/preview/2023-11-01-preview/examples/Skus_List.json
func ExampleSKUsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragecache.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSKUsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ResourceSKUsResult = armstoragecache.ResourceSKUsResult{
		// 	Value: []*armstoragecache.ResourceSKU{
		// 		{
		// 			Name: to.Ptr("Standard_2G"),
		// 			Capabilities: []*armstoragecache.ResourceSKUCapabilities{
		// 				{
		// 					Name: to.Ptr("throughput GB/s"),
		// 					Value: to.Ptr("2"),
		// 				},
		// 				{
		// 					Name: to.Ptr("cache sizes(GB)"),
		// 					Value: to.Ptr("3072,6144,12288"),
		// 			}},
		// 			LocationInfo: []*armstoragecache.ResourceSKULocationInfo{
		// 				{
		// 					Location: to.Ptr("eastus"),
		// 					Zones: []*string{
		// 					},
		// 			}},
		// 			Locations: []*string{
		// 				to.Ptr("eastus")},
		// 				ResourceType: to.Ptr("caches"),
		// 				Restrictions: []*armstoragecache.Restriction{
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("Standard_4G"),
		// 				Capabilities: []*armstoragecache.ResourceSKUCapabilities{
		// 					{
		// 						Name: to.Ptr("throughput GB/s"),
		// 						Value: to.Ptr("4"),
		// 					},
		// 					{
		// 						Name: to.Ptr("cache sizes(GB)"),
		// 						Value: to.Ptr("6144,12288,24576"),
		// 				}},
		// 				LocationInfo: []*armstoragecache.ResourceSKULocationInfo{
		// 					{
		// 						Location: to.Ptr("eastus"),
		// 						Zones: []*string{
		// 						},
		// 				}},
		// 				Locations: []*string{
		// 					to.Ptr("eastus")},
		// 					ResourceType: to.Ptr("caches"),
		// 					Restrictions: []*armstoragecache.Restriction{
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("Standard_8G"),
		// 					Capabilities: []*armstoragecache.ResourceSKUCapabilities{
		// 						{
		// 							Name: to.Ptr("throughput GB/s"),
		// 							Value: to.Ptr("8"),
		// 						},
		// 						{
		// 							Name: to.Ptr("cache sizes(GB)"),
		// 							Value: to.Ptr("12288,24576,49152"),
		// 					}},
		// 					LocationInfo: []*armstoragecache.ResourceSKULocationInfo{
		// 						{
		// 							Location: to.Ptr("eastus"),
		// 							Zones: []*string{
		// 							},
		// 					}},
		// 					Locations: []*string{
		// 						to.Ptr("eastus")},
		// 						ResourceType: to.Ptr("caches"),
		// 						Restrictions: []*armstoragecache.Restriction{
		// 						},
		// 				}},
		// 			}
	}
}
