//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ListIpFirewallRules.json
func ExampleIPFirewallRulesClient_NewListByWorkspacePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIPFirewallRulesClient().NewListByWorkspacePager("ExampleResourceGroup", "ExampleWorkspace", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IPFirewallRuleInfoListResult = armsynapse.IPFirewallRuleInfoListResult{
		// 	Value: []*armsynapse.IPFirewallRuleInfo{
		// 	},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateIpFirewallRule.json
func ExampleIPFirewallRulesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewIPFirewallRulesClient().BeginCreateOrUpdate(ctx, "ExampleResourceGroup", "ExampleWorkspace", "ExampleIpFirewallRule", armsynapse.IPFirewallRuleInfo{
		Properties: &armsynapse.IPFirewallRuleProperties{
			EndIPAddress:   to.Ptr("10.0.0.254"),
			StartIPAddress: to.Ptr("10.0.0.0"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IPFirewallRuleInfo = armsynapse.IPFirewallRuleInfo{
	// 	Name: to.Ptr("ExampleIpFirewallRule"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/firewallRules"),
	// 	ID: to.Ptr("/subscriptions/01234567-89ab-4def-0123-456789abcdef/resourceGroups/ExampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspace/firewallRules/ExampleIpFirewallRule"),
	// 	Properties: &armsynapse.IPFirewallRuleProperties{
	// 		EndIPAddress: to.Ptr("10.0.0.254"),
	// 		ProvisioningState: to.Ptr(armsynapse.ProvisioningStateSucceeded),
	// 		StartIPAddress: to.Ptr("10.0.0.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DeleteIpFirewallRule.json
func ExampleIPFirewallRulesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewIPFirewallRulesClient().BeginDelete(ctx, "ExampleResourceGroup", "ExampleWorkspace", "ExampleIpFirewallRule", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IPFirewallRuleInfo = armsynapse.IPFirewallRuleInfo{
	// 	Name: to.Ptr("ExampleIpFirewallRule"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/firewallRules"),
	// 	ID: to.Ptr("/subscriptions/01234567-89ab-4def-0123-456789abcdef/resourceGroups/ExampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspace/firewallRules/ExampleIpFirewallRule"),
	// 	Properties: &armsynapse.IPFirewallRuleProperties{
	// 		EndIPAddress: to.Ptr("10.0.0.254"),
	// 		ProvisioningState: to.Ptr(armsynapse.ProvisioningStateSucceeded),
	// 		StartIPAddress: to.Ptr("10.0.0.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetIpFirewallRule.json
func ExampleIPFirewallRulesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIPFirewallRulesClient().Get(ctx, "ExampleResourceGroup", "ExampleWorkspace", "ExampleIpFirewallRule", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IPFirewallRuleInfo = armsynapse.IPFirewallRuleInfo{
	// 	Name: to.Ptr("ExampleIpFirewallRule"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/firewallRules"),
	// 	ID: to.Ptr("/subscriptions/01234567-89ab-4def-0123-456789abcdef/resourceGroups/ExampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspace/firewallRules/ExampleIpFirewallRule"),
	// 	Properties: &armsynapse.IPFirewallRuleProperties{
	// 		EndIPAddress: to.Ptr("10.0.0.254"),
	// 		ProvisioningState: to.Ptr(armsynapse.ProvisioningStateSucceeded),
	// 		StartIPAddress: to.Ptr("10.0.0.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ReplaceAllIpFirewallRules.json
func ExampleIPFirewallRulesClient_BeginReplaceAll() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewIPFirewallRulesClient().BeginReplaceAll(ctx, "ExampleResourceGroup", "ExampleWorkspace", armsynapse.ReplaceAllIPFirewallRulesRequest{
		IPFirewallRules: map[string]*armsynapse.IPFirewallRuleProperties{
			"AnotherExampleFirewallRule": {
				EndIPAddress:   to.Ptr("10.0.1.254"),
				StartIPAddress: to.Ptr("10.0.1.0"),
			},
			"ExampleFirewallRule": {
				EndIPAddress:   to.Ptr("10.0.0.254"),
				StartIPAddress: to.Ptr("10.0.0.0"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ReplaceAllFirewallRulesOperationResponse = armsynapse.ReplaceAllFirewallRulesOperationResponse{
	// 	OperationID: to.Ptr("00000000-1111-4444-2222-333333333333"),
	// }
}
