//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvmwarecloudsimple

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The subscription ID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewCustomizationPoliciesClient creates a new instance of CustomizationPoliciesClient.
func (c *ClientFactory) NewCustomizationPoliciesClient() *CustomizationPoliciesClient {
	subClient, _ := NewCustomizationPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDedicatedCloudNodesClient creates a new instance of DedicatedCloudNodesClient.
func (c *ClientFactory) NewDedicatedCloudNodesClient() *DedicatedCloudNodesClient {
	subClient, _ := NewDedicatedCloudNodesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDedicatedCloudServicesClient creates a new instance of DedicatedCloudServicesClient.
func (c *ClientFactory) NewDedicatedCloudServicesClient() *DedicatedCloudServicesClient {
	subClient, _ := NewDedicatedCloudServicesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateCloudsClient creates a new instance of PrivateCloudsClient.
func (c *ClientFactory) NewPrivateCloudsClient() *PrivateCloudsClient {
	subClient, _ := NewPrivateCloudsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewResourcePoolsClient creates a new instance of ResourcePoolsClient.
func (c *ClientFactory) NewResourcePoolsClient() *ResourcePoolsClient {
	subClient, _ := NewResourcePoolsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSKUsAvailabilityClient creates a new instance of SKUsAvailabilityClient.
func (c *ClientFactory) NewSKUsAvailabilityClient() *SKUsAvailabilityClient {
	subClient, _ := NewSKUsAvailabilityClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewUsagesClient creates a new instance of UsagesClient.
func (c *ClientFactory) NewUsagesClient() *UsagesClient {
	subClient, _ := NewUsagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineTemplatesClient creates a new instance of VirtualMachineTemplatesClient.
func (c *ClientFactory) NewVirtualMachineTemplatesClient() *VirtualMachineTemplatesClient {
	subClient, _ := NewVirtualMachineTemplatesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachinesClient creates a new instance of VirtualMachinesClient.
func (c *ClientFactory) NewVirtualMachinesClient() *VirtualMachinesClient {
	subClient, _ := NewVirtualMachinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualNetworksClient creates a new instance of VirtualNetworksClient.
func (c *ClientFactory) NewVirtualNetworksClient() *VirtualNetworksClient {
	subClient, _ := NewVirtualNetworksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
