// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all versions of a specific Amazon Secure Agent.
func (c *Client) ListAgentRuntimeVersions(ctx context.Context, params *ListAgentRuntimeVersionsInput, optFns ...func(*Options)) (*ListAgentRuntimeVersionsOutput, error) {
	if params == nil {
		params = &ListAgentRuntimeVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAgentRuntimeVersions", params, optFns, c.addOperationListAgentRuntimeVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAgentRuntimeVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAgentRuntimeVersionsInput struct {

	// The unique identifier of the agent runtime to list versions for.
	//
	// This member is required.
	AgentRuntimeId *string

	// The maximum number of results to return in the response.
	MaxResults *int32

	// A token to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAgentRuntimeVersionsOutput struct {

	// The list of agent runtime versions.
	//
	// This member is required.
	AgentRuntimes []types.Agent

	// A token to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAgentRuntimeVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAgentRuntimeVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAgentRuntimeVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAgentRuntimeVersions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAgentRuntimeVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAgentRuntimeVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAgentRuntimeVersionsPaginatorOptions is the paginator options for
// ListAgentRuntimeVersions
type ListAgentRuntimeVersionsPaginatorOptions struct {
	// The maximum number of results to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAgentRuntimeVersionsPaginator is a paginator for ListAgentRuntimeVersions
type ListAgentRuntimeVersionsPaginator struct {
	options   ListAgentRuntimeVersionsPaginatorOptions
	client    ListAgentRuntimeVersionsAPIClient
	params    *ListAgentRuntimeVersionsInput
	nextToken *string
	firstPage bool
}

// NewListAgentRuntimeVersionsPaginator returns a new
// ListAgentRuntimeVersionsPaginator
func NewListAgentRuntimeVersionsPaginator(client ListAgentRuntimeVersionsAPIClient, params *ListAgentRuntimeVersionsInput, optFns ...func(*ListAgentRuntimeVersionsPaginatorOptions)) *ListAgentRuntimeVersionsPaginator {
	if params == nil {
		params = &ListAgentRuntimeVersionsInput{}
	}

	options := ListAgentRuntimeVersionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAgentRuntimeVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAgentRuntimeVersionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAgentRuntimeVersions page.
func (p *ListAgentRuntimeVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAgentRuntimeVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAgentRuntimeVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAgentRuntimeVersionsAPIClient is a client that implements the
// ListAgentRuntimeVersions operation.
type ListAgentRuntimeVersionsAPIClient interface {
	ListAgentRuntimeVersions(context.Context, *ListAgentRuntimeVersionsInput, ...func(*Options)) (*ListAgentRuntimeVersionsOutput, error)
}

var _ ListAgentRuntimeVersionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAgentRuntimeVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAgentRuntimeVersions",
	}
}
