// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing OAuth2 credential provider.
func (c *Client) UpdateOauth2CredentialProvider(ctx context.Context, params *UpdateOauth2CredentialProviderInput, optFns ...func(*Options)) (*UpdateOauth2CredentialProviderOutput, error) {
	if params == nil {
		params = &UpdateOauth2CredentialProviderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateOauth2CredentialProvider", params, optFns, c.addOperationUpdateOauth2CredentialProviderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateOauth2CredentialProviderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateOauth2CredentialProviderInput struct {

	// The vendor of the OAuth2 credential provider.
	//
	// This member is required.
	CredentialProviderVendor types.CredentialProviderVendorType

	// The name of the OAuth2 credential provider to update.
	//
	// This member is required.
	Name *string

	// The configuration input for the OAuth2 provider.
	//
	// This member is required.
	Oauth2ProviderConfigInput types.Oauth2ProviderConfigInput

	noSmithyDocumentSerde
}

type UpdateOauth2CredentialProviderOutput struct {

	// The Amazon Resource Name (ARN) of the client secret in AWS Secrets Manager.
	//
	// This member is required.
	ClientSecretArn *types.Secret

	// The timestamp when the OAuth2 credential provider was created.
	//
	// This member is required.
	CreatedTime *time.Time

	// The Amazon Resource Name (ARN) of the OAuth2 credential provider.
	//
	// This member is required.
	CredentialProviderArn *string

	// The vendor of the OAuth2 credential provider.
	//
	// This member is required.
	CredentialProviderVendor types.CredentialProviderVendorType

	// The timestamp when the OAuth2 credential provider was last updated.
	//
	// This member is required.
	LastUpdatedTime *time.Time

	// The name of the OAuth2 credential provider.
	//
	// This member is required.
	Name *string

	// The configuration output for the OAuth2 provider.
	//
	// This member is required.
	Oauth2ProviderConfigOutput types.Oauth2ProviderConfigOutput

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateOauth2CredentialProviderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateOauth2CredentialProvider{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateOauth2CredentialProvider{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateOauth2CredentialProvider"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateOauth2CredentialProviderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateOauth2CredentialProvider(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateOauth2CredentialProvider(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateOauth2CredentialProvider",
	}
}
