// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Links an existing user account in a user pool, or DestinationUser , to an
// identity from an external IdP, or SourceUser , based on a specified attribute
// name and value from the external IdP.
//
// This operation connects a local user profile with a user identity who hasn't
// yet signed in from their third-party IdP. When the user signs in with their IdP,
// they get access-control configuration from the local user profile. Linked local
// users can also sign in with SDK-based API operations like InitiateAuth after
// they sign in at least once through their IdP. For more information, see [Linking federated users].
//
// The maximum number of federated identities linked to a user is five.
//
// Because this API allows a user with an external federated identity to sign in
// as a local user, it is critical that it only be used with external IdPs and
// linked attributes that you trust.
//
// Amazon Cognito evaluates Identity and Access Management (IAM) policies in
// requests for this API operation. For this operation, you must use IAM
// credentials to authorize requests, and you must grant yourself the corresponding
// IAM permission in a policy.
//
// # Learn more
//
// [Signing Amazon Web Services API Requests]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html
// [Linking federated users]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html
// [Signing Amazon Web Services API Requests]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html
func (c *Client) AdminLinkProviderForUser(ctx context.Context, params *AdminLinkProviderForUserInput, optFns ...func(*Options)) (*AdminLinkProviderForUserOutput, error) {
	if params == nil {
		params = &AdminLinkProviderForUserInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AdminLinkProviderForUser", params, optFns, c.addOperationAdminLinkProviderForUserMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AdminLinkProviderForUserOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AdminLinkProviderForUserInput struct {

	// The existing user in the user pool that you want to assign to the external IdP
	// user account. This user can be a local (Username + Password) Amazon Cognito user
	// pools user or a federated user (for example, a SAML or Facebook user). If the
	// user doesn't exist, Amazon Cognito generates an exception. Amazon Cognito
	// returns this user when the new user (with the linked IdP attribute) signs in.
	//
	// For a native username + password user, the ProviderAttributeValue for the
	// DestinationUser should be the username in the user pool. For a federated user,
	// it should be the provider-specific user_id .
	//
	// The ProviderAttributeName of the DestinationUser is ignored.
	//
	// The ProviderName should be set to Cognito for users in Cognito user pools.
	//
	// All attributes in the DestinationUser profile must be mutable. If you have
	// assigned the user any immutable custom attributes, the operation won't succeed.
	//
	// This member is required.
	DestinationUser *types.ProviderUserIdentifierType

	// An external IdP account for a user who doesn't exist yet in the user pool. This
	// user must be a federated user (for example, a SAML or Facebook user), not
	// another native user.
	//
	// If the SourceUser is using a federated social IdP, such as Facebook, Google, or
	// Login with Amazon, you must set the ProviderAttributeName to Cognito_Subject .
	// For social IdPs, the ProviderName will be Facebook , Google , or LoginWithAmazon
	// , and Amazon Cognito will automatically parse the Facebook, Google, and Login
	// with Amazon tokens for id , sub , and user_id , respectively. The
	// ProviderAttributeValue for the user must be the same value as the id , sub , or
	// user_id value found in the social IdP token.
	//
	// For OIDC, the ProviderAttributeName can be any mapped value from a claim in the
	// ID token, or that your app retrieves from the userInfo endpoint. For SAML, the
	// ProviderAttributeName can be any mapped value from a claim in the SAML assertion.
	//
	// The following additional considerations apply to SourceUser for OIDC and SAML
	// providers.
	//
	//   - You must map the claim to a user pool attribute in your IdP configuration,
	//   and set the user pool attribute name as the value of ProviderAttributeName in
	//   your AdminLinkProviderForUser request. For example, email .
	//
	//   - When you set ProviderAttributeName to Cognito_Subject , Amazon Cognito will
	//   automatically parse the default unique identifier found in the subject from the
	//   IdP token.
	//
	// This member is required.
	SourceUser *types.ProviderUserIdentifierType

	// The ID of the user pool where you want to link a federated identity.
	//
	// This member is required.
	UserPoolId *string

	noSmithyDocumentSerde
}

type AdminLinkProviderForUserOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAdminLinkProviderForUserMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpAdminLinkProviderForUser{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpAdminLinkProviderForUser{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AdminLinkProviderForUser"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpAdminLinkProviderForUserValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAdminLinkProviderForUser(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAdminLinkProviderForUser(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AdminLinkProviderForUser",
	}
}
