// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists the history of the specified data lineage node.
func (c *Client) ListLineageNodeHistory(ctx context.Context, params *ListLineageNodeHistoryInput, optFns ...func(*Options)) (*ListLineageNodeHistoryOutput, error) {
	if params == nil {
		params = &ListLineageNodeHistoryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListLineageNodeHistory", params, optFns, c.addOperationListLineageNodeHistoryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListLineageNodeHistoryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListLineageNodeHistoryInput struct {

	// The ID of the domain where you want to list the history of the specified data
	// lineage node.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the data lineage node whose history you want to list.
	//
	// This member is required.
	Identifier *string

	// The direction of the data lineage node refers to the lineage node having
	// neighbors in that direction. For example, if direction is UPSTREAM , the
	// ListLineageNodeHistory API responds with historical versions with upstream
	// neighbors only.
	Direction types.EdgeDirection

	// Specifies whether the action is to return data lineage node history from the
	// time after the event timestamp.
	EventTimestampGTE *time.Time

	// Specifies whether the action is to return data lineage node history from the
	// time prior of the event timestamp.
	EventTimestampLTE *time.Time

	// The maximum number of history items to return in a single call to
	// ListLineageNodeHistory. When the number of memberships to be listed is greater
	// than the value of MaxResults, the response contains a NextToken value that you
	// can use in a subsequent call to ListLineageNodeHistory to list the next set of
	// items.
	MaxResults *int32

	// When the number of history items is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of items, the response includes a pagination token named
	// NextToken. You can specify this NextToken value in a subsequent call to
	// ListLineageNodeHistory to list the next set of items.
	NextToken *string

	// The order by which you want data lineage node history to be sorted.
	SortOrder types.SortOrder

	noSmithyDocumentSerde
}

type ListLineageNodeHistoryOutput struct {

	// When the number of history items is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of items, the response includes a pagination token named
	// NextToken. You can specify this NextToken value in a subsequent call to
	// ListLineageNodeHistory to list the next set of items.
	NextToken *string

	// The nodes returned by the ListLineageNodeHistory action.
	Nodes []types.LineageNodeSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListLineageNodeHistoryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListLineageNodeHistory{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListLineageNodeHistory{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListLineageNodeHistory"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListLineageNodeHistoryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListLineageNodeHistory(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListLineageNodeHistoryPaginatorOptions is the paginator options for
// ListLineageNodeHistory
type ListLineageNodeHistoryPaginatorOptions struct {
	// The maximum number of history items to return in a single call to
	// ListLineageNodeHistory. When the number of memberships to be listed is greater
	// than the value of MaxResults, the response contains a NextToken value that you
	// can use in a subsequent call to ListLineageNodeHistory to list the next set of
	// items.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListLineageNodeHistoryPaginator is a paginator for ListLineageNodeHistory
type ListLineageNodeHistoryPaginator struct {
	options   ListLineageNodeHistoryPaginatorOptions
	client    ListLineageNodeHistoryAPIClient
	params    *ListLineageNodeHistoryInput
	nextToken *string
	firstPage bool
}

// NewListLineageNodeHistoryPaginator returns a new ListLineageNodeHistoryPaginator
func NewListLineageNodeHistoryPaginator(client ListLineageNodeHistoryAPIClient, params *ListLineageNodeHistoryInput, optFns ...func(*ListLineageNodeHistoryPaginatorOptions)) *ListLineageNodeHistoryPaginator {
	if params == nil {
		params = &ListLineageNodeHistoryInput{}
	}

	options := ListLineageNodeHistoryPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListLineageNodeHistoryPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListLineageNodeHistoryPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListLineageNodeHistory page.
func (p *ListLineageNodeHistoryPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListLineageNodeHistoryOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListLineageNodeHistory(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListLineageNodeHistoryAPIClient is a client that implements the
// ListLineageNodeHistory operation.
type ListLineageNodeHistoryAPIClient interface {
	ListLineageNodeHistory(context.Context, *ListLineageNodeHistoryInput, ...func(*Options)) (*ListLineageNodeHistoryOutput, error)
}

var _ ListLineageNodeHistoryAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListLineageNodeHistory(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListLineageNodeHistory",
	}
}
