// Code generated by smithy-go-codegen DO NOT EDIT.

package devicefarm

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/devicefarm/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of artifacts created during the session.
func (c *Client) ListTestGridSessionArtifacts(ctx context.Context, params *ListTestGridSessionArtifactsInput, optFns ...func(*Options)) (*ListTestGridSessionArtifactsOutput, error) {
	if params == nil {
		params = &ListTestGridSessionArtifactsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTestGridSessionArtifacts", params, optFns, c.addOperationListTestGridSessionArtifactsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTestGridSessionArtifactsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTestGridSessionArtifactsInput struct {

	// The ARN of a TestGridSession.
	//
	// This member is required.
	SessionArn *string

	// The maximum number of results to be returned by a request.
	MaxResult *int32

	// Pagination token.
	NextToken *string

	// Limit results to a specified type of artifact.
	Type types.TestGridSessionArtifactCategory

	noSmithyDocumentSerde
}

type ListTestGridSessionArtifactsOutput struct {

	// A list of test grid session artifacts for a TestGridSession.
	Artifacts []types.TestGridSessionArtifact

	// Pagination token.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTestGridSessionArtifactsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListTestGridSessionArtifacts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListTestGridSessionArtifacts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTestGridSessionArtifacts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListTestGridSessionArtifactsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTestGridSessionArtifacts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListTestGridSessionArtifactsPaginatorOptions is the paginator options for
// ListTestGridSessionArtifacts
type ListTestGridSessionArtifactsPaginatorOptions struct {
	// The maximum number of results to be returned by a request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTestGridSessionArtifactsPaginator is a paginator for
// ListTestGridSessionArtifacts
type ListTestGridSessionArtifactsPaginator struct {
	options   ListTestGridSessionArtifactsPaginatorOptions
	client    ListTestGridSessionArtifactsAPIClient
	params    *ListTestGridSessionArtifactsInput
	nextToken *string
	firstPage bool
}

// NewListTestGridSessionArtifactsPaginator returns a new
// ListTestGridSessionArtifactsPaginator
func NewListTestGridSessionArtifactsPaginator(client ListTestGridSessionArtifactsAPIClient, params *ListTestGridSessionArtifactsInput, optFns ...func(*ListTestGridSessionArtifactsPaginatorOptions)) *ListTestGridSessionArtifactsPaginator {
	if params == nil {
		params = &ListTestGridSessionArtifactsInput{}
	}

	options := ListTestGridSessionArtifactsPaginatorOptions{}
	if params.MaxResult != nil {
		options.Limit = *params.MaxResult
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTestGridSessionArtifactsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTestGridSessionArtifactsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTestGridSessionArtifacts page.
func (p *ListTestGridSessionArtifactsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTestGridSessionArtifactsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResult = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTestGridSessionArtifacts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTestGridSessionArtifactsAPIClient is a client that implements the
// ListTestGridSessionArtifacts operation.
type ListTestGridSessionArtifactsAPIClient interface {
	ListTestGridSessionArtifacts(context.Context, *ListTestGridSessionArtifactsInput, ...func(*Options)) (*ListTestGridSessionArtifactsOutput, error)
}

var _ ListTestGridSessionArtifactsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTestGridSessionArtifacts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTestGridSessionArtifacts",
	}
}
