// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates presigned URLs for accessing hub content artifacts. This operation
// generates time-limited, secure URLs that allow direct download of model
// artifacts and associated files from Amazon SageMaker hub content, including
// gated models that require end-user license agreement acceptance.
func (c *Client) CreateHubContentPresignedUrls(ctx context.Context, params *CreateHubContentPresignedUrlsInput, optFns ...func(*Options)) (*CreateHubContentPresignedUrlsOutput, error) {
	if params == nil {
		params = &CreateHubContentPresignedUrlsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateHubContentPresignedUrls", params, optFns, c.addOperationCreateHubContentPresignedUrlsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateHubContentPresignedUrlsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateHubContentPresignedUrlsInput struct {

	// The name of the hub content for which to generate presigned URLs. This
	// identifies the specific model or content within the hub.
	//
	// This member is required.
	HubContentName *string

	// The type of hub content to access. Valid values include Model , Notebook , and
	// ModelReference .
	//
	// This member is required.
	HubContentType types.HubContentType

	// The name or Amazon Resource Name (ARN) of the hub that contains the content.
	// For public content, use SageMakerPublicHub .
	//
	// This member is required.
	HubName *string

	// Configuration settings for accessing the hub content, including end-user
	// license agreement acceptance for gated models and expected S3 URL validation.
	AccessConfig *types.PresignedUrlAccessConfig

	// The version of the hub content. If not specified, the latest version is used.
	HubContentVersion *string

	// The maximum number of presigned URLs to return in the response. Default value
	// is 100. Large models may contain hundreds of files, requiring pagination to
	// retrieve all URLs.
	MaxResults *int32

	//  A token for pagination. Use this token to retrieve the next set of presigned
	// URLs when the response is truncated.
	NextToken *string

	noSmithyDocumentSerde
}

type CreateHubContentPresignedUrlsOutput struct {

	// An array of authorized URL configurations, each containing a presigned URL and
	// its corresponding local file path for proper file organization during download.
	//
	// This member is required.
	AuthorizedUrlConfigs []types.AuthorizedUrl

	// A token for pagination. If present, indicates that more presigned URLs are
	// available. Use this token in a subsequent request to retrieve additional URLs.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateHubContentPresignedUrlsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateHubContentPresignedUrls{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateHubContentPresignedUrls{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateHubContentPresignedUrls"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateHubContentPresignedUrlsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateHubContentPresignedUrls(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// CreateHubContentPresignedUrlsPaginatorOptions is the paginator options for
// CreateHubContentPresignedUrls
type CreateHubContentPresignedUrlsPaginatorOptions struct {
	// The maximum number of presigned URLs to return in the response. Default value
	// is 100. Large models may contain hundreds of files, requiring pagination to
	// retrieve all URLs.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// CreateHubContentPresignedUrlsPaginator is a paginator for
// CreateHubContentPresignedUrls
type CreateHubContentPresignedUrlsPaginator struct {
	options   CreateHubContentPresignedUrlsPaginatorOptions
	client    CreateHubContentPresignedUrlsAPIClient
	params    *CreateHubContentPresignedUrlsInput
	nextToken *string
	firstPage bool
}

// NewCreateHubContentPresignedUrlsPaginator returns a new
// CreateHubContentPresignedUrlsPaginator
func NewCreateHubContentPresignedUrlsPaginator(client CreateHubContentPresignedUrlsAPIClient, params *CreateHubContentPresignedUrlsInput, optFns ...func(*CreateHubContentPresignedUrlsPaginatorOptions)) *CreateHubContentPresignedUrlsPaginator {
	if params == nil {
		params = &CreateHubContentPresignedUrlsInput{}
	}

	options := CreateHubContentPresignedUrlsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &CreateHubContentPresignedUrlsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *CreateHubContentPresignedUrlsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next CreateHubContentPresignedUrls page.
func (p *CreateHubContentPresignedUrlsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*CreateHubContentPresignedUrlsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.CreateHubContentPresignedUrls(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// CreateHubContentPresignedUrlsAPIClient is a client that implements the
// CreateHubContentPresignedUrls operation.
type CreateHubContentPresignedUrlsAPIClient interface {
	CreateHubContentPresignedUrls(context.Context, *CreateHubContentPresignedUrlsInput, ...func(*Options)) (*CreateHubContentPresignedUrlsOutput, error)
}

var _ CreateHubContentPresignedUrlsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opCreateHubContentPresignedUrls(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateHubContentPresignedUrls",
	}
}
