// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// The set of preferences used for recording RDP connections in the requesting
// Amazon Web Services account and Amazon Web Services Region. This includes
// details such as which S3 bucket recordings are stored in.
type ConnectionRecordingPreferences struct {

	// The ARN of a KMS key that is used to encrypt data while it is being processed
	// by the service. This key must exist in the same Amazon Web Services Region as
	// the node you start an RDP connection to.
	//
	// This member is required.
	KMSKeyArn *string

	// Determines where recordings of RDP connections are stored.
	//
	// This member is required.
	RecordingDestinations *RecordingDestinations

	noSmithyDocumentSerde
}

// Determines where recordings of RDP connections are stored.
type RecordingDestinations struct {

	// The S3 bucket where RDP connection recordings are stored.
	//
	// This member is required.
	S3Buckets []S3Bucket

	noSmithyDocumentSerde
}

// The S3 bucket where RDP connection recordings are stored.
type S3Bucket struct {

	// The name of the S3 bucket where RDP connection recordings are stored.
	//
	// This member is required.
	BucketName *string

	// The Amazon Web Services account number that owns the S3 bucket.
	//
	// This member is required.
	BucketOwner *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
