// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v6.31.1
// source: dolt/services/replicationapi/v1alpha1/replication.proto

package replicationapi

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	ReplicationService_UpdateUsersAndGrants_FullMethodName = "/dolt.services.replicationapi.v1alpha1.ReplicationService/UpdateUsersAndGrants"
	ReplicationService_UpdateBranchControl_FullMethodName  = "/dolt.services.replicationapi.v1alpha1.ReplicationService/UpdateBranchControl"
	ReplicationService_DropDatabase_FullMethodName         = "/dolt.services.replicationapi.v1alpha1.ReplicationService/DropDatabase"
)

// ReplicationServiceClient is the client API for ReplicationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ReplicationServiceClient interface {
	// Users and grants in Dolt are stored in in a
	// `github.com/dolthub/go-mysql-server/sql/mysql_db.*MySQLDb` instance. This
	// method is called by a primary on a standby instance in order to set its
	// in-effect users and grants. Its primary payload is the serialized contents
	// of the `*MySQLDb` instance at the primary, such that it can be applied
	// with OverwriteUsersAndGrantData.
	UpdateUsersAndGrants(ctx context.Context, in *UpdateUsersAndGrantsRequest, opts ...grpc.CallOption) (*UpdateUsersAndGrantsResponse, error)
	UpdateBranchControl(ctx context.Context, in *UpdateBranchControlRequest, opts ...grpc.CallOption) (*UpdateBranchControlResponse, error)
	DropDatabase(ctx context.Context, in *DropDatabaseRequest, opts ...grpc.CallOption) (*DropDatabaseResponse, error)
}

type replicationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReplicationServiceClient(cc grpc.ClientConnInterface) ReplicationServiceClient {
	return &replicationServiceClient{cc}
}

func (c *replicationServiceClient) UpdateUsersAndGrants(ctx context.Context, in *UpdateUsersAndGrantsRequest, opts ...grpc.CallOption) (*UpdateUsersAndGrantsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UpdateUsersAndGrantsResponse)
	err := c.cc.Invoke(ctx, ReplicationService_UpdateUsersAndGrants_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *replicationServiceClient) UpdateBranchControl(ctx context.Context, in *UpdateBranchControlRequest, opts ...grpc.CallOption) (*UpdateBranchControlResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UpdateBranchControlResponse)
	err := c.cc.Invoke(ctx, ReplicationService_UpdateBranchControl_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *replicationServiceClient) DropDatabase(ctx context.Context, in *DropDatabaseRequest, opts ...grpc.CallOption) (*DropDatabaseResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DropDatabaseResponse)
	err := c.cc.Invoke(ctx, ReplicationService_DropDatabase_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReplicationServiceServer is the server API for ReplicationService service.
// All implementations must embed UnimplementedReplicationServiceServer
// for forward compatibility.
type ReplicationServiceServer interface {
	// Users and grants in Dolt are stored in in a
	// `github.com/dolthub/go-mysql-server/sql/mysql_db.*MySQLDb` instance. This
	// method is called by a primary on a standby instance in order to set its
	// in-effect users and grants. Its primary payload is the serialized contents
	// of the `*MySQLDb` instance at the primary, such that it can be applied
	// with OverwriteUsersAndGrantData.
	UpdateUsersAndGrants(context.Context, *UpdateUsersAndGrantsRequest) (*UpdateUsersAndGrantsResponse, error)
	UpdateBranchControl(context.Context, *UpdateBranchControlRequest) (*UpdateBranchControlResponse, error)
	DropDatabase(context.Context, *DropDatabaseRequest) (*DropDatabaseResponse, error)
	mustEmbedUnimplementedReplicationServiceServer()
}

// UnimplementedReplicationServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedReplicationServiceServer struct{}

func (UnimplementedReplicationServiceServer) UpdateUsersAndGrants(context.Context, *UpdateUsersAndGrantsRequest) (*UpdateUsersAndGrantsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateUsersAndGrants not implemented")
}
func (UnimplementedReplicationServiceServer) UpdateBranchControl(context.Context, *UpdateBranchControlRequest) (*UpdateBranchControlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBranchControl not implemented")
}
func (UnimplementedReplicationServiceServer) DropDatabase(context.Context, *DropDatabaseRequest) (*DropDatabaseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DropDatabase not implemented")
}
func (UnimplementedReplicationServiceServer) mustEmbedUnimplementedReplicationServiceServer() {}
func (UnimplementedReplicationServiceServer) testEmbeddedByValue()                            {}

// UnsafeReplicationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ReplicationServiceServer will
// result in compilation errors.
type UnsafeReplicationServiceServer interface {
	mustEmbedUnimplementedReplicationServiceServer()
}

func RegisterReplicationServiceServer(s grpc.ServiceRegistrar, srv ReplicationServiceServer) {
	// If the following call panics, it indicates UnimplementedReplicationServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ReplicationService_ServiceDesc, srv)
}

func _ReplicationService_UpdateUsersAndGrants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUsersAndGrantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReplicationServiceServer).UpdateUsersAndGrants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReplicationService_UpdateUsersAndGrants_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReplicationServiceServer).UpdateUsersAndGrants(ctx, req.(*UpdateUsersAndGrantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReplicationService_UpdateBranchControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBranchControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReplicationServiceServer).UpdateBranchControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReplicationService_UpdateBranchControl_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReplicationServiceServer).UpdateBranchControl(ctx, req.(*UpdateBranchControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReplicationService_DropDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DropDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReplicationServiceServer).DropDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReplicationService_DropDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReplicationServiceServer).DropDatabase(ctx, req.(*DropDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ReplicationService_ServiceDesc is the grpc.ServiceDesc for ReplicationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ReplicationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "dolt.services.replicationapi.v1alpha1.ReplicationService",
	HandlerType: (*ReplicationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UpdateUsersAndGrants",
			Handler:    _ReplicationService_UpdateUsersAndGrants_Handler,
		},
		{
			MethodName: "UpdateBranchControl",
			Handler:    _ReplicationService_UpdateBranchControl_Handler,
		},
		{
			MethodName: "DropDatabase",
			Handler:    _ReplicationService_DropDatabase_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "dolt/services/replicationapi/v1alpha1/replication.proto",
}
