Feature: merge the current feature branch and update proposals

  Background:
    Given a Git repo with origin
    And the origin is "git@github.com:git-town/git-town.git"
    And the branches
      | NAME  | TYPE    | PARENT | LOCATIONS     |
      | alpha | feature | main   | local, origin |
    And the commits
      | BRANCH | LOCATION      | MESSAGE      |
      | alpha  | local, origin | alpha commit |
    And the branches
      | NAME | TYPE    | PARENT | LOCATIONS     |
      | beta | feature | alpha  | local, origin |
    And the commits
      | BRANCH | LOCATION      | MESSAGE     |
      | beta   | local, origin | beta commit |
    And the branches
      | NAME  | TYPE    | PARENT | LOCATIONS     |
      | gamma | feature | beta   | local, origin |
    And the commits
      | BRANCH | LOCATION      | MESSAGE      |
      | gamma  | local, origin | gamma commit |
    And the proposals
      | ID | SOURCE BRANCH | TARGET BRANCH | TITLE          | BODY       | URL                      |
      | 1  | alpha         | main          | alpha proposal | alpha body | https://example.com/pr/1 |
      | 2  | beta          | alpha         | beta proposal  | beta body  | https://example.com/pr/2 |
      | 3  | gamma         | beta          | gamma proposal | gamma body | https://example.com/pr/3 |
    And Git setting "git-town.proposal-breadcrumb" is "stacks"
    And the current branch is "beta"
    When I run "git-town merge"
    Then origin closes proposal #2

  Scenario: result
    Then Git Town runs the commands
      | BRANCH | COMMAND                                                        |
      | beta   | git fetch --prune --tags                                       |
      |        | Finding proposal from gamma into beta ... #3 (gamma proposal)  |
      |        | Updating target branch of proposal #3 to alpha ... ok          |
      |        | git checkout alpha                                             |
      | alpha  | git reset --hard {{ sha 'beta commit' }}                       |
      |        | git push origin :beta                                          |
      |        | git branch -D beta                                             |
      |        | git push --force-with-lease --force-if-includes                |
      |        | Finding all proposals for alpha ... main                       |
      |        | Finding proposal from alpha into main ... #1 (alpha proposal)  |
      |        | Finding proposal from gamma into alpha ... #3 (gamma proposal) |
      |        | Update body for #1 ... ok                                      |
      |        | Finding all proposals for beta ... alpha                       |
      |        | Update body for #2 ... ok                                      |
      |        | Finding all proposals for gamma ... alpha                      |
      |        | Finding proposal from alpha into main ... #1 (alpha proposal)  |
      |        | Update body for #3 ... ok                                      |
    And this lineage exists now
      """
      main
        alpha
          gamma
      """
    And the branches are now
      | REPOSITORY    | BRANCHES           |
      | local, origin | main, alpha, gamma |
    And no uncommitted files exist now
    And the proposals are now
      """
      url: https://example.com/pr/1
      number: 1
      source: alpha
      target: main
      body:
        alpha body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/1 :point_left:
            - https://example.com/pr/3

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->

      url: https://example.com/pr/3
      number: 3
      source: gamma
      target: alpha
      body:
        gamma body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/1
            - https://example.com/pr/3 :point_left:

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->
      """

  Scenario: undo
    When I run "git-town undo"
    Then Git Town runs the commands
      | BRANCH | COMMAND                                                       |
      | alpha  | git reset --hard {{ sha 'alpha commit' }}                     |
      |        | git push --force-with-lease --force-if-includes               |
      |        | git branch beta {{ sha 'beta commit' }}                       |
      |        | git push -u origin beta                                       |
      |        | Updating target branch of proposal #3 to beta ... ok          |
      |        | git checkout beta                                             |
      |        | Finding all proposals for alpha ... main                      |
      |        | Finding proposal from alpha into main ... #1 (alpha proposal) |
      |        | Finding proposal from gamma into alpha ... none               |
      |        | Update body for #1 ... ok                                     |
      |        | Finding all proposals for beta ... none                       |
      |        | Finding all proposals for gamma ... beta                      |
      |        | Finding proposal from alpha into main ... #1 (alpha proposal) |
      |        | Finding proposal from gamma into alpha ... none               |
      |        | Update body for #3 ... ok                                     |
    And the initial branches and lineage exist now
    And the initial commits exist now
    And the proposals are now
      """
      url: https://example.com/pr/1
      number: 1
      source: alpha
      target: main
      body:
        alpha body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/1 :point_left:

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->

      url: https://example.com/pr/3
      number: 3
      source: gamma
      target: beta
      body:
        gamma body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/1
            - gamma :point_left:

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->
      """
