Feature: propose a stack with "stacks" setting

  Background:
    Given a Git repo with origin
    And the origin is "git@github.com:git-town/git-town.git"
    And the branches
      | NAME     | TYPE    | PARENT   | LOCATIONS     |
      | branch-1 | feature | main     | local, origin |
      | branch-2 | feature | branch-1 | local, origin |
      | branch-3 | feature | branch-2 | local, origin |
    And the commits
      | BRANCH   | LOCATION      | MESSAGE  |
      | branch-1 | local, origin | commit 1 |
      | branch-2 | local, origin | commit 2 |
      | branch-3 | local, origin | commit 3 |
    And the proposals
      | ID | SOURCE BRANCH | TARGET BRANCH | TITLE             | BODY          | URL                      |
      | 1  | branch-1      | main          | branch-1 proposal | branch-1 body | https://example.com/pr/1 |
    And Git setting "git-town.proposal-breadcrumb" is "stacks"
    And the current branch is "branch-2"
    And tool "open" is installed
    When I run "git-town propose --stack"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH   | COMMAND                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
      | branch-2 | git fetch --prune --tags                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
      |          | Finding proposal from branch-1 into main ... #1 (branch-1 proposal)                                                                                                                                                                                                                                                                                                                                                                                                                               |
      |          | Finding proposal from branch-2 into branch-1 ... none                                                                                                                                                                                                                                                                                                                                                                                                                                             |
      |          | Finding proposal from branch-3 into branch-2 ... none                                                                                                                                                                                                                                                                                                                                                                                                                                             |
      |          | git checkout branch-1                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
      | branch-1 | git checkout branch-2                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
      | branch-2 | git merge --no-edit --ff branch-1                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
      |          | git push                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
      |          | git checkout branch-3                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
      | branch-3 | git merge --no-edit --ff branch-2                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
      |          | git push                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
      |          | git checkout branch-1                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
      | branch-1 | open https://example.com/pr/1                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
      |          | git checkout branch-2                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
      | branch-2 | open https://github.com/git-town/git-town/compare/branch-1...branch-2?expand=1&body=%3C%21--+branch-stack-start+--%3E%0A%0A-------------------------%0A-+main%0A++-+https%3A%2F%2Fexample.com%2Fpr%2F1%0A++++-+branch-2+%3Apoint_left%3A%0A%0A%3Csup%3E%5BStack%5D%28https%3A%2F%2Fwww.git-town.com%2Fhow-to%2Fproposal-breadcrumb.html%29+generated+by+%5BGit+Town%5D%28https%3A%2F%2Fgithub.com%2Fgit-town%2Fgit-town%29%3C%2Fsup%3E%0A%0A%3C%21--+branch-stack-end+--%3E%0A                    |
      |          | Finding all proposals for branch-2 ... none                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
      |          | git checkout branch-3                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
      | branch-3 | open https://github.com/git-town/git-town/compare/branch-2...branch-3?expand=1&body=%3C%21--+branch-stack-start+--%3E%0A%0A-------------------------%0A-+main%0A++-+https%3A%2F%2Fexample.com%2Fpr%2F1%0A++++-+branch-2%0A++++++-+branch-3+%3Apoint_left%3A%0A%0A%3Csup%3E%5BStack%5D%28https%3A%2F%2Fwww.git-town.com%2Fhow-to%2Fproposal-breadcrumb.html%29+generated+by+%5BGit+Town%5D%28https%3A%2F%2Fgithub.com%2Fgit-town%2Fgit-town%29%3C%2Fsup%3E%0A%0A%3C%21--+branch-stack-end+--%3E%0A |
      |          | Finding all proposals for branch-3 ... none                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
    And the initial proposals exist now

  Scenario: undo
    When I run "git-town undo"
    Then Git Town runs the commands
      | BRANCH   | COMMAND                                                             |
      | branch-3 | git checkout branch-2                                               |
      | branch-2 | git reset --hard {{ sha 'commit 2' }}                               |
      |          | git push --force-with-lease --force-if-includes                     |
      |          | git checkout branch-3                                               |
      | branch-3 | git reset --hard {{ sha 'commit 3' }}                               |
      |          | git push --force-with-lease --force-if-includes                     |
      |          | git checkout branch-2                                               |
      |          | Finding all proposals for branch-1 ... main                         |
      |          | Finding proposal from branch-1 into main ... #1 (branch-1 proposal) |
      |          | Finding proposal from branch-2 into branch-1 ... none               |
      |          | Finding proposal from branch-3 into branch-2 ... none               |
      |          | Update body for #1 ... ok                                           |
      |          | Finding all proposals for branch-2 ... none                         |
      |          | Finding all proposals for branch-3 ... none                         |
    And the initial lineage exists now
    And the initial branches exist now
    And the proposals are now
      """
      url: https://example.com/pr/1
      number: 1
      source: branch-1
      target: main
      body:
        branch-1 body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/1 :point_left:

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->
      """
