# Go API client for k6

HTTP API for interacting with Grafana Cloud k6.

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.

- API version: 1.7.1
- Generator version: 7.9.0

## Documentation for API Endpoints

All URIs are relative to *https://api.k6.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthorizationAPI* | [**Auth**](docs/AuthorizationAPI.md#auth) | **Get** /cloud/v6/auth | Validate a Grafana Cloud k6 API token and access to the stack.
*LoadTestsAPI* | [**LoadTestsDestroy**](docs/LoadTestsAPI.md#loadtestsdestroy) | **Delete** /cloud/v6/load_tests/{id} | Delete a load test.
*LoadTestsAPI* | [**LoadTestsList**](docs/LoadTestsAPI.md#loadtestslist) | **Get** /cloud/v6/load_tests | List all tests.
*LoadTestsAPI* | [**LoadTestsMove**](docs/LoadTestsAPI.md#loadtestsmove) | **Put** /cloud/v6/load_tests/{id}/move | Move a test to another project.
*LoadTestsAPI* | [**LoadTestsPartialUpdate**](docs/LoadTestsAPI.md#loadtestspartialupdate) | **Patch** /cloud/v6/load_tests/{id} | Update a load test.
*LoadTestsAPI* | [**LoadTestsRetrieve**](docs/LoadTestsAPI.md#loadtestsretrieve) | **Get** /cloud/v6/load_tests/{id} | Get a load test by ID.
*LoadTestsAPI* | [**LoadTestsScriptRetrieve**](docs/LoadTestsAPI.md#loadtestsscriptretrieve) | **Get** /cloud/v6/load_tests/{id}/script | Download the test script.
*LoadTestsAPI* | [**LoadTestsScriptUpdate**](docs/LoadTestsAPI.md#loadtestsscriptupdate) | **Put** /cloud/v6/load_tests/{id}/script | Upload the script for a test.
*LoadTestsAPI* | [**LoadTestsStart**](docs/LoadTestsAPI.md#loadtestsstart) | **Post** /cloud/v6/load_tests/{id}/start | Start a test in Grafana Cloud.
*LoadTestsAPI* | [**ProjectsLoadTestsCreate**](docs/LoadTestsAPI.md#projectsloadtestscreate) | **Post** /cloud/v6/projects/{id}/load_tests | Create a new test.
*LoadTestsAPI* | [**ProjectsLoadTestsRetrieve**](docs/LoadTestsAPI.md#projectsloadtestsretrieve) | **Get** /cloud/v6/projects/{id}/load_tests | List load tests in a project.
*LoadTestsAPI* | [**ValidateOptions**](docs/LoadTestsAPI.md#validateoptions) | **Post** /cloud/v6/validate_options | Validate k6 script options.
*LoadZonesAPI* | [**LoadZonesAllowedProjectsRetrieve**](docs/LoadZonesAPI.md#loadzonesallowedprojectsretrieve) | **Get** /cloud/v6/load_zones/{id}/allowed_projects | List projects allowed to use a given private load zone.
*LoadZonesAPI* | [**LoadZonesAllowedProjectsUpdate**](docs/LoadZonesAPI.md#loadzonesallowedprojectsupdate) | **Put** /cloud/v6/load_zones/{id}/allowed_projects | Update the list of projects allowed to use a given private load zone.
*LoadZonesAPI* | [**LoadZonesList**](docs/LoadZonesAPI.md#loadzoneslist) | **Get** /cloud/v6/load_zones | List all load zones.
*LoadZonesAPI* | [**ProjectsAllowedLoadZonesRetrieve**](docs/LoadZonesAPI.md#projectsallowedloadzonesretrieve) | **Get** /cloud/v6/projects/{id}/allowed_load_zones | List private load zones that can be used by a given project.
*LoadZonesAPI* | [**ProjectsAllowedLoadZonesUpdate**](docs/LoadZonesAPI.md#projectsallowedloadzonesupdate) | **Put** /cloud/v6/projects/{id}/allowed_load_zones | Update the list of private load zones that can be used by a given project.
*ProjectsAPI* | [**ProjectLimitsRetrieve**](docs/ProjectsAPI.md#projectlimitsretrieve) | **Get** /cloud/v6/project-limits | List limits for all projects.
*ProjectsAPI* | [**ProjectsCreate**](docs/ProjectsAPI.md#projectscreate) | **Post** /cloud/v6/projects | Create a project.
*ProjectsAPI* | [**ProjectsDestroy**](docs/ProjectsAPI.md#projectsdestroy) | **Delete** /cloud/v6/projects/{id} | Delete a project.
*ProjectsAPI* | [**ProjectsLimitsPartialUpdate**](docs/ProjectsAPI.md#projectslimitspartialupdate) | **Patch** /cloud/v6/projects/{id}/limits | Update project limits.
*ProjectsAPI* | [**ProjectsLimitsRetrieve**](docs/ProjectsAPI.md#projectslimitsretrieve) | **Get** /cloud/v6/projects/{id}/limits | Get project limits.
*ProjectsAPI* | [**ProjectsList**](docs/ProjectsAPI.md#projectslist) | **Get** /cloud/v6/projects | List all projects.
*ProjectsAPI* | [**ProjectsPartialUpdate**](docs/ProjectsAPI.md#projectspartialupdate) | **Patch** /cloud/v6/projects/{id} | Update a project.
*ProjectsAPI* | [**ProjectsRetrieve**](docs/ProjectsAPI.md#projectsretrieve) | **Get** /cloud/v6/projects/{id} | Get a project by ID.
*SchedulesAPI* | [**LoadTestsScheduleCreate**](docs/SchedulesAPI.md#loadtestsschedulecreate) | **Post** /cloud/v6/load_tests/{id}/schedule | Set a schedule for the load test.
*SchedulesAPI* | [**LoadTestsScheduleRetrieve**](docs/SchedulesAPI.md#loadtestsscheduleretrieve) | **Get** /cloud/v6/load_tests/{id}/schedule | Get the load test schedule.
*SchedulesAPI* | [**ScheduleActivate**](docs/SchedulesAPI.md#scheduleactivate) | **Post** /cloud/v6/schedules/{id}/activate | Re-activate deactivated schedule.
*SchedulesAPI* | [**ScheduleDeactivate**](docs/SchedulesAPI.md#scheduledeactivate) | **Post** /cloud/v6/schedules/{id}/deactivate | Deactivate a schedule.
*SchedulesAPI* | [**SchedulesDestroy**](docs/SchedulesAPI.md#schedulesdestroy) | **Delete** /cloud/v6/schedules/{id} | Delete a schedule.
*SchedulesAPI* | [**SchedulesList**](docs/SchedulesAPI.md#scheduleslist) | **Get** /cloud/v6/schedules | List all schedules.
*SchedulesAPI* | [**SchedulesRetrieve**](docs/SchedulesAPI.md#schedulesretrieve) | **Get** /cloud/v6/schedules/{id} | Get a schedule by ID.
*TestRunsAPI* | [**LoadTestsTestRunsRetrieve**](docs/TestRunsAPI.md#loadteststestrunsretrieve) | **Get** /cloud/v6/load_tests/{id}/test_runs | List all runs of a load test.
*TestRunsAPI* | [**TestRunsAbort**](docs/TestRunsAPI.md#testrunsabort) | **Post** /cloud/v6/test_runs/{id}/abort | Abort a running test.
*TestRunsAPI* | [**TestRunsDestroy**](docs/TestRunsAPI.md#testrunsdestroy) | **Delete** /cloud/v6/test_runs/{id} | Delete a test run.
*TestRunsAPI* | [**TestRunsDistributionRetrieve**](docs/TestRunsAPI.md#testrunsdistributionretrieve) | **Get** /cloud/v6/test_runs/{id}/distribution | Get test run distribution.
*TestRunsAPI* | [**TestRunsList**](docs/TestRunsAPI.md#testrunslist) | **Get** /cloud/v6/test_runs | List all test runs.
*TestRunsAPI* | [**TestRunsPartialUpdate**](docs/TestRunsAPI.md#testrunspartialupdate) | **Patch** /cloud/v6/test_runs/{id} | Update a test run.
*TestRunsAPI* | [**TestRunsRetrieve**](docs/TestRunsAPI.md#testrunsretrieve) | **Get** /cloud/v6/test_runs/{id} | Get a test run by ID.
*TestRunsAPI* | [**TestRunsSave**](docs/TestRunsAPI.md#testrunssave) | **Post** /cloud/v6/test_runs/{id}/save | Save test run results.
*TestRunsAPI* | [**TestRunsScriptRetrieve**](docs/TestRunsAPI.md#testrunsscriptretrieve) | **Get** /cloud/v6/test_runs/{id}/script | Download the test run script.
*TestRunsAPI* | [**TestRunsUnsave**](docs/TestRunsAPI.md#testrunsunsave) | **Post** /cloud/v6/test_runs/{id}/unsave | Unsave test run results.


## Documentation For Models

 - [AllowedLoadZoneApiModel](docs/AllowedLoadZoneApiModel.md)
 - [AllowedLoadZoneToUpdateApiModel](docs/AllowedLoadZoneToUpdateApiModel.md)
 - [AllowedLoadZonesListApiModel](docs/AllowedLoadZonesListApiModel.md)
 - [AllowedProjectApiModel](docs/AllowedProjectApiModel.md)
 - [AllowedProjectToUpdateApiModel](docs/AllowedProjectToUpdateApiModel.md)
 - [AllowedProjectsListApiModel](docs/AllowedProjectsListApiModel.md)
 - [AuthenticationResponse](docs/AuthenticationResponse.md)
 - [BaseTotalVuh](docs/BaseTotalVuh.md)
 - [BrowserVuh](docs/BrowserVuh.md)
 - [CloudOptions](docs/CloudOptions.md)
 - [CostBreakdownApiModel](docs/CostBreakdownApiModel.md)
 - [CreateProjectApiModel](docs/CreateProjectApiModel.md)
 - [CreateScheduleRequest](docs/CreateScheduleRequest.md)
 - [DistributionZoneApiModel](docs/DistributionZoneApiModel.md)
 - [ErrorApiModel](docs/ErrorApiModel.md)
 - [ErrorDetailsApiModel](docs/ErrorDetailsApiModel.md)
 - [ErrorResponseApiModel](docs/ErrorResponseApiModel.md)
 - [Frequency](docs/Frequency.md)
 - [LoadTestApiModel](docs/LoadTestApiModel.md)
 - [LoadTestListResponse](docs/LoadTestListResponse.md)
 - [LoadZoneApiModel](docs/LoadZoneApiModel.md)
 - [LoadZoneDistributionApiModel](docs/LoadZoneDistributionApiModel.md)
 - [LoadZonesListApiModel](docs/LoadZonesListApiModel.md)
 - [MoveLoadTestApiModel](docs/MoveLoadTestApiModel.md)
 - [NodeApiModel](docs/NodeApiModel.md)
 - [Options](docs/Options.md)
 - [OptionsCloud](docs/OptionsCloud.md)
 - [PatchLoadTestApiModel](docs/PatchLoadTestApiModel.md)
 - [PatchProjectApiModel](docs/PatchProjectApiModel.md)
 - [PatchProjectLimitsRequest](docs/PatchProjectLimitsRequest.md)
 - [PatchTestRunApiModel](docs/PatchTestRunApiModel.md)
 - [ProjectApiModel](docs/ProjectApiModel.md)
 - [ProjectLimitsApiModel](docs/ProjectLimitsApiModel.md)
 - [ProjectLimitsListResponse](docs/ProjectLimitsListResponse.md)
 - [ProjectListResponse](docs/ProjectListResponse.md)
 - [ProtocolVuh](docs/ProtocolVuh.md)
 - [ReductionRate](docs/ReductionRate.md)
 - [ReductionRateBreakdownValue](docs/ReductionRateBreakdownValue.md)
 - [ScheduleApiModel](docs/ScheduleApiModel.md)
 - [ScheduleCron](docs/ScheduleCron.md)
 - [ScheduleListResponse](docs/ScheduleListResponse.md)
 - [ScheduleRecurrenceRule](docs/ScheduleRecurrenceRule.md)
 - [StatusApiModel](docs/StatusApiModel.md)
 - [StatusExtraApiModel](docs/StatusExtraApiModel.md)
 - [TestCostApiModel](docs/TestCostApiModel.md)
 - [TestRunApiModel](docs/TestRunApiModel.md)
 - [TestRunDistributionApiModel](docs/TestRunDistributionApiModel.md)
 - [TestRunListResponse](docs/TestRunListResponse.md)
 - [TotalVuh](docs/TotalVuh.md)
 - [UpdateAllowedLoadZonesListApiModel](docs/UpdateAllowedLoadZonesListApiModel.md)
 - [UpdateAllowedProjectsListApiModel](docs/UpdateAllowedProjectsListApiModel.md)
 - [ValidateOptionsRequest](docs/ValidateOptionsRequest.md)
 - [ValidateOptionsResponse](docs/ValidateOptionsResponse.md)
 - [Weekday](docs/Weekday.md)


## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author

info@grafana.com
