/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the LoadZoneApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &LoadZoneApiModel{}

// LoadZoneApiModel struct for LoadZoneApiModel
type LoadZoneApiModel struct {
	// ID of the load zone.
	Id int32 `json:"id"`
	// Name of the load zone.
	Name string `json:"name"`
	// ID used to identify the load zone in the k6 scripts.
	K6LoadZoneId         string `json:"k6_load_zone_id"`
	AdditionalProperties map[string]interface{}
}

type _LoadZoneApiModel LoadZoneApiModel

// NewLoadZoneApiModel instantiates a new LoadZoneApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewLoadZoneApiModel(id int32, name string, k6LoadZoneId string) *LoadZoneApiModel {
	this := LoadZoneApiModel{}
	this.Id = id
	this.Name = name
	this.K6LoadZoneId = k6LoadZoneId
	return &this
}

// NewLoadZoneApiModelWithDefaults instantiates a new LoadZoneApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewLoadZoneApiModelWithDefaults() *LoadZoneApiModel {
	this := LoadZoneApiModel{}
	return &this
}

// GetId returns the Id field value
func (o *LoadZoneApiModel) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *LoadZoneApiModel) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *LoadZoneApiModel) SetId(v int32) {
	o.Id = v
}

// GetName returns the Name field value
func (o *LoadZoneApiModel) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *LoadZoneApiModel) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *LoadZoneApiModel) SetName(v string) {
	o.Name = v
}

// GetK6LoadZoneId returns the K6LoadZoneId field value
func (o *LoadZoneApiModel) GetK6LoadZoneId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.K6LoadZoneId
}

// GetK6LoadZoneIdOk returns a tuple with the K6LoadZoneId field value
// and a boolean to check if the value has been set.
func (o *LoadZoneApiModel) GetK6LoadZoneIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.K6LoadZoneId, true
}

// SetK6LoadZoneId sets field value
func (o *LoadZoneApiModel) SetK6LoadZoneId(v string) {
	o.K6LoadZoneId = v
}

func (o LoadZoneApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o LoadZoneApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["name"] = o.Name
	toSerialize["k6_load_zone_id"] = o.K6LoadZoneId

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *LoadZoneApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"name",
		"k6_load_zone_id",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varLoadZoneApiModel := _LoadZoneApiModel{}

	err = json.Unmarshal(data, &varLoadZoneApiModel)

	if err != nil {
		return err
	}

	*o = LoadZoneApiModel(varLoadZoneApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "id")
		delete(additionalProperties, "name")
		delete(additionalProperties, "k6_load_zone_id")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableLoadZoneApiModel struct {
	value *LoadZoneApiModel
	isSet bool
}

func (v NullableLoadZoneApiModel) Get() *LoadZoneApiModel {
	return v.value
}

func (v *NullableLoadZoneApiModel) Set(val *LoadZoneApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableLoadZoneApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableLoadZoneApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableLoadZoneApiModel(val *LoadZoneApiModel) *NullableLoadZoneApiModel {
	return &NullableLoadZoneApiModel{value: val, isSet: true}
}

func (v NullableLoadZoneApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableLoadZoneApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
