/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
)

// checks if the PatchProjectLimitsRequest type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PatchProjectLimitsRequest{}

// PatchProjectLimitsRequest struct for PatchProjectLimitsRequest
type PatchProjectLimitsRequest struct {
	// Max amount of virtual user hours (VUH) used per one calendar month.
	VuhMaxPerMonth NullableInt32 `json:"vuh_max_per_month,omitempty"`
	// Max number of concurrent virtual users (VUs) used in one test.
	VuMaxPerTest NullableInt32 `json:"vu_max_per_test,omitempty"`
	// Max number of concurrent browser virtual users (VUs) used in one test.
	VuBrowserMaxPerTest NullableInt32 `json:"vu_browser_max_per_test,omitempty"`
	// Max duration of a test in seconds.
	DurationMaxPerTest   NullableInt32 `json:"duration_max_per_test,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PatchProjectLimitsRequest PatchProjectLimitsRequest

// NewPatchProjectLimitsRequest instantiates a new PatchProjectLimitsRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPatchProjectLimitsRequest() *PatchProjectLimitsRequest {
	this := PatchProjectLimitsRequest{}
	return &this
}

// NewPatchProjectLimitsRequestWithDefaults instantiates a new PatchProjectLimitsRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPatchProjectLimitsRequestWithDefaults() *PatchProjectLimitsRequest {
	this := PatchProjectLimitsRequest{}
	return &this
}

// GetVuhMaxPerMonth returns the VuhMaxPerMonth field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatchProjectLimitsRequest) GetVuhMaxPerMonth() int32 {
	if o == nil || IsNil(o.VuhMaxPerMonth.Get()) {
		var ret int32
		return ret
	}
	return *o.VuhMaxPerMonth.Get()
}

// GetVuhMaxPerMonthOk returns a tuple with the VuhMaxPerMonth field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatchProjectLimitsRequest) GetVuhMaxPerMonthOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.VuhMaxPerMonth.Get(), o.VuhMaxPerMonth.IsSet()
}

// HasVuhMaxPerMonth returns a boolean if a field has been set.
func (o *PatchProjectLimitsRequest) HasVuhMaxPerMonth() bool {
	if o != nil && o.VuhMaxPerMonth.IsSet() {
		return true
	}

	return false
}

// SetVuhMaxPerMonth gets a reference to the given NullableInt32 and assigns it to the VuhMaxPerMonth field.
func (o *PatchProjectLimitsRequest) SetVuhMaxPerMonth(v int32) {
	o.VuhMaxPerMonth.Set(&v)
}

// SetVuhMaxPerMonthNil sets the value for VuhMaxPerMonth to be an explicit nil
func (o *PatchProjectLimitsRequest) SetVuhMaxPerMonthNil() {
	o.VuhMaxPerMonth.Set(nil)
}

// UnsetVuhMaxPerMonth ensures that no value is present for VuhMaxPerMonth, not even an explicit nil
func (o *PatchProjectLimitsRequest) UnsetVuhMaxPerMonth() {
	o.VuhMaxPerMonth.Unset()
}

// GetVuMaxPerTest returns the VuMaxPerTest field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatchProjectLimitsRequest) GetVuMaxPerTest() int32 {
	if o == nil || IsNil(o.VuMaxPerTest.Get()) {
		var ret int32
		return ret
	}
	return *o.VuMaxPerTest.Get()
}

// GetVuMaxPerTestOk returns a tuple with the VuMaxPerTest field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatchProjectLimitsRequest) GetVuMaxPerTestOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.VuMaxPerTest.Get(), o.VuMaxPerTest.IsSet()
}

// HasVuMaxPerTest returns a boolean if a field has been set.
func (o *PatchProjectLimitsRequest) HasVuMaxPerTest() bool {
	if o != nil && o.VuMaxPerTest.IsSet() {
		return true
	}

	return false
}

// SetVuMaxPerTest gets a reference to the given NullableInt32 and assigns it to the VuMaxPerTest field.
func (o *PatchProjectLimitsRequest) SetVuMaxPerTest(v int32) {
	o.VuMaxPerTest.Set(&v)
}

// SetVuMaxPerTestNil sets the value for VuMaxPerTest to be an explicit nil
func (o *PatchProjectLimitsRequest) SetVuMaxPerTestNil() {
	o.VuMaxPerTest.Set(nil)
}

// UnsetVuMaxPerTest ensures that no value is present for VuMaxPerTest, not even an explicit nil
func (o *PatchProjectLimitsRequest) UnsetVuMaxPerTest() {
	o.VuMaxPerTest.Unset()
}

// GetVuBrowserMaxPerTest returns the VuBrowserMaxPerTest field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatchProjectLimitsRequest) GetVuBrowserMaxPerTest() int32 {
	if o == nil || IsNil(o.VuBrowserMaxPerTest.Get()) {
		var ret int32
		return ret
	}
	return *o.VuBrowserMaxPerTest.Get()
}

// GetVuBrowserMaxPerTestOk returns a tuple with the VuBrowserMaxPerTest field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatchProjectLimitsRequest) GetVuBrowserMaxPerTestOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.VuBrowserMaxPerTest.Get(), o.VuBrowserMaxPerTest.IsSet()
}

// HasVuBrowserMaxPerTest returns a boolean if a field has been set.
func (o *PatchProjectLimitsRequest) HasVuBrowserMaxPerTest() bool {
	if o != nil && o.VuBrowserMaxPerTest.IsSet() {
		return true
	}

	return false
}

// SetVuBrowserMaxPerTest gets a reference to the given NullableInt32 and assigns it to the VuBrowserMaxPerTest field.
func (o *PatchProjectLimitsRequest) SetVuBrowserMaxPerTest(v int32) {
	o.VuBrowserMaxPerTest.Set(&v)
}

// SetVuBrowserMaxPerTestNil sets the value for VuBrowserMaxPerTest to be an explicit nil
func (o *PatchProjectLimitsRequest) SetVuBrowserMaxPerTestNil() {
	o.VuBrowserMaxPerTest.Set(nil)
}

// UnsetVuBrowserMaxPerTest ensures that no value is present for VuBrowserMaxPerTest, not even an explicit nil
func (o *PatchProjectLimitsRequest) UnsetVuBrowserMaxPerTest() {
	o.VuBrowserMaxPerTest.Unset()
}

// GetDurationMaxPerTest returns the DurationMaxPerTest field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatchProjectLimitsRequest) GetDurationMaxPerTest() int32 {
	if o == nil || IsNil(o.DurationMaxPerTest.Get()) {
		var ret int32
		return ret
	}
	return *o.DurationMaxPerTest.Get()
}

// GetDurationMaxPerTestOk returns a tuple with the DurationMaxPerTest field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatchProjectLimitsRequest) GetDurationMaxPerTestOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.DurationMaxPerTest.Get(), o.DurationMaxPerTest.IsSet()
}

// HasDurationMaxPerTest returns a boolean if a field has been set.
func (o *PatchProjectLimitsRequest) HasDurationMaxPerTest() bool {
	if o != nil && o.DurationMaxPerTest.IsSet() {
		return true
	}

	return false
}

// SetDurationMaxPerTest gets a reference to the given NullableInt32 and assigns it to the DurationMaxPerTest field.
func (o *PatchProjectLimitsRequest) SetDurationMaxPerTest(v int32) {
	o.DurationMaxPerTest.Set(&v)
}

// SetDurationMaxPerTestNil sets the value for DurationMaxPerTest to be an explicit nil
func (o *PatchProjectLimitsRequest) SetDurationMaxPerTestNil() {
	o.DurationMaxPerTest.Set(nil)
}

// UnsetDurationMaxPerTest ensures that no value is present for DurationMaxPerTest, not even an explicit nil
func (o *PatchProjectLimitsRequest) UnsetDurationMaxPerTest() {
	o.DurationMaxPerTest.Unset()
}

func (o PatchProjectLimitsRequest) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PatchProjectLimitsRequest) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if o.VuhMaxPerMonth.IsSet() {
		toSerialize["vuh_max_per_month"] = o.VuhMaxPerMonth.Get()
	}
	if o.VuMaxPerTest.IsSet() {
		toSerialize["vu_max_per_test"] = o.VuMaxPerTest.Get()
	}
	if o.VuBrowserMaxPerTest.IsSet() {
		toSerialize["vu_browser_max_per_test"] = o.VuBrowserMaxPerTest.Get()
	}
	if o.DurationMaxPerTest.IsSet() {
		toSerialize["duration_max_per_test"] = o.DurationMaxPerTest.Get()
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PatchProjectLimitsRequest) UnmarshalJSON(data []byte) (err error) {
	varPatchProjectLimitsRequest := _PatchProjectLimitsRequest{}

	err = json.Unmarshal(data, &varPatchProjectLimitsRequest)

	if err != nil {
		return err
	}

	*o = PatchProjectLimitsRequest(varPatchProjectLimitsRequest)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "vuh_max_per_month")
		delete(additionalProperties, "vu_max_per_test")
		delete(additionalProperties, "vu_browser_max_per_test")
		delete(additionalProperties, "duration_max_per_test")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePatchProjectLimitsRequest struct {
	value *PatchProjectLimitsRequest
	isSet bool
}

func (v NullablePatchProjectLimitsRequest) Get() *PatchProjectLimitsRequest {
	return v.value
}

func (v *NullablePatchProjectLimitsRequest) Set(val *PatchProjectLimitsRequest) {
	v.value = val
	v.isSet = true
}

func (v NullablePatchProjectLimitsRequest) IsSet() bool {
	return v.isSet
}

func (v *NullablePatchProjectLimitsRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePatchProjectLimitsRequest(val *PatchProjectLimitsRequest) *NullablePatchProjectLimitsRequest {
	return &NullablePatchProjectLimitsRequest{value: val, isSet: true}
}

func (v NullablePatchProjectLimitsRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePatchProjectLimitsRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
