/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify

package testing

import (
	"context"

	mock "github.com/stretchr/testify/mock"
	"k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/types"
	"k8s.io/apiserver/pkg/server/healthz"
	"k8s.io/cri-api/pkg/apis"
	"k8s.io/klog/v2"
	v10 "k8s.io/kubelet/pkg/apis/podresources/v1"
	"k8s.io/kubernetes/pkg/kubelet/cm"
	"k8s.io/kubernetes/pkg/kubelet/cm/resourceupdates"
	"k8s.io/kubernetes/pkg/kubelet/config"
	"k8s.io/kubernetes/pkg/kubelet/container"
	"k8s.io/kubernetes/pkg/kubelet/lifecycle"
	"k8s.io/kubernetes/pkg/kubelet/pluginmanager/cache"
	"k8s.io/kubernetes/pkg/kubelet/status"
	"k8s.io/kubernetes/pkg/scheduler/framework"
)

// NewMockContainerManager creates a new instance of MockContainerManager. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockContainerManager(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockContainerManager {
	mock := &MockContainerManager{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockContainerManager is an autogenerated mock type for the ContainerManager type
type MockContainerManager struct {
	mock.Mock
}

type MockContainerManager_Expecter struct {
	mock *mock.Mock
}

func (_m *MockContainerManager) EXPECT() *MockContainerManager_Expecter {
	return &MockContainerManager_Expecter{mock: &_m.Mock}
}

// ContainerHasExclusiveCPUs provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) ContainerHasExclusiveCPUs(pod *v1.Pod, container *v1.Container) bool {
	ret := _mock.Called(pod, container)

	if len(ret) == 0 {
		panic("no return value specified for ContainerHasExclusiveCPUs")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod, *v1.Container) bool); ok {
		r0 = returnFunc(pod, container)
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockContainerManager_ContainerHasExclusiveCPUs_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ContainerHasExclusiveCPUs'
type MockContainerManager_ContainerHasExclusiveCPUs_Call struct {
	*mock.Call
}

// ContainerHasExclusiveCPUs is a helper method to define mock.On call
//   - pod *v1.Pod
//   - container *v1.Container
func (_e *MockContainerManager_Expecter) ContainerHasExclusiveCPUs(pod interface{}, container interface{}) *MockContainerManager_ContainerHasExclusiveCPUs_Call {
	return &MockContainerManager_ContainerHasExclusiveCPUs_Call{Call: _e.mock.On("ContainerHasExclusiveCPUs", pod, container)}
}

func (_c *MockContainerManager_ContainerHasExclusiveCPUs_Call) Run(run func(pod *v1.Pod, container *v1.Container)) *MockContainerManager_ContainerHasExclusiveCPUs_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		var arg1 *v1.Container
		if args[1] != nil {
			arg1 = args[1].(*v1.Container)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockContainerManager_ContainerHasExclusiveCPUs_Call) Return(b bool) *MockContainerManager_ContainerHasExclusiveCPUs_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockContainerManager_ContainerHasExclusiveCPUs_Call) RunAndReturn(run func(pod *v1.Pod, container *v1.Container) bool) *MockContainerManager_ContainerHasExclusiveCPUs_Call {
	_c.Call.Return(run)
	return _c
}

// GetAllocatableCPUs provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetAllocatableCPUs() []int64 {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetAllocatableCPUs")
	}

	var r0 []int64
	if returnFunc, ok := ret.Get(0).(func() []int64); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]int64)
		}
	}
	return r0
}

// MockContainerManager_GetAllocatableCPUs_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetAllocatableCPUs'
type MockContainerManager_GetAllocatableCPUs_Call struct {
	*mock.Call
}

// GetAllocatableCPUs is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) GetAllocatableCPUs() *MockContainerManager_GetAllocatableCPUs_Call {
	return &MockContainerManager_GetAllocatableCPUs_Call{Call: _e.mock.On("GetAllocatableCPUs")}
}

func (_c *MockContainerManager_GetAllocatableCPUs_Call) Run(run func()) *MockContainerManager_GetAllocatableCPUs_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_GetAllocatableCPUs_Call) Return(int64s []int64) *MockContainerManager_GetAllocatableCPUs_Call {
	_c.Call.Return(int64s)
	return _c
}

func (_c *MockContainerManager_GetAllocatableCPUs_Call) RunAndReturn(run func() []int64) *MockContainerManager_GetAllocatableCPUs_Call {
	_c.Call.Return(run)
	return _c
}

// GetAllocatableDevices provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetAllocatableDevices() []*v10.ContainerDevices {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetAllocatableDevices")
	}

	var r0 []*v10.ContainerDevices
	if returnFunc, ok := ret.Get(0).(func() []*v10.ContainerDevices); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v10.ContainerDevices)
		}
	}
	return r0
}

// MockContainerManager_GetAllocatableDevices_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetAllocatableDevices'
type MockContainerManager_GetAllocatableDevices_Call struct {
	*mock.Call
}

// GetAllocatableDevices is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) GetAllocatableDevices() *MockContainerManager_GetAllocatableDevices_Call {
	return &MockContainerManager_GetAllocatableDevices_Call{Call: _e.mock.On("GetAllocatableDevices")}
}

func (_c *MockContainerManager_GetAllocatableDevices_Call) Run(run func()) *MockContainerManager_GetAllocatableDevices_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_GetAllocatableDevices_Call) Return(containerDevicess []*v10.ContainerDevices) *MockContainerManager_GetAllocatableDevices_Call {
	_c.Call.Return(containerDevicess)
	return _c
}

func (_c *MockContainerManager_GetAllocatableDevices_Call) RunAndReturn(run func() []*v10.ContainerDevices) *MockContainerManager_GetAllocatableDevices_Call {
	_c.Call.Return(run)
	return _c
}

// GetAllocatableMemory provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetAllocatableMemory() []*v10.ContainerMemory {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetAllocatableMemory")
	}

	var r0 []*v10.ContainerMemory
	if returnFunc, ok := ret.Get(0).(func() []*v10.ContainerMemory); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v10.ContainerMemory)
		}
	}
	return r0
}

// MockContainerManager_GetAllocatableMemory_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetAllocatableMemory'
type MockContainerManager_GetAllocatableMemory_Call struct {
	*mock.Call
}

// GetAllocatableMemory is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) GetAllocatableMemory() *MockContainerManager_GetAllocatableMemory_Call {
	return &MockContainerManager_GetAllocatableMemory_Call{Call: _e.mock.On("GetAllocatableMemory")}
}

func (_c *MockContainerManager_GetAllocatableMemory_Call) Run(run func()) *MockContainerManager_GetAllocatableMemory_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_GetAllocatableMemory_Call) Return(containerMemorys []*v10.ContainerMemory) *MockContainerManager_GetAllocatableMemory_Call {
	_c.Call.Return(containerMemorys)
	return _c
}

func (_c *MockContainerManager_GetAllocatableMemory_Call) RunAndReturn(run func() []*v10.ContainerMemory) *MockContainerManager_GetAllocatableMemory_Call {
	_c.Call.Return(run)
	return _c
}

// GetAllocateResourcesPodAdmitHandler provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetAllocateResourcesPodAdmitHandler() lifecycle.PodAdmitHandler {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetAllocateResourcesPodAdmitHandler")
	}

	var r0 lifecycle.PodAdmitHandler
	if returnFunc, ok := ret.Get(0).(func() lifecycle.PodAdmitHandler); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(lifecycle.PodAdmitHandler)
		}
	}
	return r0
}

// MockContainerManager_GetAllocateResourcesPodAdmitHandler_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetAllocateResourcesPodAdmitHandler'
type MockContainerManager_GetAllocateResourcesPodAdmitHandler_Call struct {
	*mock.Call
}

// GetAllocateResourcesPodAdmitHandler is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) GetAllocateResourcesPodAdmitHandler() *MockContainerManager_GetAllocateResourcesPodAdmitHandler_Call {
	return &MockContainerManager_GetAllocateResourcesPodAdmitHandler_Call{Call: _e.mock.On("GetAllocateResourcesPodAdmitHandler")}
}

func (_c *MockContainerManager_GetAllocateResourcesPodAdmitHandler_Call) Run(run func()) *MockContainerManager_GetAllocateResourcesPodAdmitHandler_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_GetAllocateResourcesPodAdmitHandler_Call) Return(podAdmitHandler lifecycle.PodAdmitHandler) *MockContainerManager_GetAllocateResourcesPodAdmitHandler_Call {
	_c.Call.Return(podAdmitHandler)
	return _c
}

func (_c *MockContainerManager_GetAllocateResourcesPodAdmitHandler_Call) RunAndReturn(run func() lifecycle.PodAdmitHandler) *MockContainerManager_GetAllocateResourcesPodAdmitHandler_Call {
	_c.Call.Return(run)
	return _c
}

// GetCPUs provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetCPUs(podUID string, containerName string) []int64 {
	ret := _mock.Called(podUID, containerName)

	if len(ret) == 0 {
		panic("no return value specified for GetCPUs")
	}

	var r0 []int64
	if returnFunc, ok := ret.Get(0).(func(string, string) []int64); ok {
		r0 = returnFunc(podUID, containerName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]int64)
		}
	}
	return r0
}

// MockContainerManager_GetCPUs_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetCPUs'
type MockContainerManager_GetCPUs_Call struct {
	*mock.Call
}

// GetCPUs is a helper method to define mock.On call
//   - podUID string
//   - containerName string
func (_e *MockContainerManager_Expecter) GetCPUs(podUID interface{}, containerName interface{}) *MockContainerManager_GetCPUs_Call {
	return &MockContainerManager_GetCPUs_Call{Call: _e.mock.On("GetCPUs", podUID, containerName)}
}

func (_c *MockContainerManager_GetCPUs_Call) Run(run func(podUID string, containerName string)) *MockContainerManager_GetCPUs_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockContainerManager_GetCPUs_Call) Return(int64s []int64) *MockContainerManager_GetCPUs_Call {
	_c.Call.Return(int64s)
	return _c
}

func (_c *MockContainerManager_GetCPUs_Call) RunAndReturn(run func(podUID string, containerName string) []int64) *MockContainerManager_GetCPUs_Call {
	_c.Call.Return(run)
	return _c
}

// GetCapacity provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetCapacity(localStorageCapacityIsolation bool) v1.ResourceList {
	ret := _mock.Called(localStorageCapacityIsolation)

	if len(ret) == 0 {
		panic("no return value specified for GetCapacity")
	}

	var r0 v1.ResourceList
	if returnFunc, ok := ret.Get(0).(func(bool) v1.ResourceList); ok {
		r0 = returnFunc(localStorageCapacityIsolation)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(v1.ResourceList)
		}
	}
	return r0
}

// MockContainerManager_GetCapacity_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetCapacity'
type MockContainerManager_GetCapacity_Call struct {
	*mock.Call
}

// GetCapacity is a helper method to define mock.On call
//   - localStorageCapacityIsolation bool
func (_e *MockContainerManager_Expecter) GetCapacity(localStorageCapacityIsolation interface{}) *MockContainerManager_GetCapacity_Call {
	return &MockContainerManager_GetCapacity_Call{Call: _e.mock.On("GetCapacity", localStorageCapacityIsolation)}
}

func (_c *MockContainerManager_GetCapacity_Call) Run(run func(localStorageCapacityIsolation bool)) *MockContainerManager_GetCapacity_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 bool
		if args[0] != nil {
			arg0 = args[0].(bool)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockContainerManager_GetCapacity_Call) Return(resourceList v1.ResourceList) *MockContainerManager_GetCapacity_Call {
	_c.Call.Return(resourceList)
	return _c
}

func (_c *MockContainerManager_GetCapacity_Call) RunAndReturn(run func(localStorageCapacityIsolation bool) v1.ResourceList) *MockContainerManager_GetCapacity_Call {
	_c.Call.Return(run)
	return _c
}

// GetDevicePluginResourceCapacity provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetDevicePluginResourceCapacity() (v1.ResourceList, v1.ResourceList, []string) {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetDevicePluginResourceCapacity")
	}

	var r0 v1.ResourceList
	var r1 v1.ResourceList
	var r2 []string
	if returnFunc, ok := ret.Get(0).(func() (v1.ResourceList, v1.ResourceList, []string)); ok {
		return returnFunc()
	}
	if returnFunc, ok := ret.Get(0).(func() v1.ResourceList); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(v1.ResourceList)
		}
	}
	if returnFunc, ok := ret.Get(1).(func() v1.ResourceList); ok {
		r1 = returnFunc()
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(v1.ResourceList)
		}
	}
	if returnFunc, ok := ret.Get(2).(func() []string); ok {
		r2 = returnFunc()
	} else {
		if ret.Get(2) != nil {
			r2 = ret.Get(2).([]string)
		}
	}
	return r0, r1, r2
}

// MockContainerManager_GetDevicePluginResourceCapacity_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetDevicePluginResourceCapacity'
type MockContainerManager_GetDevicePluginResourceCapacity_Call struct {
	*mock.Call
}

// GetDevicePluginResourceCapacity is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) GetDevicePluginResourceCapacity() *MockContainerManager_GetDevicePluginResourceCapacity_Call {
	return &MockContainerManager_GetDevicePluginResourceCapacity_Call{Call: _e.mock.On("GetDevicePluginResourceCapacity")}
}

func (_c *MockContainerManager_GetDevicePluginResourceCapacity_Call) Run(run func()) *MockContainerManager_GetDevicePluginResourceCapacity_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_GetDevicePluginResourceCapacity_Call) Return(resourceList v1.ResourceList, resourceList1 v1.ResourceList, strings []string) *MockContainerManager_GetDevicePluginResourceCapacity_Call {
	_c.Call.Return(resourceList, resourceList1, strings)
	return _c
}

func (_c *MockContainerManager_GetDevicePluginResourceCapacity_Call) RunAndReturn(run func() (v1.ResourceList, v1.ResourceList, []string)) *MockContainerManager_GetDevicePluginResourceCapacity_Call {
	_c.Call.Return(run)
	return _c
}

// GetDevices provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetDevices(podUID string, containerName string) []*v10.ContainerDevices {
	ret := _mock.Called(podUID, containerName)

	if len(ret) == 0 {
		panic("no return value specified for GetDevices")
	}

	var r0 []*v10.ContainerDevices
	if returnFunc, ok := ret.Get(0).(func(string, string) []*v10.ContainerDevices); ok {
		r0 = returnFunc(podUID, containerName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v10.ContainerDevices)
		}
	}
	return r0
}

// MockContainerManager_GetDevices_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetDevices'
type MockContainerManager_GetDevices_Call struct {
	*mock.Call
}

// GetDevices is a helper method to define mock.On call
//   - podUID string
//   - containerName string
func (_e *MockContainerManager_Expecter) GetDevices(podUID interface{}, containerName interface{}) *MockContainerManager_GetDevices_Call {
	return &MockContainerManager_GetDevices_Call{Call: _e.mock.On("GetDevices", podUID, containerName)}
}

func (_c *MockContainerManager_GetDevices_Call) Run(run func(podUID string, containerName string)) *MockContainerManager_GetDevices_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockContainerManager_GetDevices_Call) Return(containerDevicess []*v10.ContainerDevices) *MockContainerManager_GetDevices_Call {
	_c.Call.Return(containerDevicess)
	return _c
}

func (_c *MockContainerManager_GetDevices_Call) RunAndReturn(run func(podUID string, containerName string) []*v10.ContainerDevices) *MockContainerManager_GetDevices_Call {
	_c.Call.Return(run)
	return _c
}

// GetDynamicResources provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetDynamicResources(pod *v1.Pod, container *v1.Container) []*v10.DynamicResource {
	ret := _mock.Called(pod, container)

	if len(ret) == 0 {
		panic("no return value specified for GetDynamicResources")
	}

	var r0 []*v10.DynamicResource
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod, *v1.Container) []*v10.DynamicResource); ok {
		r0 = returnFunc(pod, container)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v10.DynamicResource)
		}
	}
	return r0
}

// MockContainerManager_GetDynamicResources_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetDynamicResources'
type MockContainerManager_GetDynamicResources_Call struct {
	*mock.Call
}

// GetDynamicResources is a helper method to define mock.On call
//   - pod *v1.Pod
//   - container *v1.Container
func (_e *MockContainerManager_Expecter) GetDynamicResources(pod interface{}, container interface{}) *MockContainerManager_GetDynamicResources_Call {
	return &MockContainerManager_GetDynamicResources_Call{Call: _e.mock.On("GetDynamicResources", pod, container)}
}

func (_c *MockContainerManager_GetDynamicResources_Call) Run(run func(pod *v1.Pod, container *v1.Container)) *MockContainerManager_GetDynamicResources_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		var arg1 *v1.Container
		if args[1] != nil {
			arg1 = args[1].(*v1.Container)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockContainerManager_GetDynamicResources_Call) Return(dynamicResources []*v10.DynamicResource) *MockContainerManager_GetDynamicResources_Call {
	_c.Call.Return(dynamicResources)
	return _c
}

func (_c *MockContainerManager_GetDynamicResources_Call) RunAndReturn(run func(pod *v1.Pod, container *v1.Container) []*v10.DynamicResource) *MockContainerManager_GetDynamicResources_Call {
	_c.Call.Return(run)
	return _c
}

// GetHealthCheckers provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetHealthCheckers() []healthz.HealthChecker {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetHealthCheckers")
	}

	var r0 []healthz.HealthChecker
	if returnFunc, ok := ret.Get(0).(func() []healthz.HealthChecker); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]healthz.HealthChecker)
		}
	}
	return r0
}

// MockContainerManager_GetHealthCheckers_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetHealthCheckers'
type MockContainerManager_GetHealthCheckers_Call struct {
	*mock.Call
}

// GetHealthCheckers is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) GetHealthCheckers() *MockContainerManager_GetHealthCheckers_Call {
	return &MockContainerManager_GetHealthCheckers_Call{Call: _e.mock.On("GetHealthCheckers")}
}

func (_c *MockContainerManager_GetHealthCheckers_Call) Run(run func()) *MockContainerManager_GetHealthCheckers_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_GetHealthCheckers_Call) Return(healthCheckers []healthz.HealthChecker) *MockContainerManager_GetHealthCheckers_Call {
	_c.Call.Return(healthCheckers)
	return _c
}

func (_c *MockContainerManager_GetHealthCheckers_Call) RunAndReturn(run func() []healthz.HealthChecker) *MockContainerManager_GetHealthCheckers_Call {
	_c.Call.Return(run)
	return _c
}

// GetMemory provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetMemory(podUID string, containerName string) []*v10.ContainerMemory {
	ret := _mock.Called(podUID, containerName)

	if len(ret) == 0 {
		panic("no return value specified for GetMemory")
	}

	var r0 []*v10.ContainerMemory
	if returnFunc, ok := ret.Get(0).(func(string, string) []*v10.ContainerMemory); ok {
		r0 = returnFunc(podUID, containerName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v10.ContainerMemory)
		}
	}
	return r0
}

// MockContainerManager_GetMemory_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetMemory'
type MockContainerManager_GetMemory_Call struct {
	*mock.Call
}

// GetMemory is a helper method to define mock.On call
//   - podUID string
//   - containerName string
func (_e *MockContainerManager_Expecter) GetMemory(podUID interface{}, containerName interface{}) *MockContainerManager_GetMemory_Call {
	return &MockContainerManager_GetMemory_Call{Call: _e.mock.On("GetMemory", podUID, containerName)}
}

func (_c *MockContainerManager_GetMemory_Call) Run(run func(podUID string, containerName string)) *MockContainerManager_GetMemory_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockContainerManager_GetMemory_Call) Return(containerMemorys []*v10.ContainerMemory) *MockContainerManager_GetMemory_Call {
	_c.Call.Return(containerMemorys)
	return _c
}

func (_c *MockContainerManager_GetMemory_Call) RunAndReturn(run func(podUID string, containerName string) []*v10.ContainerMemory) *MockContainerManager_GetMemory_Call {
	_c.Call.Return(run)
	return _c
}

// GetMountedSubsystems provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetMountedSubsystems() *cm.CgroupSubsystems {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetMountedSubsystems")
	}

	var r0 *cm.CgroupSubsystems
	if returnFunc, ok := ret.Get(0).(func() *cm.CgroupSubsystems); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*cm.CgroupSubsystems)
		}
	}
	return r0
}

// MockContainerManager_GetMountedSubsystems_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetMountedSubsystems'
type MockContainerManager_GetMountedSubsystems_Call struct {
	*mock.Call
}

// GetMountedSubsystems is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) GetMountedSubsystems() *MockContainerManager_GetMountedSubsystems_Call {
	return &MockContainerManager_GetMountedSubsystems_Call{Call: _e.mock.On("GetMountedSubsystems")}
}

func (_c *MockContainerManager_GetMountedSubsystems_Call) Run(run func()) *MockContainerManager_GetMountedSubsystems_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_GetMountedSubsystems_Call) Return(cgroupSubsystems *cm.CgroupSubsystems) *MockContainerManager_GetMountedSubsystems_Call {
	_c.Call.Return(cgroupSubsystems)
	return _c
}

func (_c *MockContainerManager_GetMountedSubsystems_Call) RunAndReturn(run func() *cm.CgroupSubsystems) *MockContainerManager_GetMountedSubsystems_Call {
	_c.Call.Return(run)
	return _c
}

// GetNodeAllocatableAbsolute provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetNodeAllocatableAbsolute() v1.ResourceList {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetNodeAllocatableAbsolute")
	}

	var r0 v1.ResourceList
	if returnFunc, ok := ret.Get(0).(func() v1.ResourceList); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(v1.ResourceList)
		}
	}
	return r0
}

// MockContainerManager_GetNodeAllocatableAbsolute_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetNodeAllocatableAbsolute'
type MockContainerManager_GetNodeAllocatableAbsolute_Call struct {
	*mock.Call
}

// GetNodeAllocatableAbsolute is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) GetNodeAllocatableAbsolute() *MockContainerManager_GetNodeAllocatableAbsolute_Call {
	return &MockContainerManager_GetNodeAllocatableAbsolute_Call{Call: _e.mock.On("GetNodeAllocatableAbsolute")}
}

func (_c *MockContainerManager_GetNodeAllocatableAbsolute_Call) Run(run func()) *MockContainerManager_GetNodeAllocatableAbsolute_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_GetNodeAllocatableAbsolute_Call) Return(resourceList v1.ResourceList) *MockContainerManager_GetNodeAllocatableAbsolute_Call {
	_c.Call.Return(resourceList)
	return _c
}

func (_c *MockContainerManager_GetNodeAllocatableAbsolute_Call) RunAndReturn(run func() v1.ResourceList) *MockContainerManager_GetNodeAllocatableAbsolute_Call {
	_c.Call.Return(run)
	return _c
}

// GetNodeAllocatableReservation provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetNodeAllocatableReservation() v1.ResourceList {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetNodeAllocatableReservation")
	}

	var r0 v1.ResourceList
	if returnFunc, ok := ret.Get(0).(func() v1.ResourceList); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(v1.ResourceList)
		}
	}
	return r0
}

// MockContainerManager_GetNodeAllocatableReservation_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetNodeAllocatableReservation'
type MockContainerManager_GetNodeAllocatableReservation_Call struct {
	*mock.Call
}

// GetNodeAllocatableReservation is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) GetNodeAllocatableReservation() *MockContainerManager_GetNodeAllocatableReservation_Call {
	return &MockContainerManager_GetNodeAllocatableReservation_Call{Call: _e.mock.On("GetNodeAllocatableReservation")}
}

func (_c *MockContainerManager_GetNodeAllocatableReservation_Call) Run(run func()) *MockContainerManager_GetNodeAllocatableReservation_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_GetNodeAllocatableReservation_Call) Return(resourceList v1.ResourceList) *MockContainerManager_GetNodeAllocatableReservation_Call {
	_c.Call.Return(resourceList)
	return _c
}

func (_c *MockContainerManager_GetNodeAllocatableReservation_Call) RunAndReturn(run func() v1.ResourceList) *MockContainerManager_GetNodeAllocatableReservation_Call {
	_c.Call.Return(run)
	return _c
}

// GetNodeConfig provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetNodeConfig() cm.NodeConfig {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetNodeConfig")
	}

	var r0 cm.NodeConfig
	if returnFunc, ok := ret.Get(0).(func() cm.NodeConfig); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(cm.NodeConfig)
	}
	return r0
}

// MockContainerManager_GetNodeConfig_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetNodeConfig'
type MockContainerManager_GetNodeConfig_Call struct {
	*mock.Call
}

// GetNodeConfig is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) GetNodeConfig() *MockContainerManager_GetNodeConfig_Call {
	return &MockContainerManager_GetNodeConfig_Call{Call: _e.mock.On("GetNodeConfig")}
}

func (_c *MockContainerManager_GetNodeConfig_Call) Run(run func()) *MockContainerManager_GetNodeConfig_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_GetNodeConfig_Call) Return(nodeConfig cm.NodeConfig) *MockContainerManager_GetNodeConfig_Call {
	_c.Call.Return(nodeConfig)
	return _c
}

func (_c *MockContainerManager_GetNodeConfig_Call) RunAndReturn(run func() cm.NodeConfig) *MockContainerManager_GetNodeConfig_Call {
	_c.Call.Return(run)
	return _c
}

// GetPluginRegistrationHandlers provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetPluginRegistrationHandlers() map[string]cache.PluginHandler {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetPluginRegistrationHandlers")
	}

	var r0 map[string]cache.PluginHandler
	if returnFunc, ok := ret.Get(0).(func() map[string]cache.PluginHandler); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]cache.PluginHandler)
		}
	}
	return r0
}

// MockContainerManager_GetPluginRegistrationHandlers_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPluginRegistrationHandlers'
type MockContainerManager_GetPluginRegistrationHandlers_Call struct {
	*mock.Call
}

// GetPluginRegistrationHandlers is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) GetPluginRegistrationHandlers() *MockContainerManager_GetPluginRegistrationHandlers_Call {
	return &MockContainerManager_GetPluginRegistrationHandlers_Call{Call: _e.mock.On("GetPluginRegistrationHandlers")}
}

func (_c *MockContainerManager_GetPluginRegistrationHandlers_Call) Run(run func()) *MockContainerManager_GetPluginRegistrationHandlers_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_GetPluginRegistrationHandlers_Call) Return(stringToPluginHandler map[string]cache.PluginHandler) *MockContainerManager_GetPluginRegistrationHandlers_Call {
	_c.Call.Return(stringToPluginHandler)
	return _c
}

func (_c *MockContainerManager_GetPluginRegistrationHandlers_Call) RunAndReturn(run func() map[string]cache.PluginHandler) *MockContainerManager_GetPluginRegistrationHandlers_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodCgroupRoot provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetPodCgroupRoot() string {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetPodCgroupRoot")
	}

	var r0 string
	if returnFunc, ok := ret.Get(0).(func() string); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(string)
	}
	return r0
}

// MockContainerManager_GetPodCgroupRoot_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodCgroupRoot'
type MockContainerManager_GetPodCgroupRoot_Call struct {
	*mock.Call
}

// GetPodCgroupRoot is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) GetPodCgroupRoot() *MockContainerManager_GetPodCgroupRoot_Call {
	return &MockContainerManager_GetPodCgroupRoot_Call{Call: _e.mock.On("GetPodCgroupRoot")}
}

func (_c *MockContainerManager_GetPodCgroupRoot_Call) Run(run func()) *MockContainerManager_GetPodCgroupRoot_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_GetPodCgroupRoot_Call) Return(s string) *MockContainerManager_GetPodCgroupRoot_Call {
	_c.Call.Return(s)
	return _c
}

func (_c *MockContainerManager_GetPodCgroupRoot_Call) RunAndReturn(run func() string) *MockContainerManager_GetPodCgroupRoot_Call {
	_c.Call.Return(run)
	return _c
}

// GetQOSContainersInfo provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetQOSContainersInfo() cm.QOSContainersInfo {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetQOSContainersInfo")
	}

	var r0 cm.QOSContainersInfo
	if returnFunc, ok := ret.Get(0).(func() cm.QOSContainersInfo); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(cm.QOSContainersInfo)
	}
	return r0
}

// MockContainerManager_GetQOSContainersInfo_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetQOSContainersInfo'
type MockContainerManager_GetQOSContainersInfo_Call struct {
	*mock.Call
}

// GetQOSContainersInfo is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) GetQOSContainersInfo() *MockContainerManager_GetQOSContainersInfo_Call {
	return &MockContainerManager_GetQOSContainersInfo_Call{Call: _e.mock.On("GetQOSContainersInfo")}
}

func (_c *MockContainerManager_GetQOSContainersInfo_Call) Run(run func()) *MockContainerManager_GetQOSContainersInfo_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_GetQOSContainersInfo_Call) Return(qOSContainersInfo cm.QOSContainersInfo) *MockContainerManager_GetQOSContainersInfo_Call {
	_c.Call.Return(qOSContainersInfo)
	return _c
}

func (_c *MockContainerManager_GetQOSContainersInfo_Call) RunAndReturn(run func() cm.QOSContainersInfo) *MockContainerManager_GetQOSContainersInfo_Call {
	_c.Call.Return(run)
	return _c
}

// GetResources provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) GetResources(ctx context.Context, pod *v1.Pod, container1 *v1.Container) (*container.RunContainerOptions, error) {
	ret := _mock.Called(ctx, pod, container1)

	if len(ret) == 0 {
		panic("no return value specified for GetResources")
	}

	var r0 *container.RunContainerOptions
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *v1.Pod, *v1.Container) (*container.RunContainerOptions, error)); ok {
		return returnFunc(ctx, pod, container1)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *v1.Pod, *v1.Container) *container.RunContainerOptions); ok {
		r0 = returnFunc(ctx, pod, container1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*container.RunContainerOptions)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *v1.Pod, *v1.Container) error); ok {
		r1 = returnFunc(ctx, pod, container1)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockContainerManager_GetResources_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetResources'
type MockContainerManager_GetResources_Call struct {
	*mock.Call
}

// GetResources is a helper method to define mock.On call
//   - ctx context.Context
//   - pod *v1.Pod
//   - container1 *v1.Container
func (_e *MockContainerManager_Expecter) GetResources(ctx interface{}, pod interface{}, container1 interface{}) *MockContainerManager_GetResources_Call {
	return &MockContainerManager_GetResources_Call{Call: _e.mock.On("GetResources", ctx, pod, container1)}
}

func (_c *MockContainerManager_GetResources_Call) Run(run func(ctx context.Context, pod *v1.Pod, container1 *v1.Container)) *MockContainerManager_GetResources_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *v1.Pod
		if args[1] != nil {
			arg1 = args[1].(*v1.Pod)
		}
		var arg2 *v1.Container
		if args[2] != nil {
			arg2 = args[2].(*v1.Container)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockContainerManager_GetResources_Call) Return(runContainerOptions *container.RunContainerOptions, err error) *MockContainerManager_GetResources_Call {
	_c.Call.Return(runContainerOptions, err)
	return _c
}

func (_c *MockContainerManager_GetResources_Call) RunAndReturn(run func(ctx context.Context, pod *v1.Pod, container1 *v1.Container) (*container.RunContainerOptions, error)) *MockContainerManager_GetResources_Call {
	_c.Call.Return(run)
	return _c
}

// InternalContainerLifecycle provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) InternalContainerLifecycle() cm.InternalContainerLifecycle {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for InternalContainerLifecycle")
	}

	var r0 cm.InternalContainerLifecycle
	if returnFunc, ok := ret.Get(0).(func() cm.InternalContainerLifecycle); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(cm.InternalContainerLifecycle)
		}
	}
	return r0
}

// MockContainerManager_InternalContainerLifecycle_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'InternalContainerLifecycle'
type MockContainerManager_InternalContainerLifecycle_Call struct {
	*mock.Call
}

// InternalContainerLifecycle is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) InternalContainerLifecycle() *MockContainerManager_InternalContainerLifecycle_Call {
	return &MockContainerManager_InternalContainerLifecycle_Call{Call: _e.mock.On("InternalContainerLifecycle")}
}

func (_c *MockContainerManager_InternalContainerLifecycle_Call) Run(run func()) *MockContainerManager_InternalContainerLifecycle_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_InternalContainerLifecycle_Call) Return(internalContainerLifecycle cm.InternalContainerLifecycle) *MockContainerManager_InternalContainerLifecycle_Call {
	_c.Call.Return(internalContainerLifecycle)
	return _c
}

func (_c *MockContainerManager_InternalContainerLifecycle_Call) RunAndReturn(run func() cm.InternalContainerLifecycle) *MockContainerManager_InternalContainerLifecycle_Call {
	_c.Call.Return(run)
	return _c
}

// NewPodContainerManager provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) NewPodContainerManager() cm.PodContainerManager {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for NewPodContainerManager")
	}

	var r0 cm.PodContainerManager
	if returnFunc, ok := ret.Get(0).(func() cm.PodContainerManager); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(cm.PodContainerManager)
		}
	}
	return r0
}

// MockContainerManager_NewPodContainerManager_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NewPodContainerManager'
type MockContainerManager_NewPodContainerManager_Call struct {
	*mock.Call
}

// NewPodContainerManager is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) NewPodContainerManager() *MockContainerManager_NewPodContainerManager_Call {
	return &MockContainerManager_NewPodContainerManager_Call{Call: _e.mock.On("NewPodContainerManager")}
}

func (_c *MockContainerManager_NewPodContainerManager_Call) Run(run func()) *MockContainerManager_NewPodContainerManager_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_NewPodContainerManager_Call) Return(podContainerManager cm.PodContainerManager) *MockContainerManager_NewPodContainerManager_Call {
	_c.Call.Return(podContainerManager)
	return _c
}

func (_c *MockContainerManager_NewPodContainerManager_Call) RunAndReturn(run func() cm.PodContainerManager) *MockContainerManager_NewPodContainerManager_Call {
	_c.Call.Return(run)
	return _c
}

// PodHasExclusiveCPUs provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) PodHasExclusiveCPUs(pod *v1.Pod) bool {
	ret := _mock.Called(pod)

	if len(ret) == 0 {
		panic("no return value specified for PodHasExclusiveCPUs")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod) bool); ok {
		r0 = returnFunc(pod)
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockContainerManager_PodHasExclusiveCPUs_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'PodHasExclusiveCPUs'
type MockContainerManager_PodHasExclusiveCPUs_Call struct {
	*mock.Call
}

// PodHasExclusiveCPUs is a helper method to define mock.On call
//   - pod *v1.Pod
func (_e *MockContainerManager_Expecter) PodHasExclusiveCPUs(pod interface{}) *MockContainerManager_PodHasExclusiveCPUs_Call {
	return &MockContainerManager_PodHasExclusiveCPUs_Call{Call: _e.mock.On("PodHasExclusiveCPUs", pod)}
}

func (_c *MockContainerManager_PodHasExclusiveCPUs_Call) Run(run func(pod *v1.Pod)) *MockContainerManager_PodHasExclusiveCPUs_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockContainerManager_PodHasExclusiveCPUs_Call) Return(b bool) *MockContainerManager_PodHasExclusiveCPUs_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockContainerManager_PodHasExclusiveCPUs_Call) RunAndReturn(run func(pod *v1.Pod) bool) *MockContainerManager_PodHasExclusiveCPUs_Call {
	_c.Call.Return(run)
	return _c
}

// PodMightNeedToUnprepareResources provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) PodMightNeedToUnprepareResources(UID types.UID) bool {
	ret := _mock.Called(UID)

	if len(ret) == 0 {
		panic("no return value specified for PodMightNeedToUnprepareResources")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func(types.UID) bool); ok {
		r0 = returnFunc(UID)
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockContainerManager_PodMightNeedToUnprepareResources_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'PodMightNeedToUnprepareResources'
type MockContainerManager_PodMightNeedToUnprepareResources_Call struct {
	*mock.Call
}

// PodMightNeedToUnprepareResources is a helper method to define mock.On call
//   - UID types.UID
func (_e *MockContainerManager_Expecter) PodMightNeedToUnprepareResources(UID interface{}) *MockContainerManager_PodMightNeedToUnprepareResources_Call {
	return &MockContainerManager_PodMightNeedToUnprepareResources_Call{Call: _e.mock.On("PodMightNeedToUnprepareResources", UID)}
}

func (_c *MockContainerManager_PodMightNeedToUnprepareResources_Call) Run(run func(UID types.UID)) *MockContainerManager_PodMightNeedToUnprepareResources_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 types.UID
		if args[0] != nil {
			arg0 = args[0].(types.UID)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockContainerManager_PodMightNeedToUnprepareResources_Call) Return(b bool) *MockContainerManager_PodMightNeedToUnprepareResources_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockContainerManager_PodMightNeedToUnprepareResources_Call) RunAndReturn(run func(UID types.UID) bool) *MockContainerManager_PodMightNeedToUnprepareResources_Call {
	_c.Call.Return(run)
	return _c
}

// PrepareDynamicResources provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) PrepareDynamicResources(context1 context.Context, pod *v1.Pod) error {
	ret := _mock.Called(context1, pod)

	if len(ret) == 0 {
		panic("no return value specified for PrepareDynamicResources")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *v1.Pod) error); ok {
		r0 = returnFunc(context1, pod)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockContainerManager_PrepareDynamicResources_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'PrepareDynamicResources'
type MockContainerManager_PrepareDynamicResources_Call struct {
	*mock.Call
}

// PrepareDynamicResources is a helper method to define mock.On call
//   - context1 context.Context
//   - pod *v1.Pod
func (_e *MockContainerManager_Expecter) PrepareDynamicResources(context1 interface{}, pod interface{}) *MockContainerManager_PrepareDynamicResources_Call {
	return &MockContainerManager_PrepareDynamicResources_Call{Call: _e.mock.On("PrepareDynamicResources", context1, pod)}
}

func (_c *MockContainerManager_PrepareDynamicResources_Call) Run(run func(context1 context.Context, pod *v1.Pod)) *MockContainerManager_PrepareDynamicResources_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *v1.Pod
		if args[1] != nil {
			arg1 = args[1].(*v1.Pod)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockContainerManager_PrepareDynamicResources_Call) Return(err error) *MockContainerManager_PrepareDynamicResources_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockContainerManager_PrepareDynamicResources_Call) RunAndReturn(run func(context1 context.Context, pod *v1.Pod) error) *MockContainerManager_PrepareDynamicResources_Call {
	_c.Call.Return(run)
	return _c
}

// ShouldResetExtendedResourceCapacity provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) ShouldResetExtendedResourceCapacity() bool {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for ShouldResetExtendedResourceCapacity")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func() bool); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockContainerManager_ShouldResetExtendedResourceCapacity_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ShouldResetExtendedResourceCapacity'
type MockContainerManager_ShouldResetExtendedResourceCapacity_Call struct {
	*mock.Call
}

// ShouldResetExtendedResourceCapacity is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) ShouldResetExtendedResourceCapacity() *MockContainerManager_ShouldResetExtendedResourceCapacity_Call {
	return &MockContainerManager_ShouldResetExtendedResourceCapacity_Call{Call: _e.mock.On("ShouldResetExtendedResourceCapacity")}
}

func (_c *MockContainerManager_ShouldResetExtendedResourceCapacity_Call) Run(run func()) *MockContainerManager_ShouldResetExtendedResourceCapacity_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_ShouldResetExtendedResourceCapacity_Call) Return(b bool) *MockContainerManager_ShouldResetExtendedResourceCapacity_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockContainerManager_ShouldResetExtendedResourceCapacity_Call) RunAndReturn(run func() bool) *MockContainerManager_ShouldResetExtendedResourceCapacity_Call {
	_c.Call.Return(run)
	return _c
}

// Start provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) Start(context1 context.Context, node *v1.Node, activePodsFunc cm.ActivePodsFunc, getNodeFunc cm.GetNodeFunc, sourcesReady config.SourcesReady, podStatusProvider status.PodStatusProvider, runtimeService cri.RuntimeService, b bool) error {
	ret := _mock.Called(context1, node, activePodsFunc, getNodeFunc, sourcesReady, podStatusProvider, runtimeService, b)

	if len(ret) == 0 {
		panic("no return value specified for Start")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *v1.Node, cm.ActivePodsFunc, cm.GetNodeFunc, config.SourcesReady, status.PodStatusProvider, cri.RuntimeService, bool) error); ok {
		r0 = returnFunc(context1, node, activePodsFunc, getNodeFunc, sourcesReady, podStatusProvider, runtimeService, b)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockContainerManager_Start_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Start'
type MockContainerManager_Start_Call struct {
	*mock.Call
}

// Start is a helper method to define mock.On call
//   - context1 context.Context
//   - node *v1.Node
//   - activePodsFunc cm.ActivePodsFunc
//   - getNodeFunc cm.GetNodeFunc
//   - sourcesReady config.SourcesReady
//   - podStatusProvider status.PodStatusProvider
//   - runtimeService cri.RuntimeService
//   - b bool
func (_e *MockContainerManager_Expecter) Start(context1 interface{}, node interface{}, activePodsFunc interface{}, getNodeFunc interface{}, sourcesReady interface{}, podStatusProvider interface{}, runtimeService interface{}, b interface{}) *MockContainerManager_Start_Call {
	return &MockContainerManager_Start_Call{Call: _e.mock.On("Start", context1, node, activePodsFunc, getNodeFunc, sourcesReady, podStatusProvider, runtimeService, b)}
}

func (_c *MockContainerManager_Start_Call) Run(run func(context1 context.Context, node *v1.Node, activePodsFunc cm.ActivePodsFunc, getNodeFunc cm.GetNodeFunc, sourcesReady config.SourcesReady, podStatusProvider status.PodStatusProvider, runtimeService cri.RuntimeService, b bool)) *MockContainerManager_Start_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *v1.Node
		if args[1] != nil {
			arg1 = args[1].(*v1.Node)
		}
		var arg2 cm.ActivePodsFunc
		if args[2] != nil {
			arg2 = args[2].(cm.ActivePodsFunc)
		}
		var arg3 cm.GetNodeFunc
		if args[3] != nil {
			arg3 = args[3].(cm.GetNodeFunc)
		}
		var arg4 config.SourcesReady
		if args[4] != nil {
			arg4 = args[4].(config.SourcesReady)
		}
		var arg5 status.PodStatusProvider
		if args[5] != nil {
			arg5 = args[5].(status.PodStatusProvider)
		}
		var arg6 cri.RuntimeService
		if args[6] != nil {
			arg6 = args[6].(cri.RuntimeService)
		}
		var arg7 bool
		if args[7] != nil {
			arg7 = args[7].(bool)
		}
		run(
			arg0,
			arg1,
			arg2,
			arg3,
			arg4,
			arg5,
			arg6,
			arg7,
		)
	})
	return _c
}

func (_c *MockContainerManager_Start_Call) Return(err error) *MockContainerManager_Start_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockContainerManager_Start_Call) RunAndReturn(run func(context1 context.Context, node *v1.Node, activePodsFunc cm.ActivePodsFunc, getNodeFunc cm.GetNodeFunc, sourcesReady config.SourcesReady, podStatusProvider status.PodStatusProvider, runtimeService cri.RuntimeService, b bool) error) *MockContainerManager_Start_Call {
	_c.Call.Return(run)
	return _c
}

// Status provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) Status() cm.Status {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for Status")
	}

	var r0 cm.Status
	if returnFunc, ok := ret.Get(0).(func() cm.Status); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(cm.Status)
	}
	return r0
}

// MockContainerManager_Status_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Status'
type MockContainerManager_Status_Call struct {
	*mock.Call
}

// Status is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) Status() *MockContainerManager_Status_Call {
	return &MockContainerManager_Status_Call{Call: _e.mock.On("Status")}
}

func (_c *MockContainerManager_Status_Call) Run(run func()) *MockContainerManager_Status_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_Status_Call) Return(status1 cm.Status) *MockContainerManager_Status_Call {
	_c.Call.Return(status1)
	return _c
}

func (_c *MockContainerManager_Status_Call) RunAndReturn(run func() cm.Status) *MockContainerManager_Status_Call {
	_c.Call.Return(run)
	return _c
}

// SystemCgroupsLimit provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) SystemCgroupsLimit() v1.ResourceList {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for SystemCgroupsLimit")
	}

	var r0 v1.ResourceList
	if returnFunc, ok := ret.Get(0).(func() v1.ResourceList); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(v1.ResourceList)
		}
	}
	return r0
}

// MockContainerManager_SystemCgroupsLimit_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'SystemCgroupsLimit'
type MockContainerManager_SystemCgroupsLimit_Call struct {
	*mock.Call
}

// SystemCgroupsLimit is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) SystemCgroupsLimit() *MockContainerManager_SystemCgroupsLimit_Call {
	return &MockContainerManager_SystemCgroupsLimit_Call{Call: _e.mock.On("SystemCgroupsLimit")}
}

func (_c *MockContainerManager_SystemCgroupsLimit_Call) Run(run func()) *MockContainerManager_SystemCgroupsLimit_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_SystemCgroupsLimit_Call) Return(resourceList v1.ResourceList) *MockContainerManager_SystemCgroupsLimit_Call {
	_c.Call.Return(resourceList)
	return _c
}

func (_c *MockContainerManager_SystemCgroupsLimit_Call) RunAndReturn(run func() v1.ResourceList) *MockContainerManager_SystemCgroupsLimit_Call {
	_c.Call.Return(run)
	return _c
}

// UnprepareDynamicResources provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) UnprepareDynamicResources(context1 context.Context, pod *v1.Pod) error {
	ret := _mock.Called(context1, pod)

	if len(ret) == 0 {
		panic("no return value specified for UnprepareDynamicResources")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *v1.Pod) error); ok {
		r0 = returnFunc(context1, pod)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockContainerManager_UnprepareDynamicResources_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UnprepareDynamicResources'
type MockContainerManager_UnprepareDynamicResources_Call struct {
	*mock.Call
}

// UnprepareDynamicResources is a helper method to define mock.On call
//   - context1 context.Context
//   - pod *v1.Pod
func (_e *MockContainerManager_Expecter) UnprepareDynamicResources(context1 interface{}, pod interface{}) *MockContainerManager_UnprepareDynamicResources_Call {
	return &MockContainerManager_UnprepareDynamicResources_Call{Call: _e.mock.On("UnprepareDynamicResources", context1, pod)}
}

func (_c *MockContainerManager_UnprepareDynamicResources_Call) Run(run func(context1 context.Context, pod *v1.Pod)) *MockContainerManager_UnprepareDynamicResources_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *v1.Pod
		if args[1] != nil {
			arg1 = args[1].(*v1.Pod)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockContainerManager_UnprepareDynamicResources_Call) Return(err error) *MockContainerManager_UnprepareDynamicResources_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockContainerManager_UnprepareDynamicResources_Call) RunAndReturn(run func(context1 context.Context, pod *v1.Pod) error) *MockContainerManager_UnprepareDynamicResources_Call {
	_c.Call.Return(run)
	return _c
}

// UpdateAllocatedDevices provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) UpdateAllocatedDevices() {
	_mock.Called()
	return
}

// MockContainerManager_UpdateAllocatedDevices_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateAllocatedDevices'
type MockContainerManager_UpdateAllocatedDevices_Call struct {
	*mock.Call
}

// UpdateAllocatedDevices is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) UpdateAllocatedDevices() *MockContainerManager_UpdateAllocatedDevices_Call {
	return &MockContainerManager_UpdateAllocatedDevices_Call{Call: _e.mock.On("UpdateAllocatedDevices")}
}

func (_c *MockContainerManager_UpdateAllocatedDevices_Call) Run(run func()) *MockContainerManager_UpdateAllocatedDevices_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_UpdateAllocatedDevices_Call) Return() *MockContainerManager_UpdateAllocatedDevices_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockContainerManager_UpdateAllocatedDevices_Call) RunAndReturn(run func()) *MockContainerManager_UpdateAllocatedDevices_Call {
	_c.Run(run)
	return _c
}

// UpdateAllocatedResourcesStatus provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) UpdateAllocatedResourcesStatus(pod *v1.Pod, status1 *v1.PodStatus) {
	_mock.Called(pod, status1)
	return
}

// MockContainerManager_UpdateAllocatedResourcesStatus_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateAllocatedResourcesStatus'
type MockContainerManager_UpdateAllocatedResourcesStatus_Call struct {
	*mock.Call
}

// UpdateAllocatedResourcesStatus is a helper method to define mock.On call
//   - pod *v1.Pod
//   - status1 *v1.PodStatus
func (_e *MockContainerManager_Expecter) UpdateAllocatedResourcesStatus(pod interface{}, status1 interface{}) *MockContainerManager_UpdateAllocatedResourcesStatus_Call {
	return &MockContainerManager_UpdateAllocatedResourcesStatus_Call{Call: _e.mock.On("UpdateAllocatedResourcesStatus", pod, status1)}
}

func (_c *MockContainerManager_UpdateAllocatedResourcesStatus_Call) Run(run func(pod *v1.Pod, status1 *v1.PodStatus)) *MockContainerManager_UpdateAllocatedResourcesStatus_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		var arg1 *v1.PodStatus
		if args[1] != nil {
			arg1 = args[1].(*v1.PodStatus)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockContainerManager_UpdateAllocatedResourcesStatus_Call) Return() *MockContainerManager_UpdateAllocatedResourcesStatus_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockContainerManager_UpdateAllocatedResourcesStatus_Call) RunAndReturn(run func(pod *v1.Pod, status1 *v1.PodStatus)) *MockContainerManager_UpdateAllocatedResourcesStatus_Call {
	_c.Run(run)
	return _c
}

// UpdatePluginResources provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) UpdatePluginResources(nodeInfo *framework.NodeInfo, podAdmitAttributes *lifecycle.PodAdmitAttributes) error {
	ret := _mock.Called(nodeInfo, podAdmitAttributes)

	if len(ret) == 0 {
		panic("no return value specified for UpdatePluginResources")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(*framework.NodeInfo, *lifecycle.PodAdmitAttributes) error); ok {
		r0 = returnFunc(nodeInfo, podAdmitAttributes)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockContainerManager_UpdatePluginResources_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdatePluginResources'
type MockContainerManager_UpdatePluginResources_Call struct {
	*mock.Call
}

// UpdatePluginResources is a helper method to define mock.On call
//   - nodeInfo *framework.NodeInfo
//   - podAdmitAttributes *lifecycle.PodAdmitAttributes
func (_e *MockContainerManager_Expecter) UpdatePluginResources(nodeInfo interface{}, podAdmitAttributes interface{}) *MockContainerManager_UpdatePluginResources_Call {
	return &MockContainerManager_UpdatePluginResources_Call{Call: _e.mock.On("UpdatePluginResources", nodeInfo, podAdmitAttributes)}
}

func (_c *MockContainerManager_UpdatePluginResources_Call) Run(run func(nodeInfo *framework.NodeInfo, podAdmitAttributes *lifecycle.PodAdmitAttributes)) *MockContainerManager_UpdatePluginResources_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *framework.NodeInfo
		if args[0] != nil {
			arg0 = args[0].(*framework.NodeInfo)
		}
		var arg1 *lifecycle.PodAdmitAttributes
		if args[1] != nil {
			arg1 = args[1].(*lifecycle.PodAdmitAttributes)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockContainerManager_UpdatePluginResources_Call) Return(err error) *MockContainerManager_UpdatePluginResources_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockContainerManager_UpdatePluginResources_Call) RunAndReturn(run func(nodeInfo *framework.NodeInfo, podAdmitAttributes *lifecycle.PodAdmitAttributes) error) *MockContainerManager_UpdatePluginResources_Call {
	_c.Call.Return(run)
	return _c
}

// UpdateQOSCgroups provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) UpdateQOSCgroups(logger klog.Logger) error {
	ret := _mock.Called(logger)

	if len(ret) == 0 {
		panic("no return value specified for UpdateQOSCgroups")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(klog.Logger) error); ok {
		r0 = returnFunc(logger)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockContainerManager_UpdateQOSCgroups_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateQOSCgroups'
type MockContainerManager_UpdateQOSCgroups_Call struct {
	*mock.Call
}

// UpdateQOSCgroups is a helper method to define mock.On call
//   - logger klog.Logger
func (_e *MockContainerManager_Expecter) UpdateQOSCgroups(logger interface{}) *MockContainerManager_UpdateQOSCgroups_Call {
	return &MockContainerManager_UpdateQOSCgroups_Call{Call: _e.mock.On("UpdateQOSCgroups", logger)}
}

func (_c *MockContainerManager_UpdateQOSCgroups_Call) Run(run func(logger klog.Logger)) *MockContainerManager_UpdateQOSCgroups_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 klog.Logger
		if args[0] != nil {
			arg0 = args[0].(klog.Logger)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockContainerManager_UpdateQOSCgroups_Call) Return(err error) *MockContainerManager_UpdateQOSCgroups_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockContainerManager_UpdateQOSCgroups_Call) RunAndReturn(run func(logger klog.Logger) error) *MockContainerManager_UpdateQOSCgroups_Call {
	_c.Call.Return(run)
	return _c
}

// Updates provides a mock function for the type MockContainerManager
func (_mock *MockContainerManager) Updates() <-chan resourceupdates.Update {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for Updates")
	}

	var r0 <-chan resourceupdates.Update
	if returnFunc, ok := ret.Get(0).(func() <-chan resourceupdates.Update); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(<-chan resourceupdates.Update)
		}
	}
	return r0
}

// MockContainerManager_Updates_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Updates'
type MockContainerManager_Updates_Call struct {
	*mock.Call
}

// Updates is a helper method to define mock.On call
func (_e *MockContainerManager_Expecter) Updates() *MockContainerManager_Updates_Call {
	return &MockContainerManager_Updates_Call{Call: _e.mock.On("Updates")}
}

func (_c *MockContainerManager_Updates_Call) Run(run func()) *MockContainerManager_Updates_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockContainerManager_Updates_Call) Return(updateCh <-chan resourceupdates.Update) *MockContainerManager_Updates_Call {
	_c.Call.Return(updateCh)
	return _c
}

func (_c *MockContainerManager_Updates_Call) RunAndReturn(run func() <-chan resourceupdates.Update) *MockContainerManager_Updates_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockPodContainerManager creates a new instance of MockPodContainerManager. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockPodContainerManager(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockPodContainerManager {
	mock := &MockPodContainerManager{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockPodContainerManager is an autogenerated mock type for the PodContainerManager type
type MockPodContainerManager struct {
	mock.Mock
}

type MockPodContainerManager_Expecter struct {
	mock *mock.Mock
}

func (_m *MockPodContainerManager) EXPECT() *MockPodContainerManager_Expecter {
	return &MockPodContainerManager_Expecter{mock: &_m.Mock}
}

// Destroy provides a mock function for the type MockPodContainerManager
func (_mock *MockPodContainerManager) Destroy(logger klog.Logger, name cm.CgroupName) error {
	ret := _mock.Called(logger, name)

	if len(ret) == 0 {
		panic("no return value specified for Destroy")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(klog.Logger, cm.CgroupName) error); ok {
		r0 = returnFunc(logger, name)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockPodContainerManager_Destroy_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Destroy'
type MockPodContainerManager_Destroy_Call struct {
	*mock.Call
}

// Destroy is a helper method to define mock.On call
//   - logger klog.Logger
//   - name cm.CgroupName
func (_e *MockPodContainerManager_Expecter) Destroy(logger interface{}, name interface{}) *MockPodContainerManager_Destroy_Call {
	return &MockPodContainerManager_Destroy_Call{Call: _e.mock.On("Destroy", logger, name)}
}

func (_c *MockPodContainerManager_Destroy_Call) Run(run func(logger klog.Logger, name cm.CgroupName)) *MockPodContainerManager_Destroy_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 klog.Logger
		if args[0] != nil {
			arg0 = args[0].(klog.Logger)
		}
		var arg1 cm.CgroupName
		if args[1] != nil {
			arg1 = args[1].(cm.CgroupName)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockPodContainerManager_Destroy_Call) Return(err error) *MockPodContainerManager_Destroy_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockPodContainerManager_Destroy_Call) RunAndReturn(run func(logger klog.Logger, name cm.CgroupName) error) *MockPodContainerManager_Destroy_Call {
	_c.Call.Return(run)
	return _c
}

// EnsureExists provides a mock function for the type MockPodContainerManager
func (_mock *MockPodContainerManager) EnsureExists(logger klog.Logger, pod *v1.Pod) error {
	ret := _mock.Called(logger, pod)

	if len(ret) == 0 {
		panic("no return value specified for EnsureExists")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(klog.Logger, *v1.Pod) error); ok {
		r0 = returnFunc(logger, pod)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockPodContainerManager_EnsureExists_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'EnsureExists'
type MockPodContainerManager_EnsureExists_Call struct {
	*mock.Call
}

// EnsureExists is a helper method to define mock.On call
//   - logger klog.Logger
//   - pod *v1.Pod
func (_e *MockPodContainerManager_Expecter) EnsureExists(logger interface{}, pod interface{}) *MockPodContainerManager_EnsureExists_Call {
	return &MockPodContainerManager_EnsureExists_Call{Call: _e.mock.On("EnsureExists", logger, pod)}
}

func (_c *MockPodContainerManager_EnsureExists_Call) Run(run func(logger klog.Logger, pod *v1.Pod)) *MockPodContainerManager_EnsureExists_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 klog.Logger
		if args[0] != nil {
			arg0 = args[0].(klog.Logger)
		}
		var arg1 *v1.Pod
		if args[1] != nil {
			arg1 = args[1].(*v1.Pod)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockPodContainerManager_EnsureExists_Call) Return(err error) *MockPodContainerManager_EnsureExists_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockPodContainerManager_EnsureExists_Call) RunAndReturn(run func(logger klog.Logger, pod *v1.Pod) error) *MockPodContainerManager_EnsureExists_Call {
	_c.Call.Return(run)
	return _c
}

// Exists provides a mock function for the type MockPodContainerManager
func (_mock *MockPodContainerManager) Exists(pod *v1.Pod) bool {
	ret := _mock.Called(pod)

	if len(ret) == 0 {
		panic("no return value specified for Exists")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod) bool); ok {
		r0 = returnFunc(pod)
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockPodContainerManager_Exists_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Exists'
type MockPodContainerManager_Exists_Call struct {
	*mock.Call
}

// Exists is a helper method to define mock.On call
//   - pod *v1.Pod
func (_e *MockPodContainerManager_Expecter) Exists(pod interface{}) *MockPodContainerManager_Exists_Call {
	return &MockPodContainerManager_Exists_Call{Call: _e.mock.On("Exists", pod)}
}

func (_c *MockPodContainerManager_Exists_Call) Run(run func(pod *v1.Pod)) *MockPodContainerManager_Exists_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockPodContainerManager_Exists_Call) Return(b bool) *MockPodContainerManager_Exists_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockPodContainerManager_Exists_Call) RunAndReturn(run func(pod *v1.Pod) bool) *MockPodContainerManager_Exists_Call {
	_c.Call.Return(run)
	return _c
}

// GetAllPodsFromCgroups provides a mock function for the type MockPodContainerManager
func (_mock *MockPodContainerManager) GetAllPodsFromCgroups() (map[types.UID]cm.CgroupName, error) {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetAllPodsFromCgroups")
	}

	var r0 map[types.UID]cm.CgroupName
	var r1 error
	if returnFunc, ok := ret.Get(0).(func() (map[types.UID]cm.CgroupName, error)); ok {
		return returnFunc()
	}
	if returnFunc, ok := ret.Get(0).(func() map[types.UID]cm.CgroupName); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[types.UID]cm.CgroupName)
		}
	}
	if returnFunc, ok := ret.Get(1).(func() error); ok {
		r1 = returnFunc()
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockPodContainerManager_GetAllPodsFromCgroups_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetAllPodsFromCgroups'
type MockPodContainerManager_GetAllPodsFromCgroups_Call struct {
	*mock.Call
}

// GetAllPodsFromCgroups is a helper method to define mock.On call
func (_e *MockPodContainerManager_Expecter) GetAllPodsFromCgroups() *MockPodContainerManager_GetAllPodsFromCgroups_Call {
	return &MockPodContainerManager_GetAllPodsFromCgroups_Call{Call: _e.mock.On("GetAllPodsFromCgroups")}
}

func (_c *MockPodContainerManager_GetAllPodsFromCgroups_Call) Run(run func()) *MockPodContainerManager_GetAllPodsFromCgroups_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPodContainerManager_GetAllPodsFromCgroups_Call) Return(uIDToCgroupName map[types.UID]cm.CgroupName, err error) *MockPodContainerManager_GetAllPodsFromCgroups_Call {
	_c.Call.Return(uIDToCgroupName, err)
	return _c
}

func (_c *MockPodContainerManager_GetAllPodsFromCgroups_Call) RunAndReturn(run func() (map[types.UID]cm.CgroupName, error)) *MockPodContainerManager_GetAllPodsFromCgroups_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodCgroupConfig provides a mock function for the type MockPodContainerManager
func (_mock *MockPodContainerManager) GetPodCgroupConfig(pod *v1.Pod, resource v1.ResourceName) (*cm.ResourceConfig, error) {
	ret := _mock.Called(pod, resource)

	if len(ret) == 0 {
		panic("no return value specified for GetPodCgroupConfig")
	}

	var r0 *cm.ResourceConfig
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod, v1.ResourceName) (*cm.ResourceConfig, error)); ok {
		return returnFunc(pod, resource)
	}
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod, v1.ResourceName) *cm.ResourceConfig); ok {
		r0 = returnFunc(pod, resource)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*cm.ResourceConfig)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(*v1.Pod, v1.ResourceName) error); ok {
		r1 = returnFunc(pod, resource)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockPodContainerManager_GetPodCgroupConfig_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodCgroupConfig'
type MockPodContainerManager_GetPodCgroupConfig_Call struct {
	*mock.Call
}

// GetPodCgroupConfig is a helper method to define mock.On call
//   - pod *v1.Pod
//   - resource v1.ResourceName
func (_e *MockPodContainerManager_Expecter) GetPodCgroupConfig(pod interface{}, resource interface{}) *MockPodContainerManager_GetPodCgroupConfig_Call {
	return &MockPodContainerManager_GetPodCgroupConfig_Call{Call: _e.mock.On("GetPodCgroupConfig", pod, resource)}
}

func (_c *MockPodContainerManager_GetPodCgroupConfig_Call) Run(run func(pod *v1.Pod, resource v1.ResourceName)) *MockPodContainerManager_GetPodCgroupConfig_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		var arg1 v1.ResourceName
		if args[1] != nil {
			arg1 = args[1].(v1.ResourceName)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockPodContainerManager_GetPodCgroupConfig_Call) Return(resourceConfig *cm.ResourceConfig, err error) *MockPodContainerManager_GetPodCgroupConfig_Call {
	_c.Call.Return(resourceConfig, err)
	return _c
}

func (_c *MockPodContainerManager_GetPodCgroupConfig_Call) RunAndReturn(run func(pod *v1.Pod, resource v1.ResourceName) (*cm.ResourceConfig, error)) *MockPodContainerManager_GetPodCgroupConfig_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodCgroupMemoryUsage provides a mock function for the type MockPodContainerManager
func (_mock *MockPodContainerManager) GetPodCgroupMemoryUsage(pod *v1.Pod) (uint64, error) {
	ret := _mock.Called(pod)

	if len(ret) == 0 {
		panic("no return value specified for GetPodCgroupMemoryUsage")
	}

	var r0 uint64
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod) (uint64, error)); ok {
		return returnFunc(pod)
	}
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod) uint64); ok {
		r0 = returnFunc(pod)
	} else {
		r0 = ret.Get(0).(uint64)
	}
	if returnFunc, ok := ret.Get(1).(func(*v1.Pod) error); ok {
		r1 = returnFunc(pod)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockPodContainerManager_GetPodCgroupMemoryUsage_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodCgroupMemoryUsage'
type MockPodContainerManager_GetPodCgroupMemoryUsage_Call struct {
	*mock.Call
}

// GetPodCgroupMemoryUsage is a helper method to define mock.On call
//   - pod *v1.Pod
func (_e *MockPodContainerManager_Expecter) GetPodCgroupMemoryUsage(pod interface{}) *MockPodContainerManager_GetPodCgroupMemoryUsage_Call {
	return &MockPodContainerManager_GetPodCgroupMemoryUsage_Call{Call: _e.mock.On("GetPodCgroupMemoryUsage", pod)}
}

func (_c *MockPodContainerManager_GetPodCgroupMemoryUsage_Call) Run(run func(pod *v1.Pod)) *MockPodContainerManager_GetPodCgroupMemoryUsage_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockPodContainerManager_GetPodCgroupMemoryUsage_Call) Return(v uint64, err error) *MockPodContainerManager_GetPodCgroupMemoryUsage_Call {
	_c.Call.Return(v, err)
	return _c
}

func (_c *MockPodContainerManager_GetPodCgroupMemoryUsage_Call) RunAndReturn(run func(pod *v1.Pod) (uint64, error)) *MockPodContainerManager_GetPodCgroupMemoryUsage_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodContainerName provides a mock function for the type MockPodContainerManager
func (_mock *MockPodContainerManager) GetPodContainerName(pod *v1.Pod) (cm.CgroupName, string) {
	ret := _mock.Called(pod)

	if len(ret) == 0 {
		panic("no return value specified for GetPodContainerName")
	}

	var r0 cm.CgroupName
	var r1 string
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod) (cm.CgroupName, string)); ok {
		return returnFunc(pod)
	}
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod) cm.CgroupName); ok {
		r0 = returnFunc(pod)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(cm.CgroupName)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(*v1.Pod) string); ok {
		r1 = returnFunc(pod)
	} else {
		r1 = ret.Get(1).(string)
	}
	return r0, r1
}

// MockPodContainerManager_GetPodContainerName_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodContainerName'
type MockPodContainerManager_GetPodContainerName_Call struct {
	*mock.Call
}

// GetPodContainerName is a helper method to define mock.On call
//   - pod *v1.Pod
func (_e *MockPodContainerManager_Expecter) GetPodContainerName(pod interface{}) *MockPodContainerManager_GetPodContainerName_Call {
	return &MockPodContainerManager_GetPodContainerName_Call{Call: _e.mock.On("GetPodContainerName", pod)}
}

func (_c *MockPodContainerManager_GetPodContainerName_Call) Run(run func(pod *v1.Pod)) *MockPodContainerManager_GetPodContainerName_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockPodContainerManager_GetPodContainerName_Call) Return(cgroupName cm.CgroupName, s string) *MockPodContainerManager_GetPodContainerName_Call {
	_c.Call.Return(cgroupName, s)
	return _c
}

func (_c *MockPodContainerManager_GetPodContainerName_Call) RunAndReturn(run func(pod *v1.Pod) (cm.CgroupName, string)) *MockPodContainerManager_GetPodContainerName_Call {
	_c.Call.Return(run)
	return _c
}

// IsPodCgroup provides a mock function for the type MockPodContainerManager
func (_mock *MockPodContainerManager) IsPodCgroup(cgroupfs string) (bool, types.UID) {
	ret := _mock.Called(cgroupfs)

	if len(ret) == 0 {
		panic("no return value specified for IsPodCgroup")
	}

	var r0 bool
	var r1 types.UID
	if returnFunc, ok := ret.Get(0).(func(string) (bool, types.UID)); ok {
		return returnFunc(cgroupfs)
	}
	if returnFunc, ok := ret.Get(0).(func(string) bool); ok {
		r0 = returnFunc(cgroupfs)
	} else {
		r0 = ret.Get(0).(bool)
	}
	if returnFunc, ok := ret.Get(1).(func(string) types.UID); ok {
		r1 = returnFunc(cgroupfs)
	} else {
		r1 = ret.Get(1).(types.UID)
	}
	return r0, r1
}

// MockPodContainerManager_IsPodCgroup_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsPodCgroup'
type MockPodContainerManager_IsPodCgroup_Call struct {
	*mock.Call
}

// IsPodCgroup is a helper method to define mock.On call
//   - cgroupfs string
func (_e *MockPodContainerManager_Expecter) IsPodCgroup(cgroupfs interface{}) *MockPodContainerManager_IsPodCgroup_Call {
	return &MockPodContainerManager_IsPodCgroup_Call{Call: _e.mock.On("IsPodCgroup", cgroupfs)}
}

func (_c *MockPodContainerManager_IsPodCgroup_Call) Run(run func(cgroupfs string)) *MockPodContainerManager_IsPodCgroup_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockPodContainerManager_IsPodCgroup_Call) Return(b bool, uID types.UID) *MockPodContainerManager_IsPodCgroup_Call {
	_c.Call.Return(b, uID)
	return _c
}

func (_c *MockPodContainerManager_IsPodCgroup_Call) RunAndReturn(run func(cgroupfs string) (bool, types.UID)) *MockPodContainerManager_IsPodCgroup_Call {
	_c.Call.Return(run)
	return _c
}

// ReduceCPULimits provides a mock function for the type MockPodContainerManager
func (_mock *MockPodContainerManager) ReduceCPULimits(logger klog.Logger, name cm.CgroupName) error {
	ret := _mock.Called(logger, name)

	if len(ret) == 0 {
		panic("no return value specified for ReduceCPULimits")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(klog.Logger, cm.CgroupName) error); ok {
		r0 = returnFunc(logger, name)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockPodContainerManager_ReduceCPULimits_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ReduceCPULimits'
type MockPodContainerManager_ReduceCPULimits_Call struct {
	*mock.Call
}

// ReduceCPULimits is a helper method to define mock.On call
//   - logger klog.Logger
//   - name cm.CgroupName
func (_e *MockPodContainerManager_Expecter) ReduceCPULimits(logger interface{}, name interface{}) *MockPodContainerManager_ReduceCPULimits_Call {
	return &MockPodContainerManager_ReduceCPULimits_Call{Call: _e.mock.On("ReduceCPULimits", logger, name)}
}

func (_c *MockPodContainerManager_ReduceCPULimits_Call) Run(run func(logger klog.Logger, name cm.CgroupName)) *MockPodContainerManager_ReduceCPULimits_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 klog.Logger
		if args[0] != nil {
			arg0 = args[0].(klog.Logger)
		}
		var arg1 cm.CgroupName
		if args[1] != nil {
			arg1 = args[1].(cm.CgroupName)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockPodContainerManager_ReduceCPULimits_Call) Return(err error) *MockPodContainerManager_ReduceCPULimits_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockPodContainerManager_ReduceCPULimits_Call) RunAndReturn(run func(logger klog.Logger, name cm.CgroupName) error) *MockPodContainerManager_ReduceCPULimits_Call {
	_c.Call.Return(run)
	return _c
}

// SetPodCgroupConfig provides a mock function for the type MockPodContainerManager
func (_mock *MockPodContainerManager) SetPodCgroupConfig(logger klog.Logger, pod *v1.Pod, resourceConfig *cm.ResourceConfig) error {
	ret := _mock.Called(logger, pod, resourceConfig)

	if len(ret) == 0 {
		panic("no return value specified for SetPodCgroupConfig")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(klog.Logger, *v1.Pod, *cm.ResourceConfig) error); ok {
		r0 = returnFunc(logger, pod, resourceConfig)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockPodContainerManager_SetPodCgroupConfig_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'SetPodCgroupConfig'
type MockPodContainerManager_SetPodCgroupConfig_Call struct {
	*mock.Call
}

// SetPodCgroupConfig is a helper method to define mock.On call
//   - logger klog.Logger
//   - pod *v1.Pod
//   - resourceConfig *cm.ResourceConfig
func (_e *MockPodContainerManager_Expecter) SetPodCgroupConfig(logger interface{}, pod interface{}, resourceConfig interface{}) *MockPodContainerManager_SetPodCgroupConfig_Call {
	return &MockPodContainerManager_SetPodCgroupConfig_Call{Call: _e.mock.On("SetPodCgroupConfig", logger, pod, resourceConfig)}
}

func (_c *MockPodContainerManager_SetPodCgroupConfig_Call) Run(run func(logger klog.Logger, pod *v1.Pod, resourceConfig *cm.ResourceConfig)) *MockPodContainerManager_SetPodCgroupConfig_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 klog.Logger
		if args[0] != nil {
			arg0 = args[0].(klog.Logger)
		}
		var arg1 *v1.Pod
		if args[1] != nil {
			arg1 = args[1].(*v1.Pod)
		}
		var arg2 *cm.ResourceConfig
		if args[2] != nil {
			arg2 = args[2].(*cm.ResourceConfig)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockPodContainerManager_SetPodCgroupConfig_Call) Return(err error) *MockPodContainerManager_SetPodCgroupConfig_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockPodContainerManager_SetPodCgroupConfig_Call) RunAndReturn(run func(logger klog.Logger, pod *v1.Pod, resourceConfig *cm.ResourceConfig) error) *MockPodContainerManager_SetPodCgroupConfig_Call {
	_c.Call.Return(run)
	return _c
}
