// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package mocks

import (
	"context"
	"sync"

	"github.com/umputun/spot/pkg/executor"
)

// ConnectorMock is a mock implementation of runner.Connector.
//
//	func TestSomethingThatUsesConnector(t *testing.T) {
//
//		// make and configure a mocked runner.Connector
//		mockedConnector := &ConnectorMock{
//			ConnectFunc: func(ctx context.Context, hostAddr string, hostName string, user string) (*executor.Remote, error) {
//				panic("mock out the Connect method")
//			},
//		}
//
//		// use mockedConnector in code that requires runner.Connector
//		// and then make assertions.
//
//	}
type ConnectorMock struct {
	// ConnectFunc mocks the Connect method.
	ConnectFunc func(ctx context.Context, hostAddr string, hostName string, user string) (*executor.Remote, error)

	// calls tracks calls to the methods.
	calls struct {
		// Connect holds details about calls to the Connect method.
		Connect []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// HostAddr is the hostAddr argument value.
			HostAddr string
			// HostName is the hostName argument value.
			HostName string
			// User is the user argument value.
			User string
		}
	}
	lockConnect sync.RWMutex
}

// Connect calls ConnectFunc.
func (mock *ConnectorMock) Connect(ctx context.Context, hostAddr string, hostName string, user string) (*executor.Remote, error) {
	if mock.ConnectFunc == nil {
		panic("ConnectorMock.ConnectFunc: method is nil but Connector.Connect was just called")
	}
	callInfo := struct {
		Ctx      context.Context
		HostAddr string
		HostName string
		User     string
	}{
		Ctx:      ctx,
		HostAddr: hostAddr,
		HostName: hostName,
		User:     user,
	}
	mock.lockConnect.Lock()
	mock.calls.Connect = append(mock.calls.Connect, callInfo)
	mock.lockConnect.Unlock()
	return mock.ConnectFunc(ctx, hostAddr, hostName, user)
}

// ConnectCalls gets all the calls that were made to Connect.
// Check the length with:
//
//	len(mockedConnector.ConnectCalls())
func (mock *ConnectorMock) ConnectCalls() []struct {
	Ctx      context.Context
	HostAddr string
	HostName string
	User     string
} {
	var calls []struct {
		Ctx      context.Context
		HostAddr string
		HostName string
		User     string
	}
	mock.lockConnect.RLock()
	calls = mock.calls.Connect
	mock.lockConnect.RUnlock()
	return calls
}
