"""Generated message classes for artifactscanguard version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'artifactscanguard'


class AffectedPackage(_messages.Message):
  r"""Affected package details.

  Fields:
    fixPackage: Output only. The package the issue was fixed in.
    name: Output only. The name of the package.
    version: Output only. The version of the package.
  """

  fixPackage = _messages.MessageField('FixPackage', 1)
  name = _messages.StringField(2)
  version = _messages.StringField(3)


class ArtifactEvaluation(_messages.Message):
  r"""ArtifactEvaluation contains details about the evaluation.

  Fields:
    conformant: Output only. Boolean flag which captures whether the
      evaluation was conformant or not. The conformance result is calculated
      based on policyEvaluation against the image CVEs.
    context: Required. PipelineContext contains details about the evaluation.
    createTime: Output only. The time at which the evaluation was created.
    etag: Optional. The etag for this connector. If this is provided on
      update, it must match the server's etag.
    evaluationResponse: Output only. The comprehensive response details of
      this artifact evaluation.
    imageMetadata: Required. ArtifactMetadata contains details about the
      image.
    name: Output only. The name of the artifactEvaluation, in the format `orga
      nizations/{organization_id}/locations/global/artifactEvaluations/{artifa
      ct_evaluation_id}`.
    reconciling: Output only. Indicates if changes are in flight. Whether the
      connector is in the process of being updated. See
      https://google.aip.dev/128 for more details.
    severityGroups: Output only. Aggregated CVE information grouped by
      severity. This is derived from the data within evaluation_response.cves.
    updateTime: Output only. The time at which the evaluation was last
      updated.
  """

  conformant = _messages.BooleanField(1)
  context = _messages.MessageField('PipelineContext', 2)
  createTime = _messages.StringField(3)
  etag = _messages.StringField(4)
  evaluationResponse = _messages.MessageField('EvaluationResponse', 5)
  imageMetadata = _messages.MessageField('ArtifactMetadata', 6)
  name = _messages.StringField(7)
  reconciling = _messages.BooleanField(8)
  severityGroups = _messages.MessageField('SeverityGroup', 9, repeated=True)
  updateTime = _messages.StringField(10)


class ArtifactEvaluationMetadata(_messages.Message):
  r"""ArtifactEvaluationMetadata contains metadata about the artifact
  evaluation.

  Fields:
    idempotentId: Output only. The idempotent ID for the artifact evaluation.
  """

  idempotentId = _messages.StringField(1)


class ArtifactMetadata(_messages.Message):
  r"""ArtifactMetadata contains details to uniquely identify a built image.

  Fields:
    buildTime: Optional. The time at which the image was built.
    imageDigest: Required. SHA256 hash of the image. For eg.:
      sha256:3b4173355427fabc9e0ddf909b0a3b4a715a831470a9a548839f6e6caa3b7e87
      Format: ^sha256:[a-f0-9]{64}$
    imageId: Optional. Unique image_id generated for an image after each
      build. For eg.: 4ecb2f62fbbd Format: ^[a-f0-9]{12}$
    imageName: Required. Name of docker image, usually of format
      [REGISTRY_HOST[:PORT]/][USERNAME/]REPOSITORY, for eg.: nginx
      myrepo/myapp gcr.io/my-project/myapp
      registry.example.com:5000/custom/image format:
      ^([a-z0-9]+(?:._-+)*)(/[a-z0-9]+(?:._-+)*)*$
    imageTag: Required. A tag identifies a specific version of an image. For
      eg.: latest v1.0.0 release-2024 123abc_test Format: ^\w{0,127}$
    purlUri: Optional. The unique GCS file name where purl is stored. Format:
      [BUCKET_NAME]/[OBJECT_NAME]
    sbomUri: Optional. The unique GCS file name where sbom is stored. Format:
      [BUCKET_NAME]/[OBJECT_NAME]
  """

  buildTime = _messages.StringField(1)
  imageDigest = _messages.StringField(2)
  imageId = _messages.StringField(3)
  imageName = _messages.StringField(4)
  imageTag = _messages.StringField(5, repeated=True)
  purlUri = _messages.StringField(6)
  sbomUri = _messages.StringField(7)


class ArtifactPoliciesEvaluation(_messages.Message):
  r"""Represents an artifact evaluation resource. This resource will be
  created by the RunArtifactPoliciesEvaluation RPC. Represents an artifact
  evaluation resource, detailing the outcome of scans and policy checks.

  Fields:
    artifactId: Immutable. The unique identifier for the artifact that was
      evaluated.
    connectorId: Immutable. The pipeline instance ID that this artifact
      evaluation applies to.
    evaluationResponse: Output only. The comprehensive response details of
      this artifact evaluation.
    name: Output only. Identifier. Resource name for the
      artifactPoliciesEvaluation, assigned by the server. Format: organization
      s/{organization_id}/locations/{location}/artifactPoliciesEvaluations/{ar
      tifact_policies_evaluation_id}
    scanTime: Output only. The timestamp when the artifact scan and evaluation
      were performed.
  """

  artifactId = _messages.StringField(1)
  connectorId = _messages.StringField(2)
  evaluationResponse = _messages.MessageField('EvaluationResponse', 3)
  name = _messages.StringField(4)
  scanTime = _messages.StringField(5)


class ArtifactscanguardFoldersLocationsConnectorsCreateRequest(_messages.Message):
  r"""A ArtifactscanguardFoldersLocationsConnectorsCreateRequest object.

  Fields:
    connector: A Connector resource to be passed as the request body.
    connectorId: Required. Id of the requesting object connector_id from the
      method_signature of Create RPC
    parent: Required. The parent resource where this connector will be
      created. Format: organizations/{organization_id}/locations/{location}
  """

  connector = _messages.MessageField('Connector', 1)
  connectorId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ArtifactscanguardFoldersLocationsConnectorsDeleteRequest(_messages.Message):
  r"""A ArtifactscanguardFoldersLocationsConnectorsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardFoldersLocationsConnectorsGetRequest(_messages.Message):
  r"""A ArtifactscanguardFoldersLocationsConnectorsGetRequest object.

  Fields:
    name: Required. The name of the connector, in the format
      `organizations/{organization}/locations/global/connectors/{connector_id}
      `
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardFoldersLocationsConnectorsListRequest(_messages.Message):
  r"""A ArtifactscanguardFoldersLocationsConnectorsListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListConnectorsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ArtifactscanguardFoldersLocationsConnectorsPatchRequest(_messages.Message):
  r"""A ArtifactscanguardFoldersLocationsConnectorsPatchRequest object.

  Fields:
    connector: A Connector resource to be passed as the request body.
    name: Required. Identifier. The name of the connector, in the format `orga
      nizations/{organization}/locations/{location}/connectors/{connector_id}`
      . connector_id is a free-text name.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Connector resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields present in the request will be
      overwritten.
  """

  connector = _messages.MessageField('Connector', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ArtifactscanguardFoldersLocationsGetRequest(_messages.Message):
  r"""A ArtifactscanguardFoldersLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardFoldersLocationsListRequest(_messages.Message):
  r"""A ArtifactscanguardFoldersLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class ArtifactscanguardFoldersLocationsOperationsCancelRequest(_messages.Message):
  r"""A ArtifactscanguardFoldersLocationsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardFoldersLocationsOperationsDeleteRequest(_messages.Message):
  r"""A ArtifactscanguardFoldersLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardFoldersLocationsOperationsGetRequest(_messages.Message):
  r"""A ArtifactscanguardFoldersLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardFoldersLocationsOperationsListRequest(_messages.Message):
  r"""A ArtifactscanguardFoldersLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the [ListOperationsResponse.unreachable] field. This can only be `true`
      when reading across collections e.g. when `parent` is set to
      `"projects/example/locations/-"`. This field is not by default supported
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class ArtifactscanguardOrganizationsLocationsArtifactEvaluationsDataGatewayRequest(_messages.Message):
  r"""A
  ArtifactscanguardOrganizationsLocationsArtifactEvaluationsDataGatewayRequest
  object.

  Fields:
    artifactMetadata_buildTime: Optional. The time at which the image was
      built.
    artifactMetadata_imageDigest: Required. SHA256 hash of the image. For eg.:
      sha256:3b4173355427fabc9e0ddf909b0a3b4a715a831470a9a548839f6e6caa3b7e87
      Format: ^sha256:[a-f0-9]{64}$
    artifactMetadata_imageId: Optional. Unique image_id generated for an image
      after each build. For eg.: 4ecb2f62fbbd Format: ^[a-f0-9]{12}$
    artifactMetadata_imageName: Required. Name of docker image, usually of
      format [REGISTRY_HOST[:PORT]/][USERNAME/]REPOSITORY, for eg.: nginx
      myrepo/myapp gcr.io/my-project/myapp
      registry.example.com:5000/custom/image format:
      ^([a-z0-9]+(?:._-+)*)(/[a-z0-9]+(?:._-+)*)*$
    artifactMetadata_imageTag: Required. A tag identifies a specific version
      of an image. For eg.: latest v1.0.0 release-2024 123abc_test Format:
      ^\w{0,127}$
    artifactMetadata_purlUri: Optional. The unique GCS file name where purl is
      stored. Format: [BUCKET_NAME]/[OBJECT_NAME]
    artifactMetadata_sbomUri: Optional. The unique GCS file name where sbom is
      stored. Format: [BUCKET_NAME]/[OBJECT_NAME]
    parent: Required. The parent resource name, in the format
      `organizations/{organization}/locations/global`.
  """

  artifactMetadata_buildTime = _messages.StringField(1)
  artifactMetadata_imageDigest = _messages.StringField(2)
  artifactMetadata_imageId = _messages.StringField(3)
  artifactMetadata_imageName = _messages.StringField(4)
  artifactMetadata_imageTag = _messages.StringField(5, repeated=True)
  artifactMetadata_purlUri = _messages.StringField(6)
  artifactMetadata_sbomUri = _messages.StringField(7)
  parent = _messages.StringField(8, required=True)


class ArtifactscanguardOrganizationsLocationsArtifactEvaluationsGetRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsArtifactEvaluationsGetRequest
  object.

  Fields:
    name: Required. The name of the artifactEvaluation, in the format `organiz
      ations/{organization}/locations/global/artifactEvaluations/{artifact_eva
      luation_id}`
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardOrganizationsLocationsArtifactEvaluationsRunRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsArtifactEvaluationsRunRequest
  object.

  Fields:
    parent: Required. The parent resource name, in the format
      `organizations/{organization_id}/locations/global`.
    runArtifactEvaluationRequest: A RunArtifactEvaluationRequest resource to
      be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  runArtifactEvaluationRequest = _messages.MessageField('RunArtifactEvaluationRequest', 2)


class ArtifactscanguardOrganizationsLocationsArtifactPoliciesEvaluationsGetRequest(_messages.Message):
  r"""A
  ArtifactscanguardOrganizationsLocationsArtifactPoliciesEvaluationsGetRequest
  object.

  Fields:
    name: Required. The full resource name of the policy to retrieve. Format:
      organizations/{organization_id}/locations/{location_id}/artifactPolicies
      Evaluation/{artifact_policies_evaluation_id}
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardOrganizationsLocationsArtifactPoliciesEvaluationsRunRequest(_messages.Message):
  r"""A
  ArtifactscanguardOrganizationsLocationsArtifactPoliciesEvaluationsRunRequest
  object.

  Fields:
    parent: Required. The parent resource where this policy evaluation will be
      created. Format: organizations/{organization_id}/locations/{location}
    runArtifactPoliciesEvaluationRequest: A
      RunArtifactPoliciesEvaluationRequest resource to be passed as the
      request body.
  """

  parent = _messages.StringField(1, required=True)
  runArtifactPoliciesEvaluationRequest = _messages.MessageField('RunArtifactPoliciesEvaluationRequest', 2)


class ArtifactscanguardOrganizationsLocationsConnectorsCreateRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsConnectorsCreateRequest object.

  Fields:
    connector: A Connector resource to be passed as the request body.
    connectorId: Required. Id of the requesting object connector_id from the
      method_signature of Create RPC
    parent: Required. The parent resource where this connector will be
      created. Format: organizations/{organization_id}/locations/{location}
  """

  connector = _messages.MessageField('Connector', 1)
  connectorId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ArtifactscanguardOrganizationsLocationsConnectorsDeleteRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsConnectorsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardOrganizationsLocationsConnectorsGetRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsConnectorsGetRequest object.

  Fields:
    name: Required. The name of the connector, in the format
      `organizations/{organization}/locations/global/connectors/{connector_id}
      `
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardOrganizationsLocationsConnectorsListRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsConnectorsListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListConnectorsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ArtifactscanguardOrganizationsLocationsConnectorsPatchRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsConnectorsPatchRequest object.

  Fields:
    connector: A Connector resource to be passed as the request body.
    name: Required. Identifier. The name of the connector, in the format `orga
      nizations/{organization}/locations/{location}/connectors/{connector_id}`
      . connector_id is a free-text name.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Connector resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields present in the request will be
      overwritten.
  """

  connector = _messages.MessageField('Connector', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ArtifactscanguardOrganizationsLocationsGetRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardOrganizationsLocationsListRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class ArtifactscanguardOrganizationsLocationsOperationsCancelRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardOrganizationsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardOrganizationsLocationsOperationsGetRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardOrganizationsLocationsOperationsListRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the [ListOperationsResponse.unreachable] field. This can only be `true`
      when reading across collections e.g. when `parent` is set to
      `"projects/example/locations/-"`. This field is not by default supported
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class ArtifactscanguardOrganizationsLocationsPoliciesCreateRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsPoliciesCreateRequest object.

  Fields:
    parent: Required. The parent resource where this policy will be created.
      Format: organizations/{organization_id}/locations/{location}
    policy: A Policy resource to be passed as the request body.
    policyId: Required. The ID of the policy to create. This is the last part
      of the full name of the policy resource. It is required for API
      consistency.
    validateOnly: Optional. True to perform validations necessary for updating
      the resource, but not actually perform the action.
  """

  parent = _messages.StringField(1, required=True)
  policy = _messages.MessageField('Policy', 2)
  policyId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class ArtifactscanguardOrganizationsLocationsPoliciesDeleteRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsPoliciesDeleteRequest object.

  Fields:
    etag: Optional. An opaque identifier for the current version of the
      policy. If you provide this value, then it must match the existing
      value. If the values don't match, then the request fails with an ABORTED
      error. If you omit this value, then the policy is deleted regardless of
      its current `etag` value.
    name: Required. The full resource name of the policy to delete. Format:
      organizations/{organization_id}/locations/{location}/policies/{policy_id
      }
    validateOnly: Optional. True to perform validations necessary for updating
      the resource, but not actually perform the action.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class ArtifactscanguardOrganizationsLocationsPoliciesGetRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsPoliciesGetRequest object.

  Fields:
    name: Required. The full resource name of the policy to retrieve. Format:
      organizations/{organization_id}/locations/{location}/policies/{policy_id
      }
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardOrganizationsLocationsPoliciesListRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsPoliciesListRequest object.

  Fields:
    filter: Optional. A filter expression to restrict the policies returned.
      The filter is a sequence of field-operator-value expressions, separated
      by "AND". Fields can be "policy_id", "enforcement_action",
      "enablement_state". The operators are "=" (equals) and "!=" (not
      equals). Example: "policy_id=my-policy AND enablement_state=ENABLED"
    pageSize: Optional. The maximum number of policies to return. The service
      may return fewer than this value. If unspecified, at most 100 policies
      will be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. A page token received from a previous `ListPolicies`
      call. Provide this to retrieve the subsequent page.
    parent: Required. The parent resource whose policies are to be listed.
      Format: organizations/{organization_id}/locations/{location}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ArtifactscanguardOrganizationsLocationsPoliciesPatchRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsPoliciesPatchRequest object.

  Fields:
    allowMissing: Optional. If allow_missing is set, and the resource is not
      found, it will be created. The field mask will then be ignored.
    name: Output only. Identifier. Format: organizations/{organization_id}/loc
      ations/{location_id}/policies/{policy_id}
    policy: A Policy resource to be passed as the request body.
    updateMask: Optional. A mask specifying which fields in the Policy to
      update. If a FieldMask is not provided, the system will default to
      updating all fields.
    validateOnly: Optional. True to perform validations necessary for updating
      the resource, but not actually perform the action.
  """

  allowMissing = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  policy = _messages.MessageField('Policy', 3)
  updateMask = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class ArtifactscanguardOrganizationsLocationsReportsConnectorEvaluationsListRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsReportsConnectorEvaluationsList
  Request object.

  Fields:
    pageSize: Optional. The maximum number of entries to return. If
      unspecified, a default number of 100 entries will be returned. The
      maximum value is 1000
    pageToken: Optional. A page token received from a previous call.
    parent: Required. The parent resource name for which to list summaries.
      Format: organizations/{organization_id}/locations/{location_id}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ArtifactscanguardOrganizationsLocationsReportsPolicyEvaluationSummariesListRequest(_messages.Message):
  r"""A ArtifactscanguardOrganizationsLocationsReportsPolicyEvaluationSummarie
  sListRequest object.

  Fields:
    pageSize: Optional. The maximum number of entries to return. If
      unspecified, a default number of 100 entries will be returned. The
      maximum value is 1000
    pageToken: Optional. A page token received from a previous
      `ListPolicyScopeSummary` call. Provide this to retrieve the subsequent
      page.
    parent: Required. The parent resource whose policies are to be listed.
      Format: organizations/{organization_id}/locations/{location_id}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ArtifactscanguardProjectsLocationsConnectorsCreateRequest(_messages.Message):
  r"""A ArtifactscanguardProjectsLocationsConnectorsCreateRequest object.

  Fields:
    connector: A Connector resource to be passed as the request body.
    connectorId: Required. Id of the requesting object connector_id from the
      method_signature of Create RPC
    parent: Required. The parent resource where this connector will be
      created. Format: organizations/{organization_id}/locations/{location}
  """

  connector = _messages.MessageField('Connector', 1)
  connectorId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ArtifactscanguardProjectsLocationsConnectorsDeleteRequest(_messages.Message):
  r"""A ArtifactscanguardProjectsLocationsConnectorsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardProjectsLocationsConnectorsGetRequest(_messages.Message):
  r"""A ArtifactscanguardProjectsLocationsConnectorsGetRequest object.

  Fields:
    name: Required. The name of the connector, in the format
      `organizations/{organization}/locations/global/connectors/{connector_id}
      `
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardProjectsLocationsConnectorsListRequest(_messages.Message):
  r"""A ArtifactscanguardProjectsLocationsConnectorsListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListConnectorsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ArtifactscanguardProjectsLocationsConnectorsPatchRequest(_messages.Message):
  r"""A ArtifactscanguardProjectsLocationsConnectorsPatchRequest object.

  Fields:
    connector: A Connector resource to be passed as the request body.
    name: Required. Identifier. The name of the connector, in the format `orga
      nizations/{organization}/locations/{location}/connectors/{connector_id}`
      . connector_id is a free-text name.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Connector resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields present in the request will be
      overwritten.
  """

  connector = _messages.MessageField('Connector', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ArtifactscanguardProjectsLocationsGetRequest(_messages.Message):
  r"""A ArtifactscanguardProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardProjectsLocationsListRequest(_messages.Message):
  r"""A ArtifactscanguardProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class ArtifactscanguardProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A ArtifactscanguardProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ArtifactscanguardProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A ArtifactscanguardProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ArtifactscanguardProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ArtifactscanguardProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ArtifactscanguardProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the [ListOperationsResponse.unreachable] field. This can only be `true`
      when reading across collections e.g. when `parent` is set to
      `"projects/example/locations/-"`. This field is not by default supported
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class CVE(_messages.Message):
  r"""Nested message for CVE details specific to EvaluationResponse. The
  following fields are populated only if the verbose flag is set to true: -
  cvss_score - affected_package.fix_package - related_references

  Enums:
    SeverityValueValuesEnum: Output only. Severity of the CVE (e.g.,
      "CRITICAL", "HIGH")

  Fields:
    affectedPackages: Output only. The packages affected by the CVE.
    cvssScore: Output only. The CVSS score of the CVE.
    detectionTime: Output only. The timestamp when the CVE was detected.
    name: Output only. The CVE identifier, e.g., "CVE-2023-1234"
    relatedReferences: Output only. Additional references related to the CVE.
    severity: Output only. Severity of the CVE (e.g., "CRITICAL", "HIGH")
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Output only. Severity of the CVE (e.g., "CRITICAL", "HIGH")

    Values:
      SEVERITY_UNSPECIFIED: The severity is unspecified.
      LOW: Low severity.
      MEDIUM: Medium severity.
      HIGH: High severity.
      CRITICAL: Critical severity. This is the maximum severity level.
    """
    SEVERITY_UNSPECIFIED = 0
    LOW = 1
    MEDIUM = 2
    HIGH = 3
    CRITICAL = 4

  affectedPackages = _messages.MessageField('AffectedPackage', 1, repeated=True)
  cvssScore = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  detectionTime = _messages.StringField(3)
  name = _messages.StringField(4)
  relatedReferences = _messages.MessageField('RelatedReference', 5, repeated=True)
  severity = _messages.EnumField('SeverityValueValuesEnum', 6)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudBuild(_messages.Message):
  r"""CloudBuild contains details about the Cloud Build job.
  https://cloud.google.com/build/docs/configuring-builds/substitute-variable-
  values

  Fields:
    buildId: Required. Globally unique for all cloud builds. UUID for eg.:
      f9b2dabc-1234-4567-890a-abc123456789, of format:
      ^[0-9a-f]{8}-[0-9a-f]{4}-1-5{3}-89ab{3}-[0-9a-f]{12}$
    projectId: Required. GCP project the build runs in. ^a-z{4,28}[a-z0-9]$
    triggerId: Optional. A fixed ID for a configured trigger in Google Cloud
      Console Present only when the build is started by a configured trigger
      (like from Git push, tag, or GitHub/Bitbucket webhook) UUID for eg.:
      f9b2dabc-1234-4567-890a-abc123456789, of format:
      ^[0-9a-f]{8}-[0-9a-f]{4}-1-5{3}-89ab{3}-[0-9a-f]{12}$
  """

  buildId = _messages.StringField(1)
  projectId = _messages.StringField(2)
  triggerId = _messages.StringField(3)


class Connector(_messages.Message):
  r"""CI Pipeline Instance configuration.

  Enums:
    PipelineTypeValueValuesEnum: Required. Platform Type of the CI/CD Pipeline
      for the Connector.

  Fields:
    createTime: Output only. The time at which the connector was created.
    description: Optional. Human-readable description of the connector. Length
      should be less than or equal to 256 characters.
    displayName: Optional. Human-readable display name of the connector.
      Length should be less than or equal to 256 characters.
    etag: Optional. The etag for this connector. If this is provided on
      update, it must match the server's etag.
    name: Required. Identifier. The name of the connector, in the format `orga
      nizations/{organization}/locations/{location}/connectors/{connector_id}`
      . connector_id is a free-text name.
    pipelineType: Required. Platform Type of the CI/CD Pipeline for the
      Connector.
    reconciling: Output only. Indicates if changes are in flight. Whether the
      connector is in the process of being updated. See
      https://google.aip.dev/128 for more details.
    updateTime: Output only. The time at which the connector was last updated.
  """

  class PipelineTypeValueValuesEnum(_messages.Enum):
    r"""Required. Platform Type of the CI/CD Pipeline for the Connector.

    Values:
      PIPELINE_TYPE_UNSPECIFIED: Default value. This value is unused.
      JENKINS_PIPELINE: Jenkins Pipeline.
      GITHUB_ACTIONS: GitHub Actions Pipeline.
      GOOGLE_CLOUD_BUILD: Google Cloud Build Pipeline.
    """
    PIPELINE_TYPE_UNSPECIFIED = 0
    JENKINS_PIPELINE = 1
    GITHUB_ACTIONS = 2
    GOOGLE_CLOUD_BUILD = 3

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  name = _messages.StringField(5)
  pipelineType = _messages.EnumField('PipelineTypeValueValuesEnum', 6)
  reconciling = _messages.BooleanField(7)
  updateTime = _messages.StringField(8)


class ConnectorEvaluationSummary(_messages.Message):
  r"""Represents an aggregated summary of evaluations for a single connector.

  Enums:
    PipelineTypeValueValuesEnum: The Pipeline type (e.g., GITHUB_ACTIONS,
      GITLAB_CI).

  Fields:
    connectorId: The unique ID of the connector.
    createTime: The timestamp when the connector was created.
    description: The description of the connector.
    displayName: The display name of the connector.
    failedScans: Number of scans that failed policy evaluation.
    name: full resource name of the connector. Format: organizations/{organiza
      tion_id}/locations/{location_id}/connectors/{connector_id}
    pipelineType: The Pipeline type (e.g., GITHUB_ACTIONS, GITLAB_CI).
    policyIds: The list of policy ids defined for this connector.
    totalScans: Total number of scans performed via this connector.
  """

  class PipelineTypeValueValuesEnum(_messages.Enum):
    r"""The Pipeline type (e.g., GITHUB_ACTIONS, GITLAB_CI).

    Values:
      PIPELINE_TYPE_UNSPECIFIED: Default value. This value is unused.
      JENKINS_PIPELINE: Jenkins Pipeline.
      GITHUB_ACTIONS: GitHub Actions Pipeline.
      GOOGLE_CLOUD_BUILD: Google Cloud Build Pipeline.
    """
    PIPELINE_TYPE_UNSPECIFIED = 0
    JENKINS_PIPELINE = 1
    GITHUB_ACTIONS = 2
    GOOGLE_CLOUD_BUILD = 3

  connectorId = _messages.StringField(1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  failedScans = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  name = _messages.StringField(6)
  pipelineType = _messages.EnumField('PipelineTypeValueValuesEnum', 7)
  policyIds = _messages.StringField(8, repeated=True)
  totalScans = _messages.IntegerField(9, variant=_messages.Variant.INT32)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class EvaluatedPolicy(_messages.Message):
  r"""Nested message for policy details specific to EvaluationResponse.

  Enums:
    PolicyEnforcementActionValueValuesEnum: Output only. The enforcement
      action to take when this policy is violated. This is populated only if
      the policy is violated.

  Fields:
    cves: Output only. List of CVEs that passed or failed the evaluation, as
      per the evaluation result.
    failureReason: Output only. The reason why the policy evaluation failed.
      Eg: "Maximum severity found: CRITICAL, Allowed maximum severity:
      MEDIUM."
    name: Output only. The name of the policy.
    policyEnforcementAction: Output only. The enforcement action to take when
      this policy is violated. This is populated only if the policy is
      violated.
  """

  class PolicyEnforcementActionValueValuesEnum(_messages.Enum):
    r"""Output only. The enforcement action to take when this policy is
    violated. This is populated only if the policy is violated.

    Values:
      ENFORCEMENT_ACTION_UNSPECIFIED: The enforcement action is unspecified.
      AUDIT_ONLY: The policy is evaluated but not enforced. The policy
        violation is only logged and not reported.
      BLOCK: The policy is evaluated and enforced. The policy violation is
        reported and the resource is blocked.
    """
    ENFORCEMENT_ACTION_UNSPECIFIED = 0
    AUDIT_ONLY = 1
    BLOCK = 2

  cves = _messages.MessageField('CVE', 1, repeated=True)
  failureReason = _messages.StringField(2)
  name = _messages.StringField(3)
  policyEnforcementAction = _messages.EnumField('PolicyEnforcementActionValueValuesEnum', 4)


class EvaluationResponse(_messages.Message):
  r"""The comprehensive response structure for a policy evaluation.

  Enums:
    EnforcementActionValueValuesEnum: Output only. The recommended enforcement
      action in case the policy evaluation fails. It is populated only if the
      policy evaluation fails. If any one of the failed policies has a BLOCK
      enforcement action, then the overall enforcement action will be BLOCK.
      Otherwise, it will be AUDIT_ONLY.
    EvaluationStatusValueValuesEnum: Output only. The overall result of the
      evaluation.

  Fields:
    cves: Output only. List of CVEs found during the evaluation with detailed
      information.
    enforcementAction: Output only. The recommended enforcement action in case
      the policy evaluation fails. It is populated only if the policy
      evaluation fails. If any one of the failed policies has a BLOCK
      enforcement action, then the overall enforcement action will be BLOCK.
      Otherwise, it will be AUDIT_ONLY.
    evaluationStatus: Output only. The overall result of the evaluation.
    failedPolicies: Output only. List of policies that failed the evaluation.
    passedPolicies: Output only. List of policy IDs that passed the
      evaluation.
  """

  class EnforcementActionValueValuesEnum(_messages.Enum):
    r"""Output only. The recommended enforcement action in case the policy
    evaluation fails. It is populated only if the policy evaluation fails. If
    any one of the failed policies has a BLOCK enforcement action, then the
    overall enforcement action will be BLOCK. Otherwise, it will be
    AUDIT_ONLY.

    Values:
      ENFORCEMENT_ACTION_UNSPECIFIED: The enforcement action is unspecified.
      AUDIT_ONLY: The policy is evaluated but not enforced. The policy
        violation is only logged and not reported.
      BLOCK: The policy is evaluated and enforced. The policy violation is
        reported and the resource is blocked.
    """
    ENFORCEMENT_ACTION_UNSPECIFIED = 0
    AUDIT_ONLY = 1
    BLOCK = 2

  class EvaluationStatusValueValuesEnum(_messages.Enum):
    r"""Output only. The overall result of the evaluation.

    Values:
      EVALUATION_STATUS_UNSPECIFIED: The evaluation status is unspecified.
      IN_PROGRESS: The evaluation is in progress.
      PASSED: The evaluation passed.
      FAILED: The evaluation failed.
      ERROR: The evaluation encountered an error.
    """
    EVALUATION_STATUS_UNSPECIFIED = 0
    IN_PROGRESS = 1
    PASSED = 2
    FAILED = 3
    ERROR = 4

  cves = _messages.MessageField('CVE', 1, repeated=True)
  enforcementAction = _messages.EnumField('EnforcementActionValueValuesEnum', 2)
  evaluationStatus = _messages.EnumField('EvaluationStatusValueValuesEnum', 3)
  failedPolicies = _messages.MessageField('EvaluatedPolicy', 4, repeated=True)
  passedPolicies = _messages.MessageField('EvaluatedPolicy', 5, repeated=True)


class ExemptedCVE(_messages.Message):
  r"""Defines a CVE and its exemption details.

  Fields:
    gracePeriodExpirationTime: Optional. The grace period at which the CVE
      exemption expires.
    id: Required. The CVE ID to be exempted. Example: CVE-2024-12345
  """

  gracePeriodExpirationTime = _messages.StringField(1)
  id = _messages.StringField(2)


class FixPackage(_messages.Message):
  r"""The fix package details.

  Fields:
    name: Output only. The name of the package.
    version: Output only. The version of the package.
  """

  name = _messages.StringField(1)
  version = _messages.StringField(2)


class GithubAction(_messages.Message):
  r"""GithubAction contains details about the GitHub workflow.
  https://docs.github.com/en/actions/writing-workflows/choosing-what-your-
  workflow-does/store-information-in-variables#default-environment-variables

  Fields:
    repository: Optional. The github repository name. eg.: octocat/hello-world
      my-org/my_repo-1 user.name/project.test format:
      ^[a-zA-Z0-9_.-]+\/[a-zA-Z0-9_.-]+$
    runId: Required. Globally unique identifier for each run of the workflow.
      This value does not change when the workflow is re-run. eg.: 6437182741
      format: ^\d{6,}$
    workflow: Optional. Identifies the name of the workflow. eg.: CI Pipeline
      - Build & Test format: ^.*$
  """

  repository = _messages.StringField(1)
  runId = _messages.StringField(2)
  workflow = _messages.StringField(3)


class Jenkins(_messages.Message):
  r"""Jenkins contains details about the Jenkins job.
  https://www.jenkins.io/doc/book/pipeline/jenkinsfile/#using-environment-
  variables

  Fields:
    buildId: Required. A unique build id for a specific Jekins pipeline.
      Captures run time, for eg.: 2025-06-12_14-05-38 format:
      ^\d{4}-\d{2}-\d{2}_\d{2}-\d{2}-\d{2}$ (YYYY-MM-DD_hh-mm-ss)
    buildTag: Required. Uniquely identifies each jenkins run. It is generated
      by combining the jenkins-${JOB_NAME}-${BUILD_NUMBER} eg.: jenkins-
      MyPipeline-14 jenkins-Folder1/SubFolder2/MyJob-123 format:
      ^(?=.{1,256}$)jenkins-[a-zA-Z0-9._\-\/]+-\d+$
  """

  buildId = _messages.StringField(1)
  buildTag = _messages.StringField(2)


class ListConnectorEvaluationsResponse(_messages.Message):
  r"""Response message for the ListConnectorEvaluations RPC. Disable the rule
  for the message's overall structure.

  Fields:
    connectorEvaluationSummaries: A list of connector evaluation summaries.
      Disable the rule for the field's name.
    nextPageToken: A token to retrieve the next page of results.
  """

  connectorEvaluationSummaries = _messages.MessageField('ConnectorEvaluationSummary', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListConnectorsResponse(_messages.Message):
  r"""Message for response to listing Connectors

  Fields:
    connectors: The list of Connector
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Unordered list. Locations that could not be reached.
  """

  connectors = _messages.MessageField('Connector', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections e.g. when attempting to list all resources across all
      supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListPoliciesResponse(_messages.Message):
  r"""Response message for the ListPolicies RPC.

  Fields:
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    policies: The policies found.
  """

  nextPageToken = _messages.StringField(1)
  policies = _messages.MessageField('Policy', 2, repeated=True)


class ListPolicyEvaluationSummariesResponse(_messages.Message):
  r"""Response message for the ListPolicyEvaluationSummaries RPC. Disable the
  rule for the message's overall structure.

  Fields:
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    policyEvaluationSummaries: The list of policy evaluation summaries.
      Disable the rule for the field's name.
  """

  nextPageToken = _messages.StringField(1)
  policyEvaluationSummaries = _messages.MessageField('PolicyEvaluationSummary', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Metadata for an Operation.

  Fields:
    apiVersion: Output only. The API version used to start the operation.
    artifactEvaluationMetadata: Output only. Metadata for Artifact Evaluation
      LRO.
    createTime: Output only. The time at which the operation was created.
    endTime: Output only. The time at which the operation finished running.
    errorMessage: Output only. The error message returned by the operation.
    requestedCancellation: Output only. Whether a request to cancel the
      operation has been received. For operations that have been cancelled
      successfully, the Operation.error field contains the error code
      CANCELLED.
    statusMessage: Output only. The status of the operation, if any.
    target: Output only. The server-defined resource path for the target of
      the operation.
    verb: Output only. The name of the action executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  artifactEvaluationMetadata = _messages.MessageField('ArtifactEvaluationMetadata', 2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  errorMessage = _messages.StringField(5)
  requestedCancellation = _messages.BooleanField(6)
  statusMessage = _messages.StringField(7)
  target = _messages.StringField(8)
  verb = _messages.StringField(9)


class Package(_messages.Message):
  r"""Defines a package.

  Fields:
    name: Required. The name of the package.
    version: Optional. The version of the package. If this is empty, the
      policy will apply to all versions of the package.
  """

  name = _messages.StringField(1)
  version = _messages.StringField(2)


class Pipeline(_messages.Message):
  r"""Pipeline has the connector IDs that are associated with the policy.

  Enums:
    EnforcementActionValueValuesEnum: Required. The enforcement action to take
      when this policy is violated in the pipeline scope.

  Fields:
    connectorIds: Required. The connector ID(s) that this policy is associated
      with. Format: organizations/{organization_id}/locations/{location_id}/co
      nnectors/{connector_id}
    enforcementAction: Required. The enforcement action to take when this
      policy is violated in the pipeline scope.
    imageNamePatterns: Optional. The image name patterns that this policy is
      associated with. This will not be a fully qualified image name. Format:
      {image_name_pattern} where image_name_pattern is a regex.
  """

  class EnforcementActionValueValuesEnum(_messages.Enum):
    r"""Required. The enforcement action to take when this policy is violated
    in the pipeline scope.

    Values:
      PIPELINE_ENFORCEMENT_ACTION_UNSPECIFIED: The enforcement action is
        unspecified.
      AUDIT_ONLY: The policy is evaluated but not enforced. The policy
        violation is only logged and not reported.
      BLOCK_BUILD: The policy is evaluated and enforced. The policy violation
        is reported and the resource is blocked. User will be recommended to
        block the build.
    """
    PIPELINE_ENFORCEMENT_ACTION_UNSPECIFIED = 0
    AUDIT_ONLY = 1
    BLOCK_BUILD = 2

  connectorIds = _messages.StringField(1, repeated=True)
  enforcementAction = _messages.EnumField('EnforcementActionValueValuesEnum', 2)
  imageNamePatterns = _messages.StringField(3, repeated=True)


class PipelineContext(_messages.Message):
  r"""PipelineContext contains details about the source which triggered the
  evaluation.

  Fields:
    cloudBuild: Optional. Cloud Build.
    githubAction: Optional. GitHub Action workflow.
    jenkins: Optional. Jenkins CI Pipeline.
  """

  cloudBuild = _messages.MessageField('CloudBuild', 1)
  githubAction = _messages.MessageField('GithubAction', 2)
  jenkins = _messages.MessageField('Jenkins', 3)


class PipelineEvaluationScope(_messages.Message):
  r"""The pipeline scope that this artifact evaluation is associated with.

  Fields:
    connectorId: Required. The connector ID that this policy is associated
      with. Format: organizations/{organization_id}/locations/{location_id}/co
      nnectors/{connector_id}
  """

  connectorId = _messages.StringField(1)


class Policy(_messages.Message):
  r"""Policy is a resource that defines a policy for managing software
  vulnerabilities.

  Enums:
    EnablementStateValueValuesEnum: Required. Defines the operational state of
      a policy.

  Messages:
    AnnotationsValue: Optional. Annotations are user-provided labels for the
      policy.

  Fields:
    annotations: Optional. Annotations are user-provided labels for the
      policy.
    createTime: Output only. The timestamp when the policy was created.
    description: Optional. The description of the policy. This is a user-
      friendly description for the policy.
    displayName: Optional. The display name of the policy. This is a user-
      friendly name for the policy.
    enablementState: Required. Defines the operational state of a policy.
    etag: Optional. An opaque identifier for the current version of the
      policy. To prevent concurrent updates from overwriting each other,
      always provide the `etag` when you update a policy. You can also provide
      the `etag` when you delete a policy, to help ensure that you're deleting
      the intended version of the policy.
    name: Output only. Identifier. Format: organizations/{organization_id}/loc
      ations/{location_id}/policies/{policy_id}
    reconciling: Output only. Whether the policy is in the process of being
      updated.
    scope: Required. Defines where this policy will be applicable.
    updateTime: Output only. The timestamp when the policy was last updated.
    vulnerabilityPolicy: Vulnerability policy. In future we will have secret
      and malware policy as well
  """

  class EnablementStateValueValuesEnum(_messages.Enum):
    r"""Required. Defines the operational state of a policy.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: The enablement state is unspecified.
      DRAFT: Draft mode. This is a new policy that is not yet enabled.
      DRY_RUN: Dry run mode. The policy is evaluated but not enforced.
      ENABLED: Deprecated. Use ACTIVE instead.
      DISABLED: Deprecated. Use INACTIVE instead.
      ACTIVE: The policy is enabled.
      INACTIVE: The policy is disabled. It will no longer be evaluated.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    DRAFT = 1
    DRY_RUN = 2
    ENABLED = 3
    DISABLED = 4
    ACTIVE = 5
    INACTIVE = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. Annotations are user-provided labels for the policy.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  enablementState = _messages.EnumField('EnablementStateValueValuesEnum', 5)
  etag = _messages.StringField(6)
  name = _messages.StringField(7)
  reconciling = _messages.BooleanField(8)
  scope = _messages.MessageField('PolicyScope', 9)
  updateTime = _messages.StringField(10)
  vulnerabilityPolicy = _messages.MessageField('VulnerabilityPolicy', 11)


class PolicyEvaluationSummary(_messages.Message):
  r"""Represents a single aggregated summary of a policy's evaluations. This
  message corresponds to one row in your target table.

  Enums:
    ScopesValueListEntryValuesEnum:
    StateValueValuesEnum: Output only. The state of policy

  Fields:
    createTime: The timestamp when the policy was created.
    deploymentBlockedCount: The number of times this policy blocked a
      deployment.
    displayName: The display name of the policy.
    failedCount: The count of evaluations that failed.
    lastScanTime: The timestamp of the most recent evaluation against this
      policy.
    name: Full resource name of the policy. Format: organizations/{organizatio
      n_id}/locations/{location_id}/policies/{policy_id}
    passedCount: The count of evaluations that passed.
    scopes: The scopes the policy applies to (e.g., "PIPELINE_SCOPE",
      "REGISTRY_SCOPE").
    state: Output only. The state of policy
    totalPolicyEvaluations: Total number of times this policy was evaluated.
  """

  class ScopesValueListEntryValuesEnum(_messages.Enum):
    r"""ScopesValueListEntryValuesEnum enum type.

    Values:
      POLICY_SCOPE_TYPE_UNSPECIFIED: The policy scope type is unspecified.
      PIPELINE: The policy scope is a pipeline.
      REGISTRY: The policy scope is a registry.
      RUNTIME: The policy scope is a runtime.
    """
    POLICY_SCOPE_TYPE_UNSPECIFIED = 0
    PIPELINE = 1
    REGISTRY = 2
    RUNTIME = 3

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of policy

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: The enablement state is unspecified.
      DRAFT: Draft mode. This is a new policy that is not yet enabled.
      DRY_RUN: Dry run mode. The policy is evaluated but not enforced.
      ENABLED: Deprecated. Use ACTIVE instead.
      DISABLED: Deprecated. Use INACTIVE instead.
      ACTIVE: The policy is enabled.
      INACTIVE: The policy is disabled. It will no longer be evaluated.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    DRAFT = 1
    DRY_RUN = 2
    ENABLED = 3
    DISABLED = 4
    ACTIVE = 5
    INACTIVE = 6

  createTime = _messages.StringField(1)
  deploymentBlockedCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  displayName = _messages.StringField(3)
  failedCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  lastScanTime = _messages.StringField(5)
  name = _messages.StringField(6)
  passedCount = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  scopes = _messages.EnumField('ScopesValueListEntryValuesEnum', 8, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  totalPolicyEvaluations = _messages.IntegerField(10, variant=_messages.Variant.INT32)


class PolicyScope(_messages.Message):
  r"""Defines the scope of a policy. A policy is applicable to a set of images
  that are scanned by a pipeline.

  Fields:
    pipeline: Optional. The pipelines that this policy is associated with. A
      pipeline connector could be associated with maximum 100 policies.
    registry: Optional. The registry scopes that this policy is associated
      with.
    runtime: Optional. The runtime scopes that this policy is associated with.
  """

  pipeline = _messages.MessageField('Pipeline', 1)
  registry = _messages.MessageField('RegistryScope', 2)
  runtime = _messages.MessageField('RuntimeScope', 3)


class RegistryEvaluationScope(_messages.Message):
  r"""The registry scope that this artifact evaluation is associated with.

  Fields:
    garRepository: Optional. The gar repository that this artifact evaluation
      is associated with. Format:
      {location}-[pkg_type].pkg.dev/{project_id}/REPOSITORY_PATTERN or
      {us|eu|asia}.gcr.io/{project_id} or gcr.io/{project_id}
    projectId: Optional. The project that is associated with the registry.
      Format: projects/{project_id}
  """

  garRepository = _messages.StringField(1)
  projectId = _messages.StringField(2)


class RegistryScope(_messages.Message):
  r"""RegistryScope contains the repositories and the projects that are
  associated with the registry.

  Fields:
    garRepositoryNamePatterns: Optional. At least one of the gar_repositories
      or projects must be set. The gar repositories that this policy is
      associated with. Format:
      {location}-[pkg_type].pkg.dev/{project_id}/REPOSITORY_PATTERN or
      {us|eu|asia}.gcr.io/{project_id} or gcr.io/{project_id}
    imageNamePatterns: Optional. The image name patterns that this policy is
      associated with. This will be a fully qualified image name. Format:
      full_repo_name/{image_name_pattern} where image_name_pattern is a regex.
    projectIds: Optional. The projects that are associated with the registry.
      Format: projects/{project_id}
  """

  garRepositoryNamePatterns = _messages.StringField(1, repeated=True)
  imageNamePatterns = _messages.StringField(2, repeated=True)
  projectIds = _messages.StringField(3, repeated=True)


class RelatedReference(_messages.Message):
  r"""Additional information about the CVE.

  Fields:
    source: Source of the reference e.g. NVD
    uri: Uri for the mentioned source e.g. https://cve.mitre.org/cgi-
      bin/cvename.cgi?name=CVE-2021-34527.
  """

  source = _messages.StringField(1)
  uri = _messages.StringField(2)


class RunArtifactEvaluationRequest(_messages.Message):
  r"""RunArtifactEvaluationRequest is the request message for
  RunArtifactEvaluation.

  Fields:
    artifactEvaluationId: Optional. The unique identifier for the artifact
      evaluation.
    artifactMetadata: Required. ArtifactMetadata contains details about the
      artifact.
    pipelineConnector: Immutable. ID of the pipeline instance that triggered
      the evaluation. Format: {connector_id} or organizations/{organization}/l
      ocations/{location}/connectors/{connector_id}
    pipelineContext: Required. PipelineContext contains details about the
      source which triggered the evaluation.
    verbose: Optional. Indicates if the evaluation should be verbose.
  """

  artifactEvaluationId = _messages.StringField(1)
  artifactMetadata = _messages.MessageField('ArtifactMetadata', 2)
  pipelineConnector = _messages.StringField(3)
  pipelineContext = _messages.MessageField('PipelineContext', 4)
  verbose = _messages.BooleanField(5)


class RunArtifactPoliciesEvaluationRequest(_messages.Message):
  r"""Request message for the RunArtifactPoliciesEvaluation RPC.

  Enums:
    ScanTypeValueListEntryValuesEnum:

  Fields:
    artifactId: Required. The unique identifier for the artifact that was
      evaluated.
    artifactPoliciesEvaluationId: Optional. A unique ID for this policy
      evaluation request. If left empty, the server will assign a unique ID.
      If provided, the server will check for idempotency: the request will
      succeed only if the given ID has not been used for a previous request
      with the same parent.
    inputGcsUri: Required. URI of the Cloud Storage bucket containing the
      artifact or scan artifacts.
    scanMetadata: Required. Metadata related to the artifact scan that
      triggers this policy evaluation.
    scanType: Optional. Optional list of specific scan types to perform. If
      empty, all configured scan types for the policy might be performed.
    verbose: Optional. If true, the response will include additional CVE
      details.
  """

  class ScanTypeValueListEntryValuesEnum(_messages.Enum):
    r"""ScanTypeValueListEntryValuesEnum enum type.

    Values:
      SCAN_TYPE_UNSPECIFIED: The scan type is unspecified.
      VULNERABILITY_SCAN: Scans only the vulnerability policies of the
        artifact.
    """
    SCAN_TYPE_UNSPECIFIED = 0
    VULNERABILITY_SCAN = 1

  artifactId = _messages.StringField(1)
  artifactPoliciesEvaluationId = _messages.StringField(2)
  inputGcsUri = _messages.StringField(3)
  scanMetadata = _messages.MessageField('ScanMetadata', 4)
  scanType = _messages.EnumField('ScanTypeValueListEntryValuesEnum', 5, repeated=True)
  verbose = _messages.BooleanField(6)


class RuntimeEvaluationScope(_messages.Message):
  r"""The runtime scope that this artifact evaluation is associated with.

  Fields:
    gkeCluster: Optional. Google Kubernetes Engine cluster. Format: //containe
      r.googleapis.com/projects/{project_id}/locations/{location}/clusters/{cl
      uster_name_pattern} where cluster_name_pattern is a regex.
    projectId: Required. The project ID that this artifact evaluation is
      associated with. Format: projects/{project_id} The policy will be
      applied to all the clusters in the project.
  """

  gkeCluster = _messages.StringField(1)
  projectId = _messages.StringField(2)


class RuntimeScope(_messages.Message):
  r"""RuntimeScope has the project IDs that are associated with the policy.

  Enums:
    EnforcementActionValueValuesEnum: Required. The enforcement action to take
      when this policy is violated in the runtime scope.

  Fields:
    enforcementAction: Required. The enforcement action to take when this
      policy is violated in the runtime scope.
    gkeClusterNamePatterns: Optional. Google Kubernetes Engine clusters that
      are associated with the policy. Format: //container.googleapis.com/proje
      cts/{project_id}/locations/{location}/clusters/{cluster_name_pattern}
      where cluster_name_pattern is a regex.
    gkeClusterNamespacePatterns: Optional. Google Kubernates Engine namespaces
      that are associated with the policy. Format: //container.googleapis.com/
      projects/{project_id}/locations/{location}/clusters/{cluster_id}/k8s/nam
      espaces/{namepace_pattern} where namespace_pattern is a regex.
    overrideBinauthzPolicy: Optional. Whether to override the existing
      BinAuthz policy for the projects in the runtime scope.
    projectIds: Required. The project ID that this policy is associated with.
      Format: projects/{project_id} The policy will be applied to all the
      clusters in the project.
  """

  class EnforcementActionValueValuesEnum(_messages.Enum):
    r"""Required. The enforcement action to take when this policy is violated
    in the runtime scope.

    Values:
      RUNTIME_ENFORCEMENT_ACTION_UNSPECIFIED: The enforcement action is
        unspecified.
      AUDIT_ONLY: The policy is evaluated but not enforced. The policy
        violation is only logged and not reported.
      BLOCK_DEPLOYMENT: The policy is evaluated and enforced. The policy
        violation is reported and the resource is blocked. The deployment will
        be blocked based on policy evaluation in registry.
    """
    RUNTIME_ENFORCEMENT_ACTION_UNSPECIFIED = 0
    AUDIT_ONLY = 1
    BLOCK_DEPLOYMENT = 2

  enforcementAction = _messages.EnumField('EnforcementActionValueValuesEnum', 1)
  gkeClusterNamePatterns = _messages.StringField(2, repeated=True)
  gkeClusterNamespacePatterns = _messages.StringField(3, repeated=True)
  overrideBinauthzPolicy = _messages.BooleanField(4)
  projectIds = _messages.StringField(5, repeated=True)


class ScanMetadata(_messages.Message):
  r"""Metadata about the artifact scan.

  Fields:
    pipeline: The pipelines that this artifact evaluation applies to.
    registryScope: The registries that this artifact evaluation applies to.
    runtimeScope: The runtimes that this artifact evaluation applies to.
  """

  pipeline = _messages.MessageField('PipelineEvaluationScope', 1)
  registryScope = _messages.MessageField('RegistryEvaluationScope', 2)
  runtimeScope = _messages.MessageField('RuntimeEvaluationScope', 3)


class SeverityGroup(_messages.Message):
  r"""Nested message for grouping CVEs by severity.

  Enums:
    SeverityValueValuesEnum: Output only. The severity level.

  Fields:
    cveNames: Output only. The list of CVE names (e.g., "CVE-2023-1234") with
      this severity.
    severity: Output only. The severity level.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Output only. The severity level.

    Values:
      SEVERITY_UNSPECIFIED: The severity is unspecified.
      LOW: Low severity.
      MEDIUM: Medium severity.
      HIGH: High severity.
      CRITICAL: Critical severity. This is the maximum severity level.
    """
    SEVERITY_UNSPECIFIED = 0
    LOW = 1
    MEDIUM = 2
    HIGH = 3
    CRITICAL = 4

  cveNames = _messages.StringField(1, repeated=True)
  severity = _messages.EnumField('SeverityValueValuesEnum', 2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class VulnerabilityPolicy(_messages.Message):
  r"""Defines a policy for managing software vulnerabilities.

  Enums:
    MaxAllowedSeverityValueValuesEnum: Optional. The maximum severity level
      allowed for vulnerabilities. Any vulnerability above this severity will
      violate the policy.

  Fields:
    allowedPackages: Optional. A list of package names that are always
      allowed, overriding any vulnerability findings or other denial rules for
      these packages.
    excludeUnfixable: Optional. If true, vulnerabilities for which no fix is
      currently available will be excluded from policy evaluation.
    exemptedCves: Optional. List of CVEs that are temporarily exempted from
      policy evaluation. These vulnerabilities might be allowed for a specific
      grace period.
    exemptionDaysPostDisclosure: Optional. The number of days, since its
      disclosure date, that a CVE exemption is granted for.
    maxAllowedSeverity: Optional. The maximum severity level allowed for
      vulnerabilities. Any vulnerability above this severity will violate the
      policy.
    maximumAllowedVulnerabilities: Optional. The maximum total number of
      vulnerabilities allowed across all severities. If exceeded, the policy
      is violated.
    restrictedCves: Optional. A list of specific CVE IDs that are explicitly
      denied and will always cause a policy violation, regardless of other
      criteria.
    restrictedPackages: Optional. A list of packages that are always denied,
      regardless of their vulnerability status or other allowlisting rules.
  """

  class MaxAllowedSeverityValueValuesEnum(_messages.Enum):
    r"""Optional. The maximum severity level allowed for vulnerabilities. Any
    vulnerability above this severity will violate the policy.

    Values:
      SEVERITY_UNSPECIFIED: The severity is unspecified.
      LOW: Low severity.
      MEDIUM: Medium severity.
      HIGH: High severity.
      CRITICAL: Critical severity. This is the maximum severity level.
    """
    SEVERITY_UNSPECIFIED = 0
    LOW = 1
    MEDIUM = 2
    HIGH = 3
    CRITICAL = 4

  allowedPackages = _messages.MessageField('Package', 1, repeated=True)
  excludeUnfixable = _messages.BooleanField(2)
  exemptedCves = _messages.MessageField('ExemptedCVE', 3, repeated=True)
  exemptionDaysPostDisclosure = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  maxAllowedSeverity = _messages.EnumField('MaxAllowedSeverityValueValuesEnum', 5)
  maximumAllowedVulnerabilities = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  restrictedCves = _messages.StringField(7, repeated=True)
  restrictedPackages = _messages.MessageField('Package', 8, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
encoding.AddCustomJsonFieldMapping(
    ArtifactscanguardOrganizationsLocationsArtifactEvaluationsDataGatewayRequest, 'artifactMetadata_buildTime', 'artifactMetadata.buildTime')
encoding.AddCustomJsonFieldMapping(
    ArtifactscanguardOrganizationsLocationsArtifactEvaluationsDataGatewayRequest, 'artifactMetadata_imageDigest', 'artifactMetadata.imageDigest')
encoding.AddCustomJsonFieldMapping(
    ArtifactscanguardOrganizationsLocationsArtifactEvaluationsDataGatewayRequest, 'artifactMetadata_imageId', 'artifactMetadata.imageId')
encoding.AddCustomJsonFieldMapping(
    ArtifactscanguardOrganizationsLocationsArtifactEvaluationsDataGatewayRequest, 'artifactMetadata_imageName', 'artifactMetadata.imageName')
encoding.AddCustomJsonFieldMapping(
    ArtifactscanguardOrganizationsLocationsArtifactEvaluationsDataGatewayRequest, 'artifactMetadata_imageTag', 'artifactMetadata.imageTag')
encoding.AddCustomJsonFieldMapping(
    ArtifactscanguardOrganizationsLocationsArtifactEvaluationsDataGatewayRequest, 'artifactMetadata_purlUri', 'artifactMetadata.purlUri')
encoding.AddCustomJsonFieldMapping(
    ArtifactscanguardOrganizationsLocationsArtifactEvaluationsDataGatewayRequest, 'artifactMetadata_sbomUri', 'artifactMetadata.sbomUri')
