"""Generated message classes for datacatalog version v1.

A fully managed and highly scalable data discovery and metadata management
service.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'datacatalog'


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class DatacatalogEntriesLookupRequest(_messages.Message):
  r"""A DatacatalogEntriesLookupRequest object.

  Fields:
    fullyQualifiedName: [Fully Qualified Name
      (FQN)](https://cloud.google.com//data-catalog/docs/fully-qualified-
      names) of the resource. FQNs take two forms: * For non-regionalized
      resources: `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}` *
      For regionalized resources: `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_R
      ESOURCE_SEPARATED_WITH_DOTS}` Example for a DPMS table: `dataproc_metast
      ore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
    linkedResource: The full name of the Google Cloud Platform resource the
      Data Catalog entry represents. For more information, see [Full Resource
      Name] (https://cloud.google.com/apis/design/resource_names#full_resource
      _name). Full names are case-sensitive. For example: * `//bigquery.google
      apis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
      * `//pubsub.googleapis.com/projects/{PROJECT_ID}/topics/{TOPIC_ID}`
    location: Location where the lookup should be performed. Required to
      lookup entry that is not a part of `DPMS` or `DATAPLEX`
      `integrated_system` using its `fully_qualified_name`. Ignored in other
      cases.
    project: Project where the lookup should be performed. Required to lookup
      entry that is not a part of `DPMS` or `DATAPLEX` `integrated_system`
      using its `fully_qualified_name`. Ignored in other cases.
    sqlResource: The SQL name of the entry. SQL names are case-sensitive.
      Examples: * `pubsub.topic.{PROJECT_ID}.{TOPIC_ID}` *
      `pubsub.topic.{PROJECT_ID}.`\``{TOPIC.ID.SEPARATED.WITH.DOTS}`\` *
      `bigquery.table.{PROJECT_ID}.{DATASET_ID}.{TABLE_ID}` *
      `bigquery.dataset.{PROJECT_ID}.{DATASET_ID}` * `datacatalog.entry.{PROJE
      CT_ID}.{LOCATION_ID}.{ENTRY_GROUP_ID}.{ENTRY_ID}` Identifiers (`*_ID`)
      should comply with the [Lexical structure in GoogleSQL]
      (https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical).
  """

  fullyQualifiedName = _messages.StringField(1)
  linkedResource = _messages.StringField(2)
  location = _messages.StringField(3)
  project = _messages.StringField(4)
  sqlResource = _messages.StringField(5)


class DatacatalogOrganizationsLocationsRetrieveConfigRequest(_messages.Message):
  r"""A DatacatalogOrganizationsLocationsRetrieveConfigRequest object.

  Fields:
    name: Required. The organization whose config is being retrieved.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogOrganizationsLocationsRetrieveEffectiveConfigRequest(_messages.Message):
  r"""A DatacatalogOrganizationsLocationsRetrieveEffectiveConfigRequest
  object.

  Fields:
    name: Required. The resource whose effective config is being retrieved.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogOrganizationsLocationsSetConfigRequest(_messages.Message):
  r"""A DatacatalogOrganizationsLocationsSetConfigRequest object.

  Fields:
    googleCloudDatacatalogV1SetConfigRequest: A
      GoogleCloudDatacatalogV1SetConfigRequest resource to be passed as the
      request body.
    name: Required. The organization or project whose config is being
      specified.
  """

  googleCloudDatacatalogV1SetConfigRequest = _messages.MessageField('GoogleCloudDatacatalogV1SetConfigRequest', 1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsCreateRequest object.

  Fields:
    entryGroupId: Required. The ID of the entry group to create. The ID must
      contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and
      must start with a letter or underscore. The maximum size is 64 bytes
      when encoded in UTF-8.
    googleCloudDatacatalogV1EntryGroup: A GoogleCloudDatacatalogV1EntryGroup
      resource to be passed as the request body.
    parent: Required. The names of the project and location that the new entry
      group belongs to. Note: The entry group itself and its child resources
      might not be stored in the location specified in its name.
  """

  entryGroupId = _messages.StringField(1)
  googleCloudDatacatalogV1EntryGroup = _messages.MessageField('GoogleCloudDatacatalogV1EntryGroup', 2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsEntryGroupsDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsDeleteRequest object.

  Fields:
    force: Optional. If true, deletes all entries in the entry group.
    name: Required. The name of the entry group to delete.
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesCreateRequest object.

  Fields:
    entryId: Required. The ID of the entry to create. The ID must contain only
      letters (a-z, A-Z), numbers (0-9), and underscores (_). The maximum size
      is 64 bytes when encoded in UTF-8.
    googleCloudDatacatalogV1Entry: A GoogleCloudDatacatalogV1Entry resource to
      be passed as the request body.
    parent: Required. The name of the entry group this entry belongs to. Note:
      The entry itself and its child resources might not be stored in the
      location specified in its name.
  """

  entryId = _messages.StringField(1)
  googleCloudDatacatalogV1Entry = _messages.MessageField('GoogleCloudDatacatalogV1Entry', 2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesDeleteRequest object.

  Fields:
    name: Required. The name of the entry to delete.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesGetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesGetIamPolicyRequest
  object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest object.

  Fields:
    name: Required. The name of the entry to get.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesImportRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesImportRequest object.

  Fields:
    googleCloudDatacatalogV1ImportEntriesRequest: A
      GoogleCloudDatacatalogV1ImportEntriesRequest resource to be passed as
      the request body.
    parent: Required. Target entry group for ingested entries.
  """

  googleCloudDatacatalogV1ImportEntriesRequest = _messages.MessageField('GoogleCloudDatacatalogV1ImportEntriesRequest', 1)
  parent = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesListRequest object.

  Fields:
    pageSize: The maximum number of items to return. Default is 10. Maximum
      limit is 1000. Throws an invalid argument if `page_size` is more than
      1000.
    pageToken: Pagination token that specifies the next page to return. If
      empty, the first page is returned.
    parent: Required. The name of the entry group that contains the entries to
      list. Can be provided in URL format.
    readMask: The fields to return for each entry. If empty or omitted, all
      fields are returned. For example, to return a list of entries with only
      the `name` field, set `read_mask` to only one path with the `name`
      value.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  readMask = _messages.StringField(4)


class DatacatalogProjectsLocationsEntryGroupsEntriesModifyEntryContactsRequest(_messages.Message):
  r"""A
  DatacatalogProjectsLocationsEntryGroupsEntriesModifyEntryContactsRequest
  object.

  Fields:
    googleCloudDatacatalogV1ModifyEntryContactsRequest: A
      GoogleCloudDatacatalogV1ModifyEntryContactsRequest resource to be passed
      as the request body.
    name: Required. The full resource name of the entry.
  """

  googleCloudDatacatalogV1ModifyEntryContactsRequest = _messages.MessageField('GoogleCloudDatacatalogV1ModifyEntryContactsRequest', 1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesModifyEntryOverviewRequest(_messages.Message):
  r"""A
  DatacatalogProjectsLocationsEntryGroupsEntriesModifyEntryOverviewRequest
  object.

  Fields:
    googleCloudDatacatalogV1ModifyEntryOverviewRequest: A
      GoogleCloudDatacatalogV1ModifyEntryOverviewRequest resource to be passed
      as the request body.
    name: Required. The full resource name of the entry.
  """

  googleCloudDatacatalogV1ModifyEntryOverviewRequest = _messages.MessageField('GoogleCloudDatacatalogV1ModifyEntryOverviewRequest', 1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest object.

  Fields:
    googleCloudDatacatalogV1Entry: A GoogleCloudDatacatalogV1Entry resource to
      be passed as the request body.
    name: Output only. Identifier. The resource name of an entry in URL
      format. Note: The entry itself and its child resources might not be
      stored in the location specified in its name.
    updateMask: Names of fields whose values to overwrite on an entry. If this
      parameter is absent or empty, all modifiable fields are overwritten. If
      such fields are non-required and omitted in the request body, their
      values are emptied. You can modify only the fields listed below. For
      entries with type `DATA_STREAM`: * `schema` For entries with type
      `FILESET`: * `schema` * `display_name` * `description` *
      `gcs_fileset_spec` * `gcs_fileset_spec.file_patterns` For entries with
      `user_specified_type`: * `schema` * `display_name` * `description` *
      `user_specified_type` * `user_specified_system` * `linked_resource` *
      `source_system_timestamps`
  """

  googleCloudDatacatalogV1Entry = _messages.MessageField('GoogleCloudDatacatalogV1Entry', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsEntryGroupsEntriesStarRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesStarRequest object.

  Fields:
    googleCloudDatacatalogV1StarEntryRequest: A
      GoogleCloudDatacatalogV1StarEntryRequest resource to be passed as the
      request body.
    name: Required. The name of the entry to mark as starred.
  """

  googleCloudDatacatalogV1StarEntryRequest = _messages.MessageField('GoogleCloudDatacatalogV1StarEntryRequest', 1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesTagsCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesTagsCreateRequest
  object.

  Fields:
    googleCloudDatacatalogV1Tag: A GoogleCloudDatacatalogV1Tag resource to be
      passed as the request body.
    parent: Required. The name of the resource to attach this tag to. Tags can
      be attached to entries or entry groups. An entry can have up to 1000
      attached tags. Note: The tag and its child resources might not be stored
      in the location specified in its name.
  """

  googleCloudDatacatalogV1Tag = _messages.MessageField('GoogleCloudDatacatalogV1Tag', 1)
  parent = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesTagsDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesTagsDeleteRequest
  object.

  Fields:
    name: Required. The name of the tag to delete.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesTagsListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesTagsListRequest object.

  Fields:
    pageSize: The maximum number of tags to return. Default is 10. Maximum
      limit is 1000.
    pageToken: Pagination token that specifies the next page to return. If
      empty, the first page is returned.
    parent: Required. The name of the Data Catalog resource to list the tags
      of. The resource can be an Entry or an EntryGroup (without
      `/entries/{entries}` at the end).
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesTagsPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesTagsPatchRequest object.

  Fields:
    googleCloudDatacatalogV1Tag: A GoogleCloudDatacatalogV1Tag resource to be
      passed as the request body.
    name: Identifier. The resource name of the tag in URL format where tag ID
      is a system-generated identifier. Note: The tag itself might not be
      stored in the location specified in its name.
    updateMask: Names of fields whose values to overwrite on a tag. Currently,
      a tag has the only modifiable field with the name `fields`. In general,
      if this parameter is absent or empty, all modifiable fields are
      overwritten. If such fields are non-required and omitted in the request
      body, their values are emptied.
  """

  googleCloudDatacatalogV1Tag = _messages.MessageField('GoogleCloudDatacatalogV1Tag', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsEntryGroupsEntriesTagsReconcileRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesTagsReconcileRequest
  object.

  Fields:
    googleCloudDatacatalogV1ReconcileTagsRequest: A
      GoogleCloudDatacatalogV1ReconcileTagsRequest resource to be passed as
      the request body.
    parent: Required. Name of Entry to be tagged.
  """

  googleCloudDatacatalogV1ReconcileTagsRequest = _messages.MessageField('GoogleCloudDatacatalogV1ReconcileTagsRequest', 1)
  parent = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesTestIamPermissionsRequest(_messages.Message):
  r"""A
  DatacatalogProjectsLocationsEntryGroupsEntriesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DatacatalogProjectsLocationsEntryGroupsEntriesUnstarRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesUnstarRequest object.

  Fields:
    googleCloudDatacatalogV1UnstarEntryRequest: A
      GoogleCloudDatacatalogV1UnstarEntryRequest resource to be passed as the
      request body.
    name: Required. The name of the entry to mark as **not** starred.
  """

  googleCloudDatacatalogV1UnstarEntryRequest = _messages.MessageField('GoogleCloudDatacatalogV1UnstarEntryRequest', 1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsGetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsGetRequest object.

  Fields:
    name: Required. The name of the entry group to get.
    readMask: The fields to return. If empty or omitted, all fields are
      returned.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class DatacatalogProjectsLocationsEntryGroupsListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return. Default is 10.
      Maximum limit is 1000. Throws an invalid argument if `page_size` is
      greater than 1000.
    pageToken: Optional. Pagination token that specifies the next page to
      return. If empty, returns the first page.
    parent: Required. The name of the location that contains the entry groups
      to list. Can be provided as a URL.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsEntryGroupsPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsPatchRequest object.

  Fields:
    googleCloudDatacatalogV1EntryGroup: A GoogleCloudDatacatalogV1EntryGroup
      resource to be passed as the request body.
    name: Identifier. The resource name of the entry group in URL format.
      Note: The entry group itself and its child resources might not be stored
      in the location specified in its name.
    updateMask: Names of fields whose values to overwrite on an entry group.
      If this parameter is absent or empty, all modifiable fields are
      overwritten. If such fields are non-required and omitted in the request
      body, their values are emptied.
  """

  googleCloudDatacatalogV1EntryGroup = _messages.MessageField('GoogleCloudDatacatalogV1EntryGroup', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsEntryGroupsSetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DatacatalogProjectsLocationsEntryGroupsTagsCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsTagsCreateRequest object.

  Fields:
    googleCloudDatacatalogV1Tag: A GoogleCloudDatacatalogV1Tag resource to be
      passed as the request body.
    parent: Required. The name of the resource to attach this tag to. Tags can
      be attached to entries or entry groups. An entry can have up to 1000
      attached tags. Note: The tag and its child resources might not be stored
      in the location specified in its name.
  """

  googleCloudDatacatalogV1Tag = _messages.MessageField('GoogleCloudDatacatalogV1Tag', 1)
  parent = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsTagsDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsTagsDeleteRequest object.

  Fields:
    name: Required. The name of the tag to delete.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsEntryGroupsTagsListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsTagsListRequest object.

  Fields:
    pageSize: The maximum number of tags to return. Default is 10. Maximum
      limit is 1000.
    pageToken: Pagination token that specifies the next page to return. If
      empty, the first page is returned.
    parent: Required. The name of the Data Catalog resource to list the tags
      of. The resource can be an Entry or an EntryGroup (without
      `/entries/{entries}` at the end).
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsEntryGroupsTagsPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsTagsPatchRequest object.

  Fields:
    googleCloudDatacatalogV1Tag: A GoogleCloudDatacatalogV1Tag resource to be
      passed as the request body.
    name: Identifier. The resource name of the tag in URL format where tag ID
      is a system-generated identifier. Note: The tag itself might not be
      stored in the location specified in its name.
    updateMask: Names of fields whose values to overwrite on a tag. Currently,
      a tag has the only modifiable field with the name `fields`. In general,
      if this parameter is absent or empty, all modifiable fields are
      overwritten. If such fields are non-required and omitted in the request
      body, their values are emptied.
  """

  googleCloudDatacatalogV1Tag = _messages.MessageField('GoogleCloudDatacatalogV1Tag', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsEntryGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DatacatalogProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the ListOperationsResponse.unreachable field. This can only be `true`
      when reading across collections. For example, when `parent` is set to
      `"projects/example/locations/-"`. This field is not supported by default
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class DatacatalogProjectsLocationsRetrieveEffectiveConfigRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsRetrieveEffectiveConfigRequest object.

  Fields:
    name: Required. The resource whose effective config is being retrieved.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsSetConfigRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsSetConfigRequest object.

  Fields:
    googleCloudDatacatalogV1SetConfigRequest: A
      GoogleCloudDatacatalogV1SetConfigRequest resource to be passed as the
      request body.
    name: Required. The organization or project whose config is being
      specified.
  """

  googleCloudDatacatalogV1SetConfigRequest = _messages.MessageField('GoogleCloudDatacatalogV1SetConfigRequest', 1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesCreateRequest object.

  Fields:
    googleCloudDatacatalogV1TagTemplate: A GoogleCloudDatacatalogV1TagTemplate
      resource to be passed as the request body.
    parent: Required. The name of the project and the template location
      [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
    tagTemplateId: Required. The ID of the tag template to create. The ID must
      contain only lowercase letters (a-z), numbers (0-9), or underscores (_),
      and must start with a letter or underscore. The maximum size is 64 bytes
      when encoded in UTF-8.
  """

  googleCloudDatacatalogV1TagTemplate = _messages.MessageField('GoogleCloudDatacatalogV1TagTemplate', 1)
  parent = _messages.StringField(2, required=True)
  tagTemplateId = _messages.StringField(3)


class DatacatalogProjectsLocationsTagTemplatesDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesDeleteRequest object.

  Fields:
    force: Required. If true, deletes all tags that use this template.
      Currently, `true` is the only supported value.
    name: Required. The name of the tag template to delete.
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesFieldsCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsCreateRequest object.

  Fields:
    googleCloudDatacatalogV1TagTemplateField: A
      GoogleCloudDatacatalogV1TagTemplateField resource to be passed as the
      request body.
    parent: Required. The name of the project and the template location
      [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
    tagTemplateFieldId: Required. The ID of the tag template field to create.
      Note: Adding a required field to an existing template is *not* allowed.
      Field IDs can contain letters (both uppercase and lowercase), numbers
      (0-9), underscores (_) and dashes (-). Field IDs must be at least 1
      character long and at most 128 characters long. Field IDs must also be
      unique within their template.
  """

  googleCloudDatacatalogV1TagTemplateField = _messages.MessageField('GoogleCloudDatacatalogV1TagTemplateField', 1)
  parent = _messages.StringField(2, required=True)
  tagTemplateFieldId = _messages.StringField(3)


class DatacatalogProjectsLocationsTagTemplatesFieldsDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsDeleteRequest object.

  Fields:
    force: Required. If true, deletes this field from any tags that use it.
      Currently, `true` is the only supported value.
    name: Required. The name of the tag template field to delete.
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesFieldsEnumValuesRenameRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsEnumValuesRenameRequest
  object.

  Fields:
    googleCloudDatacatalogV1RenameTagTemplateFieldEnumValueRequest: A
      GoogleCloudDatacatalogV1RenameTagTemplateFieldEnumValueRequest resource
      to be passed as the request body.
    name: Required. The name of the enum field value.
  """

  googleCloudDatacatalogV1RenameTagTemplateFieldEnumValueRequest = _messages.MessageField('GoogleCloudDatacatalogV1RenameTagTemplateFieldEnumValueRequest', 1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesFieldsPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsPatchRequest object.

  Fields:
    googleCloudDatacatalogV1TagTemplateField: A
      GoogleCloudDatacatalogV1TagTemplateField resource to be passed as the
      request body.
    name: Required. The name of the tag template field.
    updateMask: Optional. Names of fields whose values to overwrite on an
      individual field of a tag template. The following fields are modifiable:
      * `display_name` * `type.enum_type` * `is_required` If this parameter is
      absent or empty, all modifiable fields are overwritten. If such fields
      are non-required and omitted in the request body, their values are
      emptied with one exception: when updating an enum type, the provided
      values are merged with the existing values. Therefore, enum values can
      only be added, existing enum values cannot be deleted or renamed.
      Additionally, updating a template field from optional to required is
      *not* allowed.
  """

  googleCloudDatacatalogV1TagTemplateField = _messages.MessageField('GoogleCloudDatacatalogV1TagTemplateField', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsTagTemplatesFieldsRenameRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsRenameRequest object.

  Fields:
    googleCloudDatacatalogV1RenameTagTemplateFieldRequest: A
      GoogleCloudDatacatalogV1RenameTagTemplateFieldRequest resource to be
      passed as the request body.
    name: Required. The name of the tag template field.
  """

  googleCloudDatacatalogV1RenameTagTemplateFieldRequest = _messages.MessageField('GoogleCloudDatacatalogV1RenameTagTemplateFieldRequest', 1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesGetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesGetRequest object.

  Fields:
    name: Required. The name of the tag template to get.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsTagTemplatesPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesPatchRequest object.

  Fields:
    googleCloudDatacatalogV1TagTemplate: A GoogleCloudDatacatalogV1TagTemplate
      resource to be passed as the request body.
    name: Identifier. The resource name of the tag template in URL format.
      Note: The tag template itself and its child resources might not be
      stored in the location specified in its name.
    updateMask: Names of fields whose values to overwrite on a tag template.
      Currently, only `display_name` and `is_publicly_readable` can be
      overwritten. If this parameter is absent or empty, all modifiable fields
      are overwritten. If such fields are non-required and omitted in the
      request body, their values are emptied. Note: Updating the
      `is_publicly_readable` field may require up to 12 hours to take effect
      in search results.
  """

  googleCloudDatacatalogV1TagTemplate = _messages.MessageField('GoogleCloudDatacatalogV1TagTemplate', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsTagTemplatesSetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DatacatalogProjectsLocationsTagTemplatesTestIamPermissionsRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DatacatalogProjectsLocationsTaxonomiesCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesCreateRequest object.

  Fields:
    googleCloudDatacatalogV1Taxonomy: A GoogleCloudDatacatalogV1Taxonomy
      resource to be passed as the request body.
    parent: Required. Resource name of the project that the taxonomy will
      belong to.
  """

  googleCloudDatacatalogV1Taxonomy = _messages.MessageField('GoogleCloudDatacatalogV1Taxonomy', 1)
  parent = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTaxonomiesDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesDeleteRequest object.

  Fields:
    name: Required. Resource name of the taxonomy to delete. Note: All policy
      tags in this taxonomy are also deleted.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsTaxonomiesExportRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesExportRequest object.

  Fields:
    parent: Required. Resource name of the project that the exported
      taxonomies belong to.
    serializedTaxonomies: Serialized export taxonomies that contain all the
      policy tags as nested protocol buffers.
    taxonomies: Required. Resource names of the taxonomies to export.
  """

  parent = _messages.StringField(1, required=True)
  serializedTaxonomies = _messages.BooleanField(2)
  taxonomies = _messages.StringField(3, repeated=True)


class DatacatalogProjectsLocationsTaxonomiesGetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTaxonomiesGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesGetRequest object.

  Fields:
    name: Required. Resource name of the taxonomy to get.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsTaxonomiesImportRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesImportRequest object.

  Fields:
    googleCloudDatacatalogV1ImportTaxonomiesRequest: A
      GoogleCloudDatacatalogV1ImportTaxonomiesRequest resource to be passed as
      the request body.
    parent: Required. Resource name of project that the imported taxonomies
      will belong to.
  """

  googleCloudDatacatalogV1ImportTaxonomiesRequest = _messages.MessageField('GoogleCloudDatacatalogV1ImportTaxonomiesRequest', 1)
  parent = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTaxonomiesListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesListRequest object.

  Fields:
    filter: Supported field for filter is 'service' and value is 'dataplex'.
      Eg: service=dataplex.
    pageSize: The maximum number of items to return. Must be a value between 1
      and 1000 inclusively. If not set, defaults to 50.
    pageToken: The pagination token of the next results page. If not set, the
      first page is returned. The token is returned in the response to a
      previous list request.
    parent: Required. Resource name of the project to list the taxonomies of.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DatacatalogProjectsLocationsTaxonomiesPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPatchRequest object.

  Fields:
    googleCloudDatacatalogV1Taxonomy: A GoogleCloudDatacatalogV1Taxonomy
      resource to be passed as the request body.
    name: Identifier. Resource name of this taxonomy in URL format. Note:
      Policy tag manager generates unique taxonomy IDs.
    updateMask: Specifies fields to update. If not set, defaults to all fields
      you can update. For more information, see [FieldMask]
      (https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask).
  """

  googleCloudDatacatalogV1Taxonomy = _messages.MessageField('GoogleCloudDatacatalogV1Taxonomy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsCreateRequest object.

  Fields:
    googleCloudDatacatalogV1PolicyTag: A GoogleCloudDatacatalogV1PolicyTag
      resource to be passed as the request body.
    parent: Required. Resource name of the taxonomy that the policy tag will
      belong to.
  """

  googleCloudDatacatalogV1PolicyTag = _messages.MessageField('GoogleCloudDatacatalogV1PolicyTag', 1)
  parent = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsDeleteRequest object.

  Fields:
    name: Required. Resource name of the policy tag to delete. Note: All of
      its descendant policy tags are also deleted.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetIamPolicyRequest
  object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetRequest object.

  Fields:
    name: Required. Resource name of the policy tag.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsListRequest object.

  Fields:
    pageSize: The maximum number of items to return. Must be a value between 1
      and 1000 inclusively. If not set, defaults to 50.
    pageToken: The pagination token of the next results page. If not set,
      returns the first page. The token is returned in the response to a
      previous list request.
    parent: Required. Resource name of the taxonomy to list the policy tags
      of.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsPatchRequest object.

  Fields:
    googleCloudDatacatalogV1PolicyTag: A GoogleCloudDatacatalogV1PolicyTag
      resource to be passed as the request body.
    name: Identifier. Resource name of this policy tag in the URL format. The
      policy tag manager generates unique taxonomy IDs and policy tag IDs.
    updateMask: Specifies the fields to update. You can update only display
      name, description, and parent policy tag. If not set, defaults to all
      updatable fields. For more information, see [FieldMask]
      (https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask).
  """

  googleCloudDatacatalogV1PolicyTag = _messages.MessageField('GoogleCloudDatacatalogV1PolicyTag', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsSetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsTestIamPermissionsRequest(_messages.Message):
  r"""A
  DatacatalogProjectsLocationsTaxonomiesPolicyTagsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DatacatalogProjectsLocationsTaxonomiesReplaceRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesReplaceRequest object.

  Fields:
    googleCloudDatacatalogV1ReplaceTaxonomyRequest: A
      GoogleCloudDatacatalogV1ReplaceTaxonomyRequest resource to be passed as
      the request body.
    name: Required. Resource name of the taxonomy to update.
  """

  googleCloudDatacatalogV1ReplaceTaxonomyRequest = _messages.MessageField('GoogleCloudDatacatalogV1ReplaceTaxonomyRequest', 1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTaxonomiesSetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DatacatalogProjectsLocationsTaxonomiesTestIamPermissionsRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method.

  Fields:
    options: OPTIONAL: A `GetPolicyOptions` object for specifying options to
      `GetIamPolicy`.
  """

  options = _messages.MessageField('GetPolicyOptions', 1)


class GetPolicyOptions(_messages.Message):
  r"""Encapsulates settings provided to GetIamPolicy.

  Fields:
    requestedPolicyVersion: Optional. The maximum policy version that will be
      used to format the policy. Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected. Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset. The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1. To learn which resources support conditions in
      their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudDatacatalogV1BigQueryConnectionSpec(_messages.Message):
  r"""Specification for the BigQuery connection.

  Enums:
    ConnectionTypeValueValuesEnum: The type of the BigQuery connection.

  Fields:
    cloudSql: Specification for the BigQuery connection to a Cloud SQL
      instance.
    connectionType: The type of the BigQuery connection.
    hasCredential: True if there are credentials attached to the BigQuery
      connection; false otherwise.
  """

  class ConnectionTypeValueValuesEnum(_messages.Enum):
    r"""The type of the BigQuery connection.

    Values:
      CONNECTION_TYPE_UNSPECIFIED: Unspecified type.
      CLOUD_SQL: Cloud SQL connection.
    """
    CONNECTION_TYPE_UNSPECIFIED = 0
    CLOUD_SQL = 1

  cloudSql = _messages.MessageField('GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpec', 1)
  connectionType = _messages.EnumField('ConnectionTypeValueValuesEnum', 2)
  hasCredential = _messages.BooleanField(3)


class GoogleCloudDatacatalogV1BigQueryDateShardedSpec(_messages.Message):
  r"""Specification for a group of BigQuery tables with the `[prefix]YYYYMMDD`
  name pattern. For more information, see [Introduction to partitioned tables]
  (https://cloud.google.com/bigquery/docs/partitioned-
  tables#partitioning_versus_sharding).

  Fields:
    dataset: Output only. The Data Catalog resource name of the dataset entry
      the current table belongs to. For example: `projects/{PROJECT_ID}/locati
      ons/{LOCATION}/entrygroups/{ENTRY_GROUP_ID}/entries/{ENTRY_ID}`.
    latestShardResource: Output only. BigQuery resource name of the latest
      shard.
    shardCount: Output only. Total number of shards.
    tablePrefix: Output only. The table name prefix of the shards. The name of
      any given shard is `[table_prefix]YYYYMMDD`. For example, for the
      `MyTable20180101` shard, the `table_prefix` is `MyTable`.
  """

  dataset = _messages.StringField(1)
  latestShardResource = _messages.StringField(2)
  shardCount = _messages.IntegerField(3)
  tablePrefix = _messages.StringField(4)


class GoogleCloudDatacatalogV1BigQueryRoutineSpec(_messages.Message):
  r"""Fields specific for BigQuery routines.

  Fields:
    importedLibraries: Paths of the imported libraries.
  """

  importedLibraries = _messages.StringField(1, repeated=True)


class GoogleCloudDatacatalogV1BigQueryTableSpec(_messages.Message):
  r"""Describes a BigQuery table.

  Enums:
    TableSourceTypeValueValuesEnum: Output only. The table source type.

  Fields:
    tableSourceType: Output only. The table source type.
    tableSpec: Specification of a BigQuery table. Populated only if the
      `table_source_type` is `BIGQUERY_TABLE`.
    viewSpec: Table view specification. Populated only if the
      `table_source_type` is `BIGQUERY_VIEW`.
  """

  class TableSourceTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The table source type.

    Values:
      TABLE_SOURCE_TYPE_UNSPECIFIED: Default unknown type.
      BIGQUERY_VIEW: Table view.
      BIGQUERY_TABLE: BigQuery native table.
      BIGQUERY_MATERIALIZED_VIEW: BigQuery materialized view.
    """
    TABLE_SOURCE_TYPE_UNSPECIFIED = 0
    BIGQUERY_VIEW = 1
    BIGQUERY_TABLE = 2
    BIGQUERY_MATERIALIZED_VIEW = 3

  tableSourceType = _messages.EnumField('TableSourceTypeValueValuesEnum', 1)
  tableSpec = _messages.MessageField('GoogleCloudDatacatalogV1TableSpec', 2)
  viewSpec = _messages.MessageField('GoogleCloudDatacatalogV1ViewSpec', 3)


class GoogleCloudDatacatalogV1BusinessContext(_messages.Message):
  r"""Business Context of the entry.

  Fields:
    contacts: Contact people for the entry.
    entryOverview: Entry overview fields for rich text descriptions of
      entries.
  """

  contacts = _messages.MessageField('GoogleCloudDatacatalogV1Contacts', 1)
  entryOverview = _messages.MessageField('GoogleCloudDatacatalogV1EntryOverview', 2)


class GoogleCloudDatacatalogV1CloudBigtableInstanceSpec(_messages.Message):
  r"""Specification that applies to Instance entries that are part of
  `CLOUD_BIGTABLE` system. (user_specified_type)

  Fields:
    cloudBigtableClusterSpecs: The list of clusters for the Instance.
  """

  cloudBigtableClusterSpecs = _messages.MessageField('GoogleCloudDatacatalogV1CloudBigtableInstanceSpecCloudBigtableClusterSpec', 1, repeated=True)


class GoogleCloudDatacatalogV1CloudBigtableInstanceSpecCloudBigtableClusterSpec(_messages.Message):
  r"""Spec that applies to clusters of an Instance of Cloud Bigtable.

  Fields:
    displayName: Name of the cluster.
    linkedResource: A link back to the parent resource, in this case Instance.
    location: Location of the cluster, typically a Cloud zone.
    type: Type of the resource. For a cluster this would be "CLUSTER".
  """

  displayName = _messages.StringField(1)
  linkedResource = _messages.StringField(2)
  location = _messages.StringField(3)
  type = _messages.StringField(4)


class GoogleCloudDatacatalogV1CloudBigtableSystemSpec(_messages.Message):
  r"""Specification that applies to all entries that are part of
  `CLOUD_BIGTABLE` system (user_specified_type)

  Fields:
    instanceDisplayName: Display name of the Instance. This is user specified
      and different from the resource name.
  """

  instanceDisplayName = _messages.StringField(1)


class GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpec(_messages.Message):
  r"""Specification for the BigQuery connection to a Cloud SQL instance.

  Enums:
    TypeValueValuesEnum: Type of the Cloud SQL database.

  Fields:
    database: Database name.
    instanceId: Cloud SQL instance ID in the format of
      `project:location:instance`.
    type: Type of the Cloud SQL database.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of the Cloud SQL database.

    Values:
      DATABASE_TYPE_UNSPECIFIED: Unspecified database type.
      POSTGRES: Cloud SQL for PostgreSQL.
      MYSQL: Cloud SQL for MySQL.
    """
    DATABASE_TYPE_UNSPECIFIED = 0
    POSTGRES = 1
    MYSQL = 2

  database = _messages.StringField(1)
  instanceId = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class GoogleCloudDatacatalogV1ClusterSpec(_messages.Message):
  r"""Additional specification of a cluster.

  Fields:
    kafkaCluster: Fields specific to a Kafka cluster. Present only on
      corresponding Kafka cluster entries.
  """

  kafkaCluster = _messages.MessageField('GoogleCloudDatacatalogV1KafkaClusterSpec', 1)


class GoogleCloudDatacatalogV1ColumnSchema(_messages.Message):
  r"""A column within a schema. Columns can be nested inside other columns.

  Enums:
    HighestIndexingTypeValueValuesEnum: Optional. Most important inclusion of
      this column.

  Fields:
    column: Required. Name of the column. Must be a UTF-8 string without dots
      (.). The maximum size is 64 bytes.
    defaultValue: Optional. Default value for the column.
    description: Optional. Description of the column. Default value is an
      empty string. The description must be a UTF-8 string with the maximum
      size of 2000 bytes.
    gcRule: Optional. Garbage collection policy for the column or column
      family. Applies to systems like Cloud Bigtable.
    highestIndexingType: Optional. Most important inclusion of this column.
    lookerColumnSpec: Looker specific column info of this column.
    mode: Optional. A column's mode indicates whether values in this column
      are required, nullable, or repeated. Only `NULLABLE`, `REQUIRED`, and
      `REPEATED` values are supported. Default mode is `NULLABLE`.
    ordinalPosition: Optional. Ordinal position
    rangeElementType: Optional. The subtype of the RANGE, if the type of this
      field is RANGE. If the type is RANGE, this field is required. Possible
      values for the field element type of a RANGE include: * DATE * DATETIME
      * TIMESTAMP
    subcolumns: Optional. Schema of sub-columns. A column can have zero or
      more sub-columns.
    type: Required. Type of the column. Must be a UTF-8 string with the
      maximum size of 128 bytes.
  """

  class HighestIndexingTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Most important inclusion of this column.

    Values:
      INDEXING_TYPE_UNSPECIFIED: Unspecified.
      INDEXING_TYPE_NONE: Column not a part of an index.
      INDEXING_TYPE_NON_UNIQUE: Column Part of non unique index.
      INDEXING_TYPE_UNIQUE: Column part of unique index.
      INDEXING_TYPE_PRIMARY_KEY: Column part of the primary key.
    """
    INDEXING_TYPE_UNSPECIFIED = 0
    INDEXING_TYPE_NONE = 1
    INDEXING_TYPE_NON_UNIQUE = 2
    INDEXING_TYPE_UNIQUE = 3
    INDEXING_TYPE_PRIMARY_KEY = 4

  column = _messages.StringField(1)
  defaultValue = _messages.StringField(2)
  description = _messages.StringField(3)
  gcRule = _messages.StringField(4)
  highestIndexingType = _messages.EnumField('HighestIndexingTypeValueValuesEnum', 5)
  lookerColumnSpec = _messages.MessageField('GoogleCloudDatacatalogV1ColumnSchemaLookerColumnSpec', 6)
  mode = _messages.StringField(7)
  ordinalPosition = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  rangeElementType = _messages.MessageField('GoogleCloudDatacatalogV1ColumnSchemaFieldElementType', 9)
  subcolumns = _messages.MessageField('GoogleCloudDatacatalogV1ColumnSchema', 10, repeated=True)
  type = _messages.StringField(11)


class GoogleCloudDatacatalogV1ColumnSchemaFieldElementType(_messages.Message):
  r"""Represents the type of a field element.

  Fields:
    type: Required. The type of a field element. See ColumnSchema.type.
  """

  type = _messages.StringField(1)


class GoogleCloudDatacatalogV1ColumnSchemaLookerColumnSpec(_messages.Message):
  r"""Column info specific to Looker System.

  Enums:
    TypeValueValuesEnum: Looker specific column type of this column.

  Fields:
    type: Looker specific column type of this column.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Looker specific column type of this column.

    Values:
      LOOKER_COLUMN_TYPE_UNSPECIFIED: Unspecified.
      DIMENSION: Dimension.
      DIMENSION_GROUP: Dimension group - parent for Dimension.
      FILTER: Filter.
      MEASURE: Measure.
      PARAMETER: Parameter.
    """
    LOOKER_COLUMN_TYPE_UNSPECIFIED = 0
    DIMENSION = 1
    DIMENSION_GROUP = 2
    FILTER = 3
    MEASURE = 4
    PARAMETER = 5

  type = _messages.EnumField('TypeValueValuesEnum', 1)


class GoogleCloudDatacatalogV1CommonUsageStats(_messages.Message):
  r"""Common statistics on the entry's usage. They can be set on any system.

  Fields:
    viewCount: View count in source system.
  """

  viewCount = _messages.IntegerField(1)


class GoogleCloudDatacatalogV1Contacts(_messages.Message):
  r"""Contact people for the entry.

  Fields:
    people: The list of contact people for the entry.
  """

  people = _messages.MessageField('GoogleCloudDatacatalogV1ContactsPerson', 1, repeated=True)


class GoogleCloudDatacatalogV1ContactsPerson(_messages.Message):
  r"""A contact person for the entry.

  Fields:
    designation: Designation of the person, for example, Data Steward.
    email: Email of the person in the format of `john.doe@xyz`, ``, or `John
      Doe`.
  """

  designation = _messages.StringField(1)
  email = _messages.StringField(2)


class GoogleCloudDatacatalogV1CrossRegionalSource(_messages.Message):
  r"""Cross-regional source used to import an existing taxonomy into a
  different region.

  Fields:
    taxonomy: Required. The resource name of the source taxonomy to import.
  """

  taxonomy = _messages.StringField(1)


class GoogleCloudDatacatalogV1DataSource(_messages.Message):
  r"""Physical location of an entry.

  Enums:
    ServiceValueValuesEnum: Service that physically stores the data.

  Fields:
    resource: Full name of a resource as defined by the service. For example:
      `//bigquery.googleapis.com/projects/{PROJECT_ID}/locations/{LOCATION}/da
      tasets/{DATASET_ID}/tables/{TABLE_ID}`
    service: Service that physically stores the data.
    sourceEntry: Output only. Data Catalog entry name, if applicable.
    storageProperties: Detailed properties of the underlying storage.
  """

  class ServiceValueValuesEnum(_messages.Enum):
    r"""Service that physically stores the data.

    Values:
      SERVICE_UNSPECIFIED: Default unknown service.
      CLOUD_STORAGE: Google Cloud Storage service.
      BIGQUERY: BigQuery service.
    """
    SERVICE_UNSPECIFIED = 0
    CLOUD_STORAGE = 1
    BIGQUERY = 2

  resource = _messages.StringField(1)
  service = _messages.EnumField('ServiceValueValuesEnum', 2)
  sourceEntry = _messages.StringField(3)
  storageProperties = _messages.MessageField('GoogleCloudDatacatalogV1StorageProperties', 4)


class GoogleCloudDatacatalogV1DataSourceConnectionSpec(_messages.Message):
  r"""Specification that applies to a data source connection. Valid only for
  entries with the `DATA_SOURCE_CONNECTION` type. Only one of internal specs
  can be set at the time, and cannot be changed later.

  Fields:
    bigqueryConnectionSpec: Output only. Fields specific to BigQuery
      connections.
  """

  bigqueryConnectionSpec = _messages.MessageField('GoogleCloudDatacatalogV1BigQueryConnectionSpec', 1)


class GoogleCloudDatacatalogV1DataStreamSpec(_messages.Message):
  r"""Additional specification of a data stream.

  Fields:
    kafkaTopic: Fields specific to a Kafka topic. Present only on
      corresponding Kafka topic entries.
  """

  kafkaTopic = _messages.MessageField('GoogleCloudDatacatalogV1KafkaTopicSpec', 1)


class GoogleCloudDatacatalogV1DatabaseTableSpec(_messages.Message):
  r"""Specification that applies to a table resource. Valid only for entries
  with the `TABLE` type.

  Enums:
    TypeValueValuesEnum: Type of this table.

  Fields:
    databaseViewSpec: Spec what applies to tables that are actually views. Not
      set for "real" tables.
    dataplexTable: Output only. Fields specific to a Dataplex Universal
      Catalog table and present only in the Dataplex Universal Catalog table
      entries.
    type: Type of this table.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of this table.

    Values:
      TABLE_TYPE_UNSPECIFIED: Default unknown table type.
      NATIVE: Native table.
      EXTERNAL: External table.
    """
    TABLE_TYPE_UNSPECIFIED = 0
    NATIVE = 1
    EXTERNAL = 2

  databaseViewSpec = _messages.MessageField('GoogleCloudDatacatalogV1DatabaseTableSpecDatabaseViewSpec', 1)
  dataplexTable = _messages.MessageField('GoogleCloudDatacatalogV1DataplexTableSpec', 2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class GoogleCloudDatacatalogV1DatabaseTableSpecDatabaseViewSpec(_messages.Message):
  r"""Specification that applies to database view.

  Enums:
    ViewTypeValueValuesEnum: Type of this view.

  Fields:
    baseTable: Name of a singular table this view reflects one to one.
    sqlQuery: SQL query used to generate this view.
    viewType: Type of this view.
  """

  class ViewTypeValueValuesEnum(_messages.Enum):
    r"""Type of this view.

    Values:
      VIEW_TYPE_UNSPECIFIED: Default unknown view type.
      STANDARD_VIEW: Standard view.
      MATERIALIZED_VIEW: Materialized view.
    """
    VIEW_TYPE_UNSPECIFIED = 0
    STANDARD_VIEW = 1
    MATERIALIZED_VIEW = 2

  baseTable = _messages.StringField(1)
  sqlQuery = _messages.StringField(2)
  viewType = _messages.EnumField('ViewTypeValueValuesEnum', 3)


class GoogleCloudDatacatalogV1DataplexExternalTable(_messages.Message):
  r"""External table registered by Dataplex Universal Catalog. Dataplex
  Universal Catalog publishes data discovered from an asset into multiple
  other systems (BigQuery, DPMS) in form of tables. We call them "external
  tables". External tables are also synced into the Data Catalog. This message
  contains pointers to those external tables (fully qualified name, resource
  name et cetera) within the Data Catalog.

  Enums:
    SystemValueValuesEnum: Service in which the external table is registered.

  Fields:
    dataCatalogEntry: Name of the Data Catalog entry representing the external
      table.
    fullyQualifiedName: Fully qualified name (FQN) of the external table.
    googleCloudResource: Google Cloud resource name of the external table.
    system: Service in which the external table is registered.
  """

  class SystemValueValuesEnum(_messages.Enum):
    r"""Service in which the external table is registered.

    Values:
      INTEGRATED_SYSTEM_UNSPECIFIED: Default unknown system.
      BIGQUERY: BigQuery.
      CLOUD_PUBSUB: Cloud Pub/Sub.
      DATAPROC_METASTORE: Dataproc Metastore.
      DATAPLEX: Dataplex Universal Catalog.
      CLOUD_SPANNER: Cloud Spanner
      CLOUD_BIGTABLE: Cloud Bigtable
      CLOUD_SQL: Cloud Sql
      LOOKER: Looker
      VERTEX_AI: Vertex AI
    """
    INTEGRATED_SYSTEM_UNSPECIFIED = 0
    BIGQUERY = 1
    CLOUD_PUBSUB = 2
    DATAPROC_METASTORE = 3
    DATAPLEX = 4
    CLOUD_SPANNER = 5
    CLOUD_BIGTABLE = 6
    CLOUD_SQL = 7
    LOOKER = 8
    VERTEX_AI = 9

  dataCatalogEntry = _messages.StringField(1)
  fullyQualifiedName = _messages.StringField(2)
  googleCloudResource = _messages.StringField(3)
  system = _messages.EnumField('SystemValueValuesEnum', 4)


class GoogleCloudDatacatalogV1DataplexFilesetSpec(_messages.Message):
  r"""Entry specification for a Dataplex Universal Catalog fileset.

  Fields:
    dataplexSpec: Common Dataplex Universal Catalog fields.
  """

  dataplexSpec = _messages.MessageField('GoogleCloudDatacatalogV1DataplexSpec', 1)


class GoogleCloudDatacatalogV1DataplexSpec(_messages.Message):
  r"""Common Dataplex Universal Catalog fields.

  Fields:
    asset: Fully qualified resource name of an asset in Dataplex Universal
      Catalog, to which the underlying data source (Cloud Storage bucket or
      BigQuery dataset) of the entity is attached.
    compressionFormat: Compression format of the data, e.g., zip, gzip etc.
    dataFormat: Format of the data.
    projectId: Project ID of the underlying Cloud Storage or BigQuery data.
      Note that this may not be the same project as the corresponding Dataplex
      Universal Catalog lake / zone / asset.
  """

  asset = _messages.StringField(1)
  compressionFormat = _messages.StringField(2)
  dataFormat = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchema', 3)
  projectId = _messages.StringField(4)


class GoogleCloudDatacatalogV1DataplexTableSpec(_messages.Message):
  r"""Entry specification for a Dataplex Universal Catalog table.

  Fields:
    dataplexSpec: Common Dataplex Universal Catalog fields.
    externalTables: List of external tables registered by Dataplex Universal
      Catalog in other systems based on the same underlying data. External
      tables allow to query this data in those systems.
    userManaged: Indicates if the table schema is managed by the user or not.
  """

  dataplexSpec = _messages.MessageField('GoogleCloudDatacatalogV1DataplexSpec', 1)
  externalTables = _messages.MessageField('GoogleCloudDatacatalogV1DataplexExternalTable', 2, repeated=True)
  userManaged = _messages.BooleanField(3)


class GoogleCloudDatacatalogV1DatasetSpec(_messages.Message):
  r"""Specification that applies to a dataset. Valid only for entries with the
  `DATASET` type.

  Fields:
    vertexDatasetSpec: Vertex AI Dataset specific fields
  """

  vertexDatasetSpec = _messages.MessageField('GoogleCloudDatacatalogV1VertexDatasetSpec', 1)


class GoogleCloudDatacatalogV1DumpItem(_messages.Message):
  r"""Wrapper for any item that can be contained in the dump.

  Fields:
    taggedEntry: Entry and its tags.
  """

  taggedEntry = _messages.MessageField('GoogleCloudDatacatalogV1TaggedEntry', 1)


class GoogleCloudDatacatalogV1Entry(_messages.Message):
  r"""Entry metadata. A Data Catalog entry represents another resource in
  Google Cloud Platform (such as a BigQuery dataset or a Pub/Sub topic) or
  outside of it. You can use the `linked_resource` field in the entry resource
  to refer to the original resource ID of the source system. An entry resource
  contains resource details, for example, its schema. Additionally, you can
  attach flexible metadata to an entry in the form of a Tag.

  Enums:
    IntegratedSystemValueValuesEnum: Output only. Indicates the entry's source
      system that Data Catalog integrates with, such as BigQuery, Pub/Sub, or
      Dataproc Metastore.
    TypeValueValuesEnum: The type of the entry. For details, see
      [`EntryType`](#entrytype).

  Messages:
    LabelsValue: Cloud labels attached to the entry. In Data Catalog, you can
      create and modify labels attached only to custom entries. Synced entries
      have unmodifiable labels that come from the source system.

  Fields:
    bigqueryDateShardedSpec: Output only. Specification for a group of
      BigQuery tables with the `[prefix]YYYYMMDD` name pattern. For more
      information, see [Introduction to partitioned tables]
      (https://cloud.google.com/bigquery/docs/partitioned-
      tables#partitioning_versus_sharding).
    bigqueryTableSpec: Output only. Specification that applies to a BigQuery
      table. Valid only for entries with the `TABLE` type.
    businessContext: Business Context of the entry. Not supported for BigQuery
      datasets
    cloudBigtableSystemSpec: Specification that applies to Cloud Bigtable
      system. Only settable when `integrated_system` is equal to
      `CLOUD_BIGTABLE`
    clusterSpec: Additional specification of a cluster. Present only on the
      entries that represent clusters.
    dataSource: Output only. Physical location of the entry.
    dataSourceConnectionSpec: Specification that applies to a data source
      connection. Valid only for entries with the `DATA_SOURCE_CONNECTION`
      type.
    dataStreamSpec: Additional specification of a non-Pub/Sub data stream.
    databaseTableSpec: Specification that applies to a table resource. Valid
      only for entries with the `TABLE` or `EXPLORE` type.
    datasetSpec: Specification that applies to a dataset.
    description: Entry description that can consist of several sentences or
      paragraphs that describe entry contents. The description must not
      contain Unicode non-characters as well as C0 and C1 control codes except
      tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
      The maximum size is 2000 bytes when encoded in UTF-8. Default value is
      an empty string.
    displayName: Display name of an entry. The maximum size is 500 bytes when
      encoded in UTF-8. Default value is an empty string.
    featureOnlineStoreSpec: FeatureonlineStore spec for Vertex AI Feature
      Store.
    filesetSpec: Specification that applies to a fileset resource. Valid only
      for entries with the `FILESET` type.
    fullyQualifiedName: [Fully Qualified Name
      (FQN)](https://cloud.google.com//data-catalog/docs/fully-qualified-
      names) of the resource. Set automatically for entries representing
      resources from synced systems. Settable only during creation, and read-
      only later. Can be used for search and lookup of the entries.
    gcsFilesetSpec: Specification that applies to a Cloud Storage fileset.
      Valid only for entries with the `FILESET` type.
    graphSpec: Spec for graph.
    integratedSystem: Output only. Indicates the entry's source system that
      Data Catalog integrates with, such as BigQuery, Pub/Sub, or Dataproc
      Metastore.
    labels: Cloud labels attached to the entry. In Data Catalog, you can
      create and modify labels attached only to custom entries. Synced entries
      have unmodifiable labels that come from the source system.
    linkedResource: The resource this metadata entry refers to. For Google
      Cloud Platform resources, `linked_resource` is the [Full Resource Name]
      (https://cloud.google.com/apis/design/resource_names#full_resource_name)
      . For example, the `linked_resource` for a table resource from BigQuery
      is: `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_I
      D}/tables/{TABLE_ID}` Output only when the entry is one of the types in
      the `EntryType` enum. For entries with a `user_specified_type`, this
      field is optional and defaults to an empty string. The resource string
      must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
      periods (.), colons (:), slashes (/), dashes (-), and hashes (#). The
      maximum size is 200 bytes when encoded in UTF-8.
    lookerSystemSpec: Specification that applies to Looker sysstem. Only
      settable when `user_specified_system` is equal to `LOOKER`
    modelSpec: Model specification.
    name: Output only. Identifier. The resource name of an entry in URL
      format. Note: The entry itself and its child resources might not be
      stored in the location specified in its name.
    personalDetails: Output only. Additional information related to the entry.
      Private to the current user.
    routineSpec: Specification that applies to a user-defined function or
      procedure. Valid only for entries with the `ROUTINE` type.
    schema: Schema of the entry. An entry might not have any schema attached
      to it.
    serviceSpec: Specification that applies to a Service resource.
    sourceSystemTimestamps: Timestamps from the underlying resource, not from
      the Data Catalog entry. Output only when the entry has a system listed
      in the `IntegratedSystem` enum. For entries with
      `user_specified_system`, this field is optional and defaults to an empty
      timestamp.
    spannerTableSpec: Specification of a Spanner table.
    sqlDatabaseSystemSpec: Specification that applies to a relational database
      system. Only settable when `user_specified_system` is equal to
      `SQL_DATABASE`
    type: The type of the entry. For details, see [`EntryType`](#entrytype).
    usageSignal: Resource usage statistics.
    userSpecifiedSystem: Indicates the entry's source system that Data Catalog
      doesn't automatically integrate with. The `user_specified_system` string
      has the following limitations: * Is case insensitive. * Must begin with
      a letter or underscore. * Can only contain letters, numbers, and
      underscores. * Must be at least 1 character and at most 64 characters
      long.
    userSpecifiedType: Custom entry type that doesn't match any of the values
      allowed for input and listed in the `EntryType` enum. When creating an
      entry, first check the type values in the enum. If there are no
      appropriate types for the new entry, provide a custom value, for
      example, `my_special_type`. The `user_specified_type` string has the
      following limitations: * Is case insensitive. * Must begin with a letter
      or underscore. * Can only contain letters, numbers, and underscores. *
      Must be at least 1 character and at most 64 characters long.
  """

  class IntegratedSystemValueValuesEnum(_messages.Enum):
    r"""Output only. Indicates the entry's source system that Data Catalog
    integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.

    Values:
      INTEGRATED_SYSTEM_UNSPECIFIED: Default unknown system.
      BIGQUERY: BigQuery.
      CLOUD_PUBSUB: Cloud Pub/Sub.
      DATAPROC_METASTORE: Dataproc Metastore.
      DATAPLEX: Dataplex Universal Catalog.
      CLOUD_SPANNER: Cloud Spanner
      CLOUD_BIGTABLE: Cloud Bigtable
      CLOUD_SQL: Cloud Sql
      LOOKER: Looker
      VERTEX_AI: Vertex AI
    """
    INTEGRATED_SYSTEM_UNSPECIFIED = 0
    BIGQUERY = 1
    CLOUD_PUBSUB = 2
    DATAPROC_METASTORE = 3
    DATAPLEX = 4
    CLOUD_SPANNER = 5
    CLOUD_BIGTABLE = 6
    CLOUD_SQL = 7
    LOOKER = 8
    VERTEX_AI = 9

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the entry. For details, see [`EntryType`](#entrytype).

    Values:
      ENTRY_TYPE_UNSPECIFIED: Default unknown type.
      TABLE: The entry type that has a GoogleSQL schema, including logical
        views.
      MODEL: The type of models. For more information, see [Supported models
        in BigQuery ML](/bigquery/docs/bqml-introduction#supported_models).
      DATA_STREAM: An entry type for streaming entries. For example, a Pub/Sub
        topic.
      FILESET: An entry type for a set of files or objects. For example, a
        Cloud Storage fileset.
      CLUSTER: A group of servers that work together. For example, a Kafka
        cluster.
      DATABASE: A database.
      DATA_SOURCE_CONNECTION: Connection to a data source. For example, a
        BigQuery connection.
      ROUTINE: Routine, for example, a BigQuery routine.
      LAKE: A Dataplex Universal Catalog lake.
      ZONE: A Dataplex Universal Catalog zone.
      SERVICE: A service, for example, a Dataproc Metastore service.
      DATABASE_SCHEMA: Schema within a relational database.
      DASHBOARD: A Dashboard, for example from Looker.
      EXPLORE: A Looker Explore. For more information, see [Looker Explore
        API] (https://developers.looker.com/api/explorer/4.0/methods/LookmlMod
        el/lookml_model_explore).
      LOOK: A Looker Look. For more information, see [Looker Look API]
        (https://developers.looker.com/api/explorer/4.0/methods/Look).
      FEATURE_ONLINE_STORE: Feature Online Store resource in Vertex AI Feature
        Store.
      FEATURE_VIEW: Feature View resource in Vertex AI Feature Store.
      FEATURE_GROUP: Feature Group resource in Vertex AI Feature Store.
      GRAPH: An entry type for a graph.
    """
    ENTRY_TYPE_UNSPECIFIED = 0
    TABLE = 1
    MODEL = 2
    DATA_STREAM = 3
    FILESET = 4
    CLUSTER = 5
    DATABASE = 6
    DATA_SOURCE_CONNECTION = 7
    ROUTINE = 8
    LAKE = 9
    ZONE = 10
    SERVICE = 11
    DATABASE_SCHEMA = 12
    DASHBOARD = 13
    EXPLORE = 14
    LOOK = 15
    FEATURE_ONLINE_STORE = 16
    FEATURE_VIEW = 17
    FEATURE_GROUP = 18
    GRAPH = 19

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cloud labels attached to the entry. In Data Catalog, you can create
    and modify labels attached only to custom entries. Synced entries have
    unmodifiable labels that come from the source system.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bigqueryDateShardedSpec = _messages.MessageField('GoogleCloudDatacatalogV1BigQueryDateShardedSpec', 1)
  bigqueryTableSpec = _messages.MessageField('GoogleCloudDatacatalogV1BigQueryTableSpec', 2)
  businessContext = _messages.MessageField('GoogleCloudDatacatalogV1BusinessContext', 3)
  cloudBigtableSystemSpec = _messages.MessageField('GoogleCloudDatacatalogV1CloudBigtableSystemSpec', 4)
  clusterSpec = _messages.MessageField('GoogleCloudDatacatalogV1ClusterSpec', 5)
  dataSource = _messages.MessageField('GoogleCloudDatacatalogV1DataSource', 6)
  dataSourceConnectionSpec = _messages.MessageField('GoogleCloudDatacatalogV1DataSourceConnectionSpec', 7)
  dataStreamSpec = _messages.MessageField('GoogleCloudDatacatalogV1DataStreamSpec', 8)
  databaseTableSpec = _messages.MessageField('GoogleCloudDatacatalogV1DatabaseTableSpec', 9)
  datasetSpec = _messages.MessageField('GoogleCloudDatacatalogV1DatasetSpec', 10)
  description = _messages.StringField(11)
  displayName = _messages.StringField(12)
  featureOnlineStoreSpec = _messages.MessageField('GoogleCloudDatacatalogV1FeatureOnlineStoreSpec', 13)
  filesetSpec = _messages.MessageField('GoogleCloudDatacatalogV1FilesetSpec', 14)
  fullyQualifiedName = _messages.StringField(15)
  gcsFilesetSpec = _messages.MessageField('GoogleCloudDatacatalogV1GcsFilesetSpec', 16)
  graphSpec = _messages.MessageField('GoogleCloudDatacatalogV1GraphSpec', 17)
  integratedSystem = _messages.EnumField('IntegratedSystemValueValuesEnum', 18)
  labels = _messages.MessageField('LabelsValue', 19)
  linkedResource = _messages.StringField(20)
  lookerSystemSpec = _messages.MessageField('GoogleCloudDatacatalogV1LookerSystemSpec', 21)
  modelSpec = _messages.MessageField('GoogleCloudDatacatalogV1ModelSpec', 22)
  name = _messages.StringField(23)
  personalDetails = _messages.MessageField('GoogleCloudDatacatalogV1PersonalDetails', 24)
  routineSpec = _messages.MessageField('GoogleCloudDatacatalogV1RoutineSpec', 25)
  schema = _messages.MessageField('GoogleCloudDatacatalogV1Schema', 26)
  serviceSpec = _messages.MessageField('GoogleCloudDatacatalogV1ServiceSpec', 27)
  sourceSystemTimestamps = _messages.MessageField('GoogleCloudDatacatalogV1SystemTimestamps', 28)
  spannerTableSpec = _messages.MessageField('GoogleCloudDatacatalogV1SpannerTableSpec', 29)
  sqlDatabaseSystemSpec = _messages.MessageField('GoogleCloudDatacatalogV1SqlDatabaseSystemSpec', 30)
  type = _messages.EnumField('TypeValueValuesEnum', 31)
  usageSignal = _messages.MessageField('GoogleCloudDatacatalogV1UsageSignal', 32)
  userSpecifiedSystem = _messages.StringField(33)
  userSpecifiedType = _messages.StringField(34)


class GoogleCloudDatacatalogV1EntryGroup(_messages.Message):
  r"""Entry group metadata. An `EntryGroup` resource represents a logical
  grouping of zero or more Data Catalog Entry resources.

  Fields:
    dataCatalogTimestamps: Output only. Timestamps of the entry group. Default
      value is empty.
    description: Entry group description. Can consist of several sentences or
      paragraphs that describe the entry group contents. Default value is an
      empty string.
    displayName: A short name to identify the entry group, for example,
      "analytics data - jan 2011". Default value is an empty string.
    name: Identifier. The resource name of the entry group in URL format.
      Note: The entry group itself and its child resources might not be stored
      in the location specified in its name.
    transferredToDataplex: Optional. When set to [true], it means DataCatalog
      EntryGroup was transferred to Dataplex Universal Catalog. It makes
      EntryGroup and its Entries to be read-only in DataCatalog. However, new
      Tags on EntryGroup and its Entries can be created. After setting the
      flag to [true] it cannot be unset.
  """

  dataCatalogTimestamps = _messages.MessageField('GoogleCloudDatacatalogV1SystemTimestamps', 1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  name = _messages.StringField(4)
  transferredToDataplex = _messages.BooleanField(5)


class GoogleCloudDatacatalogV1EntryOverview(_messages.Message):
  r"""Entry overview fields for rich text descriptions of entries.

  Fields:
    overview: Entry overview with support for rich text. The overview must
      only contain Unicode characters, and should be formatted using HTML. The
      maximum length is 10 MiB as this value holds HTML descriptions including
      encoded images. The maximum length of the text without images is 100
      KiB.
  """

  overview = _messages.StringField(1)


class GoogleCloudDatacatalogV1ExportTaxonomiesResponse(_messages.Message):
  r"""Response message for ExportTaxonomies.

  Fields:
    taxonomies: List of taxonomies and policy tags as nested protocol buffers.
  """

  taxonomies = _messages.MessageField('GoogleCloudDatacatalogV1SerializedTaxonomy', 1, repeated=True)


class GoogleCloudDatacatalogV1FeatureOnlineStoreSpec(_messages.Message):
  r"""Detail description of the source information of a Vertex Feature Online
  Store.

  Enums:
    StorageTypeValueValuesEnum: Output only. Type of underlying storage for
      the FeatureOnlineStore.

  Fields:
    storageType: Output only. Type of underlying storage for the
      FeatureOnlineStore.
  """

  class StorageTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Type of underlying storage for the FeatureOnlineStore.

    Values:
      STORAGE_TYPE_UNSPECIFIED: Should not be used.
      BIGTABLE: Underlsying storgae is Bigtable.
      OPTIMIZED: Underlying is optimized online server (Lightning).
    """
    STORAGE_TYPE_UNSPECIFIED = 0
    BIGTABLE = 1
    OPTIMIZED = 2

  storageType = _messages.EnumField('StorageTypeValueValuesEnum', 1)


class GoogleCloudDatacatalogV1FieldType(_messages.Message):
  r"""A GoogleCloudDatacatalogV1FieldType object.

  Enums:
    PrimitiveTypeValueValuesEnum: Primitive types, such as string, boolean,
      etc.

  Fields:
    enumType: An enum type.
    primitiveType: Primitive types, such as string, boolean, etc.
  """

  class PrimitiveTypeValueValuesEnum(_messages.Enum):
    r"""Primitive types, such as string, boolean, etc.

    Values:
      PRIMITIVE_TYPE_UNSPECIFIED: The default invalid value for a type.
      DOUBLE: A double precision number.
      STRING: An UTF-8 string.
      BOOL: A boolean value.
      TIMESTAMP: A timestamp.
      RICHTEXT: A Richtext description.
    """
    PRIMITIVE_TYPE_UNSPECIFIED = 0
    DOUBLE = 1
    STRING = 2
    BOOL = 3
    TIMESTAMP = 4
    RICHTEXT = 5

  enumType = _messages.MessageField('GoogleCloudDatacatalogV1FieldTypeEnumType', 1)
  primitiveType = _messages.EnumField('PrimitiveTypeValueValuesEnum', 2)


class GoogleCloudDatacatalogV1FieldTypeEnumType(_messages.Message):
  r"""A GoogleCloudDatacatalogV1FieldTypeEnumType object.

  Fields:
    allowedValues: The set of allowed values for this enum. This set must not
      be empty and can include up to 100 allowed values. The display names of
      the values in this set must not be empty and must be case-insensitively
      unique within this set. The order of items in this set is preserved.
      This field can be used to create, remove, and reorder enum values. To
      rename enum values, use the `RenameTagTemplateFieldEnumValue` method.
  """

  allowedValues = _messages.MessageField('GoogleCloudDatacatalogV1FieldTypeEnumTypeEnumValue', 1, repeated=True)


class GoogleCloudDatacatalogV1FieldTypeEnumTypeEnumValue(_messages.Message):
  r"""A GoogleCloudDatacatalogV1FieldTypeEnumTypeEnumValue object.

  Fields:
    displayName: Required. The display name of the enum value. Must not be an
      empty string. The name must contain only Unicode letters, numbers (0-9),
      underscores (_), dashes (-), spaces ( ), and can't start or end with
      spaces. The maximum length is 200 characters.
  """

  displayName = _messages.StringField(1)


class GoogleCloudDatacatalogV1FilesetSpec(_messages.Message):
  r"""Specification that applies to a fileset. Valid only for entries with the
  'FILESET' type.

  Fields:
    dataplexFileset: Fields specific to a Dataplex Universal Catalog fileset
      and present only in the Dataplex Universal Catalog fileset entries.
  """

  dataplexFileset = _messages.MessageField('GoogleCloudDatacatalogV1DataplexFilesetSpec', 1)


class GoogleCloudDatacatalogV1GcsFileSpec(_messages.Message):
  r"""Specification of a single file in Cloud Storage.

  Fields:
    filePath: Required. Full file path. Example: `gs://bucket_name/a/b.txt`.
    gcsTimestamps: Output only. Creation, modification, and expiration
      timestamps of a Cloud Storage file.
    sizeBytes: Output only. File size in bytes.
  """

  filePath = _messages.StringField(1)
  gcsTimestamps = _messages.MessageField('GoogleCloudDatacatalogV1SystemTimestamps', 2)
  sizeBytes = _messages.IntegerField(3)


class GoogleCloudDatacatalogV1GcsFilesetSpec(_messages.Message):
  r"""Describes a Cloud Storage fileset entry.

  Fields:
    filePatterns: Required. Patterns to identify a set of files in Google
      Cloud Storage. For more information, see [Wildcard Names]
      (https://cloud.google.com/storage/docs/wildcards). Note: Currently,
      bucket wildcards are not supported. Examples of valid `file_patterns`: *
      `gs://bucket_name/dir/*`: matches all files in `bucket_name/dir`
      directory * `gs://bucket_name/dir/**`: matches all files in
      `bucket_name/dir` and all subdirectories * `gs://bucket_name/file*`:
      matches files prefixed by `file` in `bucket_name` *
      `gs://bucket_name/??.txt`: matches files with two characters followed by
      `.txt` in `bucket_name` * `gs://bucket_name/[aeiou].txt`: matches files
      that contain a single vowel character followed by `.txt` in
      `bucket_name` * `gs://bucket_name/[a-m].txt`: matches files that contain
      `a`, `b`, ... or `m` followed by `.txt` in `bucket_name` *
      `gs://bucket_name/a/*/b`: matches all files in `bucket_name` that match
      the `a/*/b` pattern, such as `a/c/b`, `a/d/b` *
      `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt` You can
      combine wildcards to match complex sets of files, for example:
      `gs://bucket_name/[a-m]??.j*g`
    sampleGcsFileSpecs: Output only. Sample files contained in this fileset,
      not all files contained in this fileset are represented here.
  """

  filePatterns = _messages.StringField(1, repeated=True)
  sampleGcsFileSpecs = _messages.MessageField('GoogleCloudDatacatalogV1GcsFileSpec', 2, repeated=True)


class GoogleCloudDatacatalogV1GraphSpec(_messages.Message):
  r"""Specification that applies to a graph.

  Fields:
    edgeTables: Optional. Edge tables of the graph.
    name: Output only. Fully qualified graph name. e.g.
      `named_catalog.MyGraph`
    nodeTables: Required. Node tables of the graph.
  """

  edgeTables = _messages.MessageField('GoogleCloudDatacatalogV1GraphSpecGraphElementTable', 1, repeated=True)
  name = _messages.StringField(2)
  nodeTables = _messages.MessageField('GoogleCloudDatacatalogV1GraphSpecGraphElementTable', 3, repeated=True)


class GoogleCloudDatacatalogV1GraphSpecGraphElementTable(_messages.Message):
  r"""Element table definition.

  Enums:
    InputSourceValueValuesEnum: Required. The input source of the graph
      element.
    KindValueValuesEnum: Required. The kind of the graph element.

  Fields:
    alias: Required. The alias name of the graph element.
    dataSource: Required. The name of the data source. This is either a table
      name or a view name that is used for graph element input source. E.g.
      `Person` table or `PersonView` view.
    destinationNodeReference: Optional. The destination node reference of the
      edge.
    dynamicLabelColumn: Optional. If set, this is the input column for dynamic
      label in schemaless data model.
    dynamicPropertiesColumn: Optional. If set, this is the input column for
      dynamic properties in schemaless data model.
    elementKeys: Required. The name of the keys of the elements in the table.
    inputSource: Required. The input source of the graph element.
    kind: Required. The kind of the graph element.
    labelAndProperties: Required. The labels and their properties for the
      graph element.
    sourceNodeReference: Optional. The source node reference of the edge.
  """

  class InputSourceValueValuesEnum(_messages.Enum):
    r"""Required. The input source of the graph element.

    Values:
      INPUT_SOURCE_UNSPECIFIED: Default unknown input source.
      TABLE: Table input source.
      VIEW: View input source.
    """
    INPUT_SOURCE_UNSPECIFIED = 0
    TABLE = 1
    VIEW = 2

  class KindValueValuesEnum(_messages.Enum):
    r"""Required. The kind of the graph element.

    Values:
      KIND_UNSPECIFIED: Default unknown kind.
      NODE: Node kind.
      EDGE: Edge kind.
    """
    KIND_UNSPECIFIED = 0
    NODE = 1
    EDGE = 2

  alias = _messages.StringField(1)
  dataSource = _messages.StringField(2)
  destinationNodeReference = _messages.MessageField('GoogleCloudDatacatalogV1GraphSpecGraphElementTableGraphNodeReference', 3)
  dynamicLabelColumn = _messages.StringField(4)
  dynamicPropertiesColumn = _messages.StringField(5)
  elementKeys = _messages.StringField(6, repeated=True)
  inputSource = _messages.EnumField('InputSourceValueValuesEnum', 7)
  kind = _messages.EnumField('KindValueValuesEnum', 8)
  labelAndProperties = _messages.MessageField('GoogleCloudDatacatalogV1GraphSpecGraphElementTableLabelAndProperties', 9, repeated=True)
  sourceNodeReference = _messages.MessageField('GoogleCloudDatacatalogV1GraphSpecGraphElementTableGraphNodeReference', 10)


class GoogleCloudDatacatalogV1GraphSpecGraphElementTableGraphNodeReference(_messages.Message):
  r"""A reference to a source or destination node in a graph edge.

  Fields:
    edgeTableColumns: Required. The referencing columns in the edge table. The
      size of `edge_table_columns` must be equal to the size of
      `node_table_columns`.
    nodeAlias: Required. The reference to the source/destination node of the
      edge. This name must be a valid `alias` of a node element in the same
      graph. Example, `Person` node can be a source node name of an edge
      element `Person_to_Address`.
    nodeTableColumns: Required. The referenced columns of the source node
      table.
  """

  edgeTableColumns = _messages.StringField(1, repeated=True)
  nodeAlias = _messages.StringField(2)
  nodeTableColumns = _messages.StringField(3, repeated=True)


class GoogleCloudDatacatalogV1GraphSpecGraphElementTableLabelAndProperties(_messages.Message):
  r"""The label and its properties. Each label is associated with a set of
  properties.

  Fields:
    label: Required. The name of the label.
    properties: Optional. The properties associated with the label.
  """

  label = _messages.StringField(1)
  properties = _messages.MessageField('GoogleCloudDatacatalogV1GraphSpecGraphElementTableProperty', 2, repeated=True)


class GoogleCloudDatacatalogV1GraphSpecGraphElementTableProperty(_messages.Message):
  r"""A property declaration.

  Fields:
    name: Required. Property name.
    type: Required. Property data type.
  """

  name = _messages.StringField(1)
  type = _messages.StringField(2)


class GoogleCloudDatacatalogV1ImportEntriesMetadata(_messages.Message):
  r"""Metadata message for long-running operation returned by the
  ImportEntries.

  Enums:
    StateValueValuesEnum: State of the import operation.

  Fields:
    errors: Partial errors that are encountered during the ImportEntries
      operation. There is no guarantee that all the encountered errors are
      reported. However, if no errors are reported, it means that no errors
      were encountered.
    state: State of the import operation.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of the import operation.

    Values:
      IMPORT_STATE_UNSPECIFIED: Default value. This value is unused.
      IMPORT_QUEUED: The dump with entries has been queued for import.
      IMPORT_IN_PROGRESS: The import of entries is in progress.
      IMPORT_DONE: The import of entries has been finished.
      IMPORT_OBSOLETE: The import of entries has been abandoned in favor of a
        newer request.
    """
    IMPORT_STATE_UNSPECIFIED = 0
    IMPORT_QUEUED = 1
    IMPORT_IN_PROGRESS = 2
    IMPORT_DONE = 3
    IMPORT_OBSOLETE = 4

  errors = _messages.MessageField('Status', 1, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudDatacatalogV1ImportEntriesRequest(_messages.Message):
  r"""Request message for ImportEntries method.

  Fields:
    gcsBucketPath: Path to a Cloud Storage bucket that contains a dump ready
      for ingestion.
    jobId: Optional. (Optional) Dataplex Universal Catalog task job id, if
      specified will be used as part of ImportEntries LRO ID
  """

  gcsBucketPath = _messages.StringField(1)
  jobId = _messages.StringField(2)


class GoogleCloudDatacatalogV1ImportEntriesResponse(_messages.Message):
  r"""Response message for long-running operation returned by the
  ImportEntries.

  Fields:
    deletedEntriesCount: Number of entries deleted as a result of import
      operation.
    upsertedEntriesCount: Cumulative number of entries created and entries
      updated as a result of import operation.
  """

  deletedEntriesCount = _messages.IntegerField(1)
  upsertedEntriesCount = _messages.IntegerField(2)


class GoogleCloudDatacatalogV1ImportTaxonomiesRequest(_messages.Message):
  r"""Request message for ImportTaxonomies.

  Fields:
    crossRegionalSource: Cross-regional source taxonomy to import.
    inlineSource: Inline source taxonomy to import.
  """

  crossRegionalSource = _messages.MessageField('GoogleCloudDatacatalogV1CrossRegionalSource', 1)
  inlineSource = _messages.MessageField('GoogleCloudDatacatalogV1InlineSource', 2)


class GoogleCloudDatacatalogV1ImportTaxonomiesResponse(_messages.Message):
  r"""Response message for ImportTaxonomies.

  Fields:
    taxonomies: Imported taxonomies.
  """

  taxonomies = _messages.MessageField('GoogleCloudDatacatalogV1Taxonomy', 1, repeated=True)


class GoogleCloudDatacatalogV1InlineSource(_messages.Message):
  r"""Inline source containing taxonomies to import.

  Fields:
    taxonomies: Required. Taxonomies to import.
  """

  taxonomies = _messages.MessageField('GoogleCloudDatacatalogV1SerializedTaxonomy', 1, repeated=True)


class GoogleCloudDatacatalogV1KafkaClusterSpec(_messages.Message):
  r"""Entry spec describing a Kafka cluster.

  Fields:
    bootstrapServers: Required. A comma-separated list of host and port pairs-
      addresses of Kafka brokers in a "bootstrap" Kafka cluster. Kafka clients
      connect to this cluster to bootstrap themselves. The list has the same
      format as the `bootstrap.servers` configuration property for Kafka
      clients. For example: `host1:port1,host2:port2,host3:port3`. For more
      information, see [bootstrap.servers property]
      (https://kafka.apache.org/documentation/#bootstrap.servers). Data
      Catalog doesn't validate the content of this field.
  """

  bootstrapServers = _messages.StringField(1)


class GoogleCloudDatacatalogV1KafkaTopicSpec(_messages.Message):
  r"""Entry specification of a Kafka topic.

  Fields:
    clusterEntry: Required. Name of the Kafka cluster entry this topic is a
      part of. Example:
      `projects/my_project/locations/us/entryGroups/kafka/entries/my_cluster`.
      Data Catalog doesn't validate the content of this field.
    topic: Required. Name of the Kafka topic this entry represents. Example:
      `my_topic`. Data Catalog doesn't validate the content of this field.
  """

  clusterEntry = _messages.StringField(1)
  topic = _messages.StringField(2)


class GoogleCloudDatacatalogV1ListEntriesResponse(_messages.Message):
  r"""Response message for ListEntries.

  Fields:
    entries: Entry details.
    nextPageToken: Pagination token of the next results page. Empty if there
      are no more items in results.
  """

  entries = _messages.MessageField('GoogleCloudDatacatalogV1Entry', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDatacatalogV1ListEntryGroupsResponse(_messages.Message):
  r"""Response message for ListEntryGroups.

  Fields:
    entryGroups: Entry group details.
    nextPageToken: Pagination token to specify in the next call to retrieve
      the next page of results. Empty if there are no more items.
  """

  entryGroups = _messages.MessageField('GoogleCloudDatacatalogV1EntryGroup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDatacatalogV1ListPolicyTagsResponse(_messages.Message):
  r"""Response message for ListPolicyTags.

  Fields:
    nextPageToken: Pagination token of the next results page. Empty if there
      are no more results in the list.
    policyTags: The policy tags that belong to the taxonomy.
  """

  nextPageToken = _messages.StringField(1)
  policyTags = _messages.MessageField('GoogleCloudDatacatalogV1PolicyTag', 2, repeated=True)


class GoogleCloudDatacatalogV1ListTagsResponse(_messages.Message):
  r"""Response message for ListTags.

  Fields:
    nextPageToken: Pagination token of the next results page. Empty if there
      are no more items in results.
    tags: Tag details.
  """

  nextPageToken = _messages.StringField(1)
  tags = _messages.MessageField('GoogleCloudDatacatalogV1Tag', 2, repeated=True)


class GoogleCloudDatacatalogV1ListTaxonomiesResponse(_messages.Message):
  r"""Response message for ListTaxonomies.

  Fields:
    nextPageToken: Pagination token of the next results page. Empty if there
      are no more results in the list.
    taxonomies: Taxonomies that the project contains.
  """

  nextPageToken = _messages.StringField(1)
  taxonomies = _messages.MessageField('GoogleCloudDatacatalogV1Taxonomy', 2, repeated=True)


class GoogleCloudDatacatalogV1LookerSystemSpec(_messages.Message):
  r"""Specification that applies to entries that are part `LOOKER` system
  (user_specified_type)

  Fields:
    parentInstanceDisplayName: Name of the parent Looker Instance. Empty if it
      does not exist.
    parentInstanceId: ID of the parent Looker Instance. Empty if it does not
      exist. Example value: `someinstance.looker.com`
    parentModelDisplayName: Name of the parent Model. Empty if it does not
      exist.
    parentModelId: ID of the parent Model. Empty if it does not exist.
    parentViewDisplayName: Name of the parent View. Empty if it does not
      exist.
    parentViewId: ID of the parent View. Empty if it does not exist.
  """

  parentInstanceDisplayName = _messages.StringField(1)
  parentInstanceId = _messages.StringField(2)
  parentModelDisplayName = _messages.StringField(3)
  parentModelId = _messages.StringField(4)
  parentViewDisplayName = _messages.StringField(5)
  parentViewId = _messages.StringField(6)


class GoogleCloudDatacatalogV1MigrationConfig(_messages.Message):
  r"""The configuration related to the migration to Dataplex Universal Catalog
  applied to an organization or project. It is the response message for
  SetConfig and RetrieveEffectiveConfig.

  Enums:
    CatalogUiExperienceValueValuesEnum: Opt-in status for the UI switch to
      Dataplex Universal Catalog.
    TagTemplateMigrationValueValuesEnum: Opt-in status for the migration of
      Tag Templates to Dataplex Universal Catalog.

  Fields:
    catalogUiExperience: Opt-in status for the UI switch to Dataplex Universal
      Catalog.
    tagTemplateMigration: Opt-in status for the migration of Tag Templates to
      Dataplex Universal Catalog.
    templateMigrationEnabledTime: The time when the Tag Template migration was
      enabled. If the Tag Template migration is not enabled, this field is not
      set.
  """

  class CatalogUiExperienceValueValuesEnum(_messages.Enum):
    r"""Opt-in status for the UI switch to Dataplex Universal Catalog.

    Values:
      CATALOG_UI_EXPERIENCE_UNSPECIFIED: Default value. The default UI is
        Dataplex Universal Catalog.
      CATALOG_UI_EXPERIENCE_ENABLED: The UI is Dataplex Universal Catalog.
      CATALOG_UI_EXPERIENCE_DISABLED: The UI is Data Catalog.
    """
    CATALOG_UI_EXPERIENCE_UNSPECIFIED = 0
    CATALOG_UI_EXPERIENCE_ENABLED = 1
    CATALOG_UI_EXPERIENCE_DISABLED = 2

  class TagTemplateMigrationValueValuesEnum(_messages.Enum):
    r"""Opt-in status for the migration of Tag Templates to Dataplex Universal
    Catalog.

    Values:
      TAG_TEMPLATE_MIGRATION_UNSPECIFIED: Default value. Migration of Tag
        Templates from Data Catalog to Dataplex Universal Catalog is not
        performed. For projects that are under an organization, the project
        inherits the organization's configuration when you set the project-
        level configuration to unspecified
        (`TAG_TEMPLATE_MIGRATION_UNSPECIFIED`). This means that when migration
        is enabled at the organization level, and the project-level
        configuration is unspecified, the project is migrated. To explicitly
        opt-in or opt-out individual projects, set the project-level
        configuration to enabled (`TAG_TEMPLATE_MIGRATION_ENABLED`) or
        disabled (`TAG_TEMPLATE_MIGRATION_DISABLED`).
      TAG_TEMPLATE_MIGRATION_ENABLED: Migration of Tag Templates from Data
        Catalog to Dataplex Universal Catalog is enabled.
      TAG_TEMPLATE_MIGRATION_DISABLED: Migration of Tag Templates from Data
        Catalog to Dataplex Universal Catalog is disabled.
    """
    TAG_TEMPLATE_MIGRATION_UNSPECIFIED = 0
    TAG_TEMPLATE_MIGRATION_ENABLED = 1
    TAG_TEMPLATE_MIGRATION_DISABLED = 2

  catalogUiExperience = _messages.EnumField('CatalogUiExperienceValueValuesEnum', 1)
  tagTemplateMigration = _messages.EnumField('TagTemplateMigrationValueValuesEnum', 2)
  templateMigrationEnabledTime = _messages.StringField(3)


class GoogleCloudDatacatalogV1ModelSpec(_messages.Message):
  r"""Specification that applies to a model. Valid only for entries with the
  `MODEL` type.

  Fields:
    vertexModelSpec: Specification for vertex model resources.
  """

  vertexModelSpec = _messages.MessageField('GoogleCloudDatacatalogV1VertexModelSpec', 1)


class GoogleCloudDatacatalogV1ModifyEntryContactsRequest(_messages.Message):
  r"""Request message for ModifyEntryContacts.

  Fields:
    contacts: Required. The new value for the Contacts.
  """

  contacts = _messages.MessageField('GoogleCloudDatacatalogV1Contacts', 1)


class GoogleCloudDatacatalogV1ModifyEntryOverviewRequest(_messages.Message):
  r"""Request message for ModifyEntryOverview.

  Fields:
    entryOverview: Required. The new value for the Entry Overview.
  """

  entryOverview = _messages.MessageField('GoogleCloudDatacatalogV1EntryOverview', 1)


class GoogleCloudDatacatalogV1OrganizationConfig(_messages.Message):
  r"""The configuration related to the migration from Data Catalog to Dataplex
  Universal Catalog that has been applied to an organization and any projects
  under it. It is the response message for RetrieveConfig.

  Messages:
    ConfigValue: Map of organizations and project resource names and their
      configuration. The format for the map keys is
      `organizations/{organizationId}` or `projects/{projectId}`.

  Fields:
    config: Map of organizations and project resource names and their
      configuration. The format for the map keys is
      `organizations/{organizationId}` or `projects/{projectId}`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConfigValue(_messages.Message):
    r"""Map of organizations and project resource names and their
    configuration. The format for the map keys is
    `organizations/{organizationId}` or `projects/{projectId}`.

    Messages:
      AdditionalProperty: An additional property for a ConfigValue object.

    Fields:
      additionalProperties: Additional properties of type ConfigValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConfigValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudDatacatalogV1MigrationConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudDatacatalogV1MigrationConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  config = _messages.MessageField('ConfigValue', 1)


class GoogleCloudDatacatalogV1PersonalDetails(_messages.Message):
  r"""Entry metadata relevant only to the user and private to them.

  Fields:
    starTime: Set if the entry is starred; unset otherwise.
    starred: True if the entry is starred by the user; false otherwise.
  """

  starTime = _messages.StringField(1)
  starred = _messages.BooleanField(2)


class GoogleCloudDatacatalogV1PhysicalSchema(_messages.Message):
  r"""Native schema used by a resource represented as an entry. Used by query
  engines for deserializing and parsing source data.

  Fields:
    avro: Schema in Avro JSON format.
    csv: Marks a CSV-encoded data source.
    orc: Marks an ORC-encoded data source.
    parquet: Marks a Parquet-encoded data source.
    protobuf: Schema in protocol buffer format.
    thrift: Schema in Thrift format.
  """

  avro = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchemaAvroSchema', 1)
  csv = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchemaCsvSchema', 2)
  orc = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchemaOrcSchema', 3)
  parquet = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchemaParquetSchema', 4)
  protobuf = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchemaProtobufSchema', 5)
  thrift = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchemaThriftSchema', 6)


class GoogleCloudDatacatalogV1PhysicalSchemaAvroSchema(_messages.Message):
  r"""Schema in Avro JSON format.

  Fields:
    text: JSON source of the Avro schema.
  """

  text = _messages.StringField(1)


class GoogleCloudDatacatalogV1PhysicalSchemaCsvSchema(_messages.Message):
  r"""Marks a CSV-encoded data source."""


class GoogleCloudDatacatalogV1PhysicalSchemaOrcSchema(_messages.Message):
  r"""Marks an ORC-encoded data source."""


class GoogleCloudDatacatalogV1PhysicalSchemaParquetSchema(_messages.Message):
  r"""Marks a Parquet-encoded data source."""


class GoogleCloudDatacatalogV1PhysicalSchemaProtobufSchema(_messages.Message):
  r"""Schema in protocol buffer format.

  Fields:
    text: Protocol buffer source of the schema.
  """

  text = _messages.StringField(1)


class GoogleCloudDatacatalogV1PhysicalSchemaThriftSchema(_messages.Message):
  r"""Schema in Thrift format.

  Fields:
    text: Thrift IDL source of the schema.
  """

  text = _messages.StringField(1)


class GoogleCloudDatacatalogV1PolicyTag(_messages.Message):
  r"""Denotes one policy tag in a taxonomy, for example, SSN. Policy tags can
  be defined in a hierarchy. For example: ``` + Geolocation + LatLong + City +
  ZipCode ``` Where the "Geolocation" policy tag contains three children.

  Fields:
    childPolicyTags: Output only. Resource names of child policy tags of this
      policy tag.
    description: Description of this policy tag. If not set, defaults to
      empty. The description must contain only Unicode characters, tabs,
      newlines, carriage returns and page breaks, and be at most 2000 bytes
      long when encoded in UTF-8.
    displayName: Required. User-defined name of this policy tag. The name
      can't start or end with spaces and must be unique within the parent
      taxonomy, contain only Unicode letters, numbers, underscores, dashes and
      spaces, and be at most 200 bytes long when encoded in UTF-8.
    name: Identifier. Resource name of this policy tag in the URL format. The
      policy tag manager generates unique taxonomy IDs and policy tag IDs.
    parentPolicyTag: Resource name of this policy tag's parent policy tag. If
      empty, this is a top level tag. If not set, defaults to an empty string.
      For example, for the "LatLong" policy tag in the example above, this
      field contains the resource name of the "Geolocation" policy tag, and,
      for "Geolocation", this field is empty.
  """

  childPolicyTags = _messages.StringField(1, repeated=True)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  name = _messages.StringField(4)
  parentPolicyTag = _messages.StringField(5)


class GoogleCloudDatacatalogV1ReconcileTagsMetadata(_messages.Message):
  r"""Long-running operation metadata message returned by the ReconcileTags.

  Enums:
    StateValueValuesEnum: State of the reconciliation operation.

  Messages:
    ErrorsValue: Maps the name of each tagged column (or empty string for a
      sole entry) to tagging operation status.

  Fields:
    errors: Maps the name of each tagged column (or empty string for a sole
      entry) to tagging operation status.
    state: State of the reconciliation operation.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of the reconciliation operation.

    Values:
      RECONCILIATION_STATE_UNSPECIFIED: Default value. This value is unused.
      RECONCILIATION_QUEUED: The reconciliation has been queued and awaits for
        execution.
      RECONCILIATION_IN_PROGRESS: The reconciliation is in progress.
      RECONCILIATION_DONE: The reconciliation has been finished.
    """
    RECONCILIATION_STATE_UNSPECIFIED = 0
    RECONCILIATION_QUEUED = 1
    RECONCILIATION_IN_PROGRESS = 2
    RECONCILIATION_DONE = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ErrorsValue(_messages.Message):
    r"""Maps the name of each tagged column (or empty string for a sole entry)
    to tagging operation status.

    Messages:
      AdditionalProperty: An additional property for a ErrorsValue object.

    Fields:
      additionalProperties: Additional properties of type ErrorsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ErrorsValue object.

      Fields:
        key: Name of the additional property.
        value: A Status attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Status', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  errors = _messages.MessageField('ErrorsValue', 1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudDatacatalogV1ReconcileTagsRequest(_messages.Message):
  r"""Request message for ReconcileTags.

  Fields:
    forceDeleteMissing: A boolean attribute.
    tagTemplate: Required. The name of the tag template, which is used for
      reconciliation.
    tags: A list of tags to apply to an entry. A tag can specify a tag
      template, which must be the template specified in the
      `ReconcileTagsRequest`. The sole entry and each of its columns must be
      mentioned at most once.
  """

  forceDeleteMissing = _messages.BooleanField(1)
  tagTemplate = _messages.StringField(2)
  tags = _messages.MessageField('GoogleCloudDatacatalogV1Tag', 3, repeated=True)


class GoogleCloudDatacatalogV1ReconcileTagsResponse(_messages.Message):
  r"""Long-running operation response message returned by ReconcileTags.

  Fields:
    createdTagsCount: Number of tags created in the request.
    deletedTagsCount: Number of tags deleted in the request.
    updatedTagsCount: Number of tags updated in the request.
  """

  createdTagsCount = _messages.IntegerField(1)
  deletedTagsCount = _messages.IntegerField(2)
  updatedTagsCount = _messages.IntegerField(3)


class GoogleCloudDatacatalogV1RenameTagTemplateFieldEnumValueRequest(_messages.Message):
  r"""Request message for RenameTagTemplateFieldEnumValue.

  Fields:
    newEnumValueDisplayName: Required. The new display name of the enum value.
      For example, `my_new_enum_value`.
  """

  newEnumValueDisplayName = _messages.StringField(1)


class GoogleCloudDatacatalogV1RenameTagTemplateFieldRequest(_messages.Message):
  r"""Request message for RenameTagTemplateField.

  Fields:
    newTagTemplateFieldId: Required. The new ID of this tag template field.
      For example, `my_new_field`.
  """

  newTagTemplateFieldId = _messages.StringField(1)


class GoogleCloudDatacatalogV1ReplaceTaxonomyRequest(_messages.Message):
  r"""Request message for ReplaceTaxonomy.

  Fields:
    serializedTaxonomy: Required. Taxonomy to update along with its child
      policy tags.
  """

  serializedTaxonomy = _messages.MessageField('GoogleCloudDatacatalogV1SerializedTaxonomy', 1)


class GoogleCloudDatacatalogV1RoutineSpec(_messages.Message):
  r"""Specification that applies to a routine. Valid only for entries with the
  `ROUTINE` type.

  Enums:
    RoutineTypeValueValuesEnum: The type of the routine.

  Fields:
    bigqueryRoutineSpec: Fields specific for BigQuery routines.
    definitionBody: The body of the routine.
    language: The language the routine is written in. The exact value depends
      on the source system. For BigQuery routines, possible values are: *
      `SQL` * `JAVASCRIPT`
    returnType: Return type of the argument. The exact value depends on the
      source system and the language.
    routineArguments: Arguments of the routine.
    routineType: The type of the routine.
  """

  class RoutineTypeValueValuesEnum(_messages.Enum):
    r"""The type of the routine.

    Values:
      ROUTINE_TYPE_UNSPECIFIED: Unspecified type.
      SCALAR_FUNCTION: Non-builtin permanent scalar function.
      PROCEDURE: Stored procedure.
    """
    ROUTINE_TYPE_UNSPECIFIED = 0
    SCALAR_FUNCTION = 1
    PROCEDURE = 2

  bigqueryRoutineSpec = _messages.MessageField('GoogleCloudDatacatalogV1BigQueryRoutineSpec', 1)
  definitionBody = _messages.StringField(2)
  language = _messages.StringField(3)
  returnType = _messages.StringField(4)
  routineArguments = _messages.MessageField('GoogleCloudDatacatalogV1RoutineSpecArgument', 5, repeated=True)
  routineType = _messages.EnumField('RoutineTypeValueValuesEnum', 6)


class GoogleCloudDatacatalogV1RoutineSpecArgument(_messages.Message):
  r"""Input or output argument of a function or stored procedure.

  Enums:
    ModeValueValuesEnum: Specifies whether the argument is input or output.

  Fields:
    mode: Specifies whether the argument is input or output.
    name: The name of the argument. A return argument of a function might not
      have a name.
    type: Type of the argument. The exact value depends on the source system
      and the language.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""Specifies whether the argument is input or output.

    Values:
      MODE_UNSPECIFIED: Unspecified mode.
      IN: The argument is input-only.
      OUT: The argument is output-only.
      INOUT: The argument is both an input and an output.
    """
    MODE_UNSPECIFIED = 0
    IN = 1
    OUT = 2
    INOUT = 3

  mode = _messages.EnumField('ModeValueValuesEnum', 1)
  name = _messages.StringField(2)
  type = _messages.StringField(3)


class GoogleCloudDatacatalogV1Schema(_messages.Message):
  r"""Represents a schema, for example, a BigQuery, GoogleSQL, or Avro schema.

  Fields:
    columns: The unified GoogleSQL-like schema of columns. The overall maximum
      number of columns and nested columns is 10,000. The maximum nested depth
      is 15 levels.
    physicalSchema: Physical schema that encodes the data represented by this
      entry.
  """

  columns = _messages.MessageField('GoogleCloudDatacatalogV1ColumnSchema', 1, repeated=True)
  physicalSchema = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchema', 2)


class GoogleCloudDatacatalogV1SearchCatalogRequest(_messages.Message):
  r"""Request message for SearchCatalog.

  Fields:
    adminSearch: Optional. If set, use searchAll permission granted on
      organizations from `include_org_ids` and projects from
      `include_project_ids` instead of the fine grained per resource
      permissions when filtering the search results. The only allowed
      `order_by` criteria for admin_search mode is `default`. Using this flags
      guarantees a full recall of the search results.
    orderBy: Specifies the order of results. Currently supported case-
      sensitive values are: * `relevance` that can only be descending *
      `last_modified_timestamp [asc|desc]` with descending (`desc`) as default
      * `default` that can only be descending Search queries don't guarantee
      full recall. Results that match your query might not be returned, even
      in subsequent result pages. Additionally, returned (and not returned)
      results can vary if you repeat search queries. If you are experiencing
      recall issues and you don't have to fetch the results in any specific
      order, consider setting this parameter to `default`. If this parameter
      is omitted, it defaults to the descending `relevance`.
    pageSize: Upper bound on the number of results you can get in a single
      response. Can't be negative or 0, defaults to 10 in this case. The
      maximum number is 1000. If exceeded, throws an "invalid argument"
      exception.
    pageToken: Optional. Pagination token that, if specified, returns the next
      page of search results. If empty, returns the first page. This token is
      returned in the SearchCatalogResponse.next_page_token field of the
      response to a previous SearchCatalogRequest call.
    query: Optional. The query string with a minimum of 3 characters and
      specific syntax. For more information, see [Data Catalog search
      syntax](https://cloud.google.com/data-catalog/docs/how-to/search-
      reference). An empty query string returns all data assets (in the
      specified scope) that you have access to. A query string can be a simple
      `xyz` or qualified by predicates: * `name:x` * `column:y` *
      `description:z`
    scope: Required. The scope of this search request. The `scope` is invalid
      if `include_org_ids`, `include_project_ids` are empty AND
      `include_gcp_public_datasets` is set to `false`. In this case, the
      request returns an error.
  """

  adminSearch = _messages.BooleanField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  query = _messages.StringField(5)
  scope = _messages.MessageField('GoogleCloudDatacatalogV1SearchCatalogRequestScope', 6)


class GoogleCloudDatacatalogV1SearchCatalogRequestScope(_messages.Message):
  r"""The criteria that select the subspace used for query matching.

  Fields:
    includeGcpPublicDatasets: If `true`, include Google Cloud public datasets
      in search results. By default, they are excluded. See [Google Cloud
      Public Datasets](/public-datasets) for more information.
    includeOrgIds: The list of organization IDs to search within. To find your
      organization ID, follow the steps from [Creating and managing
      organizations] (/resource-manager/docs/creating-managing-organization).
    includeProjectIds: The list of project IDs to search within. For more
      information on the distinction between project names, IDs, and numbers,
      see [Projects](/docs/overview/#projects).
    includePublicTagTemplates: Optional. This field is deprecated. The search
      mechanism for public and private tag templates is the same.
    restrictedLocations: Optional. The list of locations to search within. If
      empty, all locations are searched. Returns an error if any location in
      the list isn't one of the [Supported
      regions](https://cloud.google.com/data-
      catalog/docs/concepts/regions#supported_regions). If a location is
      unreachable, its name is returned in the
      `SearchCatalogResponse.unreachable` field. To get additional information
      on the error, repeat the search request and set the location name as the
      value of this parameter.
    starredOnly: Optional. If `true`, search only among starred entries. By
      default, all results are returned, starred or not.
  """

  includeGcpPublicDatasets = _messages.BooleanField(1)
  includeOrgIds = _messages.StringField(2, repeated=True)
  includeProjectIds = _messages.StringField(3, repeated=True)
  includePublicTagTemplates = _messages.BooleanField(4)
  restrictedLocations = _messages.StringField(5, repeated=True)
  starredOnly = _messages.BooleanField(6)


class GoogleCloudDatacatalogV1SearchCatalogResponse(_messages.Message):
  r"""Response message for SearchCatalog.

  Fields:
    nextPageToken: Pagination token that can be used in subsequent calls to
      retrieve the next page of results.
    results: Search results.
    totalSize: The approximate total number of entries matched by the query.
    unreachable: Unreachable locations. Search results don't include data from
      those locations. To get additional information on an error, repeat the
      search request and restrict it to specific locations by setting the
      `SearchCatalogRequest.scope.restricted_locations` parameter.
  """

  nextPageToken = _messages.StringField(1)
  results = _messages.MessageField('GoogleCloudDatacatalogV1SearchCatalogResult', 2, repeated=True)
  totalSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  unreachable = _messages.StringField(4, repeated=True)


class GoogleCloudDatacatalogV1SearchCatalogResult(_messages.Message):
  r"""Result in the response to a search request. Each result captures details
  of one entry that matches the search.

  Enums:
    IntegratedSystemValueValuesEnum: Output only. The source system that Data
      Catalog automatically integrates with, such as BigQuery, Cloud Pub/Sub,
      or Dataproc Metastore.
    SearchResultTypeValueValuesEnum: Type of the search result. You can use
      this field to determine which get method to call to fetch the full
      resource.

  Fields:
    description: Entry description that can consist of several sentences or
      paragraphs that describe entry contents.
    displayName: The display name of the result.
    fullyQualifiedName: Fully qualified name (FQN) of the resource. FQNs take
      two forms: * For non-regionalized resources:
      `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}` * For
      regionalized resources: `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOU
      RCE_SEPARATED_WITH_DOTS}` Example for a DPMS table: `dataproc_metastore:
      PROJECT_ID.LOCATION_ID.INSTANCE_ID.DATABASE_ID.TABLE_ID`
    integratedSystem: Output only. The source system that Data Catalog
      automatically integrates with, such as BigQuery, Cloud Pub/Sub, or
      Dataproc Metastore.
    linkedResource: The full name of the Google Cloud resource the entry
      belongs to. For more information, see [Full Resource Name]
      (/apis/design/resource_names#full_resource_name). Example: `//bigquery.g
      oogleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID`
    modifyTime: The last modification timestamp of the entry in the source
      system.
    relativeResourceName: The relative name of the resource in URL format.
      Examples: * `projects/{PROJECT_ID}/locations/{LOCATION_ID}/entryGroups/{
      ENTRY_GROUP_ID}/entries/{ENTRY_ID}` *
      `projects/{PROJECT_ID}/tagTemplates/{TAG_TEMPLATE_ID}`
    searchResultSubtype: Sub-type of the search result. A dot-delimited full
      type of the resource. The same type you specify in the `type` search
      predicate. Examples: `entry.table`, `entry.dataStream`, `tagTemplate`.
    searchResultType: Type of the search result. You can use this field to
      determine which get method to call to fetch the full resource.
    userSpecifiedSystem: Custom source system that you can manually integrate
      Data Catalog with.
  """

  class IntegratedSystemValueValuesEnum(_messages.Enum):
    r"""Output only. The source system that Data Catalog automatically
    integrates with, such as BigQuery, Cloud Pub/Sub, or Dataproc Metastore.

    Values:
      INTEGRATED_SYSTEM_UNSPECIFIED: Default unknown system.
      BIGQUERY: BigQuery.
      CLOUD_PUBSUB: Cloud Pub/Sub.
      DATAPROC_METASTORE: Dataproc Metastore.
      DATAPLEX: Dataplex Universal Catalog.
      CLOUD_SPANNER: Cloud Spanner
      CLOUD_BIGTABLE: Cloud Bigtable
      CLOUD_SQL: Cloud Sql
      LOOKER: Looker
      VERTEX_AI: Vertex AI
    """
    INTEGRATED_SYSTEM_UNSPECIFIED = 0
    BIGQUERY = 1
    CLOUD_PUBSUB = 2
    DATAPROC_METASTORE = 3
    DATAPLEX = 4
    CLOUD_SPANNER = 5
    CLOUD_BIGTABLE = 6
    CLOUD_SQL = 7
    LOOKER = 8
    VERTEX_AI = 9

  class SearchResultTypeValueValuesEnum(_messages.Enum):
    r"""Type of the search result. You can use this field to determine which
    get method to call to fetch the full resource.

    Values:
      SEARCH_RESULT_TYPE_UNSPECIFIED: Default unknown type.
      ENTRY: An Entry.
      TAG_TEMPLATE: A TagTemplate.
      ENTRY_GROUP: An EntryGroup.
    """
    SEARCH_RESULT_TYPE_UNSPECIFIED = 0
    ENTRY = 1
    TAG_TEMPLATE = 2
    ENTRY_GROUP = 3

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  fullyQualifiedName = _messages.StringField(3)
  integratedSystem = _messages.EnumField('IntegratedSystemValueValuesEnum', 4)
  linkedResource = _messages.StringField(5)
  modifyTime = _messages.StringField(6)
  relativeResourceName = _messages.StringField(7)
  searchResultSubtype = _messages.StringField(8)
  searchResultType = _messages.EnumField('SearchResultTypeValueValuesEnum', 9)
  userSpecifiedSystem = _messages.StringField(10)


class GoogleCloudDatacatalogV1SerializedPolicyTag(_messages.Message):
  r"""A nested protocol buffer that represents a policy tag and all its
  descendants.

  Fields:
    childPolicyTags: Children of the policy tag, if any.
    description: Description of the serialized policy tag. At most 2000 bytes
      when encoded in UTF-8. If not set, defaults to an empty description.
    displayName: Required. Display name of the policy tag. At most 200 bytes
      when encoded in UTF-8.
    policyTag: Resource name of the policy tag. This field is ignored when
      calling `ImportTaxonomies`.
  """

  childPolicyTags = _messages.MessageField('GoogleCloudDatacatalogV1SerializedPolicyTag', 1, repeated=True)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  policyTag = _messages.StringField(4)


class GoogleCloudDatacatalogV1SerializedTaxonomy(_messages.Message):
  r"""A nested protocol buffer that represents a taxonomy and the hierarchy of
  its policy tags. Used for taxonomy replacement, import, and export.

  Enums:
    ActivatedPolicyTypesValueListEntryValuesEnum:

  Fields:
    activatedPolicyTypes: A list of policy types that are activated per
      taxonomy.
    description: Description of the serialized taxonomy. At most 2000 bytes
      when encoded in UTF-8. If not set, defaults to an empty description.
    displayName: Required. Display name of the taxonomy. At most 200 bytes
      when encoded in UTF-8.
    policyTags: Top level policy tags associated with the taxonomy, if any.
  """

  class ActivatedPolicyTypesValueListEntryValuesEnum(_messages.Enum):
    r"""ActivatedPolicyTypesValueListEntryValuesEnum enum type.

    Values:
      POLICY_TYPE_UNSPECIFIED: Unspecified policy type.
      FINE_GRAINED_ACCESS_CONTROL: Fine-grained access control policy that
        enables access control on tagged sub-resources.
    """
    POLICY_TYPE_UNSPECIFIED = 0
    FINE_GRAINED_ACCESS_CONTROL = 1

  activatedPolicyTypes = _messages.EnumField('ActivatedPolicyTypesValueListEntryValuesEnum', 1, repeated=True)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  policyTags = _messages.MessageField('GoogleCloudDatacatalogV1SerializedPolicyTag', 4, repeated=True)


class GoogleCloudDatacatalogV1ServiceSpec(_messages.Message):
  r"""Specification that applies to a Service resource. Valid only for entries
  with the `SERVICE` type.

  Fields:
    cloudBigtableInstanceSpec: Specification that applies to Instance entries
      of `CLOUD_BIGTABLE` system.
  """

  cloudBigtableInstanceSpec = _messages.MessageField('GoogleCloudDatacatalogV1CloudBigtableInstanceSpec', 1)


class GoogleCloudDatacatalogV1SetConfigRequest(_messages.Message):
  r"""Request message for SetConfig.

  Enums:
    CatalogUiExperienceValueValuesEnum: Opt-in status for the UI switch to
      Dataplex Universal Catalog.
    TagTemplateMigrationValueValuesEnum: Opt-in status for the migration of
      Tag Templates to Dataplex Universal Catalog.

  Fields:
    catalogUiExperience: Opt-in status for the UI switch to Dataplex Universal
      Catalog.
    tagTemplateMigration: Opt-in status for the migration of Tag Templates to
      Dataplex Universal Catalog.
  """

  class CatalogUiExperienceValueValuesEnum(_messages.Enum):
    r"""Opt-in status for the UI switch to Dataplex Universal Catalog.

    Values:
      CATALOG_UI_EXPERIENCE_UNSPECIFIED: Default value. The default UI is
        Dataplex Universal Catalog.
      CATALOG_UI_EXPERIENCE_ENABLED: The UI is Dataplex Universal Catalog.
      CATALOG_UI_EXPERIENCE_DISABLED: The UI is Data Catalog.
    """
    CATALOG_UI_EXPERIENCE_UNSPECIFIED = 0
    CATALOG_UI_EXPERIENCE_ENABLED = 1
    CATALOG_UI_EXPERIENCE_DISABLED = 2

  class TagTemplateMigrationValueValuesEnum(_messages.Enum):
    r"""Opt-in status for the migration of Tag Templates to Dataplex Universal
    Catalog.

    Values:
      TAG_TEMPLATE_MIGRATION_UNSPECIFIED: Default value. Migration of Tag
        Templates from Data Catalog to Dataplex Universal Catalog is not
        performed. For projects that are under an organization, the project
        inherits the organization's configuration when you set the project-
        level configuration to unspecified
        (`TAG_TEMPLATE_MIGRATION_UNSPECIFIED`). This means that when migration
        is enabled at the organization level, and the project-level
        configuration is unspecified, the project is migrated. To explicitly
        opt-in or opt-out individual projects, set the project-level
        configuration to enabled (`TAG_TEMPLATE_MIGRATION_ENABLED`) or
        disabled (`TAG_TEMPLATE_MIGRATION_DISABLED`).
      TAG_TEMPLATE_MIGRATION_ENABLED: Migration of Tag Templates from Data
        Catalog to Dataplex Universal Catalog is enabled.
      TAG_TEMPLATE_MIGRATION_DISABLED: Migration of Tag Templates from Data
        Catalog to Dataplex Universal Catalog is disabled.
    """
    TAG_TEMPLATE_MIGRATION_UNSPECIFIED = 0
    TAG_TEMPLATE_MIGRATION_ENABLED = 1
    TAG_TEMPLATE_MIGRATION_DISABLED = 2

  catalogUiExperience = _messages.EnumField('CatalogUiExperienceValueValuesEnum', 1)
  tagTemplateMigration = _messages.EnumField('TagTemplateMigrationValueValuesEnum', 2)


class GoogleCloudDatacatalogV1SpannerTableSpec(_messages.Message):
  r"""Specification of a Spanner table.

  Fields:
    foreignKeys: Output only. The foreign keys of the table.
    primaryKey: Output only. The primary key of the table.
  """

  foreignKeys = _messages.MessageField('GoogleCloudDatacatalogV1SpannerTableSpecSpannerForeignKey', 1, repeated=True)
  primaryKey = _messages.MessageField('GoogleCloudDatacatalogV1SpannerTableSpecSpannerPrimaryKey', 2)


class GoogleCloudDatacatalogV1SpannerTableSpecSpannerForeignKey(_messages.Message):
  r"""Specification of a Spanner foreign key.

  Fields:
    columnMappings: Output only. The ordered list of column mappings for this
      foreign key.
    entry: Output only. The table name this foreign key referenced to. Format:
      `projects/{PROJECT_ID}/locations/{LOCATION}/entryGroups/{ENTRY_GROUP_ID}
      /entries/{ENTRY_ID}`
    name: Output only. The constraint_name of the foreign key, for example,
      FK_CustomerOrder.
  """

  columnMappings = _messages.MessageField('GoogleCloudDatacatalogV1SpannerTableSpecSpannerForeignKeyForeignKeyColumnMapping', 1, repeated=True)
  entry = _messages.StringField(2)
  name = _messages.StringField(3)


class GoogleCloudDatacatalogV1SpannerTableSpecSpannerForeignKeyForeignKeyColumnMapping(_messages.Message):
  r"""Column mapping for a Spanner foreign key.

  Fields:
    column: Output only. The column in the current table that is part of the
      foreign key.
    referenceColumn: Output only. The column in the referenced table that is
      part of the foreign key.
  """

  column = _messages.StringField(1)
  referenceColumn = _messages.StringField(2)


class GoogleCloudDatacatalogV1SpannerTableSpecSpannerPrimaryKey(_messages.Message):
  r"""Specification of a Spanner primary key.

  Fields:
    columns: Output only. Column names of the primary key.
  """

  columns = _messages.StringField(1, repeated=True)


class GoogleCloudDatacatalogV1SqlDatabaseSystemSpec(_messages.Message):
  r"""Specification that applies to entries that are part `SQL_DATABASE`
  system (user_specified_type)

  Fields:
    databaseVersion: Version of the database engine.
    instanceHost: Host of the SQL database enum InstanceHost { UNDEFINED = 0;
      SELF_HOSTED = 1; CLOUD_SQL = 2; AMAZON_RDS = 3; AZURE_SQL = 4; } Host of
      the enclousing database instance.
    sqlEngine: SQL Database Engine. enum SqlEngine { UNDEFINED = 0; MY_SQL =
      1; POSTGRE_SQL = 2; SQL_SERVER = 3; } Engine of the enclosing database
      instance.
  """

  databaseVersion = _messages.StringField(1)
  instanceHost = _messages.StringField(2)
  sqlEngine = _messages.StringField(3)


class GoogleCloudDatacatalogV1StarEntryRequest(_messages.Message):
  r"""Request message for StarEntry."""


class GoogleCloudDatacatalogV1StarEntryResponse(_messages.Message):
  r"""Response message for StarEntry. Empty for now"""


class GoogleCloudDatacatalogV1StorageProperties(_messages.Message):
  r"""Details the properties of the underlying storage.

  Fields:
    filePattern: Patterns to identify a set of files for this fileset.
      Examples of a valid `file_pattern`: * `gs://bucket_name/dir/*`: matches
      all files in the `bucket_name/dir` directory *
      `gs://bucket_name/dir/**`: matches all files in the `bucket_name/dir`
      and all subdirectories recursively * `gs://bucket_name/file*`: matches
      files prefixed by `file` in `bucket_name` * `gs://bucket_name/??.txt`:
      matches files with two characters followed by `.txt` in `bucket_name` *
      `gs://bucket_name/[aeiou].txt`: matches files that contain a single
      vowel character followed by `.txt` in `bucket_name` *
      `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
      or `m` followed by `.txt` in `bucket_name` * `gs://bucket_name/a/*/b`:
      matches all files in `bucket_name` that match the `a/*/b` pattern, such
      as `a/c/b`, `a/d/b` * `gs://another_bucket/a.txt`: matches
      `gs://another_bucket/a.txt`
    fileType: File type in MIME format, for example, `text/plain`.
  """

  filePattern = _messages.StringField(1, repeated=True)
  fileType = _messages.StringField(2)


class GoogleCloudDatacatalogV1SystemTimestamps(_messages.Message):
  r"""Timestamps associated with this resource in a particular system.

  Fields:
    createTime: Creation timestamp of the resource within the given system.
    expireTime: Output only. Expiration timestamp of the resource within the
      given system. Currently only applicable to BigQuery resources.
    updateTime: Timestamp of the last modification of the resource or its
      metadata within a given system. Note: Depending on the source system,
      not every modification updates this timestamp. For example, BigQuery
      timestamps every metadata modification but not data or permission
      changes.
  """

  createTime = _messages.StringField(1)
  expireTime = _messages.StringField(2)
  updateTime = _messages.StringField(3)


class GoogleCloudDatacatalogV1TableSpec(_messages.Message):
  r"""Normal BigQuery table specification.

  Fields:
    groupedEntry: Output only. If the table is date-sharded, that is, it
      matches the `[prefix]YYYYMMDD` name pattern, this field is the Data
      Catalog resource name of the date-sharded grouped entry. For example: `p
      rojects/{PROJECT_ID}/locations/{LOCATION}/entrygroups/{ENTRY_GROUP_ID}/e
      ntries/{ENTRY_ID}`. Otherwise, `grouped_entry` is empty.
  """

  groupedEntry = _messages.StringField(1)


class GoogleCloudDatacatalogV1Tag(_messages.Message):
  r"""Tags contain custom metadata and are attached to Data Catalog resources.
  Tags conform with the specification of their tag template. See [Data Catalog
  IAM](https://cloud.google.com/data-catalog/docs/concepts/iam) for
  information on the permissions needed to create or view tags.

  Enums:
    DataplexTransferStatusValueValuesEnum: Output only. Denotes the transfer
      status of the Tag Template.

  Messages:
    FieldsValue: Required. Maps the ID of a tag field to its value and
      additional information about that field. Tag template defines valid
      field IDs. A tag must have at least 1 field and at most 500 fields.

  Fields:
    column: Resources like entry can have schemas associated with them. This
      scope allows you to attach tags to an individual column based on that
      schema. To attach a tag to a nested column, separate column names with a
      dot (`.`). Example: `column.nested_column`.
    dataplexTransferStatus: Output only. Denotes the transfer status of the
      Tag Template.
    fields: Required. Maps the ID of a tag field to its value and additional
      information about that field. Tag template defines valid field IDs. A
      tag must have at least 1 field and at most 500 fields.
    name: Identifier. The resource name of the tag in URL format where tag ID
      is a system-generated identifier. Note: The tag itself might not be
      stored in the location specified in its name.
    template: Required. The resource name of the tag template this tag uses.
      Example: `projects/{PROJECT_ID}/locations/{LOCATION}/tagTemplates/{TAG_T
      EMPLATE_ID}` This field cannot be modified after creation.
    templateDisplayName: Output only. The display name of the tag template.
  """

  class DataplexTransferStatusValueValuesEnum(_messages.Enum):
    r"""Output only. Denotes the transfer status of the Tag Template.

    Values:
      DATAPLEX_TRANSFER_STATUS_UNSPECIFIED: Default value. TagTemplate and its
        tags are only visible and editable in Data Catalog.
      MIGRATED: TagTemplate and its tags are auto-copied to Dataplex Universal
        Catalog service. Visible in both services. Editable in Data Catalog,
        read-only in Dataplex Universal Catalog. Deprecated: Individual
        TagTemplate migration is deprecated in favor of organization or
        project wide TagTemplate migration opt-in.
      TRANSFERRED: TagTemplate and its tags are auto-copied to Dataplex
        Universal Catalog service. Visible in both services. Editable in
        Dataplex Universal Catalog, read-only in Data Catalog.
    """
    DATAPLEX_TRANSFER_STATUS_UNSPECIFIED = 0
    MIGRATED = 1
    TRANSFERRED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FieldsValue(_messages.Message):
    r"""Required. Maps the ID of a tag field to its value and additional
    information about that field. Tag template defines valid field IDs. A tag
    must have at least 1 field and at most 500 fields.

    Messages:
      AdditionalProperty: An additional property for a FieldsValue object.

    Fields:
      additionalProperties: Additional properties of type FieldsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FieldsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudDatacatalogV1TagField attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudDatacatalogV1TagField', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  column = _messages.StringField(1)
  dataplexTransferStatus = _messages.EnumField('DataplexTransferStatusValueValuesEnum', 2)
  fields = _messages.MessageField('FieldsValue', 3)
  name = _messages.StringField(4)
  template = _messages.StringField(5)
  templateDisplayName = _messages.StringField(6)


class GoogleCloudDatacatalogV1TagField(_messages.Message):
  r"""Contains the value and additional information on a field within a Tag.

  Fields:
    boolValue: The value of a tag field with a boolean type.
    displayName: Output only. The display name of this field.
    doubleValue: The value of a tag field with a double type.
    enumValue: The value of a tag field with an enum type. This value must be
      one of the allowed values listed in this enum.
    order: Output only. The order of this field with respect to other fields
      in this tag. Can be set by Tag. For example, a higher value can indicate
      a more important field. The value can be negative. Multiple fields can
      have the same order, and field orders within a tag don't have to be
      sequential.
    richtextValue: The value of a tag field with a rich text type. The maximum
      length is 10 MiB as this value holds HTML descriptions including encoded
      images. The maximum length of the text without images is 100 KiB.
    stringValue: The value of a tag field with a string type. The maximum
      length is 2000 UTF-8 characters.
    timestampValue: The value of a tag field with a timestamp type.
  """

  boolValue = _messages.BooleanField(1)
  displayName = _messages.StringField(2)
  doubleValue = _messages.FloatField(3)
  enumValue = _messages.MessageField('GoogleCloudDatacatalogV1TagFieldEnumValue', 4)
  order = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  richtextValue = _messages.StringField(6)
  stringValue = _messages.StringField(7)
  timestampValue = _messages.StringField(8)


class GoogleCloudDatacatalogV1TagFieldEnumValue(_messages.Message):
  r"""An enum value.

  Fields:
    displayName: The display name of the enum value.
  """

  displayName = _messages.StringField(1)


class GoogleCloudDatacatalogV1TagTemplate(_messages.Message):
  r"""A tag template defines a tag that can have one or more typed fields. The
  template is used to create tags that are attached to Google Cloud resources.
  [Tag template roles] (https://cloud.google.com/iam/docs/understanding-
  roles#data-catalog-roles) provide permissions to create, edit, and use the
  template. For example, see the [TagTemplate User]
  (https://cloud.google.com/data-catalog/docs/how-to/template-user) role that
  includes a permission to use the tag template to tag resources.

  Enums:
    DataplexTransferStatusValueValuesEnum: Optional. Transfer status of the
      TagTemplate

  Messages:
    FieldsValue: Required. Map of tag template field IDs to the settings for
      the field. This map is an exhaustive list of the allowed fields. The map
      must contain at least one field and at most 500 fields. The keys to this
      map are tag template field IDs. The IDs have the following limitations:
      * Can contain uppercase and lowercase letters, numbers (0-9) and
      underscores (_). * Must be at least 1 character and at most 64
      characters long. * Must start with a letter or underscore.

  Fields:
    dataplexTransferStatus: Optional. Transfer status of the TagTemplate
    displayName: Display name for this template. Defaults to an empty string.
      The name must contain only Unicode letters, numbers (0-9), underscores
      (_), dashes (-), spaces ( ), and can't start or end with spaces. The
      maximum length is 200 characters.
    fields: Required. Map of tag template field IDs to the settings for the
      field. This map is an exhaustive list of the allowed fields. The map
      must contain at least one field and at most 500 fields. The keys to this
      map are tag template field IDs. The IDs have the following limitations:
      * Can contain uppercase and lowercase letters, numbers (0-9) and
      underscores (_). * Must be at least 1 character and at most 64
      characters long. * Must start with a letter or underscore.
    isPubliclyReadable: Indicates whether tags created with this template are
      public. Public tags do not require tag template access to appear in
      ListTags API response. Additionally, you can search for a public tag by
      value with a simple search query in addition to using a ``tag:``
      predicate.
    name: Identifier. The resource name of the tag template in URL format.
      Note: The tag template itself and its child resources might not be
      stored in the location specified in its name.
  """

  class DataplexTransferStatusValueValuesEnum(_messages.Enum):
    r"""Optional. Transfer status of the TagTemplate

    Values:
      DATAPLEX_TRANSFER_STATUS_UNSPECIFIED: Default value. TagTemplate and its
        tags are only visible and editable in Data Catalog.
      MIGRATED: TagTemplate and its tags are auto-copied to Dataplex Universal
        Catalog service. Visible in both services. Editable in Data Catalog,
        read-only in Dataplex Universal Catalog. Deprecated: Individual
        TagTemplate migration is deprecated in favor of organization or
        project wide TagTemplate migration opt-in.
      TRANSFERRED: TagTemplate and its tags are auto-copied to Dataplex
        Universal Catalog service. Visible in both services. Editable in
        Dataplex Universal Catalog, read-only in Data Catalog.
    """
    DATAPLEX_TRANSFER_STATUS_UNSPECIFIED = 0
    MIGRATED = 1
    TRANSFERRED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FieldsValue(_messages.Message):
    r"""Required. Map of tag template field IDs to the settings for the field.
    This map is an exhaustive list of the allowed fields. The map must contain
    at least one field and at most 500 fields. The keys to this map are tag
    template field IDs. The IDs have the following limitations: * Can contain
    uppercase and lowercase letters, numbers (0-9) and underscores (_). * Must
    be at least 1 character and at most 64 characters long. * Must start with
    a letter or underscore.

    Messages:
      AdditionalProperty: An additional property for a FieldsValue object.

    Fields:
      additionalProperties: Additional properties of type FieldsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FieldsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudDatacatalogV1TagTemplateField attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudDatacatalogV1TagTemplateField', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  dataplexTransferStatus = _messages.EnumField('DataplexTransferStatusValueValuesEnum', 1)
  displayName = _messages.StringField(2)
  fields = _messages.MessageField('FieldsValue', 3)
  isPubliclyReadable = _messages.BooleanField(4)
  name = _messages.StringField(5)


class GoogleCloudDatacatalogV1TagTemplateField(_messages.Message):
  r"""The template for an individual field within a tag template.

  Fields:
    description: The description for this field. Defaults to an empty string.
    displayName: The display name for this field. Defaults to an empty string.
      The name must contain only Unicode letters, numbers (0-9), underscores
      (_), dashes (-), spaces ( ), and can't start or end with spaces. The
      maximum length is 200 characters.
    isRequired: If true, this field is required. Defaults to false.
    name: Identifier. The resource name of the tag template field in URL
      format. Example: `projects/{PROJECT_ID}/locations/{LOCATION}/tagTemplate
      s/{TAG_TEMPLATE}/fields/{FIELD}` Note: The tag template field itself
      might not be stored in the location specified in its name. The name must
      contain only letters (a-z, A-Z), numbers (0-9), or underscores (_), and
      must start with a letter or underscore. The maximum length is 64
      characters.
    order: The order of this field with respect to other fields in this tag
      template. For example, a higher value can indicate a more important
      field. The value can be negative. Multiple fields can have the same
      order and field orders within a tag don't have to be sequential.
    type: Required. The type of value this tag field can contain.
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  isRequired = _messages.BooleanField(3)
  name = _messages.StringField(4)
  order = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  type = _messages.MessageField('GoogleCloudDatacatalogV1FieldType', 6)


class GoogleCloudDatacatalogV1TaggedEntry(_messages.Message):
  r"""Wrapper containing Entry and information about Tags that should and
  should not be attached to it.

  Fields:
    absentTags: Optional. Tags that should be deleted from the Data Catalog.
      Caller should populate template name and column only.
    presentTags: Optional. Tags that should be ingested into the Data Catalog.
      Caller should populate template name, column and fields.
    v1Entry: Non-encrypted Data Catalog v1 Entry.
  """

  absentTags = _messages.MessageField('GoogleCloudDatacatalogV1Tag', 1, repeated=True)
  presentTags = _messages.MessageField('GoogleCloudDatacatalogV1Tag', 2, repeated=True)
  v1Entry = _messages.MessageField('GoogleCloudDatacatalogV1Entry', 3)


class GoogleCloudDatacatalogV1Taxonomy(_messages.Message):
  r"""A taxonomy is a collection of hierarchical policy tags that classify
  data along a common axis. For example, a "data sensitivity" taxonomy might
  contain the following policy tags: ``` + PII + Account number + Age + SSN +
  Zipcode + Financials + Revenue ``` A "data origin" taxonomy might contain
  the following policy tags: ``` + User data + Employee data + Partner data +
  Public data ```

  Enums:
    ActivatedPolicyTypesValueListEntryValuesEnum:

  Fields:
    activatedPolicyTypes: Optional. A list of policy types that are activated
      for this taxonomy. If not set, defaults to an empty list.
    description: Optional. Description of this taxonomy. If not set, defaults
      to empty. The description must contain only Unicode characters, tabs,
      newlines, carriage returns, and page breaks, and be at most 2000 bytes
      long when encoded in UTF-8.
    displayName: Required. User-defined name of this taxonomy. The name can't
      start or end with spaces, must contain only Unicode letters, numbers,
      underscores, dashes, and spaces, and be at most 200 bytes long when
      encoded in UTF-8. The taxonomy display name must be unique within an
      organization.
    name: Identifier. Resource name of this taxonomy in URL format. Note:
      Policy tag manager generates unique taxonomy IDs.
    policyTagCount: Output only. Number of policy tags in this taxonomy.
    service: Output only. Identity of the service which owns the Taxonomy.
      This field is only populated when the taxonomy is created by a Google
      Cloud service. Currently only 'DATAPLEX' is supported.
    taxonomyTimestamps: Output only. Creation and modification timestamps of
      this taxonomy.
  """

  class ActivatedPolicyTypesValueListEntryValuesEnum(_messages.Enum):
    r"""ActivatedPolicyTypesValueListEntryValuesEnum enum type.

    Values:
      POLICY_TYPE_UNSPECIFIED: Unspecified policy type.
      FINE_GRAINED_ACCESS_CONTROL: Fine-grained access control policy that
        enables access control on tagged sub-resources.
    """
    POLICY_TYPE_UNSPECIFIED = 0
    FINE_GRAINED_ACCESS_CONTROL = 1

  activatedPolicyTypes = _messages.EnumField('ActivatedPolicyTypesValueListEntryValuesEnum', 1, repeated=True)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  name = _messages.StringField(4)
  policyTagCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  service = _messages.MessageField('GoogleCloudDatacatalogV1TaxonomyService', 6)
  taxonomyTimestamps = _messages.MessageField('GoogleCloudDatacatalogV1SystemTimestamps', 7)


class GoogleCloudDatacatalogV1TaxonomyService(_messages.Message):
  r"""The source system of the Taxonomy.

  Enums:
    NameValueValuesEnum: The Google Cloud service name.

  Fields:
    identity: The service agent for the service.
    name: The Google Cloud service name.
  """

  class NameValueValuesEnum(_messages.Enum):
    r"""The Google Cloud service name.

    Values:
      MANAGING_SYSTEM_UNSPECIFIED: Default value
      MANAGING_SYSTEM_DATAPLEX: Dataplex Universal Catalog.
      MANAGING_SYSTEM_OTHER: Other
    """
    MANAGING_SYSTEM_UNSPECIFIED = 0
    MANAGING_SYSTEM_DATAPLEX = 1
    MANAGING_SYSTEM_OTHER = 2

  identity = _messages.StringField(1)
  name = _messages.EnumField('NameValueValuesEnum', 2)


class GoogleCloudDatacatalogV1UnstarEntryRequest(_messages.Message):
  r"""Request message for UnstarEntry."""


class GoogleCloudDatacatalogV1UnstarEntryResponse(_messages.Message):
  r"""Response message for UnstarEntry. Empty for now"""


class GoogleCloudDatacatalogV1UsageSignal(_messages.Message):
  r"""The set of all usage signals that Data Catalog stores. Note: Usually,
  these signals are updated daily. In rare cases, an update may fail but will
  be performed again on the next day.

  Messages:
    CommonUsageWithinTimeRangeValue: Common usage statistics over each of the
      predefined time ranges. Supported time ranges are `{"24H", "7D", "30D",
      "Lifetime"}`.
    UsageWithinTimeRangeValue: Output only. BigQuery usage statistics over
      each of the predefined time ranges. Supported time ranges are `{"24H",
      "7D", "30D"}`.

  Fields:
    commonUsageWithinTimeRange: Common usage statistics over each of the
      predefined time ranges. Supported time ranges are `{"24H", "7D", "30D",
      "Lifetime"}`.
    favoriteCount: Favorite count in the source system.
    updateTime: The end timestamp of the duration of usage statistics.
    usageWithinTimeRange: Output only. BigQuery usage statistics over each of
      the predefined time ranges. Supported time ranges are `{"24H", "7D",
      "30D"}`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class CommonUsageWithinTimeRangeValue(_messages.Message):
    r"""Common usage statistics over each of the predefined time ranges.
    Supported time ranges are `{"24H", "7D", "30D", "Lifetime"}`.

    Messages:
      AdditionalProperty: An additional property for a
        CommonUsageWithinTimeRangeValue object.

    Fields:
      additionalProperties: Additional properties of type
        CommonUsageWithinTimeRangeValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a CommonUsageWithinTimeRangeValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudDatacatalogV1CommonUsageStats attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudDatacatalogV1CommonUsageStats', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class UsageWithinTimeRangeValue(_messages.Message):
    r"""Output only. BigQuery usage statistics over each of the predefined
    time ranges. Supported time ranges are `{"24H", "7D", "30D"}`.

    Messages:
      AdditionalProperty: An additional property for a
        UsageWithinTimeRangeValue object.

    Fields:
      additionalProperties: Additional properties of type
        UsageWithinTimeRangeValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a UsageWithinTimeRangeValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudDatacatalogV1UsageStats attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudDatacatalogV1UsageStats', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  commonUsageWithinTimeRange = _messages.MessageField('CommonUsageWithinTimeRangeValue', 1)
  favoriteCount = _messages.IntegerField(2)
  updateTime = _messages.StringField(3)
  usageWithinTimeRange = _messages.MessageField('UsageWithinTimeRangeValue', 4)


class GoogleCloudDatacatalogV1UsageStats(_messages.Message):
  r"""Detailed statistics on the entry's usage. Usage statistics have the
  following limitations: - Only BigQuery tables have them. - They only include
  BigQuery query jobs. - They might be underestimated because wildcard table
  references are not yet counted. For more information, see [Querying multiple
  tables using a wildcard table]
  (https://cloud.google.com/bigquery/docs/querying-wildcard-tables)

  Fields:
    totalCancellations: The number of cancelled attempts to use the underlying
      entry.
    totalCompletions: The number of successful uses of the underlying entry.
    totalExecutionTimeForCompletionsMillis: Total time spent only on
      successful uses, in milliseconds.
    totalFailures: The number of failed attempts to use the underlying entry.
  """

  totalCancellations = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  totalCompletions = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  totalExecutionTimeForCompletionsMillis = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  totalFailures = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleCloudDatacatalogV1VertexDatasetSpec(_messages.Message):
  r"""Specification for vertex dataset resources.

  Enums:
    DataTypeValueValuesEnum: Type of the dataset.

  Fields:
    dataItemCount: The number of DataItems in this Dataset. Only apply for
      non-structured Dataset.
    dataType: Type of the dataset.
  """

  class DataTypeValueValuesEnum(_messages.Enum):
    r"""Type of the dataset.

    Values:
      DATA_TYPE_UNSPECIFIED: Should not be used.
      TABLE: Structured data dataset.
      IMAGE: Image dataset which supports ImageClassification,
        ImageObjectDetection and ImageSegmentation problems.
      TEXT: Document dataset which supports TextClassification, TextExtraction
        and TextSentiment problems.
      VIDEO: Video dataset which supports VideoClassification,
        VideoObjectTracking and VideoActionRecognition problems.
      CONVERSATION: Conversation dataset which supports conversation problems.
      TIME_SERIES: TimeSeries dataset.
      DOCUMENT: Document dataset which supports DocumentAnnotation problems.
      TEXT_TO_SPEECH: TextToSpeech dataset which supports TextToSpeech
        problems.
      TRANSLATION: Translation dataset which supports Translation problems.
      STORE_VISION: Store Vision dataset which is used for HITL integration.
      ENTERPRISE_KNOWLEDGE_GRAPH: Enterprise Knowledge Graph dataset which is
        used for HITL labeling integration.
      TEXT_PROMPT: Text prompt dataset which supports Large Language Models.
    """
    DATA_TYPE_UNSPECIFIED = 0
    TABLE = 1
    IMAGE = 2
    TEXT = 3
    VIDEO = 4
    CONVERSATION = 5
    TIME_SERIES = 6
    DOCUMENT = 7
    TEXT_TO_SPEECH = 8
    TRANSLATION = 9
    STORE_VISION = 10
    ENTERPRISE_KNOWLEDGE_GRAPH = 11
    TEXT_PROMPT = 12

  dataItemCount = _messages.IntegerField(1)
  dataType = _messages.EnumField('DataTypeValueValuesEnum', 2)


class GoogleCloudDatacatalogV1VertexModelSourceInfo(_messages.Message):
  r"""Detail description of the source information of a Vertex model.

  Enums:
    SourceTypeValueValuesEnum: Type of the model source.

  Fields:
    copy: If this Model is copy of another Model. If true then source_type
      pertains to the original.
    sourceType: Type of the model source.
  """

  class SourceTypeValueValuesEnum(_messages.Enum):
    r"""Type of the model source.

    Values:
      MODEL_SOURCE_TYPE_UNSPECIFIED: Should not be used.
      AUTOML: The Model is uploaded by automl training pipeline.
      CUSTOM: The Model is uploaded by user or custom training pipeline.
      BQML: The Model is registered and sync'ed from BigQuery ML.
      MODEL_GARDEN: The Model is saved or tuned from Model Garden.
      GENIE: The Model is saved or tuned from Genie.
      CUSTOM_TEXT_EMBEDDING: The Model is uploaded by text embedding
        finetuning pipeline.
      MARKETPLACE: The Model is saved or tuned from Marketplace.
    """
    MODEL_SOURCE_TYPE_UNSPECIFIED = 0
    AUTOML = 1
    CUSTOM = 2
    BQML = 3
    MODEL_GARDEN = 4
    GENIE = 5
    CUSTOM_TEXT_EMBEDDING = 6
    MARKETPLACE = 7

  copy = _messages.BooleanField(1)
  sourceType = _messages.EnumField('SourceTypeValueValuesEnum', 2)


class GoogleCloudDatacatalogV1VertexModelSpec(_messages.Message):
  r"""Specification for vertex model resources.

  Fields:
    containerImageUri: URI of the Docker image to be used as the custom
      container for serving predictions.
    versionAliases: User provided version aliases so that a model version can
      be referenced via alias
    versionDescription: The description of this version.
    versionId: The version ID of the model.
    vertexModelSourceInfo: Source of a Vertex model.
  """

  containerImageUri = _messages.StringField(1)
  versionAliases = _messages.StringField(2, repeated=True)
  versionDescription = _messages.StringField(3)
  versionId = _messages.StringField(4)
  vertexModelSourceInfo = _messages.MessageField('GoogleCloudDatacatalogV1VertexModelSourceInfo', 5)


class GoogleCloudDatacatalogV1ViewSpec(_messages.Message):
  r"""Table view specification.

  Fields:
    viewQuery: Output only. The query that defines the table view.
  """

  viewQuery = _messages.StringField(1)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections. For example, when attempting to list all resources
      across all supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
