subroutine sub_major(method,hdirty,hresid,hclean,   &
     &    hbeam,hprim,hmask,dcclist,dcct,mask,list,error,        &
     &    major_plot, next_flux)
  use gkernel_interfaces
  use imager_interfaces, except_this=>sub_major
  use clean_def
  use image_def
  use gbl_message
  !$ use omp_lib
  !--------------------------------------------------------------
  ! @ private-mandatory
  !*
  ! IMAGER -- Support routine for CLEAN
  !
  !     Perfom a CLEAN based on all CLEAN algorithms,
  !     except the MRC (Multi Resolution CLEAN)
  !     which requires a different tool
  !
  !     Works for mosaic also.
  !!
  !--------------------------------------------------------------
  external :: major_plot      !! Routine to plot at major cycle
  external :: next_flux       !! Routine to plot flux at minor cycle
  !
  type (clean_par), intent(inout) :: method !! Clean parameters
  type (gildas), intent(in) :: hdirty       !! Dirty cube header
  type (gildas), intent(inout) :: hbeam     !! Dirty beam header
  type (gildas), intent(inout) :: hclean    !! Clean cube header
  type (gildas), intent(inout) :: hresid    !! Residual cube header
  type (gildas), intent(in) :: hprim        !! Primary beam cube header
  type (gildas), intent(in) :: hmask        !! Clean mask header
  type(cct_lst), intent(inout), allocatable :: dcclist(:)
  !! Clean Component list
  real, intent(inout), allocatable :: dcct(:,:,:)
  !! Clean component array
  logical, intent(in), target :: mask(:,:)  !! 2-D mask
  integer, intent(in), target :: list(:)    !! Search list ? 
  logical, intent(inout) ::  error          !! Logical error flag
  !
  character(len=*), parameter :: rname='SUB_MAJOR'
  !
  ! Local ---
  character(len=64) :: mess
  integer :: ith, i, ier
  logical :: parallel
  integer :: mthread, ithread, nplane
  !
  ! Code ----
  error = .false.
  !
  ! By default, use outer parallel mode even on large images.
  ! The two-level parallelism will adapt the ressources properly.
  parallel = .false.
  !$ parallel = .true.
#ifndef GAG_USE_STATICLINK
  !$ call sic_get_inte('OMP_SIZE',ith,error)
  ! !Print *,'ith ',ith
  ! !read(5,*) ith
#endif
  !
  ! Check if more possible Threads than Planes
  mthread = 1
  ithread = 1
  !$  mthread = omp_get_max_threads()
  nplane = method%last-method%first+1
  !
  allocate(dcclist(hclean%gil%dim(3)),stat=ier)
  do i=1,hclean%gil%dim(3)
    dcclist(i)%cur_size = 0
    dcclist(i)%max_size = 0
    if (method%m_iter.ne.0) call dcclist(i)%reallocate(method%m_iter)
  enddo
  if (parallel) then
    mess = 'Using Open-MP parallel code'
  else
    mess = 'Using Open-MP capable code in Non-Parallel mode'
  endif
  !
  call map_message(seve%i,method%method,mess)
  call sub_major_omp(method,mask,list,error,        &
   &    major_plot, next_flux)
  !
  ! Here move it to the Dg array once all done...
!    Print *,'Befor LIST_TO_CCT  ',dcclist(:)%cur_size
!  call list_to_cct(hclean,dcclist,dcct)
  !
  deallocate(dcclist) ! Everything de-allocated
  !
end subroutine sub_major
!
subroutine sub_major_omp(inout_method,mask,list,error,        &
     &    major_plot, next_flux)
  use gkernel_interfaces
  use imager_interfaces, except_this=>sub_major_omp
  use clean_arrays
  use clean_def
  use clean_default
  use clean_support
  use image_def
  use gbl_message
  use gclean_mod
  !$ use omp_lib
  use omp_control
  !--------------------------------------------------------------
  ! @ private
  !*
  ! IMAGER -- Support routine for CLEAN
  !
  !     Perfom a CLEAN based on all CLEAN algorithms,
  !     except the MRC (Multi Resolution CLEAN)
  !     which requires a different tool
  !
  !     Works for mosaic also, except for the Gauss Scale clean
  !     (implemented  but insufficiently tested for this one)
  !!
  !--------------------------------------------------------------
  external :: major_plot  !! Plot routine at Major Cycles
  external :: next_flux   !! Plot routine for flux display
  !
  type (clean_par), intent(inout) :: inout_method !! User specified CLEAN parameters
  logical, intent(in), target :: mask(:,:)    !! Spatial bit mask
  integer, intent(in), target :: list(:)      !! Pixel Search list
  logical, intent(inout) ::  error            !! Logical error flag
  !
  ! Constants
  character(len=*), parameter :: rname = 'CLEAN'
  !
  ! Local ---
  real, pointer :: dirty(:,:)  ! Dirty map
  real, pointer :: resid(:,:)  ! Iterated residual
  real, pointer :: clean(:,:)  ! Clean Map
  real, pointer :: d3prim(:,:,:)    ! Primary beam (per field)
  real, pointer :: d3beam(:,:,:)    ! Dirty beam (per field)
  real, pointer :: atten(:,:) ! Mosaic weight
  !
  real, allocatable :: w_fft(:)         ! TF work area
  complex, allocatable :: w_work(:,:)   ! Work area
  type(cct_par), allocatable :: w_comp(:)
  real, allocatable :: w_cct(:,:)
  logical, allocatable :: s_mask(:,:)
  real, allocatable :: s_beam(:,:,:), t_beam(:,:), s_resi(:,:)
  real, pointer :: tfbeam(:,:,:)
  real, allocatable, target :: ftbeam(:,:,:,:)
  integer, allocatable :: mymask(:,:)
  integer :: f_iter, m_iter
  integer :: dcct_size, mplane
  !
  type (clean_par), save :: method
  real, target :: dummy_prim(1,1,1), dummy_atten(1,1)
  integer iplane, jplane
  integer nx,ny,np,nl,beam_nx,beam_ny,nc, kx,ky, icct, mcct
  integer ip, ier, ix, iy, i, jcode
  real fhat, limit, flux
  logical :: do_fft, true_dofft, err
  integer :: ntf
  character(len=message_length) :: chain
  character(len=16) :: cmethod
  character(len=48) :: cthread
  character(len=24) :: cname
  integer :: ibeam, ithread, mthread, nplane, max_thread
  integer :: fitted_beam_plane, nfits
  logical :: omp_nested
  ! Mask & List per thread
  integer :: nmask, j, idum
  logical, allocatable, target :: masks(:,:,:)
  integer, allocatable, target :: lists(:,:)
  logical, pointer :: lmask(:,:)
  integer, pointer :: llist(:)
  !
  type(cct_lst), allocatable :: the_ccts(:)
  integer, allocatable :: the_siter(:)
  integer :: the_ccts_size
  logical :: NEW_CCT
  type(cct_lst) :: cct_list
  integer :: cctsize
  integer :: nbeam
  integer :: sever
  !
  real, save :: major,minor,angle
  ! Multi Kernel 
  integer, parameter :: ms=3
  integer, parameter :: mk=11
  integer nker(ms)                   ! Kernel size
  real :: kernel(mk,mk,ms)           ! Smoothing kernels
  ! Multi Gaussian
  real :: gauss(clean_mscale)
  real :: cc_scale(clean_mscale)
  !
  ! /RESTART option
  integer :: start_cct_size          ! Initial size
  integer :: start_iter              ! Starting iteration
  real :: start_flux                 ! Starting flux
  logical :: start_cont              ! Ill name, do_restart
  character(len=12) :: amethod
  real, allocatable :: start_cct(:,:,:) ! Initial Clean List
  !
  ! FFTW plan
  integer ndim, nn(2)
  logical :: do_gauss  ! GCLEAN flag
  !
  ! Code ----
  error = .false.
  call imager_tree('SUB_MAJOR_OMP',.false.)
  !
  if (support_type.eq.support_mask) then    
    if ( hmask%gil%dim(1).ne.hdirty%gil%dim(1) .or. &
      &  hmask%gil%dim(2).ne.hdirty%gil%dim(2) ) then
      call map_message(seve%e,rname,'MASK and DIRTY do not match')
      error =.true.
      return
    endif
  endif
  !
  method = inout_method
  !
  cmethod = method%method
  new_cct = .false.
  error = .false.
  call sic_get_logi('NEW_CCT',NEW_CCT,error)
  error = .false.
  if (cmethod.eq.'SDI' .or. cmethod.eq.'MRC') then
    NEW_CCT = .false.
  else if (cmethod.eq.'GAUSS') then
    gauss = method%gsize*acos(-1.0)/180./3600.0
  endif
  !
  start_cont = method%restart.ne.0
  !
  if (start_cont) then
    if (method%mosaic) then
      call map_message(seve%w,rname,'Option /RESTART under test for Mosaics (so far)',1)
    endif
    select case(cmethod)
    case ('HOGBOM')
      cmethod = 'SIMPLE'      ! This method requires TFBEAM to get started
    case ('MRC') 
      call map_message(seve%e,rname,'Option /RESTART invalid for MRC',1)
      error = .true.
    case ('SDI') 
      call map_message(seve%w,rname,'Option /RESTART not yet validated for '//cmethod,1)
    case ('CLARK','GAUSS')
      continue
    end select
    if (error) return
    call map_message(seve%i,rname,'Restarting with method '//cmethod,3)
  endif
  do_fft = (cmethod.ne.'HOGBOM')
  !
  ! Local variables
  nx = hclean%gil%dim(1)
  ny = hclean%gil%dim(2)
  beam_nx = hbeam%gil%dim(1)
  beam_ny = hbeam%gil%dim(2)
  nl = method%nlist
  nc = nx*ny
  np = max(1,hprim%gil%dim(1))
  !
  if (do_fft) then
    ! TFBEAM cannot be alocate here because it must be PRIVATE in parallel sections
    if (method%method.eq.'MULTI') then
      kx = nx
      ky = ny
      ntf = 1
      allocate(w_work(kx,ky),w_fft(2*max(kx,ky)),stat=ier)
    else
      kx = nx
      ky = ny
      ntf = np
      write(chain,'(A,A,I0,1X,I0)') 'Method '//method%method//', Allocating ',kx,ky
      call map_message(seve%d,rname,chain)
      allocate(w_work(kx,ky),w_fft(2*max(kx,ky)),stat=ier)
    endif
    if (ier.ne.0) then
      call map_message(seve%e,rname,'Memory allocation error for TFBEAM')
      error = .true.
      return
    endif
    ! Set the FFT plan for speed 
    ndim = 2
    nn(1) = nx
    nn(2) = ny
!    call fourt_plan(w_work,nn,ndim,-1,1) !TEST
!    call fourt_plan(w_work,nn,ndim,+1,1) !TEST
    !
  else
    ! W_FFT is used for Mosaics in Get_Beam (not sure, though)
    allocate(w_work(1,1),w_fft(2*max(nx,ny)),tfbeam(1,1,1),stat=ier)  
    if (ier.ne.0) then
      call map_message(seve%e,rname,'FFT Memory allocation failure')
      error = .true.
      return
    endif
  endif
  !
  ier = 0
  select case (cmethod)
  case ('CLARK')
    allocate(w_comp(nc),w_cct(1,1),mymask(1,1), &
    & s_mask(1,1),s_resi(1,1),t_beam(1,1), &
    & s_beam(1,1,3),stat=ier)
    !
    ! Inner Parallelism is only Per-Field (and not yet coded)
    max_thread = np
  case ('SDI')
    allocate(w_comp(nc),w_cct(nx,ny),mymask(nx,ny), &
    & s_mask(1,1),s_resi(1,1),t_beam(1,1), &
    & s_beam(1,1,3),stat=ier)
    max_thread = np
  case ('MULTI')
    allocate (w_comp(1),w_cct(nx,ny),mymask(nx,ny), &
      & s_mask(nx,ny),s_resi(nx,ny),t_beam(nx,ny), &
      & s_beam(beam_nx,beam_ny,3),stat=ier)
    max_thread = max(np,32)
  case ('GAUSS')
    allocate (w_comp(1),w_cct(nx,ny),mymask(nx,ny), &
      & s_mask(nx,ny),s_resi(nx,ny),t_beam(nx,ny), &
      & s_beam(beam_nx,beam_ny,3),stat=ier)
    max_thread = max(np,32)
  case default
    allocate(w_comp(1), w_cct(1,1),mymask(1,1), &
    & s_mask(1,1),s_resi(1,1),t_beam(1,1), &
    & s_beam(1,1,3),stat=ier)
    max_thread = 1
    if (cmethod.eq.'HOGBOM'.or.cmethod.eq.'SIMPLE') then
      max_thread = max(16*nx*ny/1024/1024,np)
    endif
  end select
  if (ier.ne.0) then
    call map_message(seve%e,rname,'Work Arrays Memory allocation failure')
    error = .true.
    return
  endif
  call sic_get_inte('OMP_MAP%INNER',max_thread,error)
  error = .false.
  !
  !
  mthread = 1
  ithread = 1
  ! Define the optimum number of inner threads according to
  !	1) Method  and 2) Images size
  nplane = method%last-method%first+1
  call ompset_thread_nesting(rname,nplane, max_thread, omp_nested)
  mthread = ompget_outer_threads()  !... For the MASKS !...
  !
  ! Global aliases: SHARED here
  if (support_type.eq.support_mask) then    
    !
    ! Allocate the Masks and List per-thread
    nmask = min(hmask%gil%dim(3),nplane,mthread)
    if (nmask.gt.1) then
      ! If not degenerate, allocate enough to handle any case.
      nmask = max(hmask%gil%dim(3),min(nplane,mthread))
      allocate(masks(nx,ny,nmask),lists(nx*ny,nmask),stat=ier)
      if (ier.ne.0) then
        call map_message(seve%e,rname,'Mask & List memory allocation error')
        return
      else
        call map_message(seve%i,rname,'Mask & List allocation success')
      endif
    endif
  else
    !
    ! Keep the global association
    nmask = 0
  endif
  !
  cname = method%method
  if (method%mosaic) then
    write(chain,'(A,1pg10.3,A,1pg10.3,A,1pg10.3)') &
        &   'Thresholds: Search ',method%search,'; Restore ', &
        &   method%restor,'; Primary beam ',method%trunca
    call map_message(seve%i,rname,chain)
  endif
  ! 
  !$ if (omp_debug)  Print *,'Number of planes ',nplane
  !
  ! We need some CLEAN beam parameters already at this stage
  !$ if (omp_debug) Print *,'Getting SOME beam parameters '
  iplane = method%first
  ibeam = beam_for_channel(iplane,hdirty,hbeam)
  !
  if (method%mosaic) then
    if (hbeam%gil%faxi.eq.3) then
      allocate(d3beam(hbeam%gil%dim(1),hbeam%gil%dim(2),hbeam%gil%dim(4)))
      call map_message(seve%d,rname,'3D - Copy of 4D beam')
      d3beam = hbeam%r4d(:,:,ibeam,:)     ! Contiguous copy
    else
      call map_message(seve%d,rname,'3D - Pointer to 4D Beam')
      d3beam => hbeam%r4d(:,:,:,ibeam)    ! Contiguous pointer
    endif
  else
    d3beam => hbeam%r4d(:,:,ibeam,1:1)
  endif
  !
  ! Beam fit
  fitted_beam_plane = 0   ! Set the Clean Beam as unknown
  nfits = 0
  major = 0.
  minor = 0.
  angle = 0.
  !
  start_cct_size = 0
  dcct_size = size(dcct,3)
  cctsize = size(dcct,1)
  mplane = size(dcct,2) ! Actual number of planes in CCT
  !
  call gclean_init      ! For GAUSS method
  do_gauss = cmethod.eq.'GAUSS'
  !
  ! Prepare the TFBEAM array as needed
  if (do_fft) then
    if (start_cont) then
      amethod = method%method
      method%method = 'SIMPLE' ! For test
      allocate(start_cct(hcct%gil%dim(1),hcct%gil%dim(2),hcct%gil%dim(3)),stat=ier)
      if (ier.ne.0) then
        call map_message(seve%e,rname,'Initial Clean Component List memory allocation error')
        error = .true.
        return
      endif
      start_cct = dcct
      start_cct_size = dcct_size
    endif
    !
    nbeam = hbeam%gil%dim(hbeam%gil%faxi)
    allocate(ftbeam(beam_nx,beam_ny,np,nbeam),stat=ier)
    if (ier.ne.0) then
      call map_message(seve%e,rname,'FTBEAM memory allocation error')
      error = .true.
      return
    endif
    !
    !$OMP PARALLEL IF (nbeam.gt.1) DEFAULT(none) NUM_THREADS(omp_outer_thread) &
    !$OMP & SHARED(nbeam, nmask, mthread, error) &
    !$OMP & SHARED(method,hbeam,hresid,hprim,ftbeam, masks, mask) &
    !$OMP & PRIVATE(w_work,w_fft,fhat,err,ibeam, ithread, lmask)
    ! Get the new mask
    ithread = 1
    !$ ithread = omp_get_thread_num()+1
    if (nmask.gt.1) then
      if (ithread.gt.mthread) then
        Print *,'Big problem ITHREAD ',ithread,' > ',mthread,' NTHREAD'
      endif
      lmask => masks(:,:,ithread)
    else
      lmask => mask
    endif
    !$OMP DO
    do ibeam=1,nbeam
      err = .false.
      call get_beam (ibeam,method%verbose,method,hbeam,hresid,hprim,.true.,   &
        &        ftbeam(:,:,:,ibeam),w_work,w_fft,fhat,err, lmask)
      if (err) error = .true.
    enddo
    !$OMP END DO
    !$OMP END PARALLEL
    if (start_cont) method%method = amethod
    if (error) return
  endif
  !
  ! Initialize the CCT List
  if (NEW_CCT) then
    allocate(the_ccts(nplane),the_siter(nplane),stat=ier)
    do i=1,nplane
      call the_ccts(i)%initialize()
    enddo
    the_ccts_size = 0
  endif
  !
  ! Loop here if needed
  !$OMP PARALLEL IF (nplane.gt.1) DEFAULT(none) NUM_THREADS(omp_outer_thread) & 
  !$OMP & SHARED(hdirty,hclean,hbeam,hprim,hresid,hmask) &         ! Headers
  !$OMP & SHARED(dummy_prim,dummy_atten) &                         ! Big arrays
  !$OMP & SHARED(fhat, nx,ny,beam_nx,beam_ny,np,nc, mcct,omp_debug) &
  !$OMP & SHARED(do_gauss, n_scales) & 
  !$OMP & SHARED(inout_method, gauss, cctsize) &                   ! A modified structure
  !$OMP & SHARED(major,minor,angle,cmethod, fitted_beam_plane, nfits) &
  !$OMP & SHARED(nmask,masks,lists,mask,list, mthread, dcclist, dcct, dcct_size, mplane) &
  !$OMP & SHARED(ftbeam, do_fft, ntf, start_cct, start_cct_size) & ! Beam TF
  !$OMP & PRIVATE(method, ier, true_dofft)                &                    ! A modified structure
  !$OMP & PRIVATE(iplane, ibeam, jplane, sever, error, nl, chain, cthread, cname) &
  !$OMP & PRIVATE(tfbeam,w_work,w_fft,w_comp,w_cct,cct_list)   &   ! Arrays
  !$OMP & PRIVATE(flux,f_iter,m_iter,limit,ithread,jcode,icct) &
  !$OMP & PRIVATE(ix,iy,i,j) &  ! These were NOT diagnosed by the DEFAULT(none)
  !$OMP & PRIVATE(d3beam,d3prim,idum) &
  !$OMP & PRIVATE(nker,kernel)         &               ! These could be computed once only ?
  !$OMP & PRIVATE(mymask,s_mask,s_beam,s_resi,t_beam)  &           ! Arrays
  !$OMP & SHARED(start_cont) PRIVATE(start_iter, start_flux, cc_scale) & 
  !$OMP & PRIVATE(dirty,resid,clean) PRIVATE(atten,llist,lmask)  & ! Pointers
  !$OMP & SHARED(the_ccts,new_cct,the_siter) REDUCTION(max:the_ccts_size)  ! Global structure of CCTs
  !
  !$ if (omp_debug)  Print *,'Number of threads ',omp_get_num_threads()
  !
  ! Re-Define the method (in parallel mode, private entities are uninitialized)
  !   Method comes first
  method = inout_method ! And NOT  call copy_method(inout_method, method)
  if (method%m_iter.eq.0) method%m_iter = 2**30 ! Almost infinity
  !
  ! Then its Global aliases, which are PRIVATE inside
  if (.not.inout_method%mosaic) then
    atten => dummy_atten
  endif
  if (nmask.gt.1) then
    method%imask = 0 ! Mask is undefined at beginning if more than 1 plane
  endif
  !
  ithread = 1
  !$ ithread = omp_get_thread_num()+1
  !
  ! Loop on planes
  !$OMP DO SCHEDULE(STATIC,1) 
  do iplane = inout_method%first, inout_method%last
    nullify(tfbeam) ! In all cases
    !
    method%iplane = iplane
    !
    call get_stopping(method%m_iter,method%ares,iplane)
    !$ write(cthread,'(A,I0)') ', Thread ',ithread
    !$ write(cname,'(A,A,I0,A)') trim(cmethod),'(',iplane,')' 
    !
    !$ if (omp_debug) then
      !$OMP CRITICAL (DEBUG)
      !$ Print *,'Calling beam_plane '//cthread
      !$ call mapping_print_debug(method)
      !$ Print *,'Done beam_plane '//cthread
      !$OMP END CRITICAL (DEBUG)
    !$ endif
    !
    !THAT WAS CRASHING ! call beam_plane(method,hbeam,hdirty)
    ibeam = beam_for_channel(iplane,hdirty,hbeam)
    method%ibeam = ibeam
    !
    ! Get the new mask
    if (nmask.gt.1) then
      if (ithread.gt.mthread) then
        Print *,'Big problem ITHREAD ',ithread,' > ',mthread,' NTHREAD'
      endif
      lmask => masks(:,:,ithread)
      llist => lists(:,ithread)
    else
      lmask => mask
      llist => list
    endif
    !$ if (omp_debug) Print *,'Calling get_maskplane - OMP'
    call get_maskplane(method,hmask,hdirty,lmask,llist)    
    nl = method%nlist
    !$ if (omp_debug) Print *,'Thread ',ithread,' NL ',nl,' Mask plane ',method%imask
    !
    ! Local aliases
    if (method%imask.ge.1) then
      write(chain,'(A,A,I0,A,I0,A,I0,A,I0)') 'Planes: ', &
          & '  Image ',method%iplane, & 
          & ', - Beam ', method%ibeam, & 
          & ', - Mask ', method%imask,', Selected pixels ',nl
    else
      write(chain,'(A,A,I0,A,I0,A,I0)') 'Planes: ', & 
          & '  Image ',method%iplane, & 
          & ', - Beam ', method%ibeam
    endif
    !$ chain = trim(chain)//cthread
    call map_message(seve%d,cname,chain)
    if ((method%imask.ge.1).and.(nl.eq.0)) then
      call map_message(seve%d,cname,'No valid pixels in current mask',3)
    endif
    !
    ! Local aliases
    dirty => hdirty%r3d(:,:,iplane)
    resid => hresid%r3d(:,:,iplane)
    clean => hclean%r3d(:,:,iplane)
    !
    ! Initialize to Dirty map
    resid = dirty
    !$ if (omp_debug) Print *,'BEAM shape ',ubound(hbeam%r4d)
    !
    if (method%mosaic) then
      if (hbeam%gil%faxi.eq.3) then
        write(chain,'(A,4(1x,I0))') 'FAXI = 3 Copy array ',hbeam%gil%dim(1:4)
        d3beam  = hbeam%r4d(:,:,ibeam,:)    ! Contiguous copy
      else
        write(chain,'(A,4(1x,I0))') 'FAXI # 3 Pointer to array ',hbeam%gil%dim(1:4)
        d3beam => hbeam%r4d(:,:,:,ibeam)    ! Contiguous pointer
      endif
      d3prim => hprim%r4d(:,:,:,ibeam)
      call map_message(seve%d,rname,chain)
    else
      d3beam  => hbeam%r4d(:,:,ibeam,1:1)  ! Contiguous pointer
      d3prim => dummy_prim
    endif
    !
    if (method%pcycle) call init_plot (method,hdirty,resid)
    !
    ! Prepare beam parameters - subroutine is not Thread safe though...
    !$OMP CRITICAL (BEAM)
    !$ if (omp_debug) Print *,'Critical get_clean '//cthread
    error = .false.
    if (fitted_beam_plane.ne.method%ibeam) then
      method%major = inout_method%major
      method%minor = inout_method%minor
      method%angle = inout_method%angle
      call get_clean (method, hbeam, d3beam, error)
      if (.not.error) then
        if (do_gauss) then
          write(chain,'(A,I0,A,I0,A)') 'Beam plane change (',fitted_beam_plane,' --> ',method%ibeam, &
            & ') Reset Smoothed beams'
          call map_message(seve%i,cname,chain,3)
          call gclean_beams(cname,hdirty,nx,ny,np,method%nscale,gauss,d3beam,error) !TEST GAUSS
        endif
        ! Average beam characteristics - Better than nothing, but clearly
        ! not fully realistic when beam differs. However, this only
        ! happens under User Choice.
        fitted_beam_plane = method%ibeam
        major = major + method%major
        minor = minor + method%minor
        angle = angle + method%angle
        nfits = nfits+1
      endif
      !$OMP FLUSH
    else if (nfits.ne.0) then
      method%major = major/nfits
      method%minor = minor/nfits
      method%angle = angle/nfits
      ! !Print *,'Method Beam ',method%major,method%minor,method%angle,nfits
    else
      write(chain,'(A,I0,A,I0)') 'No Clean Beam for channel ', &
        & method%iplane,' beam plane ',method%ibeam
      call map_message(seve%w,cname,chain)
    endif
    !
    ! !Print *,'N_SCALES ',n_scales,' Thread ',ithread
    !
    !$ if (omp_debug) Print *,'end Critical get_clean '//cthread
    !$OMP END CRITICAL (BEAM)
    if (error) then
      !return !Oops, cannot do that in a DO parallel...
      cycle
    endif
    !$ if (omp_debug) Print *,'start get_beam '//cthread
    method%method = cmethod ! Needed to have SIMPLE instead of HOGBOM in case of START
    !
    ibeam = method%ibeam
    call get_beam (ibeam,method%verbose, &
    &   method,hbeam,hresid,hprim,.false.,   &
    &   tfbeam,w_work,w_fft,fhat,error, lmask)
    !
    if (do_fft) tfbeam => ftbeam(:,:,:,ibeam)
    !
    !$ if (omp_debug) Print *,'end get_beam '//cthread
    ! Empty beam case
    if (error) then
      error = .false.
      clean = resid
      !return !Oops, cannot do that in a DO parallel...
      cycle
    endif
    !
    ! Mosaic case
    if (method%mosaic) then
      !$ if (omp_debug) Print *,'Setting weight for ',method%ibeam
      ! Reset search list as the mask may have been altered
      call lmask_to_list (lmask,nx*ny,llist,method%nlist)
      nl = method%nlist
      atten => method%atten(:,:,method%ibeam)
      !$ if (omp_debug) Print *,'Done weight for ',method%ibeam
      resid = resid * atten
    endif
    !
    ! Remove starting model
    if (start_cont) then
      !
      ! Remove the Continuum or Line CCT before Cleaning
      call cct_list%initialize(max(2*start_cct_size,500))                     
      call cct_remove_start(hdirty,iplane,resid,tfbeam,start_cct,cct_list%cc, &    
        & np,d3prim,atten,method%trunca,start_iter,start_flux)                
      write(chain,'(A,I0,A,1PG10.3,A)') 'Restarting from iteration ', &
        & start_iter,', Flux ',start_flux,' Jy'
      call map_message(seve%d,cname,chain)
    else
      call cct_list%initialize(500) ! Start from Scratch
      start_iter = 1
      start_flux = 0.
    endif
    !
    ! Performs decomposition into components only
    ! if NL # 0 
    if (nl.ne.0) then
      !$ if (omp_debug) Print *,'Select case '//cmethod//cthread
      select case (cmethod)
      case('HOGBOM','SIMPLE')
        flux = 0.
        call map_message(seve%t,'HOGBOM','Entering '//cthread)
        call hogbom_cycle (cname,& 
          &  method%pflux,   &   ! Plot flux
          &  d3beam,beam_nx,beam_ny,   &   ! Beam and size
          &  resid,nx,ny,    &   ! Residual and size
          &  method%beam0(1),method%beam0(2),   & ! Beam center
          &  method%box, method%fres, method%ares,   &
          &  method%m_iter, method%p_iter, method%n_iter,   &
          &  method%gain, method%converge,   &    !
          &  cct_list,       &   ! Component Structure
          &  start_iter,     &   ! Starting iteration
          &  lmask,          &   ! Search mask
          &  llist,          &   ! Search list
          &  nl,             &   ! and its size
          &  np,             &   ! Number of fields
          &  d3prim,         &   ! Primary beams
          &  atten,          &   ! Weight
          &  method%trunca, flux, jcode, next_flux)
        call map_message(seve%t,'HOGBOM','EXITing '//cthread)
      case('CLARK')
        !
        ! Find components
        method%n_iter = start_iter-1 ! In principle
        call major_clark (cname,method,hclean,   &   !
          &  d3beam,         &   ! Dirty beams
          &  beam_nx,beam_ny, &
          &  nx,ny,          &   ! image sizes
          &  clean,          &   ! Final CLEAN image
          &  resid,          &   ! Residual
          &  tfbeam, w_work, &   ! FT of dirty beam + Work area
          &  w_comp, nc,     &   ! Component storage + Size
          &  method%beam0(1),method%beam0(2),   & ! Beam center
          &  method%patch(1), method%patch(2), method%bgain,   &
          &  method%box,     &
          &  w_fft,          &   ! Work space for FFTs
          &  cct_list,       &   ! Component Structure
          &  llist, nl,      &   ! Search list (truncated...)
          &  np,             &   ! Number of fields
          &  d3prim,         &   ! Primary beams
          &  atten,          &   ! Weight
          &  major_plot,     &   ! Plotting routine
          &  next_flux)
      case('SDI')
        !
        ! Find components
        method%n_iter = start_iter-1 ! In principle
        call major_sdi (cname,method,hclean,   &
          &  clean,          &   ! Final CLEAN image
          &  d3beam,         &   ! Dirty beams
          &  resid,nx,ny,    &   ! Residual and size
          &  tfbeam, w_work, &   ! FT of dirty beam + Work area
          &  w_comp, nc,     &   ! Component storage + Size
          &  method%beam0(1),method%beam0(2),   & ! Beam center
          &  method%patch(1), method%patch(2), method%bgain,   &
          &  method%box,     &
          &  w_fft,          &   ! Work space for FFTs
          &  w_cct,          &   ! Clean Component Image
          &  llist, nl,      &   ! Search list (truncated...)
          &  np,             &   ! Number of fields
          &  d3prim,         &   ! Primary beams
          &  atten,          &   ! Weight
          &  major_plot)         ! Plotting routine
      case('MULTI')
        !
        ! Performs decomposition into components
        call amaxmask (resid,lmask,nx,ny,ix,iy)
        limit = max(method%ares,method%fres*abs(resid(ix,iy)))
        if (limit.eq.method%ares) then
          write (chain,'(A,1PG10.3,A)')  'Cleaning down to ',limit,' from ARES'
        else
          write (chain,'(A,1PG10.3,A,I0,A,I0,A)')  'Cleaning down to ',limit,' from FRES at (',ix,',',iy,')'
        endif
        call map_message(seve%i,cname,chain)
        !
        clean = 0. ! Just in case
        call major_multi90 (cname,method,hclean,   &
          &  d3beam,         &   ! hbeam%r4d(:,:,:,method%ibeam),                  &
          &  beam_nx,beam_ny, &  ! Dirty Beam size
          &  nx,ny,          &   ! Image sizes
          &  dirty,          &   ! hdirty%r3d(:,:,iplane),   &
          &  resid,          &   ! hresid%r3d(:,:,iplane),   &
          &  lmask,          &   ! Check definition of this mask...
          &  clean,          &   ! hclean%r3d(:,:,iplane),   &
          &  cct_list,       &   ! Clean Component List
          &  start_iter,     &   ! Starting iteration
          &  method%m_iter,  &   ! Maximum number of components
          &  limit,          &   ! Residual
          &  method%n_iter,  &   ! Number of components
          &  s_mask,         &   ! Smoothed mask
          &  s_resi,         &   ! Smoothed residual,
          &  t_beam,         &   ! Translated beam
          &  w_work,         &   ! Complex work space
          &  s_beam,         &   ! Smoothed beams
          &  tfbeam,         &   ! Beam Fourier Transform (real)
          &  w_fft, icct,    & 
          &  nker, kernel,   &   ! Kernel sizes & values
          &  np,             &   ! Number of fields
          &  d3prim,         &   ! Primary beams
          &  atten)              ! Weight
          !
          w_cct(:,:) = clean
      case('GAUSS')
        !
        ! Performs decomposition into Gaussian components
        call amaxmask (resid,lmask,nx,ny,ix,iy)
        limit = max(method%ares,method%fres*abs(resid(ix,iy)))
        if (limit.eq.method%ares) then
          write (chain,'(A,1PG10.3,A)')  'Cleaning down to ',limit,' from ARES'
        else
          write (chain,'(A,1PG10.3,A,I0,A,I0,A)')  'Cleaning down to ',limit,' from FRES at (',ix,',',iy,')'
        endif
        call map_message(seve%i,cname,chain)
        !
        clean = 0. ! Just in case
        method%n_iter = start_iter-1 ! In principle
        !
        call gclean_major (cname,method,hclean,   &
          &  d3beam,         &   ! hbeam%r4d(:,:,:,method%ibeam),                  &
          &  beam_nx,beam_ny, &  ! Dirty Beam size
          &  nx,ny,          &   ! Image sizes
          &  dirty,          &   ! hdirty%r3d(:,:,iplane),   &
          &  resid,          &   ! hresid%r3d(:,:,iplane),   &
          &  lmask,          &   ! Check definition of this mask...
          &  clean,          &   ! hclean%r3d(:,:,iplane),   &
          &  cct_list,       &   ! Clean Component List
          &  start_iter,     &   ! Starting iteration
          &  method%m_iter,  &   ! Maximum number of components
          &  limit,          &   ! Residual
          &  method%n_iter,  &   ! Number of components
          &  method%nscale,  &   ! Number of Gaussians    ! up to M_GAUSS
          &  gauss,          &   ! Gaussian values in radians
          &  cc_scale,       &
          &  tfbeam,         &   ! Beam Fourier Transform (real)
          &  w_fft,          &   ! Work space
          &  np,             &   ! Number of fields
          &  d3prim,         &   ! Primary beams
          &  atten, ithread, iplane)              ! Weight
          !
      end select
      !$ if (omp_debug) Print *,'End Select case '//cmethod//cthread
    else
      ! Empty search area: No new Clean components...
      if (start_cont) then
        method%n_iter = start_iter-1
        flux = start_flux
      else
        method%n_iter = 0
        flux = 0.0
      endif
    endif
    !          dcclist%cc(1:dcclist%cur_size) = tmp
    ! method%n_iter = method%n_iter + start_iter - 1  ! Not for HOGBOM
    !
    ! Update the Clean image
    ! !call map_message(seve%t,'UPDATE_CLEAN','Entering '//cthread)
    if (cmethod.ne.'GAUSS') call update_clean(method,hclean,cct_list%cc,np,clean,resid,atten)
    !$ if (omp_debug) Print *,'Finishing '//cthread
    ! !call map_message(seve%t,'UPDATE_CLEAN','Exiting '//cthread)
    !
    ! Put the CC structure into its final place
    ier = 0
    if (NEW_CCT) then
      jplane = iplane-inout_method%first+1
      call the_ccts(jplane)%reallocate(cct_list%cur_size)
      the_siter(jplane) = start_iter
      the_ccts(jplane) = cct_list
      the_ccts_size = max(the_ccts_size,cct_list%cur_size)
      !
    else
      !     Step 1) cannot be done if any other parallel thread is running (at Step 2)
      !     Step 2) can be done in parallel, unless Step 1) is running
      !       so must use a Critical SECTION for Both !...
      !$OMP CRITICAL (CCT_EXTEND)
      ! 1) Check size of DCCT, and reallocate it if needed.
      call map_message(seve%t,'MOVE_TO_DCCT','Checking '//cthread)
      if (cct_list%cur_size.gt.dcct_size) then
        write(chain,'(A,I0)') 'Extending DCCT to ',cct_list%cur_size
        call map_message(seve%d,cname,chain)
        dcct_size = cct_list%cur_size
        error = .true.
        call reallocate_cct(cctsize,mplane,dcct_size,dcct,error)
      endif
      ! 2) Copy to DCCT
      call map_message(seve%t,'MOVE_TO_DCCT','Entering '//cthread)
      icct = method%n_iter
      call move_to_dcct(cmethod,start_iter,iplane,icct,mcct,  &
        & w_cct, cct_list%cc, hclean, dcct, chain, sever, ithread)
      call map_message(seve%t,'MOVE_TO_DCCT','Exiting '//cthread)
      !$OMP END CRITICAL (CCT_EXTEND)
      call map_message(sever,cname,chain)
    ENDIF
    !$ if (omp_debug) Print *,'End loop '//cthread
  enddo
  !$OMP END DO
  !
  !$OMP END PARALLEL
  !
  if (NEW_CCT) then
    ! Move the CCT list to the DCCT array for all channels
    dcct_size = the_ccts_size
    error = .true.
    call reallocate_cct(cctsize,mplane,dcct_size,dcct,error)
    do iplane=method%first,method%last
      jplane = iplane-inout_method%first+1
      icct = the_ccts(jplane)%cur_size
      start_iter = the_siter(jplane)
      call move_to_dcct(cmethod,start_iter,iplane,icct,mcct,  &    ! START_ITER is plane dependent
        & w_cct, the_ccts(jplane)%cc, hclean, dcct, chain, sever, 0)  ! W_CCT is undefined here
      call map_message(sever,cname,chain)   ! Printout message 
    enddo
  ENDIF
  !
  if (nfits.ne.0) then
    inout_method%major = major/nfits
    inout_method%minor = minor/nfits
    inout_method%angle = angle/nfits
  else
    call map_message(seve%e,cname,'No valid Clean beam in data')
  endif
  !$  call omp_set_nested(omp_nested)
  !$  if (nplane.lt.mthread) call omp_set_num_threads(mthread)
  !
  if (allocated(masks)) then
    deallocate(masks,lists)
  endif
  !
  ! PHAT
  ! !Print *,'sub_major PHAT ',method%phat
  ! This logic is only valid for One beam for all...
  if (method%phat.ne.0) then
    fhat = 1.0/fhat
    if (method%mosaic) then
      d3beam = d3beam*fhat
      do ip=1,np
        d3beam(method%beam0(1),method%beam0(2),ip) =   &
          &  d3beam(method%beam0(1),method%beam0(2),ip) -   &
          &  method%phat
      enddo
    else
      d3beam = d3beam*fhat
    endif
  endif
  !
  ! Set the blanking value for Mosaics
  if (method%mosaic) then
    hclean%gil%eval = 0
  endif
  !
  ! Clean work space: in principle, Fortran 95 does it for you
  deallocate(w_comp,w_cct,mymask, &
    &  s_mask,s_resi,t_beam,s_beam, &
    &  w_work,w_fft, stat=ier)
    !
  call imager_tree('SUB_MAJOR_OMP',.true.)
end subroutine sub_major_omp
!
!
subroutine get_beam(ibeam,verbose,method,hbeam,hresid,hprim,  &
     &    do_fft,tfbeam,w_work,w_fft,fhat,error, mask)
  use gkernel_interfaces
  use imager_interfaces, except_this => get_beam
  use clean_def
  use image_def
  use gbl_message
  !-----------------------------------------------------------------
  ! @ private-mandatory
  !*
  ! IMAGER -- Support for CLEAN
  !
  !    Get beam related information: Min - Max and Fourier Transform
  !!
  !-----------------------------------------------------------------
  integer, intent(in) :: ibeam              !! Beam plane
  logical, intent(in) :: verbose            !! Printout level
  type (clean_par), intent(inout) :: method !! Clean method
  type (gildas), intent(in)  :: hbeam       !! Dirty beam (x,y,v,p) or (x,y,p,v)
  type (gildas), intent(in)  :: hresid      !! Residual (unused here, kept for consistency)
  type (gildas), intent(in)  :: hprim       !! Primary beam  (p,x,y,v)
  logical, intent(in) :: do_fft             !! Need the FFT ?
  real, intent(inout) :: tfbeam(:,:,:)      !! Per Pointing beam TF
  complex, intent(inout) :: w_work(:,:)     !! FFT workspace
  real, intent(inout) :: fhat               !! Prussian hat factor
  real, intent(inout) :: w_fft(:)           !! FFT workspace
  logical, intent(inout) :: error           !! Logical error flag
  logical, optional, intent(inout) :: mask(:,:)  !! Search Mask array
  !
  character(len=*), parameter :: rname = 'CLEAN'
  ! 
  ! Local ---
  integer nx,ny,mx,my
  integer ifreq,nfreq, ifield,nfield
  real beam_min,beam_max,beam_area,f
  integer ix_min,ix_max,iy_min,iy_max,jx_max,jy_max
  character(len=message_length) :: chain
  real, pointer :: d2beam(:,:)      ! Beam (per single field & frequency)
  real, pointer :: d3prim(:,:,:)    ! Primary beams (p,x,y) (for one frequency)
  real, pointer :: d3beam(:,:,:)    ! Dirty beam (x,y,p) (for one frequency)
  real, pointer :: atten(:,:,:)     ! Global Sky Attenuation (x,y,v)
  real, allocatable :: i2beam(:,:)  ! Intermediate beam if no size matching
  integer :: ier, nn(3), bzone(4)   ! For the Beam itself...
  logical :: err
  !
  ! Code ---
  call map_message(seve%t,'GET_BEAM',' entering..')
  !
  nx = hbeam%gil%dim(1)
  ny = hbeam%gil%dim(2)
  !
  mx = hresid%gil%dim(1)
  my = hresid%gil%dim(2)
  !
  ! HBeam may have two different shapes
  if (hbeam%gil%faxi.eq.3) then
    nfreq = hbeam%gil%dim(3)
    nfield = max(1,hbeam%gil%dim(4))
  else
    nfreq = hbeam%gil%dim(4)
    nfield = max(1,hbeam%gil%dim(3))
  endif
  !
  if (do_fft) then
    if (method%method.ne.'MULTI') then
      nn = [mx,my,nfield]   ! Number of Primary Beams, not Frequency Slices.
    else
      nn = [mx,my,1]        ! The Multi Scale clean is different
    endif
    err = .false.
    call v_size_r4_3('TFBEAM',tfbeam,nn,err)
    if (err) then
      Print *,'Size error on TFBEAM'
      read(5,*) ifreq
    endif
  endif
  !
  atten => method%atten
  !
  f = 1.0   ! No Prussian Hat
  !
  if (method%mosaic) then
    nn = [mx,my,nfreq]
    call v_size_r4_3('ATTEN',method%atten,nn,err)
    !
    if (verbose)  Print *,'Testing MOSAIC case ',hbeam%gil%dim(1:hbeam%gil%ndim),' Method ',method%method
    if (.not.present(mask)) then
      call map_message(seve%f,rname,'Programming error: Missing MASK argument with MOSAIC mode',1)
      error = .true.
      return
    endif
    !
    ! At this stage, the Beam may have beam re-shaped to 3 dimensions
    if (hbeam%gil%faxi.eq.3) then
      call map_message(seve%d,rname,'3D - Copy of 4D beam')
      allocate(d3beam(hbeam%gil%dim(1),hbeam%gil%dim(2),hbeam%gil%dim(4)),stat=ier)
      if (ier.ne.0) then
        call map_message(seve%e,rname,'BEAM memory allocation error',2)
        error = .true.
        return
      endif
      !
      ! Copy the relevant beams at the appropriate frequency
      d3beam = hbeam%r4d(:,:,ibeam,:)   ! and not (:,:,:,method%ibeam)
    else
      ! Point to the relevant beams at the appropriate frequency
      call map_message(seve%d,rname,'3D - Pointer to 4D beam')
      d3beam => hbeam%r4d(:,:,:,ibeam)
    endif
    !
    nfield = hprim%gil%dim(1)
    !
    ! Analyze beam
    allocate(i2beam(mx,my),stat=ier)
    if (ier.ne.0) then
      call map_message(seve%e,rname,'BEAM memory allocation error',2)
      error = .true.
      return
    endif
    bzone = [1,1,nx,ny]
    do ifield = 1,nfield
      if (verbose) then
        write(chain,'(A,I0,A,2(1X,I0),A,4(1X,I0))') 'Field ',ifield,' NX,NY',nx,ny,' Zone ',bzone
        call map_message(seve%d,rname,chain)
      endif
      call maxmap(d3beam(:,:,ifield),nx,ny,bzone,   &
           &        beam_max,ix_max,iy_max,beam_min,ix_min,iy_min)
      if (verbose) then
        write(chain,'(A,I4,A,F5.3,A,I6,I6,A,1PG10.3,A,I6,I6)') &
          & 'Field ',ifield, &
          &   ' Beam max. ',beam_max,' at ',ix_max,iy_max,  &
          &   ', Min. ',beam_min,' at ',ix_min,iy_min
        call map_message(seve%i,rname,chain)
      endif
      !
      if (do_fft) then
        ! Plunge in appropriate size Beam if needed
        ! and then compute its TF into TFbeam - ZZZZ
        if (nx.eq.mx .and. ny.eq.my) then
          call init_convolve (ix_max,iy_max,nx,ny,   &
            &          d3beam(:,:,ifield),w_work,beam_area,w_fft)
        else
          call plunge_r4(d3beam(:,:,ifield),nx,ny,i2beam,mx,my)
          jx_max = ix_max+(mx-nx)/2
          jy_max = iy_max+(my-ny)/2
          call init_convolve (jx_max,jy_max,mx,my,   &
               &        i2beam,w_work,beam_area,w_fft)
        endif
        tfbeam(:,:,ifield) = real(w_work)
        if (verbose) then
          write(chain,102) 'Beam area is ',beam_area
          call map_message(seve%i,rname,chain)
        endif
      endif
      !
      ! Prussian Hat - NOT SUPPORTED HERE
    enddo
    !
    select case (method%method)
    case ('SDI','CLARK')
      method%bgain = 0
      call mos_sidelobe (d3beam,nx,ny,ix_max,iy_max,   &
           &        method%patch(1),method%patch(2),method%bgain,nfield)
      write(chain,102) 'Sidelobe is ',method%bgain
      call map_message(seve%i,rname,chain)
    case default
      continue
    end select
    !
    ! Define the weight function and truncate the mask
    do ifreq=1,nfreq
      d3prim => hprim%r4d(:,:,:,ifreq)
      call compute_atten(mx,my,nfield,atten(:,:,ifreq),d3prim,mask,   &
          &      method%search,method%restor,method%trunca)
    enddo
    if (hbeam%gil%faxi.eq.3) deallocate (d3beam)    !    (hbeam%gil%dim(1),hbeam%gil%dim(2),hbeam%gil%dim(3))
    !
  else
    !
    ! Single field case
    d2beam  => hbeam%r4d(:,:,ibeam,1)    !Single field case, contiguous pointer
    !
    ! Simple case
    call maxmap(d2beam,nx,ny,method%bzone,   &
        &      beam_max,ix_max,iy_max,   &
        &      beam_min,ix_min,iy_min)
    if (method%verbose) then
      write(chain,'(A,1PG10.3,A,I6,I6,A,1PG10.3,A,I6,I6)') &
        &   'Beam max. ',beam_max,' at ',ix_max,iy_max,  &
        &   ', Min. ',beam_min,' at ',ix_min,iy_min
      call map_message(seve%i,rname,chain)
    endif
    if (beam_max.eq.0.0) then
      call map_message(seve%w,rname,'Beam is empty')
      error = .true.
      return
    endif
    call comshi (d2beam,nx,ny,ix_max,iy_max,method%bshift)
    if (do_fft) then
      if ((nx.eq.mx).and.(ny.eq.my)) then
        call init_convolve (ix_max,iy_max,nx,ny,   &
             &        d2beam,w_work,beam_area,w_fft)
      else
        allocate(i2beam(mx,my),stat=ier)
        call plunge_r4(d2beam,nx,ny,i2beam,mx,my)
        jx_max = ix_max+(mx-nx)/2
        jy_max = iy_max+(my-ny)/2
        call init_convolve (jx_max,jy_max,mx,my,   &
             &        i2beam,w_work,beam_area,w_fft)
      endif
      tfbeam(:,:,1)  = real(w_work)
      if (method%verbose) then
         write(chain,102) 'Beam area is ',beam_area
         call map_message(seve%i,rname,chain)
      endif
    endif
    !
    ! Prussian Hat
    if (method%phat.ne.0) then
      d2beam(ix_max,iy_max) = d2beam(ix_max,iy_max)   &
           &         + method%phat
      f = 1.0/d2beam(ix_max,iy_max)
      d2beam(:,:) = d2beam*f
    endif
    !
    if (method%method.ne.'HOGBOM' .and. method%method.ne.'MULTI') then
      call find_sidelobe (d2beam,nx,ny,ix_max,iy_max,   &
           &        method%patch(1),method%patch(2),method%bgain)
      write(chain,102) 'Sidelobe is ',method%bgain
      call map_message(seve%d,rname,chain)
    endif
  endif
  !
  method%beam0 = (/ix_max,iy_max/)
  if (method%phat.ne.0) fhat = f
  error = .false.
  call map_message(seve%T,'GET_BEAM',' exiting..')
  return
  !
102 format(a,1pg10.3,a,i6,i6)
end subroutine get_beam
!
subroutine get_stopping(miter,ares,iplane)
  use clean_arrays
  !--------------------------------------------------------------
  ! @ private
  !*
  ! IMAGER -- Support for Clean
  !
  !     Define current stopping criterium from per channel
  !   NITER or ARES list. Little used, a bit obsolescent.
  !!
  !--------------------------------------------------------------
  !
  integer, intent(inout) :: miter   !! Max. iteration number
  real, intent(inout) :: ares       !! Absolute residual
  integer, intent(in) :: iplane     !! Current plane
  !
  if (iplane.ge.1 .and. iplane.le.niter_listsize) then
    miter = niter_list(iplane)
  endif
  if (iplane.ge.1 .and. iplane.le.ares_listsize) then
    ares = ares_list(iplane)
  endif
end subroutine get_stopping
!
subroutine move_to_dcct(cmethod,start_iter,iplane,ncct,mcct,  &
  & w_cct, tcc, hclean, dcct, chain, sever, ithread)
  use image_def
  use clean_def
  use gbl_message
  use imager_interfaces, only : reallocate_cct, map_message
  !--------------------------------------------------------------
  ! @ private-mandatory
  !*
  ! IMAGER -- Support for Clean
  !
  !     Move Clean composent list to its final shape and
  !   location, the DCCT array that can be saved
  !!
  !--------------------------------------------------------------
  character(len=*), intent(in) :: cmethod     !! Method name
  integer, intent(in) :: start_iter           !! Starting iteration
  integer, intent(in) :: iplane               !! Plane number
  integer, intent(inout) :: mcct              !! Maximum number of components
  integer, intent(in) :: ncct                 !! Number of clean components
  real, intent(in) :: w_cct(:,:)              !! Image of Clean components
  real, intent(inout), allocatable :: dcct(:,:,:)  !! Clean component array
  type(cct_par), intent(in) :: tcc(:)         !! Clean component list
  type(gildas), intent(in) :: hclean          !! Header characteristics
  character(len=*), intent(inout) :: chain    !! Returned Message
  integer, intent(out) :: sever               !! Severity of returned message
  integer, intent(in) :: ithread              !! Thread number
  !
  ! Local
  integer :: f_iter,m_iter,cctsize
  integer :: i,nx,ny,ix,iy,nc
  real :: flux
  logical :: error
  real :: start_flux
  !
  nx = ubound(w_cct,1)
  ny = ubound(w_cct,2)
  nc = hclean%gil%dim(3)
  sever = seve%i  ! Default is just Information
  !
  ! Check size of CCT array
  cctsize = 3
  if (cmethod.eq.'GAUSS') cctsize = 4
  if (allocated(dcct)) then
    if (size(dcct,1).lt.cctsize) then
      write(chain,'(A,I0,A,I0)') &
        & 'Programming error: Incorrect Size of Clean Component. Expected ', &
        & cctsize,' Got ',size(dcct,1)
      call map_message(seve%e,cmethod,chain)
      sever = seve%e
      call reallocate_cct(cctsize,nc,ncct,dcct,error)
    endif
  endif
  !
  ! Put the TCC structure into its final place
  if (cmethod.eq.'SDI' .or. cmethod.eq.'MULTI') then
    if (ncct.eq.0) then
      dcct(3,iplane,1) = 0
      write (chain,'(A,1PG10.3,A,A,A,I6)')  'Cleaned ',0.0,   &
          &        ' Jy with     NO components ' &
          &       ,' Plane ',iplane
    else
      !
      f_iter = 0
      flux = 0.0
      do iy=1,ny
        do ix=1,nx
          if (w_cct(ix,iy).ne.0) f_iter = f_iter+1
        enddo
      enddo
      m_iter = size(dcct,3)
      if (f_iter.gt.m_iter) then
        write(chain,'(A,I0,A,I0,A,I0)') 'Thread ',ithread,' Reallocating to ',f_iter,' > ',m_iter
        sever = seve%w
        call map_message(sever,cmethod,chain)
        call reallocate_cct(cctsize,nc,f_iter,dcct,error)
        m_iter = f_iter
      endif
      !
      f_iter = 0
      flux = 0.0
      do iy=1,ny
        do ix=1,nx
          if (w_cct(ix,iy).ne.0) then
            f_iter = f_iter+1
            dcct(1,iplane,f_iter) = (dble(ix) -   &
             & hclean%gil%convert(1,1)) * hclean%gil%convert(3,1) + &
             & hclean%gil%convert(2,1)
            dcct(2,iplane,f_iter) = (dble(iy) -   &
             & hclean%gil%convert(1,2)) * hclean%gil%convert(3,2) + &
             & hclean%gil%convert(2,2)
            dcct(3,iplane,f_iter) = w_cct(ix,iy)
            flux = flux+w_cct(ix,iy)
          endif
        enddo
      enddo
      if (f_iter.lt.m_iter) dcct(:,iplane,f_iter+1) = 0
      write (chain,'(A,1PG10.3,A,I0,A,A,I0)')  'Cleaned ',flux,   &
          &        ' Jy with ',f_iter,' components ' &
          &       ,' Plane ',iplane
    endif
  else if (cmethod.ne.'MRC') then
    start_flux = 0.
    m_iter = ncct
    if (m_iter.gt.size(dcct,3)) then
      write(chain,'(A,I0,A,I0)') 'Programming error: M_ITER ',m_iter,' > Size of DCCT ',size(dcct,3)
      call map_message(seve%f,cmethod,chain)
      call map_message(seve%f,cmethod,'Attempting re-allocation',1)
      call reallocate_cct(cctsize,nc,m_iter,dcct,error)
    endif
    !
    flux = 0
    do i=1,m_iter
      dcct(1,iplane,i) = (dble(tcc(i)%ix) -   &
          & hclean%gil%convert(1,1)) * hclean%gil%convert(3,1) + &
          & hclean%gil%convert(2,1)
      dcct(2,iplane,i) = (dble(tcc(i)%iy) -   &
          & hclean%gil%convert(1,2)) * hclean%gil%convert(3,2) + &
          & hclean%gil%convert(2,2)
      dcct(3,iplane,i) = tcc(i)%value
      if (i.lt.start_iter) then
        start_flux = start_flux+tcc(i)%value
      else
        flux = flux+tcc(i)%value
      endif
      if (cctsize.eq.4) dcct(4,iplane,i) = tcc(i)%size
    enddo
    if (m_iter.lt.size(dcct,3)) then
      dcct(:,iplane,m_iter+1) = 0
    endif
    !
    if (start_flux.eq.0) then
      write (chain,'(A,1PG10.3,A,I0,A,A,I0)')  'Cleaned ',flux,   &
        &        ' Jy with ',m_iter,' components ' &
        &       ,' Plane ',iplane
    else
      write (chain,'(A,1PG10.3,A,I0,A,I0,A,1PG10.3,A,I6)')  'Cleaned ',flux,   &
        &   ' Jy with ',m_iter-start_iter+1,' (+',start_iter-1, &
        &   ') components (total ',flux+start_flux,' Jy),  Plane ',iplane
    endif
    !
  endif
end subroutine move_to_dcct
!
subroutine list_to_cct(hclean,cct_list,cct)
  use clean_def
  use image_def
  use gbl_message
  use imager_interfaces, only : reallocate_cct, map_message
  !------------------------------------------------------------------
  ! @ private-mandatory
  !*
  ! IMAGER -- Support for command CLEAN
  !
  !   Set the DCCT common array to its final size
  !
  !      == OBSOLETE ROUTINE ==
  !!
  !------------------------------------------------------------------
  type(gildas), intent(in) :: hclean    
  type(cct_lst), intent(in) :: cct_list(:)
  real, allocatable, intent(inout) :: cct(:,:,:)
  !
  integer :: csize
  integer :: iplane, nplane, i
  real :: flux
  character(len=80) :: chain
  logical :: error
  !
  nplane = hclean%gil%dim(3)
  do iplane=1,nplane
    csize = max(csize,cct_list(iplane)%cur_size)
  enddo
  !
  ! Only valid for OLD code...
  if (csize.gt.size(cct,3)) then
    call reallocate_cct(3,nplane,csize,cct,error)
  endif
  !
  cct = 0. ! Empty list...
  do iplane=1,nplane
    flux = 0
    do i=1,cct_list(iplane)%cur_size
      cct(1,iplane,i) = (dble(cct_list(iplane)%cc(i)%ix) -   &
          & hclean%gil%convert(1,1)) * hclean%gil%convert(3,1) + &
          & hclean%gil%convert(2,1)
      cct(2,iplane,i) = (dble(cct_list(iplane)%cc(i)%iy) -   &
          & hclean%gil%convert(1,2)) * hclean%gil%convert(3,2) + &
          & hclean%gil%convert(2,2)
      cct(3,iplane,i) = cct_list(iplane)%cc(i)%value
      flux = flux+cct_list(iplane)%cc(i)%value
    enddo
    !
    write (chain,'(A,1PG10.3,A,I6,A,A,I6)')  'Cleaned ',flux,   &
      &        ' Jy with ',cct_list(iplane)%cur_size,' components ' &
      &       ,' Plane ',iplane
    call map_message(seve%i,'CLEAN',chain)
  enddo
  !
end subroutine list_to_cct
!
subroutine update_clean(method,hclean,tcc,np,clean,resid,atten)
  use image_def
  use clean_def
  use imager_interfaces, only : clean_make
  !--------------------------------------------------------------
  ! @ private-mandatory
  !*
  ! IMAGER -- Support for CLEAN
  !
  !     Update the final image, depending on user specification  
  !   method%residual < 0   Just the Clean components, unconvolved  
  !   method%residual = 0   Usual Clean + Residual  
  !   method%residual > 0   Just the Clean components, no Residual  
  !--------------------------------------------------------------
  type(clean_par), intent(in) :: method   !! Clean parameters
  type(gildas), intent(inout) :: hclean   !! Clean Header
  type(cct_par), intent(in) :: tcc(:)     !! Clean Component list
  integer, intent(in) :: np               !! Number of pointings
  real, intent(inout) :: clean(:,:)       !! Clean array
  real, intent(inout) :: resid(:,:)       !! Residual
  real, intent(inout) :: atten(:,:)       !! Attenuation in Mosaics
  !
  ! Code ----
  if (method%n_iter.ne.0) then
    if (method%residual.ge.0) then
      call clean_make (method, hclean, clean, tcc)
      if (method%residual.eq.0) then
        if (np.le.1) then
          clean = clean + resid
        else
          clean = clean + resid*atten
          where (atten.eq.0) clean = hclean%gil%bval ! Undefined pixel there
        endif
      endif
    else
      call cct_to_clean (method, hclean, clean, tcc)
    endif
  else if (method%residual.eq.0) then
    if (np.le.1) then
      clean = resid
    else
      clean = resid*atten
      where (atten.eq.0) clean = hclean%gil%bval ! Undefined pixel there
    endif
  else
    clean = 0
  endif
end subroutine update_clean
!
subroutine get_ftbeam(method,hbeam,hresid,hprim,ftbeam,nbeam,error)
  use gkernel_interfaces
  use imager_interfaces, only : get_abeam, map_message
  use clean_def
  use image_def
  use gbl_message
  !-----------------------------------------------------------------
  ! @ private-mandatory
  !*
  ! IMAGER -- Support for CLEAN
  !
  !    Get Fourier Transform of beams (one per beam Plane & Pointing)
  !!
  !-----------------------------------------------------------------
  type (clean_par), intent(inout) :: method !! Clean parameters
  type (gildas), intent(in)  :: hbeam       !! Dirty beam header (x,y,v,p) or (x,y,p,v)
  type (gildas), intent(in)  :: hresid      !! Residual (unused)
  type (gildas), intent(in)  :: hprim       !! Primary beam header (p,x,y,v)
  real, intent(inout), allocatable :: ftbeam(:,:,:,:)  !! Per Pointing & Frequency beam TF
  integer, intent(out) :: nbeam             !! Number of Frequency beams
  logical, intent(inout) :: error           !! Logical error flag
  !
  ! Local
  character(len=80) :: chain
  integer :: nfield, ibeam, nx, ny, ier
  complex, allocatable :: w_work(:,:)
  real, allocatable :: w_fft(:)
  !
  if (allocated(ftbeam)) deallocate(ftbeam)
  !
  if (hbeam%gil%faxi.eq.3) then
    nbeam = hbeam%gil%dim(3)
    nfield = hbeam%gil%dim(4)
  else
    nbeam = hbeam%gil%dim(4)
    nfield = hbeam%gil%dim(3)
  endif
  nx = hbeam%gil%dim(1)
  ny = hbeam%gil%dim(2)
  !
  allocate(ftbeam(nx,ny,nfield,nbeam),w_work(nx,ny),w_fft(2*max(nx,ny)),stat=ier)
  if (ier.ne.0) then
    call map_message(seve%e,'CLEAN','Beam Fourier Transform memory allocation errror')
    error = .true.
    return
  endif
  !
  do ibeam=1,nbeam
    call get_abeam(method,hbeam,hresid,hprim,  &
     &    ftbeam(:,:,:,ibeam),w_work,w_fft,error)
    if (error) then
      write(chain,'(A,I0)') 'Beam Fourier Transform derivation error on plane ',ibeam
      call map_message(seve%e,'CLEAN',chain)
      return
    endif
  enddo
  deallocate(w_work,w_fft)
end subroutine get_ftbeam
!!
subroutine get_abeam(method,hbeam,hresid,hprim,  &
     &    tfbeam,w_work,w_fft,error) 
  use gkernel_interfaces
  use imager_interfaces, only : plunge_r4, init_convolve, map_message, v_size_r4_3
  use clean_def
  use image_def
  use gbl_message
  !-----------------------------------------------------------------
  ! @ private-mandatory
  !*
  ! IMAGER -- Support for command CLEAN /RESTART
  !
  !   Get the Fourier Transform of one beam plane
  !!
  !-----------------------------------------------------------------
  type (clean_par), intent(inout) :: method !! Clean parameters
  type (gildas), intent(in)  :: hbeam       !! Dirty beam header (x,y,v,p) or (x,y,p,v)
  type (gildas), intent(in)  :: hresid      !! Residual (unused)
  type (gildas), intent(in)  :: hprim       !! Primary beam  (p,x,y,v)
  real, intent(inout) :: tfbeam(:,:,:)      !! Per Pointing beam FT
  complex, intent(inout) :: w_work(:,:)     !! FT work array
  real, intent(inout) :: w_fft(:)           !! FFT work array
  logical, intent(inout) :: error           !! Logical error flag
  !
  ! Local ---
  integer nx,ny,mx,my
  integer ifreq,nfreq, ifield,nfield
  real beam_area,f
  integer ix_max,iy_max,jx_max,jy_max
  logical do_fft
  character(len=message_length) :: chain
  character(len=*), parameter :: rname = 'CLEAN'
  real, pointer :: d2beam(:,:)      ! Beam (per single field & frequency)
  ! real, pointer :: d3prim(:,:,:)    ! Primary beams (p,x,y) (for one frequency)
  real, pointer :: d3beam(:,:,:)    ! Dirty beam (x,y,p) (for one frequency)
  real, pointer :: atten(:,:,:)     ! Global Sky Attenuation (x,y,v)
  real, allocatable :: i2beam(:,:)  ! Intermediate beam if no size matching
  integer :: ier, nn(3)
  logical :: err, verbose
  !
  do_fft = method%method.ne.'HOGBOM'   &
       &    .and. method%method.ne.'MX'
  if (.not.do_fft) then
    call map_message(seve%e,'GET_ABEAM','Called with DO_FFT = .FALSE. & Method = '//method%method)
    error = .true.
    return
  endif
  !
  nx = hbeam%gil%dim(1)
  ny = hbeam%gil%dim(2)
  !
  mx = hresid%gil%dim(1)
  my = hresid%gil%dim(2)
  !
  ! Hbeam may have two different shapes
  if (hbeam%gil%faxi.eq.3) then
    nfreq = hbeam%gil%dim(3)
    nfield = max(1,hbeam%gil%dim(4))
  else
    nfreq = hbeam%gil%dim(4)
    nfield = max(1,hbeam%gil%dim(3))
  endif
  !
  ! Quick fix on beam maximum position
  ix_max = nx/2+1
  iy_max = ny/2+1
  !
  if (method%method.ne.'MULTI') then
    nn = [mx,my,nfield]   ! Number of Primary Beams, not Frequency Slices.
  else
    nn = [mx,my,1]        ! The Multi Scale clean is different
  endif
  err = .false.
  call v_size_r4_3('FTBEAM',tfbeam,nn,err)
  if (err) then
    Print *,'Size error on FTBEAM'
    read(5,*) ifreq
  endif
  !
  verbose = method%verbose
  atten => method%atten
  !
  f = 1.0   ! No Prussian Hat
  !
  if (method%mosaic) then
    nn = [mx,my,nfreq]
    call v_size_r4_3('ATTEN',method%atten,nn,err)
    !
    if (verbose)  Print *,'Testing MOSAIC case ',hbeam%gil%dim(1:hbeam%gil%ndim),' Method ',method%method
    !
    ! At this stage, the Beam may have beam re-shaped to 3 dimensions
    if (hbeam%gil%faxi.eq.3) then
      call map_message(seve%d,rname,'3D - Copy of 4D beam')
      allocate(d3beam(hbeam%gil%dim(1),hbeam%gil%dim(2),hbeam%gil%dim(4)),stat=ier)
      if (ier.ne.0) then
        call map_message(seve%e,rname,'BEAM memory allocation error',2)
        error = .true.
        return
      endif
      !
      ! Copy the relevant beams at the appropriate frequency
      d3beam = hbeam%r4d(:,:,method%ibeam,:)   ! and not (:,:,:,method%ibeam)
    else
      ! Point to the relevant beams at the appropriate frequency
      call map_message(seve%d,rname,'3D - Pointer to 4D beam')
      d3beam => hbeam%r4d(:,:,:,method%ibeam)
    endif
    !
    nfield = hprim%gil%dim(1)
    !
    ! Analyze beam
    allocate(i2beam(mx,my),stat=ier)
    if (ier.ne.0) then
      call map_message(seve%e,rname,'BEAM memory allocation error',2)
      error = .true.
      return
    endif
    do ifield = 1,nfield
      !
      if (do_fft) then
        if (nx.eq.mx .and. ny.eq.my) then
          call init_convolve (ix_max,iy_max,nx,ny,   &
            &          d3beam(:,:,ifield),w_work,beam_area,w_fft)
        else
          call plunge_r4(d3beam(:,:,ifield),nx,ny,i2beam,mx,my)
          jx_max = ix_max+(mx-nx)/2
          jy_max = iy_max+(my-ny)/2
          call init_convolve (jx_max,jy_max,mx,my,   &
               &        i2beam,w_work,beam_area,w_fft)
        endif
        tfbeam(:,:,ifield) = real(w_work)
        if (verbose) then
          write(chain,102) 'Beam area is ',beam_area
          call map_message(seve%i,rname,chain)
        endif
      endif
      !
    enddo
    !
    if (hbeam%gil%faxi.eq.3) deallocate (d3beam)    !    (hbeam%gil%dim(1),hbeam%gil%dim(2),hbeam%gil%dim(3))
    !
  else
    !
    ! Single field case
    d2beam  => hbeam%r4d(:,:,method%ibeam,1)    !Single field case, contiguous pointer
    !
    if ((nx.eq.mx).and.(ny.eq.my)) then
      ! Simple case
      call init_convolve (ix_max,iy_max,nx,ny,   &
           &        d2beam,w_work,beam_area,w_fft)
    else
      ! Larger beam case
      allocate(i2beam(mx,my),stat=ier)
      call plunge_r4(d2beam,nx,ny,i2beam,mx,my)
      jx_max = ix_max+(mx-nx)/2
      jy_max = iy_max+(my-ny)/2
      call init_convolve (jx_max,jy_max,mx,my,   &
           &        i2beam,w_work,beam_area,w_fft)
    endif
    tfbeam(:,:,1)  = real(w_work)
  endif
  error = .false.
  return
  !
102 format(a,1pg10.3,a,i6,i6)
end subroutine get_abeam


