!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
subroutine import_package(line,error)
  use sic_dependencies_interfaces
  use gpack_def
  use sic_interfaces, except_this=>import_package
  use gbl_message
  !---------------------------------------------------------------------
  ! @ private
  ! SIC Internal routine
  !    Support routine for command SIC\IMPORT. Syntax is:
  !    IMPORT foo [/DEBUG]
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: line   ! Command line
  logical,          intent(inout) :: error  ! Error flag
  ! Local
  character(len=gpack_name_length) :: packname
  character(len=6) :: rname = 'IMPORT'
  integer :: pl,narg
  logical :: debug = .false.  ! Load library in debug mode?
  integer(kind=4) :: i, j, k, dir_nfile
  character(len=filename_length) :: filestring,tmpstring,dirstring
  character(len=filename_length), allocatable :: dir_file(:)
  character(len=12), allocatable :: packages(:)
  !
  narg = sic_narg(0)
  if (narg.ne.1) then
    call sic_message(seve%e,rname,'Command IMPORT needs 1 and only 1 argument')
    error = .true.
    return
  endif
  !
  ! Retrieve package name
  call sic_ch (line,0,1,packname,pl,.true.,error)
  if (error) return
  if (packname.eq."?") then
    dir_nfile = 0
    !
    filestring = 'py*.so'
    tmpstring = '$PYTHONPATH'
    call sic_parse_file(tmpstring,'','',dirstring)  ! Translate Sic logicals and others
    call gag_directory(dirstring,filestring,dir_file,dir_nfile,error)
    if (error) return
    if (dir_nfile.le.0) return
    !
    allocate(packages(dir_nfile))
    k = 0
    do i=1,dir_nfile
      j = index(dir_file(i),'.')-1
      k = k+1
      packages(k) = dir_file(i)(3:j)
      if (packages(k).eq."gildas") k=k-1
    enddo
    if (k.gt.0) then
      write(*,'(A)') 'I-IMPORT, Available packages : '
      write(*,*) packages(1:k)
    endif
  else
    call sic_lower(packname)
    debug = sic_present(1,0)
    call sic_let_char('SIC%IMPORT',packname,error)
    !
    ! Dynamic load the library
    call gpack_sic_import(packname,debug,error)
  endif
  !
end subroutine import_package
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
