/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.DiscourseAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class DiscourseAnnouncerValidator {
    private static final String DEFAULT_DISCOURSE_TPL = "src/jreleaser/templates/discourse.tpl";

    private DiscourseAnnouncerValidator() {
    }

    public static void validateDiscourse(JReleaserContext context, DiscourseAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.discourse");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.discourse", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)announcer.getHost())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"discourse.host"}));
        }
        announcer.setUsername(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.discourse.username", "DISCOURSE_USERNAME"}), "announce.discourse.username", announcer.getUsername(), errors, context.isDryrun()));
        announcer.setApiKey(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.discourse.api.key", "DISCOURSE_API_KEY"}), "announce.discourse.apiKey", announcer.getApiKey(), errors, context.isDryrun()));
        announcer.setCategoryName(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.discourse.category", "DISCOURSE_CATEGORY_NAME"}), "announce.discourse.category", announcer.getCategoryName(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)announcer.getTitle())) {
            announcer.setTitle(RB.$((String)"default.discussion.title", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)announcer.getMessage()) && StringUtils.isBlank((String)announcer.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_DISCOURSE_TPL), new LinkOption[0])) {
                announcer.setMessageTemplate(DEFAULT_DISCOURSE_TPL);
            } else {
                announcer.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)announcer.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"discourse.messageTemplate", announcer.getMessageTemplate()}));
        }
        Validator.validateTimeout(announcer);
    }
}

