/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.assemble;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.api.assemble.Assembler;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.AbstractAssembler;
import org.jreleaser.model.internal.assemble.JavaAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Glob;
import org.jreleaser.model.internal.common.Java;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public abstract class AbstractJavaAssembler<S extends AbstractJavaAssembler<S, A>, A extends Assembler>
extends AbstractAssembler<S, A>
implements JavaAssembler<A> {
    private static final long serialVersionUID = -1293187422642323327L;
    private final Artifact mainJar = new Artifact();
    private final List<Glob> jars = new ArrayList<Glob>();
    private final Java java = new Java();
    private String executable;

    protected AbstractJavaAssembler(String type) {
        super(type);
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.executable = this.merge(this.executable, ((AbstractJavaAssembler)source).getExecutable());
        this.setJava(((AbstractJavaAssembler)source).getJava());
        this.setMainJar(((AbstractJavaAssembler)source).getMainJar());
        this.setJars(this.merge(this.jars, ((AbstractJavaAssembler)source).getJars()));
    }

    @Override
    public TemplateContext props(JReleaserContext context) {
        TemplateContext props = super.props(context);
        props.set("distributionExecutable", (Object)this.executable);
        props.setAll(this.java.resolvedExtraProperties());
        props.set("distributionJavaGroupId", (Object)this.java.getGroupId(), (Object)"");
        props.set("distributionJavaArtifactId", (Object)this.java.getArtifactId(), (Object)"");
        props.set("distributionJavaMainClass", (Object)this.java.getMainClass(), (Object)"");
        if (StringUtils.isNotBlank((String)this.java.getVersion())) {
            props.set("distributionJavaVersion", (Object)this.java.getVersion());
            SemanticVersion jv = SemanticVersion.of((String)this.java.getVersion());
            props.set("distributionJavaVersionMajor", (Object)jv.getMajor(), (Object)"");
            props.set("distributionJavaVersionMinor", (Object)jv.getMinor(), (Object)"");
            props.set("distributionJavaVersionPatch", (Object)jv.getPatch(), (Object)"");
            props.set("distributionJavaVersionTag", (Object)jv.getTag(), (Object)"");
            props.set("distributionJavaVersionBuild", (Object)jv.getBuild(), (Object)"");
        } else {
            props.set("distributionJavaVersion", (Object)"");
            props.set("distributionJavaVersionMajor", (Object)"");
            props.set("distributionJavaVersionMinor", (Object)"");
            props.set("distributionJavaVersionPatch", (Object)"");
            props.set("distributionJavaVersionTag", (Object)"");
            props.set("distributionJavaVersionBuild", (Object)"");
        }
        return props;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    @Override
    public void setExecutable(String executable) {
        this.executable = executable;
    }

    @Override
    public Java getJava() {
        return this.java;
    }

    @Override
    public void setJava(Java java) {
        this.java.merge(java);
    }

    @Override
    public Artifact getMainJar() {
        return this.mainJar;
    }

    @Override
    public void setMainJar(Artifact mainJar) {
        this.mainJar.merge(mainJar);
    }

    @Override
    public List<Glob> getJars() {
        return this.jars;
    }

    @Override
    public void setJars(List<Glob> jars) {
        this.jars.clear();
        this.jars.addAll(jars);
    }

    @Override
    public void addJars(List<Glob> jars) {
        this.jars.addAll(jars);
    }

    @Override
    public void addJar(Glob jar) {
        if (null != jar) {
            this.jars.add(jar);
        }
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("executable", this.executable);
        props.put("mainJar", this.mainJar.asMap(full));
        LinkedHashMap<String, Map<String, Object>> mappedJars = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.jars.size(); ++i) {
            mappedJars.put("glob " + i, this.jars.get(i).asMap(full));
        }
        props.put("jars", mappedJars);
        props.put("extraProperties", this.getExtraProperties());
        if (this.java.isEnabled()) {
            props.put("java", this.java.asMap(full));
        }
    }
}

