/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.SnapPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class SnapPackagerValidator {
    private SnapPackagerValidator() {
    }

    public static void validateSnap(JReleaserContext context, Distribution distribution, SnapPackager packager, Errors errors) {
        context.getLogger().debug("distribution.{}." + packager.getType(), new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        SnapPackager parentPackager = model.getPackagers().getSnap();
        Validator.resolveActivatable(context, (Activatable)packager, "distributions." + distribution.getName() + "." + packager.getType(), parentPackager);
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        BaseReleaser<?, ?> service = model.getRelease().getReleaser();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.isEmpty()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.no.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), packager.getSupportedFileExtensions(distribution.getType())}));
            packager.disable();
            return;
        }
        if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.multiple.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.multiple.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), candidateArtifacts.stream().map(Artifact::getPath).collect(Collectors.toList())}));
            packager.disable();
            return;
        }
        Validator.validateCommitAuthor(packager, parentPackager);
        SnapPackager.SnapRepository snap = packager.getRepository();
        Validator.validateRepository(context, distribution, snap, parentPackager.getRepository(), "snap.repository");
        if (StringUtils.isBlank((String)snap.getName())) {
            snap.setName(distribution.getName() + "-snap");
        }
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        Validator.validateContinueOnError(packager, parentPackager);
        Validator.validateSkipPublishing(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        SnapPackagerValidator.mergeSnapPlugs(packager, parentPackager);
        SnapPackagerValidator.mergeSnapSlots(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getPackageName())) {
            packager.setPackageName(parentPackager.getPackageName());
            if (StringUtils.isBlank((String)packager.getPackageName())) {
                packager.setPackageName(distribution.getName());
            }
        }
        if (StringUtils.isBlank((String)packager.getBase())) {
            packager.setBase(parentPackager.getBase());
            if (StringUtils.isBlank((String)packager.getBase())) {
                packager.setBase("core20");
            }
        }
        if (StringUtils.isBlank((String)packager.getGrade())) {
            packager.setGrade(parentPackager.getGrade());
            if (StringUtils.isBlank((String)packager.getGrade())) {
                packager.setGrade("stable");
            }
        }
        if (StringUtils.isBlank((String)packager.getConfinement())) {
            packager.setConfinement(parentPackager.getConfinement());
            if (StringUtils.isBlank((String)packager.getConfinement())) {
                packager.setConfinement("strict");
            }
        }
        if (!packager.isRemoteBuildSet() && parentPackager.isRemoteBuildSet()) {
            packager.setRemoteBuild(parentPackager.isRemoteBuild());
        }
        if (!packager.isRemoteBuild() && StringUtils.isBlank((String)packager.getExportedLogin())) {
            packager.setExportedLogin(parentPackager.getExportedLogin());
            if (StringUtils.isBlank((String)packager.getExportedLogin())) {
                errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.exportedLogin"}));
            } else if (!Files.exists(context.getBasedir().resolve(packager.getExportedLogin()), new LinkOption[0])) {
                errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.exportedLogin", context.getBasedir().resolve(packager.getExportedLogin())}));
            }
        }
        DistributionsValidator.validateArtifactPlatforms(distribution, packager, candidateArtifacts, errors);
        packager.addArchitecture(parentPackager.getArchitectures());
        for (int i = 0; i < packager.getArchitectures().size(); ++i) {
            SnapPackager.Architecture arch = packager.getArchitectures().get(i);
            if (arch.hasBuildOn()) continue;
            errors.configuration(RB.$((String)"validation_snap_missing_buildon", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.architectures", i}));
        }
        if (errors.hasErrors()) {
            packager.disable();
        }
    }

    private static void mergeSnapPlugs(SnapPackager packager, SnapPackager common) {
        LinkedHashSet<String> localPlugs = new LinkedHashSet<String>();
        localPlugs.addAll(packager.getLocalPlugs());
        localPlugs.addAll(common.getLocalPlugs());
        packager.setLocalPlugs(localPlugs);
        Map<String, SnapPackager.Plug> commonPlugs = common.getPlugs().stream().collect(Collectors.toMap(SnapPackager.Plug::getName, SnapPackager.Plug::copyOf));
        Map<String, SnapPackager.Plug> packagerPlugs = packager.getPlugs().stream().collect(Collectors.toMap(SnapPackager.Plug::getName, SnapPackager.Plug::copyOf));
        commonPlugs.forEach((name, cp) -> {
            SnapPackager.Plug tp = (SnapPackager.Plug)packagerPlugs.remove(name);
            if (null != tp) {
                cp.getAttributes().putAll(tp.getAttributes());
                LinkedHashSet<String> tmp = new LinkedHashSet<String>(cp.getReads());
                tmp.addAll(tp.getReads());
                cp.setReads(new ArrayList<String>(tmp));
                tmp = new LinkedHashSet<String>(cp.getWrites());
                tmp.addAll(tp.getWrites());
                cp.setWrites(new ArrayList<String>(tmp));
            }
        });
        commonPlugs.putAll(packagerPlugs);
        packager.setPlugs(new ArrayList<SnapPackager.Plug>(commonPlugs.values()));
    }

    private static void mergeSnapSlots(SnapPackager packager, SnapPackager common) {
        LinkedHashSet<String> localSlots = new LinkedHashSet<String>();
        localSlots.addAll(packager.getLocalSlots());
        localSlots.addAll(common.getLocalSlots());
        packager.setLocalSlots(localSlots);
        Map<String, SnapPackager.Slot> commonSlots = common.getSlots().stream().collect(Collectors.toMap(SnapPackager.Slot::getName, SnapPackager.Slot::copyOf));
        Map<String, SnapPackager.Slot> packagerSlots = packager.getSlots().stream().collect(Collectors.toMap(SnapPackager.Slot::getName, SnapPackager.Slot::copyOf));
        commonSlots.forEach((name, cp) -> {
            SnapPackager.Slot tp = (SnapPackager.Slot)packagerSlots.remove(name);
            if (null != tp) {
                cp.getAttributes().putAll(tp.getAttributes());
                LinkedHashSet<String> tmp = new LinkedHashSet<String>(cp.getReads());
                tmp.addAll(tp.getReads());
                cp.setReads(new ArrayList<String>(tmp));
                tmp = new LinkedHashSet<String>(cp.getWrites());
                tmp.addAll(tp.getWrites());
                cp.setWrites(new ArrayList<String>(tmp));
            }
        });
        commonSlots.putAll(packagerSlots);
        packager.setSlots(new ArrayList<SnapPackager.Slot>(commonSlots.values()));
    }
}

