/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.sign;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.sign.AbstractSigner;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.signing.Keyring;
import org.jreleaser.model.api.signing.SigningException;
import org.jreleaser.model.internal.signing.SigningTool;
import org.jreleaser.sdk.signing.GpgCommandSigner;
import org.jreleaser.sdk.signing.SigningUtils;

public final class PgpSigner
extends AbstractSigner {
    public PgpSigner(org.jreleaser.model.internal.JReleaserContext context, SigningTool tool) {
        super(context, tool);
    }

    public void sign() throws SigningException {
        switch (this.context.getModel().getSigning().getPgp().getMode()) {
            case COMMAND: {
                this.cmdSign();
                break;
            }
            case FILE: 
            case MEMORY: {
                this.bcSign();
                break;
            }
        }
    }

    private void cmdSign() throws SigningException {
        List<Object> files = this.collectArtifacts(pair -> SigningUtils.isValid((JReleaserContext)this.context.asImmutable(), null, (SigningUtils.FilePair)pair));
        if (files.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"signing.no.match", (Object[])new Object[0]));
            return;
        }
        if ((files = files.stream().filter(SigningUtils.FilePair::isInvalid).collect(Collectors.toList())).isEmpty()) {
            this.context.getLogger().info(RB.$((String)"signing.up.to.date", (Object[])new Object[0]));
            return;
        }
        this.sign(files);
        if (this.context.getModel().getSigning().getPgp().isVerify()) {
            this.verify(files);
        }
    }

    private void bcSign() throws SigningException {
        Keyring keyring = this.context.createKeyring();
        List<Object> files = this.collectArtifacts(pair -> SigningUtils.isValid((JReleaserContext)this.context.asImmutable(), (Keyring)keyring, (SigningUtils.FilePair)pair));
        if (files.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"signing.no.match", (Object[])new Object[0]));
            return;
        }
        if ((files = files.stream().filter(SigningUtils.FilePair::isInvalid).collect(Collectors.toList())).isEmpty()) {
            this.context.getLogger().info(RB.$((String)"signing.up.to.date", (Object[])new Object[0]));
            return;
        }
        this.sign(keyring, files);
        if (this.context.getModel().getSigning().getPgp().isVerify()) {
            this.verify(keyring, files);
        }
    }

    private void verify(Keyring keyring, List<SigningUtils.FilePair> files) throws SigningException {
        if (null == keyring) {
            this.verify(files);
            return;
        }
        this.context.getLogger().debug(RB.$((String)"signing.verify.signatures", (Object[])new Object[0]), new Object[]{files.size()});
        for (SigningUtils.FilePair pair : files) {
            pair.setValid(this.verify(keyring, pair));
            if (pair.isValid()) continue;
            throw new SigningException(RB.$((String)"ERROR_signing_verify_file", (Object[])new Object[]{this.context.relativizeToBasedir(pair.getInputFile()), this.context.relativizeToBasedir(pair.getSignatureFile())}));
        }
    }

    private void verify(List<SigningUtils.FilePair> files) throws SigningException {
        this.context.getLogger().debug(RB.$((String)"signing.verify.signatures", (Object[])new Object[0]), new Object[]{files.size()});
        for (SigningUtils.FilePair pair : files) {
            pair.setValid(SigningUtils.verify((JReleaserContext)this.context.asImmutable(), (SigningUtils.FilePair)pair));
            if (pair.isValid()) continue;
            throw new SigningException(RB.$((String)"ERROR_signing_verify_file", (Object[])new Object[]{this.context.relativizeToBasedir(pair.getInputFile()), this.context.relativizeToBasedir(pair.getSignatureFile())}));
        }
    }

    private boolean verify(Keyring keyring, SigningUtils.FilePair filePair) throws SigningException {
        this.context.getLogger().setPrefix("verify");
        this.context.getLogger().debug("{}", new Object[]{this.context.relativizeToBasedir(filePair.getSignatureFile())});
        try {
            boolean bl;
            block20: {
                InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)new BufferedInputStream(Files.newInputStream(filePair.getSignatureFile(), new OpenOption[0])));
                try {
                    PGPObjectFactory pgpObjFactory = new PGPObjectFactory(sigInputStream, keyring.getKeyFingerPrintCalculator());
                    Iterable pgpSigList = null;
                    Object obj = pgpObjFactory.nextObject();
                    if (obj instanceof PGPCompressedData) {
                        PGPCompressedData c1 = (PGPCompressedData)obj;
                        pgpObjFactory = new PGPObjectFactory(c1.getDataStream(), keyring.getKeyFingerPrintCalculator());
                        pgpSigList = (Iterable)pgpObjFactory.nextObject();
                    } else {
                        pgpSigList = (Iterable)obj;
                    }
                    PGPSignature sig = (PGPSignature)pgpSigList.iterator().next();
                    try (BufferedInputStream fileInputStream = new BufferedInputStream(Files.newInputStream(filePair.getInputFile(), new OpenOption[0]));){
                        int ch;
                        PGPPublicKey pubKey = keyring.readPublicKey();
                        sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pubKey);
                        while ((ch = ((InputStream)fileInputStream).read()) >= 0) {
                            sig.update((byte)ch);
                        }
                    }
                    bl = sig.verify();
                    if (sigInputStream == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (sigInputStream != null) {
                            try {
                                sigInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | PGPException e) {
                        throw new SigningException(RB.$((String)"ERROR_signing_verify_signature", (Object[])new Object[]{this.context.relativizeToBasedir(filePair.getInputFile())}), e);
                    }
                }
                sigInputStream.close();
            }
            return bl;
        }
        finally {
            this.context.getLogger().restorePrefix();
        }
    }

    private void sign(List<SigningUtils.FilePair> files) throws SigningException {
        Path signaturesDirectory = this.context.getSignaturesDirectory();
        try {
            Files.createDirectories(signaturesDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_create_signature_dir", (Object[])new Object[0]), (Throwable)e);
        }
        this.context.getLogger().debug(RB.$((String)"signing.signing.files", (Object[])new Object[0]), new Object[]{files.size(), this.context.relativizeToBasedir(signaturesDirectory)});
        GpgCommandSigner commandSigner = SigningUtils.initCommandSigner((JReleaserContext)this.context.asImmutable());
        for (SigningUtils.FilePair pair : files) {
            SigningUtils.sign((JReleaserContext)this.context.asImmutable(), (GpgCommandSigner)commandSigner, (Path)pair.getInputFile(), (Path)pair.getSignatureFile());
        }
    }

    private void sign(Keyring keyring, List<SigningUtils.FilePair> files) throws SigningException {
        Path signaturesDirectory = this.context.getSignaturesDirectory();
        try {
            Files.createDirectories(signaturesDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_create_signature_dir", (Object[])new Object[0]), (Throwable)e);
        }
        this.context.getLogger().debug(RB.$((String)"signing.signing.files", (Object[])new Object[0]), new Object[]{files.size(), this.context.relativizeToBasedir(signaturesDirectory)});
        PGPSignatureGenerator signatureGenerator = SigningUtils.initSignatureGenerator((JReleaserContext)this.context.asImmutable(), (Keyring)keyring);
        for (SigningUtils.FilePair pair : files) {
            SigningUtils.sign((JReleaserContext)this.context.asImmutable(), (PGPSignatureGenerator)signatureGenerator, (Path)pair.getInputFile(), (Path)pair.getSignatureFile());
        }
    }
}

