/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.webhooks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.extensions.api.workflow.WorkflowListenerException;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.WebhookAnnouncer;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;

public class WebhooksAnnouncer
implements Announcer<org.jreleaser.model.api.announce.WebhooksAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.WebhooksAnnouncer webhooks;

    public WebhooksAnnouncer(JReleaserContext context) {
        this.context = context;
        this.webhooks = context.getModel().getAnnounce().getConfiguredWebhooks();
    }

    public org.jreleaser.model.api.announce.WebhooksAnnouncer getAnnouncer() {
        return this.webhooks.asImmutable();
    }

    public String getName() {
        return "webhooks";
    }

    public boolean isEnabled() {
        return this.webhooks.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announce() throws AnnounceException {
        Map webhooks = this.webhooks.getWebhooks();
        for (Map.Entry e : webhooks.entrySet()) {
            if (!((WebhookAnnouncer)e.getValue()).isEnabled()) continue;
            this.context.getLogger().setPrefix("webhook." + (String)e.getKey());
            try {
                WebhooksAnnouncer.announce(this.context, (WebhookAnnouncer)e.getValue(), false);
            }
            catch (AnnounceException x) {
                this.context.getLogger().warn(x.getMessage().trim());
            }
            finally {
                this.context.getLogger().restorePrefix();
            }
        }
    }

    public static void announce(JReleaserContext context, WebhookAnnouncer webhook, boolean discreet) throws AnnounceException {
        String message = "";
        if (StringUtils.isNotBlank((String)webhook.getMessage())) {
            message = webhook.getResolvedMessage(context);
        } else {
            TemplateContext props = new TemplateContext();
            if ("teams".equals(webhook.getName())) {
                props.set("changelog", (Object)MustacheUtils.passThrough((String)WebhooksAnnouncer.convertLineEndings(context.getChangelog().getResolvedChangelog())));
                props.set("changelogChanges", (Object)MustacheUtils.passThrough((String)WebhooksAnnouncer.convertLineEndings(context.getChangelog().getFormattedChanges())));
                props.set("changelogContributors", (Object)MustacheUtils.passThrough((String)WebhooksAnnouncer.convertLineEndings(context.getChangelog().getFormattedContributors())));
            }
            context.getModel().getRelease().getReleaser().fillProps(props, context);
            message = webhook.getResolvedMessageTemplate(context, props);
        }
        if (webhook.isStructuredMessage() && StringUtils.isNotBlank((String)webhook.getMessageProperty())) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                message = objectMapper.writeValueAsString((Object)CollectionUtils.mapOf((Object[])new Object[]{webhook.getMessageProperty(), message}));
            }
            catch (JsonProcessingException e) {
                throw new AnnounceException(RB.$((String)"ERROR_unexpected_json_format", (Object[])new Object[0]), (Throwable)e);
            }
        }
        if (discreet) {
            context.getLogger().info(RB.$((String)"webhook.message.send", (Object[])new Object[0]));
        } else {
            context.getLogger().info(message);
        }
        if (!context.isDryrun()) {
            WebhooksAnnouncer.fireAnnouncerEvent(ExecutionEvent.before((String)JReleaserCommand.ANNOUNCE.toStep()), context, webhook);
            try {
                ClientUtils.webhook((JReleaserLogger)context.getLogger(), (String)webhook.getWebhook(), (int)webhook.getConnectTimeout(), (int)webhook.getReadTimeout(), (String)message);
                WebhooksAnnouncer.fireAnnouncerEvent(ExecutionEvent.success((String)JReleaserCommand.ANNOUNCE.toStep()), context, webhook);
            }
            catch (RuntimeException e) {
                WebhooksAnnouncer.fireAnnouncerEvent(ExecutionEvent.failure((String)JReleaserCommand.ANNOUNCE.toStep(), (Throwable)e), context, webhook);
                throw e;
            }
        }
    }

    private static void fireAnnouncerEvent(ExecutionEvent event, JReleaserContext context, WebhookAnnouncer webhook) {
        try {
            context.fireAnnounceStepEvent(event, (org.jreleaser.model.api.announce.Announcer)webhook.asImmutable());
        }
        catch (WorkflowListenerException e) {
            context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{e.getListener().getClass().getName()}));
            context.getLogger().trace((Throwable)e);
        }
    }

    public static String convertLineEndings(String str) {
        return str.replaceAll("\\n", "\\\\n\\\\n");
    }
}

