/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.runtime.load.CompiledScriptLoader;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;

public class ExternalScript
implements Library {
    private final LoadServiceResource resource;

    public ExternalScript(LoadServiceResource resource, String name2) {
        this.resource = resource;
    }

    @Override
    public void load(Ruby runtime2, boolean wrap2) {
        InputStream in = null;
        try {
            in = this.resource.getInputStream();
            String name2 = this.resource.getName();
            if (runtime2.getInstanceConfig().getCompileMode().shouldPrecompileAll()) {
                runtime2.compileAndLoadFile(name2, in, wrap2);
            } else {
                name2 = CompiledScriptLoader.getFilenameFromPathAndName(this.resource.getPath(), name2, this.resource.isAbsolute());
                runtime2.loadFile(name2, in, wrap2);
            }
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception2) {}
        }
    }

    public String toString() {
        return "ExternalScript: " + this.resource.getName();
    }
}

