/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.plugin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.plugin.version.PluginVersionResult;
import org.apache.maven.plugin.version.internal.DefaultPluginVersionResolver;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.sisu.Priority;
import org.eclipse.sisu.Typed;

@Named
@Singleton
@Priority(value=10)
@Typed(value={PluginVersionResolver.class})
public class CachingPluginVersionResolver
extends DefaultPluginVersionResolver {
    private static final Object CACHE_KEY = new Object();

    public PluginVersionResult resolve(PluginVersionRequest request) throws PluginVersionResolutionException {
        String key;
        Map<String, PluginVersionResult> cache = this.getCache(request.getRepositorySession().getData());
        PluginVersionResult result = cache.get(key = CachingPluginVersionResolver.getKey(request));
        if (result == null) {
            result = super.resolve(request);
            cache.putIfAbsent(key, result);
        }
        return result;
    }

    private Map<String, PluginVersionResult> getCache(SessionData data) {
        Map cache = (ConcurrentHashMap)data.get(CACHE_KEY);
        while (cache == null && !data.set(CACHE_KEY, null, cache = new ConcurrentHashMap(256))) {
            cache = (Map)data.get(CACHE_KEY);
        }
        return cache;
    }

    private static String getKey(PluginVersionRequest request) {
        return Stream.concat(Stream.of(request.getGroupId(), request.getArtifactId()), request.getRepositories().stream().map(RemoteRepository::getId)).collect(Collectors.joining(":"));
    }
}

